# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'DiscoveryJobDiscoveryDetailsArgs',
    'DiscoveryJobDiscoveryDetailsCredentialsArgs',
    'DiscoveryJobDiscoveryDetailsCredentialsItemArgs',
    'DiscoveryJobDiscoveryDetailsCredentialsItemPropertiesArgs',
    'DiscoveryJobDiscoveryDetailsPropertiesArgs',
    'DiscoveryJobDiscoveryDetailsTagsArgs',
    'MonitoredResourceAdditionalAliasArgs',
    'MonitoredResourceAdditionalAliasCredentialArgs',
    'MonitoredResourceAdditionalCredentialArgs',
    'MonitoredResourceAdditionalCredentialPropertyArgs',
    'MonitoredResourceAliasesArgs',
    'MonitoredResourceAliasesCredentialArgs',
    'MonitoredResourceCredentialsArgs',
    'MonitoredResourceCredentialsPropertyArgs',
    'MonitoredResourceDatabaseConnectionDetailsArgs',
    'MonitoredResourcePropertyArgs',
    'MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetailArgs',
    'MonitoredResourcesAssociateMonitoredResourceSourceResourceDetailArgs',
    'MonitoredResourcesListMemberItemArgs',
    'MonitoredResourcesSearchAssociationItemArgs',
    'MonitoredResourcesSearchAssociationItemDestinationResourceDetailArgs',
    'MonitoredResourcesSearchAssociationItemSourceResourceDetailArgs',
    'MonitoredResourcesSearchItemArgs',
    'MonitoredResourcesSearchItemPropertyArgs',
    'GetConfigsFilterArgs',
    'GetDiscoveryJobLogsFilterArgs',
    'GetDiscoveryJobsFilterArgs',
]

@pulumi.input_type
class DiscoveryJobDiscoveryDetailsArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[str],
                 properties: pulumi.Input['DiscoveryJobDiscoveryDetailsPropertiesArgs'],
                 resource_name: pulumi.Input[str],
                 resource_type: pulumi.Input[str],
                 credentials: Optional[pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsArgs']] = None,
                 tags: Optional[pulumi.Input['DiscoveryJobDiscoveryDetailsTagsArgs']] = None):
        """
        :param pulumi.Input[str] agent_id: The OCID of Management Agent
        :param pulumi.Input['DiscoveryJobDiscoveryDetailsPropertiesArgs'] properties: Property Details
        :param pulumi.Input[str] resource_name: The Name of resource type
        :param pulumi.Input[str] resource_type: Resource Type.
        :param pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsArgs'] credentials: List of DiscoveryJob Credential Details.
        :param pulumi.Input['DiscoveryJobDiscoveryDetailsTagsArgs'] tags: Property Details
        """
        DiscoveryJobDiscoveryDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            agent_id=agent_id,
            properties=properties,
            resource_name=resource_name,
            resource_type=resource_type,
            credentials=credentials,
            tags=tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             agent_id: pulumi.Input[str],
             properties: pulumi.Input['DiscoveryJobDiscoveryDetailsPropertiesArgs'],
             resource_name: pulumi.Input[str],
             resource_type: pulumi.Input[str],
             credentials: Optional[pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsArgs']] = None,
             tags: Optional[pulumi.Input['DiscoveryJobDiscoveryDetailsTagsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'agentId' in kwargs:
            agent_id = kwargs['agentId']
        if 'resourceName' in kwargs:
            resource_name = kwargs['resourceName']
        if 'resourceType' in kwargs:
            resource_type = kwargs['resourceType']

        _setter("agent_id", agent_id)
        _setter("properties", properties)
        _setter("resource_name", resource_name)
        _setter("resource_type", resource_type)
        if credentials is not None:
            _setter("credentials", credentials)
        if tags is not None:
            _setter("tags", tags)

    @property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[str]:
        """
        The OCID of Management Agent
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "agent_id", value)

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Input['DiscoveryJobDiscoveryDetailsPropertiesArgs']:
        """
        Property Details
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input['DiscoveryJobDiscoveryDetailsPropertiesArgs']):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Input[str]:
        """
        The Name of resource type
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        Resource Type.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsArgs']]:
        """
        List of DiscoveryJob Credential Details.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input['DiscoveryJobDiscoveryDetailsTagsArgs']]:
        """
        Property Details
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input['DiscoveryJobDiscoveryDetailsTagsArgs']]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class DiscoveryJobDiscoveryDetailsCredentialsArgs:
    def __init__(__self__, *,
                 items: pulumi.Input[Sequence[pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsItemArgs']]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsItemArgs']]] items: List of DiscoveryJob credentials.
        """
        DiscoveryJobDiscoveryDetailsCredentialsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: pulumi.Input[Sequence[pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsItemArgs']]],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> pulumi.Input[Sequence[pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsItemArgs']]]:
        """
        List of DiscoveryJob credentials.
        """
        return pulumi.get(self, "items")

    @items.setter
    def items(self, value: pulumi.Input[Sequence[pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsItemArgs']]]):
        pulumi.set(self, "items", value)


@pulumi.input_type
class DiscoveryJobDiscoveryDetailsCredentialsItemArgs:
    def __init__(__self__, *,
                 credential_name: pulumi.Input[str],
                 credential_type: pulumi.Input[str],
                 properties: pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsItemPropertiesArgs']):
        """
        :param pulumi.Input[str] credential_name: Name of Credential
        :param pulumi.Input[str] credential_type: Name of Credential Type
        :param pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsItemPropertiesArgs'] properties: Property Details
        """
        DiscoveryJobDiscoveryDetailsCredentialsItemArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            credential_name=credential_name,
            credential_type=credential_type,
            properties=properties,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             credential_name: pulumi.Input[str],
             credential_type: pulumi.Input[str],
             properties: pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsItemPropertiesArgs'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'credentialName' in kwargs:
            credential_name = kwargs['credentialName']
        if 'credentialType' in kwargs:
            credential_type = kwargs['credentialType']

        _setter("credential_name", credential_name)
        _setter("credential_type", credential_type)
        _setter("properties", properties)

    @property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> pulumi.Input[str]:
        """
        Name of Credential
        """
        return pulumi.get(self, "credential_name")

    @credential_name.setter
    def credential_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "credential_name", value)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Input[str]:
        """
        Name of Credential Type
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsItemPropertiesArgs']:
        """
        Property Details
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: pulumi.Input['DiscoveryJobDiscoveryDetailsCredentialsItemPropertiesArgs']):
        pulumi.set(self, "properties", value)


@pulumi.input_type
class DiscoveryJobDiscoveryDetailsCredentialsItemPropertiesArgs:
    def __init__(__self__, *,
                 properties_map: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] properties_map: Key/Value pair of Property
        """
        DiscoveryJobDiscoveryDetailsCredentialsItemPropertiesArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            properties_map=properties_map,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             properties_map: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'propertiesMap' in kwargs:
            properties_map = kwargs['propertiesMap']

        if properties_map is not None:
            _setter("properties_map", properties_map)

    @property
    @pulumi.getter(name="propertiesMap")
    def properties_map(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Key/Value pair of Property
        """
        return pulumi.get(self, "properties_map")

    @properties_map.setter
    def properties_map(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "properties_map", value)


@pulumi.input_type
class DiscoveryJobDiscoveryDetailsPropertiesArgs:
    def __init__(__self__, *,
                 properties_map: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] properties_map: Key/Value pair of Property
        """
        DiscoveryJobDiscoveryDetailsPropertiesArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            properties_map=properties_map,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             properties_map: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'propertiesMap' in kwargs:
            properties_map = kwargs['propertiesMap']

        if properties_map is not None:
            _setter("properties_map", properties_map)

    @property
    @pulumi.getter(name="propertiesMap")
    def properties_map(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Key/Value pair of Property
        """
        return pulumi.get(self, "properties_map")

    @properties_map.setter
    def properties_map(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "properties_map", value)


@pulumi.input_type
class DiscoveryJobDiscoveryDetailsTagsArgs:
    def __init__(__self__, *,
                 properties_map: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] properties_map: Key/Value pair of Property
        """
        DiscoveryJobDiscoveryDetailsTagsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            properties_map=properties_map,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             properties_map: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'propertiesMap' in kwargs:
            properties_map = kwargs['propertiesMap']

        if properties_map is not None:
            _setter("properties_map", properties_map)

    @property
    @pulumi.getter(name="propertiesMap")
    def properties_map(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Key/Value pair of Property
        """
        return pulumi.get(self, "properties_map")

    @properties_map.setter
    def properties_map(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "properties_map", value)


@pulumi.input_type
class MonitoredResourceAdditionalAliasArgs:
    def __init__(__self__, *,
                 credential: pulumi.Input['MonitoredResourceAdditionalAliasCredentialArgs'],
                 name: pulumi.Input[str],
                 source: pulumi.Input[str]):
        """
        :param pulumi.Input['MonitoredResourceAdditionalAliasCredentialArgs'] credential: (Updatable) Monitored Resource Alias Reference Source Credential.
        :param pulumi.Input[str] name: (Updatable) Property Name.
        :param pulumi.Input[str] source: (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        MonitoredResourceAdditionalAliasArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            credential=credential,
            name=name,
            source=source,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             credential: pulumi.Input['MonitoredResourceAdditionalAliasCredentialArgs'],
             name: pulumi.Input[str],
             source: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("credential", credential)
        _setter("name", name)
        _setter("source", source)

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Input['MonitoredResourceAdditionalAliasCredentialArgs']:
        """
        (Updatable) Monitored Resource Alias Reference Source Credential.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: pulumi.Input['MonitoredResourceAdditionalAliasCredentialArgs']):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class MonitoredResourceAdditionalAliasCredentialArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 service: pulumi.Input[str],
                 source: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: (Updatable) Property Name.
        :param pulumi.Input[str] service: (Updatable) The name of the service owning the credential.  Example: stack-monitoring or dbmgmt
        :param pulumi.Input[str] source: (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        MonitoredResourceAdditionalAliasCredentialArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            service=service,
            source=source,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: pulumi.Input[str],
             service: pulumi.Input[str],
             source: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("service", service)
        _setter("source", source)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        (Updatable) The name of the service owning the credential.  Example: stack-monitoring or dbmgmt
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class MonitoredResourceAdditionalCredentialArgs:
    def __init__(__self__, *,
                 credential_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialPropertyArgs']]]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] credential_type: (Updatable) Type of credentials specified in the credentials element. Three possible values - EXISTING, PLAINTEXT and ENCRYPTED.
               * EXISTING  - Credential is already stored in agent and only credential name need to be passed for existing credential.
               * PLAINTEXT - The credential properties will have credentials in plain text format.
               * ENCRYPTED - The credential properties will have credentials stored in vault in encrypted format using KMS client which uses master key for encryption. The same master key will be used to decrypt the credentials before passing on to the management agent.
        :param pulumi.Input[str] description: (Updatable) The user-specified textual description of the credential.
        :param pulumi.Input[str] key_id: (Updatable) The master key should be created in Oracle Cloud Infrastructure Vault owned by the client of this API.  The user should have permission to access the vault key.
        :param pulumi.Input[str] name: (Updatable) Property Name.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialPropertyArgs']]] properties: (Updatable) List of monitored resource properties.
        :param pulumi.Input[str] source: (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        :param pulumi.Input[str] type: Monitored Resource Type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        MonitoredResourceAdditionalCredentialArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            credential_type=credential_type,
            description=description,
            key_id=key_id,
            name=name,
            properties=properties,
            source=source,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             credential_type: Optional[pulumi.Input[str]] = None,
             description: Optional[pulumi.Input[str]] = None,
             key_id: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             properties: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialPropertyArgs']]]] = None,
             source: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'credentialType' in kwargs:
            credential_type = kwargs['credentialType']
        if 'keyId' in kwargs:
            key_id = kwargs['keyId']

        if credential_type is not None:
            _setter("credential_type", credential_type)
        if description is not None:
            _setter("description", description)
        if key_id is not None:
            _setter("key_id", key_id)
        if name is not None:
            _setter("name", name)
        if properties is not None:
            _setter("properties", properties)
        if source is not None:
            _setter("source", source)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of credentials specified in the credentials element. Three possible values - EXISTING, PLAINTEXT and ENCRYPTED.
        * EXISTING  - Credential is already stored in agent and only credential name need to be passed for existing credential.
        * PLAINTEXT - The credential properties will have credentials in plain text format.
        * ENCRYPTED - The credential properties will have credentials stored in vault in encrypted format using KMS client which uses master key for encryption. The same master key will be used to decrypt the credentials before passing on to the management agent.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-specified textual description of the credential.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The master key should be created in Oracle Cloud Infrastructure Vault owned by the client of this API.  The user should have permission to access the vault key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialPropertyArgs']]]]:
        """
        (Updatable) List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialPropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MonitoredResourceAdditionalCredentialPropertyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: (Updatable) Property Name.
        :param pulumi.Input[str] value: (Updatable) Property Value.
        """
        MonitoredResourceAdditionalCredentialPropertyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[pulumi.Input[str]] = None,
             value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if name is not None:
            _setter("name", name)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Property Value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class MonitoredResourceAliasesArgs:
    def __init__(__self__, *,
                 credential: pulumi.Input['MonitoredResourceAliasesCredentialArgs'],
                 name: pulumi.Input[str],
                 source: pulumi.Input[str]):
        """
        :param pulumi.Input['MonitoredResourceAliasesCredentialArgs'] credential: (Updatable) Monitored Resource Alias Reference Source Credential.
        :param pulumi.Input[str] name: (Updatable) Property Name.
        :param pulumi.Input[str] source: (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        MonitoredResourceAliasesArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            credential=credential,
            name=name,
            source=source,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             credential: pulumi.Input['MonitoredResourceAliasesCredentialArgs'],
             name: pulumi.Input[str],
             source: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("credential", credential)
        _setter("name", name)
        _setter("source", source)

    @property
    @pulumi.getter
    def credential(self) -> pulumi.Input['MonitoredResourceAliasesCredentialArgs']:
        """
        (Updatable) Monitored Resource Alias Reference Source Credential.
        """
        return pulumi.get(self, "credential")

    @credential.setter
    def credential(self, value: pulumi.Input['MonitoredResourceAliasesCredentialArgs']):
        pulumi.set(self, "credential", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class MonitoredResourceAliasesCredentialArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 service: pulumi.Input[str],
                 source: pulumi.Input[str]):
        """
        :param pulumi.Input[str] name: (Updatable) Property Name.
        :param pulumi.Input[str] service: (Updatable) The name of the service owning the credential.  Example: stack-monitoring or dbmgmt
        :param pulumi.Input[str] source: (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        MonitoredResourceAliasesCredentialArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            service=service,
            source=source,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: pulumi.Input[str],
             service: pulumi.Input[str],
             source: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("service", service)
        _setter("source", source)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def service(self) -> pulumi.Input[str]:
        """
        (Updatable) The name of the service owning the credential.  Example: stack-monitoring or dbmgmt
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: pulumi.Input[str]):
        pulumi.set(self, "service", value)

    @property
    @pulumi.getter
    def source(self) -> pulumi.Input[str]:
        """
        (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[str]):
        pulumi.set(self, "source", value)


@pulumi.input_type
class MonitoredResourceCredentialsArgs:
    def __init__(__self__, *,
                 credential_type: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceCredentialsPropertyArgs']]]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] credential_type: (Updatable) Type of credentials specified in the credentials element. Three possible values - EXISTING, PLAINTEXT and ENCRYPTED.
               * EXISTING  - Credential is already stored in agent and only credential name need to be passed for existing credential.
               * PLAINTEXT - The credential properties will have credentials in plain text format.
               * ENCRYPTED - The credential properties will have credentials stored in vault in encrypted format using KMS client which uses master key for encryption. The same master key will be used to decrypt the credentials before passing on to the management agent.
        :param pulumi.Input[str] description: (Updatable) The user-specified textual description of the credential.
        :param pulumi.Input[str] key_id: (Updatable) The master key should be created in Oracle Cloud Infrastructure Vault owned by the client of this API.  The user should have permission to access the vault key.
        :param pulumi.Input[str] name: (Updatable) Property Name.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceCredentialsPropertyArgs']]] properties: (Updatable) List of monitored resource properties.
        :param pulumi.Input[str] source: (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        :param pulumi.Input[str] type: Monitored Resource Type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        MonitoredResourceCredentialsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            credential_type=credential_type,
            description=description,
            key_id=key_id,
            name=name,
            properties=properties,
            source=source,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             credential_type: Optional[pulumi.Input[str]] = None,
             description: Optional[pulumi.Input[str]] = None,
             key_id: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             properties: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceCredentialsPropertyArgs']]]] = None,
             source: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'credentialType' in kwargs:
            credential_type = kwargs['credentialType']
        if 'keyId' in kwargs:
            key_id = kwargs['keyId']

        if credential_type is not None:
            _setter("credential_type", credential_type)
        if description is not None:
            _setter("description", description)
        if key_id is not None:
            _setter("key_id", key_id)
        if name is not None:
            _setter("name", name)
        if properties is not None:
            _setter("properties", properties)
        if source is not None:
            _setter("source", source)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Type of credentials specified in the credentials element. Three possible values - EXISTING, PLAINTEXT and ENCRYPTED.
        * EXISTING  - Credential is already stored in agent and only credential name need to be passed for existing credential.
        * PLAINTEXT - The credential properties will have credentials in plain text format.
        * ENCRYPTED - The credential properties will have credentials stored in vault in encrypted format using KMS client which uses master key for encryption. The same master key will be used to decrypt the credentials before passing on to the management agent.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The user-specified textual description of the credential.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The master key should be created in Oracle Cloud Infrastructure Vault owned by the client of this API.  The user should have permission to access the vault key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceCredentialsPropertyArgs']]]]:
        """
        (Updatable) List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceCredentialsPropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The source type and source name combination, delimited with (.) separator. {source type}.{source name} and source type max char limit is 63.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MonitoredResourceCredentialsPropertyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: (Updatable) Property Name.
        :param pulumi.Input[str] value: (Updatable) Property Value.
        """
        MonitoredResourceCredentialsPropertyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[pulumi.Input[str]] = None,
             value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if name is not None:
            _setter("name", name)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Property Value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class MonitoredResourceDatabaseConnectionDetailsArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 protocol: pulumi.Input[str],
                 service_name: pulumi.Input[str],
                 connector_id: Optional[pulumi.Input[str]] = None,
                 db_id: Optional[pulumi.Input[str]] = None,
                 db_unique_name: Optional[pulumi.Input[str]] = None,
                 ssl_secret_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] port: (Updatable) Listener Port number used for connection requests.
        :param pulumi.Input[str] protocol: (Updatable) Protocol used in DB connection string when connecting to external database service.
        :param pulumi.Input[str] service_name: (Updatable) Service name used for connection requests.
        :param pulumi.Input[str] connector_id: (Updatable) Database connector Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] db_id: (Updatable) dbId of the database.
        :param pulumi.Input[str] db_unique_name: (Updatable) UniqueName used for database connection requests.
        :param pulumi.Input[str] ssl_secret_id: (Updatable) SSL Secret Identifier for TCPS connector in Oracle Cloud Infrastructure Vault[OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        MonitoredResourceDatabaseConnectionDetailsArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            port=port,
            protocol=protocol,
            service_name=service_name,
            connector_id=connector_id,
            db_id=db_id,
            db_unique_name=db_unique_name,
            ssl_secret_id=ssl_secret_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             port: pulumi.Input[int],
             protocol: pulumi.Input[str],
             service_name: pulumi.Input[str],
             connector_id: Optional[pulumi.Input[str]] = None,
             db_id: Optional[pulumi.Input[str]] = None,
             db_unique_name: Optional[pulumi.Input[str]] = None,
             ssl_secret_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'serviceName' in kwargs:
            service_name = kwargs['serviceName']
        if 'connectorId' in kwargs:
            connector_id = kwargs['connectorId']
        if 'dbId' in kwargs:
            db_id = kwargs['dbId']
        if 'dbUniqueName' in kwargs:
            db_unique_name = kwargs['dbUniqueName']
        if 'sslSecretId' in kwargs:
            ssl_secret_id = kwargs['sslSecretId']

        _setter("port", port)
        _setter("protocol", protocol)
        _setter("service_name", service_name)
        if connector_id is not None:
            _setter("connector_id", connector_id)
        if db_id is not None:
            _setter("db_id", db_id)
        if db_unique_name is not None:
            _setter("db_unique_name", db_unique_name)
        if ssl_secret_id is not None:
            _setter("ssl_secret_id", ssl_secret_id)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        (Updatable) Listener Port number used for connection requests.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        (Updatable) Protocol used in DB connection string when connecting to external database service.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Service name used for connection requests.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Database connector Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connector_id", value)

    @property
    @pulumi.getter(name="dbId")
    def db_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) dbId of the database.
        """
        return pulumi.get(self, "db_id")

    @db_id.setter
    def db_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_id", value)

    @property
    @pulumi.getter(name="dbUniqueName")
    def db_unique_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) UniqueName used for database connection requests.
        """
        return pulumi.get(self, "db_unique_name")

    @db_unique_name.setter
    def db_unique_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_unique_name", value)

    @property
    @pulumi.getter(name="sslSecretId")
    def ssl_secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) SSL Secret Identifier for TCPS connector in Oracle Cloud Infrastructure Vault[OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "ssl_secret_id")

    @ssl_secret_id.setter
    def ssl_secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ssl_secret_id", value)


@pulumi.input_type
class MonitoredResourcePropertyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: (Updatable) Property Name.
        :param pulumi.Input[str] value: (Updatable) Property Value.
        """
        MonitoredResourcePropertyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[pulumi.Input[str]] = None,
             value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if name is not None:
            _setter("name", name)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Property Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Property Value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetailArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] name: Monitored Resource Name.
        :param pulumi.Input[str] type: Monitored Resource Type.
        """
        MonitoredResourcesAssociateMonitoredResourceDestinationResourceDetailArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            name=name,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if name is not None:
            _setter("name", name)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MonitoredResourcesAssociateMonitoredResourceSourceResourceDetailArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] name: Monitored Resource Name.
        :param pulumi.Input[str] type: Monitored Resource Type.
        """
        MonitoredResourcesAssociateMonitoredResourceSourceResourceDetailArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            name=name,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if name is not None:
            _setter("name", name)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MonitoredResourcesListMemberItemArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 resource_display_name: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 resource_name: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        :param pulumi.Input[str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host_name: Monitored Resource Host Name.
        :param pulumi.Input[str] parent_id: Parent monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] resource_display_name: Monitored resource display name.
        :param pulumi.Input[str] resource_id: Monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] resource_name: Monitored Resource Name.
        :param pulumi.Input[str] resource_type: Monitored Resource Type.
        :param pulumi.Input[str] state: The current state of the Resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        MonitoredResourcesListMemberItemArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            external_id=external_id,
            freeform_tags=freeform_tags,
            host_name=host_name,
            parent_id=parent_id,
            resource_display_name=resource_display_name,
            resource_id=resource_id,
            resource_name=resource_name,
            resource_type=resource_type,
            state=state,
            system_tags=system_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             external_id: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             host_name: Optional[pulumi.Input[str]] = None,
             parent_id: Optional[pulumi.Input[str]] = None,
             resource_display_name: Optional[pulumi.Input[str]] = None,
             resource_id: Optional[pulumi.Input[str]] = None,
             resource_name: Optional[pulumi.Input[str]] = None,
             resource_type: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'externalId' in kwargs:
            external_id = kwargs['externalId']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'hostName' in kwargs:
            host_name = kwargs['hostName']
        if 'parentId' in kwargs:
            parent_id = kwargs['parentId']
        if 'resourceDisplayName' in kwargs:
            resource_display_name = kwargs['resourceDisplayName']
        if 'resourceId' in kwargs:
            resource_id = kwargs['resourceId']
        if 'resourceName' in kwargs:
            resource_name = kwargs['resourceName']
        if 'resourceType' in kwargs:
            resource_type = kwargs['resourceType']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if external_id is not None:
            _setter("external_id", external_id)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if host_name is not None:
            _setter("host_name", host_name)
        if parent_id is not None:
            _setter("parent_id", parent_id)
        if resource_display_name is not None:
            _setter("resource_display_name", resource_display_name)
        if resource_id is not None:
            _setter("resource_id", resource_id)
        if resource_name is not None:
            _setter("resource_name", resource_name)
        if resource_type is not None:
            _setter("resource_type", resource_type)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Host Name.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[str]]:
        """
        Parent monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter(name="resourceDisplayName")
    def resource_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored resource display name.
        """
        return pulumi.get(self, "resource_display_name")

    @resource_display_name.setter
    def resource_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_display_name", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Type.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)


@pulumi.input_type
class MonitoredResourcesSearchAssociationItemArgs:
    def __init__(__self__, *,
                 association_type: Optional[pulumi.Input[str]] = None,
                 destination_resource_details: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchAssociationItemDestinationResourceDetailArgs']]]] = None,
                 destination_resource_id: Optional[pulumi.Input[str]] = None,
                 source_resource_details: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchAssociationItemSourceResourceDetailArgs']]]] = None,
                 source_resource_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] association_type: Association type filter to search associated resources.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchAssociationItemDestinationResourceDetailArgs']]] destination_resource_details: Association Resource Details.
        :param pulumi.Input[str] destination_resource_id: Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchAssociationItemSourceResourceDetailArgs']]] source_resource_details: Association Resource Details.
        :param pulumi.Input[str] source_resource_id: Source Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] time_created: The association creation time. An RFC3339 formatted datetime string.
        """
        MonitoredResourcesSearchAssociationItemArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            association_type=association_type,
            destination_resource_details=destination_resource_details,
            destination_resource_id=destination_resource_id,
            source_resource_details=source_resource_details,
            source_resource_id=source_resource_id,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             association_type: Optional[pulumi.Input[str]] = None,
             destination_resource_details: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchAssociationItemDestinationResourceDetailArgs']]]] = None,
             destination_resource_id: Optional[pulumi.Input[str]] = None,
             source_resource_details: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchAssociationItemSourceResourceDetailArgs']]]] = None,
             source_resource_id: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'associationType' in kwargs:
            association_type = kwargs['associationType']
        if 'destinationResourceDetails' in kwargs:
            destination_resource_details = kwargs['destinationResourceDetails']
        if 'destinationResourceId' in kwargs:
            destination_resource_id = kwargs['destinationResourceId']
        if 'sourceResourceDetails' in kwargs:
            source_resource_details = kwargs['sourceResourceDetails']
        if 'sourceResourceId' in kwargs:
            source_resource_id = kwargs['sourceResourceId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        if association_type is not None:
            _setter("association_type", association_type)
        if destination_resource_details is not None:
            _setter("destination_resource_details", destination_resource_details)
        if destination_resource_id is not None:
            _setter("destination_resource_id", destination_resource_id)
        if source_resource_details is not None:
            _setter("source_resource_details", source_resource_details)
        if source_resource_id is not None:
            _setter("source_resource_id", source_resource_id)
        if time_created is not None:
            _setter("time_created", time_created)

    @property
    @pulumi.getter(name="associationType")
    def association_type(self) -> Optional[pulumi.Input[str]]:
        """
        Association type filter to search associated resources.
        """
        return pulumi.get(self, "association_type")

    @association_type.setter
    def association_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "association_type", value)

    @property
    @pulumi.getter(name="destinationResourceDetails")
    def destination_resource_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchAssociationItemDestinationResourceDetailArgs']]]]:
        """
        Association Resource Details.
        """
        return pulumi.get(self, "destination_resource_details")

    @destination_resource_details.setter
    def destination_resource_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchAssociationItemDestinationResourceDetailArgs']]]]):
        pulumi.set(self, "destination_resource_details", value)

    @property
    @pulumi.getter(name="destinationResourceId")
    def destination_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Destination Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "destination_resource_id")

    @destination_resource_id.setter
    def destination_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_resource_id", value)

    @property
    @pulumi.getter(name="sourceResourceDetails")
    def source_resource_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchAssociationItemSourceResourceDetailArgs']]]]:
        """
        Association Resource Details.
        """
        return pulumi.get(self, "source_resource_details")

    @source_resource_details.setter
    def source_resource_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchAssociationItemSourceResourceDetailArgs']]]]):
        pulumi.set(self, "source_resource_details", value)

    @property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Source Monitored Resource Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_resource_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The association creation time. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


@pulumi.input_type
class MonitoredResourcesSearchAssociationItemDestinationResourceDetailArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] name: Monitored Resource Name.
        :param pulumi.Input[str] type: Monitored Resource Type.
        """
        MonitoredResourcesSearchAssociationItemDestinationResourceDetailArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            name=name,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if name is not None:
            _setter("name", name)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MonitoredResourcesSearchAssociationItemSourceResourceDetailArgs:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compartment_id: Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] name: Monitored Resource Name.
        :param pulumi.Input[str] type: Monitored Resource Type.
        """
        MonitoredResourcesSearchAssociationItemSourceResourceDetailArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            name=name,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if name is not None:
            _setter("name", name)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored Resource Type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MonitoredResourcesSearchItemArgs:
    def __init__(__self__, *,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 host_name: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 management_agent_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchItemPropertyArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: Monitored resource display name.
        :param pulumi.Input[str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] host_name: A filter to return resources with host name match.
        :param pulumi.Input[str] id: Monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] management_agent_id: A filter to return resources with matching management agent id.
        :param pulumi.Input[str] name: A filter to return resources that match exact resource name.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchItemPropertyArgs']]] properties: List of monitored resource properties.
        :param pulumi.Input[str] state: A filter to return resources with matching lifecycle state.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: Monitored resource creation time. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: Monitored resource update time. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] type: A filter to return resources that match resource type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        MonitoredResourcesSearchItemArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            defined_tags=defined_tags,
            display_name=display_name,
            external_id=external_id,
            freeform_tags=freeform_tags,
            host_name=host_name,
            id=id,
            management_agent_id=management_agent_id,
            name=name,
            properties=properties,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             external_id: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             host_name: Optional[pulumi.Input[str]] = None,
             id: Optional[pulumi.Input[str]] = None,
             management_agent_id: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             properties: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchItemPropertyArgs']]]] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'externalId' in kwargs:
            external_id = kwargs['externalId']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'hostName' in kwargs:
            host_name = kwargs['hostName']
        if 'managementAgentId' in kwargs:
            management_agent_id = kwargs['managementAgentId']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if external_id is not None:
            _setter("external_id", external_id)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if host_name is not None:
            _setter("host_name", host_name)
        if id is not None:
            _setter("id", id)
        if management_agent_id is not None:
            _setter("management_agent_id", management_agent_id)
        if name is not None:
            _setter("name", name)
        if properties is not None:
            _setter("properties", properties)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)
        if type is not None:
            _setter("type", type)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored resource display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only following resource types - Container database, non-container database,  pluggable database and Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[str]]:
        """
        A filter to return resources with host name match.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_name", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[str]]:
        """
        A filter to return resources with matching management agent id.
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "management_agent_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A filter to return resources that match exact resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchItemPropertyArgs']]]]:
        """
        List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcesSearchItemPropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        A filter to return resources with matching lifecycle state.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored resource creation time. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        Monitored resource update time. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        A filter to return resources that match resource type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class MonitoredResourcesSearchItemPropertyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: A filter to return resources that match exact resource name.
        :param pulumi.Input[str] value: Property Value.
        """
        MonitoredResourcesSearchItemPropertyArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[pulumi.Input[str]] = None,
             value: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if name is not None:
            _setter("name", name)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A filter to return resources that match exact resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Property Value.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GetConfigsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetConfigsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDiscoveryJobLogsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetDiscoveryJobLogsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class GetDiscoveryJobsFilterArgs:
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: A filter to return only discovery jobs that match the entire resource name given.
        """
        GetDiscoveryJobsFilterArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A filter to return only discovery jobs that match the entire resource name given.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: str):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Sequence[str]):
        pulumi.set(self, "values", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[bool]):
        pulumi.set(self, "regex", value)


