# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PathAnalyzerTestArgs', 'PathAnalyzerTest']

@pulumi.input_type
class PathAnalyzerTestArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 destination_endpoint: pulumi.Input['PathAnalyzerTestDestinationEndpointArgs'],
                 protocol: pulumi.Input[int],
                 source_endpoint: pulumi.Input['PathAnalyzerTestSourceEndpointArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 protocol_parameters: Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']] = None,
                 query_options: Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']] = None):
        """
        The set of arguments for constructing a PathAnalyzerTest resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        :param pulumi.Input['PathAnalyzerTestDestinationEndpointArgs'] destination_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[int] protocol: (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        :param pulumi.Input['PathAnalyzerTestSourceEndpointArgs'] source_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input['PathAnalyzerTestProtocolParametersArgs'] protocol_parameters: (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        :param pulumi.Input['PathAnalyzerTestQueryOptionsArgs'] query_options: (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        """
        PathAnalyzerTestArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            destination_endpoint=destination_endpoint,
            protocol=protocol,
            source_endpoint=source_endpoint,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            protocol_parameters=protocol_parameters,
            query_options=query_options,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             destination_endpoint: pulumi.Input['PathAnalyzerTestDestinationEndpointArgs'],
             protocol: pulumi.Input[int],
             source_endpoint: pulumi.Input['PathAnalyzerTestSourceEndpointArgs'],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             protocol_parameters: Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']] = None,
             query_options: Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'destinationEndpoint' in kwargs:
            destination_endpoint = kwargs['destinationEndpoint']
        if 'sourceEndpoint' in kwargs:
            source_endpoint = kwargs['sourceEndpoint']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'protocolParameters' in kwargs:
            protocol_parameters = kwargs['protocolParameters']
        if 'queryOptions' in kwargs:
            query_options = kwargs['queryOptions']

        _setter("compartment_id", compartment_id)
        _setter("destination_endpoint", destination_endpoint)
        _setter("protocol", protocol)
        _setter("source_endpoint", source_endpoint)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if protocol_parameters is not None:
            _setter("protocol_parameters", protocol_parameters)
        if query_options is not None:
            _setter("query_options", query_options)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="destinationEndpoint")
    def destination_endpoint(self) -> pulumi.Input['PathAnalyzerTestDestinationEndpointArgs']:
        """
        (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_endpoint")

    @destination_endpoint.setter
    def destination_endpoint(self, value: pulumi.Input['PathAnalyzerTestDestinationEndpointArgs']):
        pulumi.set(self, "destination_endpoint", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[int]:
        """
        (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[int]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="sourceEndpoint")
    def source_endpoint(self) -> pulumi.Input['PathAnalyzerTestSourceEndpointArgs']:
        """
        (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_endpoint")

    @source_endpoint.setter
    def source_endpoint(self, value: pulumi.Input['PathAnalyzerTestSourceEndpointArgs']):
        pulumi.set(self, "source_endpoint", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="protocolParameters")
    def protocol_parameters(self) -> Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']]:
        """
        (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol_parameters")

    @protocol_parameters.setter
    def protocol_parameters(self, value: Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']]):
        pulumi.set(self, "protocol_parameters", value)

    @property
    @pulumi.getter(name="queryOptions")
    def query_options(self) -> Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']]:
        """
        (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "query_options")

    @query_options.setter
    def query_options(self, value: Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']]):
        pulumi.set(self, "query_options", value)


@pulumi.input_type
class _PathAnalyzerTestState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 destination_endpoint: Optional[pulumi.Input['PathAnalyzerTestDestinationEndpointArgs']] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 protocol: Optional[pulumi.Input[int]] = None,
                 protocol_parameters: Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']] = None,
                 query_options: Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']] = None,
                 source_endpoint: Optional[pulumi.Input['PathAnalyzerTestSourceEndpointArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PathAnalyzerTest resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input['PathAnalyzerTestDestinationEndpointArgs'] destination_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] protocol: (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        :param pulumi.Input['PathAnalyzerTestProtocolParametersArgs'] protocol_parameters: (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        :param pulumi.Input['PathAnalyzerTestQueryOptionsArgs'] query_options: (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        :param pulumi.Input['PathAnalyzerTestSourceEndpointArgs'] source_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[str] state: The current state of the `PathAnalyzerTest` resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_updated: The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        _PathAnalyzerTestState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            destination_endpoint=destination_endpoint,
            display_name=display_name,
            freeform_tags=freeform_tags,
            protocol=protocol,
            protocol_parameters=protocol_parameters,
            query_options=query_options,
            source_endpoint=source_endpoint,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             destination_endpoint: Optional[pulumi.Input['PathAnalyzerTestDestinationEndpointArgs']] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             protocol: Optional[pulumi.Input[int]] = None,
             protocol_parameters: Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']] = None,
             query_options: Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']] = None,
             source_endpoint: Optional[pulumi.Input['PathAnalyzerTestSourceEndpointArgs']] = None,
             state: Optional[pulumi.Input[str]] = None,
             system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'destinationEndpoint' in kwargs:
            destination_endpoint = kwargs['destinationEndpoint']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'protocolParameters' in kwargs:
            protocol_parameters = kwargs['protocolParameters']
        if 'queryOptions' in kwargs:
            query_options = kwargs['queryOptions']
        if 'sourceEndpoint' in kwargs:
            source_endpoint = kwargs['sourceEndpoint']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if destination_endpoint is not None:
            _setter("destination_endpoint", destination_endpoint)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if protocol is not None:
            _setter("protocol", protocol)
        if protocol_parameters is not None:
            _setter("protocol_parameters", protocol_parameters)
        if query_options is not None:
            _setter("query_options", query_options)
        if source_endpoint is not None:
            _setter("source_endpoint", source_endpoint)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="destinationEndpoint")
    def destination_endpoint(self) -> Optional[pulumi.Input['PathAnalyzerTestDestinationEndpointArgs']]:
        """
        (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_endpoint")

    @destination_endpoint.setter
    def destination_endpoint(self, value: Optional[pulumi.Input['PathAnalyzerTestDestinationEndpointArgs']]):
        pulumi.set(self, "destination_endpoint", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter(name="protocolParameters")
    def protocol_parameters(self) -> Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']]:
        """
        (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol_parameters")

    @protocol_parameters.setter
    def protocol_parameters(self, value: Optional[pulumi.Input['PathAnalyzerTestProtocolParametersArgs']]):
        pulumi.set(self, "protocol_parameters", value)

    @property
    @pulumi.getter(name="queryOptions")
    def query_options(self) -> Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']]:
        """
        (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "query_options")

    @query_options.setter
    def query_options(self, value: Optional[pulumi.Input['PathAnalyzerTestQueryOptionsArgs']]):
        pulumi.set(self, "query_options", value)

    @property
    @pulumi.getter(name="sourceEndpoint")
    def source_endpoint(self) -> Optional[pulumi.Input['PathAnalyzerTestSourceEndpointArgs']]:
        """
        (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_endpoint")

    @source_endpoint.setter
    def source_endpoint(self, value: Optional[pulumi.Input['PathAnalyzerTestSourceEndpointArgs']]):
        pulumi.set(self, "source_endpoint", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class PathAnalyzerTest(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 destination_endpoint: Optional[pulumi.Input[pulumi.InputType['PathAnalyzerTestDestinationEndpointArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 protocol: Optional[pulumi.Input[int]] = None,
                 protocol_parameters: Optional[pulumi.Input[pulumi.InputType['PathAnalyzerTestProtocolParametersArgs']]] = None,
                 query_options: Optional[pulumi.Input[pulumi.InputType['PathAnalyzerTestQueryOptionsArgs']]] = None,
                 source_endpoint: Optional[pulumi.Input[pulumi.InputType['PathAnalyzerTestSourceEndpointArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Path Analyzer Test resource in Oracle Cloud Infrastructure Vn Monitoring service.

        Creates a new `PathAnalyzerTest` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_path_analyzer_test = oci.vn_monitoring.PathAnalyzerTest("testPathAnalyzerTest",
            compartment_id=var["compartment_id"],
            destination_endpoint=oci.vn_monitoring.PathAnalyzerTestDestinationEndpointArgs(
                type=var["path_analyzer_test_destination_endpoint_type"],
                address=var["path_analyzer_test_destination_endpoint_address"],
                instance_id=oci_core_instance["test_instance"]["id"],
                listener_id=oci_load_balancer_listener["test_listener"]["id"],
                load_balancer_id=oci_load_balancer_load_balancer["test_load_balancer"]["id"],
                network_load_balancer_id=oci_network_load_balancer_network_load_balancer["test_network_load_balancer"]["id"],
                subnet_id=oci_core_subnet["test_subnet"]["id"],
                vlan_id=oci_core_vlan["test_vlan"]["id"],
                vnic_id=oci_core_vnic_attachment["test_vnic_attachment"]["id"],
            ),
            protocol=var["path_analyzer_test_protocol"],
            source_endpoint=oci.vn_monitoring.PathAnalyzerTestSourceEndpointArgs(
                type=var["path_analyzer_test_source_endpoint_type"],
                address=var["path_analyzer_test_source_endpoint_address"],
                instance_id=oci_core_instance["test_instance"]["id"],
                listener_id=oci_load_balancer_listener["test_listener"]["id"],
                load_balancer_id=oci_load_balancer_load_balancer["test_load_balancer"]["id"],
                network_load_balancer_id=oci_network_load_balancer_network_load_balancer["test_network_load_balancer"]["id"],
                subnet_id=oci_core_subnet["test_subnet"]["id"],
                vlan_id=oci_core_vlan["test_vlan"]["id"],
                vnic_id=oci_core_vnic_attachment["test_vnic_attachment"]["id"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=var["path_analyzer_test_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            protocol_parameters=oci.vn_monitoring.PathAnalyzerTestProtocolParametersArgs(
                type=var["path_analyzer_test_protocol_parameters_type"],
                destination_port=var["path_analyzer_test_protocol_parameters_destination_port"],
                icmp_code=var["path_analyzer_test_protocol_parameters_icmp_code"],
                icmp_type=var["path_analyzer_test_protocol_parameters_icmp_type"],
                source_port=var["path_analyzer_test_protocol_parameters_source_port"],
            ),
            query_options=oci.vn_monitoring.PathAnalyzerTestQueryOptionsArgs(
                is_bi_directional_analysis=var["path_analyzer_test_query_options_is_bi_directional_analysis"],
            ))
        ```

        ## Import

        PathAnalyzerTests can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:VnMonitoring/pathAnalyzerTest:PathAnalyzerTest test_path_analyzer_test "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[pulumi.InputType['PathAnalyzerTestDestinationEndpointArgs']] destination_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] protocol: (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        :param pulumi.Input[pulumi.InputType['PathAnalyzerTestProtocolParametersArgs']] protocol_parameters: (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        :param pulumi.Input[pulumi.InputType['PathAnalyzerTestQueryOptionsArgs']] query_options: (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        :param pulumi.Input[pulumi.InputType['PathAnalyzerTestSourceEndpointArgs']] source_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PathAnalyzerTestArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Path Analyzer Test resource in Oracle Cloud Infrastructure Vn Monitoring service.

        Creates a new `PathAnalyzerTest` resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_path_analyzer_test = oci.vn_monitoring.PathAnalyzerTest("testPathAnalyzerTest",
            compartment_id=var["compartment_id"],
            destination_endpoint=oci.vn_monitoring.PathAnalyzerTestDestinationEndpointArgs(
                type=var["path_analyzer_test_destination_endpoint_type"],
                address=var["path_analyzer_test_destination_endpoint_address"],
                instance_id=oci_core_instance["test_instance"]["id"],
                listener_id=oci_load_balancer_listener["test_listener"]["id"],
                load_balancer_id=oci_load_balancer_load_balancer["test_load_balancer"]["id"],
                network_load_balancer_id=oci_network_load_balancer_network_load_balancer["test_network_load_balancer"]["id"],
                subnet_id=oci_core_subnet["test_subnet"]["id"],
                vlan_id=oci_core_vlan["test_vlan"]["id"],
                vnic_id=oci_core_vnic_attachment["test_vnic_attachment"]["id"],
            ),
            protocol=var["path_analyzer_test_protocol"],
            source_endpoint=oci.vn_monitoring.PathAnalyzerTestSourceEndpointArgs(
                type=var["path_analyzer_test_source_endpoint_type"],
                address=var["path_analyzer_test_source_endpoint_address"],
                instance_id=oci_core_instance["test_instance"]["id"],
                listener_id=oci_load_balancer_listener["test_listener"]["id"],
                load_balancer_id=oci_load_balancer_load_balancer["test_load_balancer"]["id"],
                network_load_balancer_id=oci_network_load_balancer_network_load_balancer["test_network_load_balancer"]["id"],
                subnet_id=oci_core_subnet["test_subnet"]["id"],
                vlan_id=oci_core_vlan["test_vlan"]["id"],
                vnic_id=oci_core_vnic_attachment["test_vnic_attachment"]["id"],
            ),
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=var["path_analyzer_test_display_name"],
            freeform_tags={
                "bar-key": "value",
            },
            protocol_parameters=oci.vn_monitoring.PathAnalyzerTestProtocolParametersArgs(
                type=var["path_analyzer_test_protocol_parameters_type"],
                destination_port=var["path_analyzer_test_protocol_parameters_destination_port"],
                icmp_code=var["path_analyzer_test_protocol_parameters_icmp_code"],
                icmp_type=var["path_analyzer_test_protocol_parameters_icmp_type"],
                source_port=var["path_analyzer_test_protocol_parameters_source_port"],
            ),
            query_options=oci.vn_monitoring.PathAnalyzerTestQueryOptionsArgs(
                is_bi_directional_analysis=var["path_analyzer_test_query_options_is_bi_directional_analysis"],
            ))
        ```

        ## Import

        PathAnalyzerTests can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:VnMonitoring/pathAnalyzerTest:PathAnalyzerTest test_path_analyzer_test "id"
        ```

        :param str resource_name: The name of the resource.
        :param PathAnalyzerTestArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PathAnalyzerTestArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            PathAnalyzerTestArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 destination_endpoint: Optional[pulumi.Input[pulumi.InputType['PathAnalyzerTestDestinationEndpointArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 protocol: Optional[pulumi.Input[int]] = None,
                 protocol_parameters: Optional[pulumi.Input[pulumi.InputType['PathAnalyzerTestProtocolParametersArgs']]] = None,
                 query_options: Optional[pulumi.Input[pulumi.InputType['PathAnalyzerTestQueryOptionsArgs']]] = None,
                 source_endpoint: Optional[pulumi.Input[pulumi.InputType['PathAnalyzerTestSourceEndpointArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PathAnalyzerTestArgs.__new__(PathAnalyzerTestArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if destination_endpoint is not None and not isinstance(destination_endpoint, PathAnalyzerTestDestinationEndpointArgs):
                destination_endpoint = destination_endpoint or {}
                def _setter(key, value):
                    destination_endpoint[key] = value
                PathAnalyzerTestDestinationEndpointArgs._configure(_setter, **destination_endpoint)
            if destination_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'destination_endpoint'")
            __props__.__dict__["destination_endpoint"] = destination_endpoint
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
            if protocol_parameters is not None and not isinstance(protocol_parameters, PathAnalyzerTestProtocolParametersArgs):
                protocol_parameters = protocol_parameters or {}
                def _setter(key, value):
                    protocol_parameters[key] = value
                PathAnalyzerTestProtocolParametersArgs._configure(_setter, **protocol_parameters)
            __props__.__dict__["protocol_parameters"] = protocol_parameters
            if query_options is not None and not isinstance(query_options, PathAnalyzerTestQueryOptionsArgs):
                query_options = query_options or {}
                def _setter(key, value):
                    query_options[key] = value
                PathAnalyzerTestQueryOptionsArgs._configure(_setter, **query_options)
            __props__.__dict__["query_options"] = query_options
            if source_endpoint is not None and not isinstance(source_endpoint, PathAnalyzerTestSourceEndpointArgs):
                source_endpoint = source_endpoint or {}
                def _setter(key, value):
                    source_endpoint[key] = value
                PathAnalyzerTestSourceEndpointArgs._configure(_setter, **source_endpoint)
            if source_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'source_endpoint'")
            __props__.__dict__["source_endpoint"] = source_endpoint
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(PathAnalyzerTest, __self__).__init__(
            'oci:VnMonitoring/pathAnalyzerTest:PathAnalyzerTest',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            destination_endpoint: Optional[pulumi.Input[pulumi.InputType['PathAnalyzerTestDestinationEndpointArgs']]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            protocol: Optional[pulumi.Input[int]] = None,
            protocol_parameters: Optional[pulumi.Input[pulumi.InputType['PathAnalyzerTestProtocolParametersArgs']]] = None,
            query_options: Optional[pulumi.Input[pulumi.InputType['PathAnalyzerTestQueryOptionsArgs']]] = None,
            source_endpoint: Optional[pulumi.Input[pulumi.InputType['PathAnalyzerTestSourceEndpointArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'PathAnalyzerTest':
        """
        Get an existing PathAnalyzerTest resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[pulumi.InputType['PathAnalyzerTestDestinationEndpointArgs']] destination_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[int] protocol: (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        :param pulumi.Input[pulumi.InputType['PathAnalyzerTestProtocolParametersArgs']] protocol_parameters: (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        :param pulumi.Input[pulumi.InputType['PathAnalyzerTestQueryOptionsArgs']] query_options: (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        :param pulumi.Input[pulumi.InputType['PathAnalyzerTestSourceEndpointArgs']] source_endpoint: (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        :param pulumi.Input[str] state: The current state of the `PathAnalyzerTest` resource.
        :param pulumi.Input[Mapping[str, Any]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_updated: The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PathAnalyzerTestState.__new__(_PathAnalyzerTestState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["destination_endpoint"] = destination_endpoint
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["protocol"] = protocol
        __props__.__dict__["protocol_parameters"] = protocol_parameters
        __props__.__dict__["query_options"] = query_options
        __props__.__dict__["source_endpoint"] = source_endpoint
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return PathAnalyzerTest(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the `PathAnalyzerTest` resource's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="destinationEndpoint")
    def destination_endpoint(self) -> pulumi.Output['outputs.PathAnalyzerTestDestinationEndpoint']:
        """
        (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "destination_endpoint")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[int]:
        """
        (Updatable) The IP protocol to use in the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="protocolParameters")
    def protocol_parameters(self) -> pulumi.Output['outputs.PathAnalyzerTestProtocolParameters']:
        """
        (Updatable) Defines the IP protocol parameters for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "protocol_parameters")

    @property
    @pulumi.getter(name="queryOptions")
    def query_options(self) -> pulumi.Output['outputs.PathAnalyzerTestQueryOptions']:
        """
        (Updatable) Defines the query options required for a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "query_options")

    @property
    @pulumi.getter(name="sourceEndpoint")
    def source_endpoint(self) -> pulumi.Output['outputs.PathAnalyzerTestSourceEndpoint']:
        """
        (Updatable) Information describing a source or destination in a `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "source_endpoint")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the `PathAnalyzerTest` resource.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the `PathAnalyzerTest` resource was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the `PathAnalyzerTest` resource was last updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_updated")

