# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetCustomProtectionRuleResult',
    'AwaitableGetCustomProtectionRuleResult',
    'get_custom_protection_rule',
    'get_custom_protection_rule_output',
]

@pulumi.output_type
class GetCustomProtectionRuleResult:
    """
    A collection of values returned by getCustomProtectionRule.
    """
    def __init__(__self__, compartment_id=None, custom_protection_rule_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, mod_security_rule_ids=None, state=None, template=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if custom_protection_rule_id and not isinstance(custom_protection_rule_id, str):
            raise TypeError("Expected argument 'custom_protection_rule_id' to be a str")
        pulumi.set(__self__, "custom_protection_rule_id", custom_protection_rule_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mod_security_rule_ids and not isinstance(mod_security_rule_ids, list):
            raise TypeError("Expected argument 'mod_security_rule_ids' to be a list")
        pulumi.set(__self__, "mod_security_rule_ids", mod_security_rule_ids)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if template and not isinstance(template, str):
            raise TypeError("Expected argument 'template' to be a str")
        pulumi.set(__self__, "template", template)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom protection rule's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="customProtectionRuleId")
    def custom_protection_rule_id(self) -> str:
        return pulumi.get(self, "custom_protection_rule_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the custom protection rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name of the custom protection rule.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom protection rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="modSecurityRuleIds")
    def mod_security_rule_ids(self) -> Sequence[str]:
        """
        The auto-generated ID for the custom protection rule. These IDs are referenced in logs.
        """
        return pulumi.get(self, "mod_security_rule_ids")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the custom protection rule.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def template(self) -> str:
        """
        The template text of the custom protection rule. All custom protection rules are expressed in ModSecurity Rule Language.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the protection rule was created, expressed in RFC 3339 timestamp format.
        """
        return pulumi.get(self, "time_created")


class AwaitableGetCustomProtectionRuleResult(GetCustomProtectionRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCustomProtectionRuleResult(
            compartment_id=self.compartment_id,
            custom_protection_rule_id=self.custom_protection_rule_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            mod_security_rule_ids=self.mod_security_rule_ids,
            state=self.state,
            template=self.template,
            time_created=self.time_created)


def get_custom_protection_rule(custom_protection_rule_id: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCustomProtectionRuleResult:
    """
    This data source provides details about a specific Custom Protection Rule resource in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

    Gets the details of a custom protection rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_custom_protection_rule = oci.Waas.get_custom_protection_rule(custom_protection_rule_id=oci_waas_custom_protection_rule["test_custom_protection_rule"]["id"])
    ```


    :param str custom_protection_rule_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom protection rule. This number is generated when the custom protection rule is added to the compartment.
    """
    __args__ = dict()
    __args__['customProtectionRuleId'] = custom_protection_rule_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Waas/getCustomProtectionRule:getCustomProtectionRule', __args__, opts=opts, typ=GetCustomProtectionRuleResult).value

    return AwaitableGetCustomProtectionRuleResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        custom_protection_rule_id=pulumi.get(__ret__, 'custom_protection_rule_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        mod_security_rule_ids=pulumi.get(__ret__, 'mod_security_rule_ids'),
        state=pulumi.get(__ret__, 'state'),
        template=pulumi.get(__ret__, 'template'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_custom_protection_rule)
def get_custom_protection_rule_output(custom_protection_rule_id: Optional[pulumi.Input[str]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCustomProtectionRuleResult]:
    """
    This data source provides details about a specific Custom Protection Rule resource in Oracle Cloud Infrastructure Web Application Acceleration and Security service.

    Gets the details of a custom protection rule.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_custom_protection_rule = oci.Waas.get_custom_protection_rule(custom_protection_rule_id=oci_waas_custom_protection_rule["test_custom_protection_rule"]["id"])
    ```


    :param str custom_protection_rule_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the custom protection rule. This number is generated when the custom protection rule is added to the compartment.
    """
    ...
