from logging import INFO, WARNING

# Timing
SECOND = 1.0
MINUTE = 60.0 * SECOND
HOUR = 60.0 * MINUTE
DAY = 24.0 * HOUR

# Vtex Auth
APP_KEY_HEADER = "X-VTEX-API-AppKey"
APP_TOKEN_HEADER = "X-VTEX-API-AppToken"  # noqa: S105

# Configs
ACCOUNT_NAME_ENV_VAR = "VTEX_ACCOUNT_NAME"
APP_KEY_ENV_VAR = "VTEX_APP_KEY"
APP_TOKEN_ENV_VAR = "VTEX_APP_TOKEN"  # noqa: S105
TIMEOUT_ENV_VAR = "VTEX_TIMEOUT"
RETRY_ATTEMPTS_ENV_VAR = "VTEX_RETRY_ATTEMPTS"
RETRY_BACKOFF_MIN_ENV_VAR = "VTEX_RETRY_BACKOFF_MIN"
RETRY_BACKOFF_MAX_ENV_VAR = "VTEX_RETRY_BACKOFF_MAX"
RETRY_STATUS_CODES_ENV_VAR = "VTEX_RETRY_STATUS_CODES"
RAISE_FOR_STATUS_CODE_ENV_VAR = "VTEX_RAISE_FOR_STATUS_CODE"
RATE_LIMIT_STORAGE_URL_ENV_VAR = "VTEX_RATE_LIMIT_STORAGE_URL"
LOG_RETRIES_ENV_VAR = "VTEX_LOG_RETRIES"
LOG_1XX_ENV_VAR = "VTEX_LOG_1XX"
LOG_2XX_ENV_VAR = "VTEX_LOG_2XX"
LOG_3XX_ENV_VAR = "VTEX_LOG_3XX"
LOG_4XX_ENV_VAR = "VTEX_LOG_4XX"
LOG_5XX_ENV_VAR = "VTEX_LOG_5XX"

DEFAULT_TIMEOUT = MINUTE
DEFAULT_RETRY_ATTEMPTS = 10
DEFAULT_RETRY_BACKOFF_MIN = SECOND
DEFAULT_RETRY_BACKOFF_MAX = MINUTE
DEFAULT_RETRY_STATUS_CODES = [
    407,
    408,
    409,
    425,
    429,
    500,
    502,
    503,
    504,
    507,
    511,
    525,
]
DEFAULT_RAISE_FOR_STATUS_CODE = True
DEFAULT_RATE_LIMIT_STORAGE_URL = None
DEFAULT_LOG_RETRIES = WARNING
DEFAULT_LOG_1XX = INFO
DEFAULT_LOG_2XX = INFO
DEFAULT_LOG_3XX = INFO
DEFAULT_LOG_4XX = WARNING
DEFAULT_LOG_5XX = WARNING

# Generics
MIN_PAGE_SIZE = 1

# Catalog
LIST_SKU_IDS_START_PAGE = 1
LIST_SKU_IDS_MAX_PAGE_SIZE = 1_000

LIST_CATEGORIES_START_PAGE = 1
LIST_CATEGORIES_MAX_PAGE_SIZE = 50

GET_CATEGORY_TREE_MAX_LEVELS = 1_000

# License Manager
LIST_ROLES_START_PAGE = 1
LIST_ROLES_MAX_PAGE_SIZE = 1_000

# Logistics
LIST_CARRIERS_START_PAGE = 1
LIST_CARRIERS_MAX_PAGE_SIZE = 1_000

LIST_DOCKS_START_PAGE = 1
LIST_DOCKS_MAX_PAGE_SIZE = 1_000

LIST_SHIPPING_POLICIES_START_PAGE = 1
LIST_SHIPPING_POLICIES_MAX_PAGE_SIZE = 1_000

# Master Data
SEARCH_DOCUMENTS_START_PAGE = 1
SEARCH_DOCUMENTS_MAX_PAGE_SIZE = 100

# Orders
LIST_FEED_ORDERS_MAX_PAGE_SIZE = 10
LIST_ORDERS_START_PAGE = 1
LIST_ORDERS_MAX_PAGE = 30
LIST_ORDERS_MAX_PAGE_SIZE = 100
