# Generated by Django 2.2.8 on 2019-12-08 11:29
# pylint: disable=invalid-name,missing-docstring
import django.contrib.postgres.fields
import django.db.models.deletion
from django.db import migrations, models

import phonenumber_field.modelfields


class Migration(migrations.Migration):

    initial = True

    dependencies = []  # type: ignore

    operations = [
        migrations.CreateModel(
            name="MeasurementUnit",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created"),
                ),
                (
                    "modified",
                    models.DateTimeField(auto_now=True, verbose_name="Modified"),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="e.g. Kilogram", max_length=2000, verbose_name="Name"
                    ),
                ),
                (
                    "symbol",
                    models.CharField(
                        db_index=True,
                        help_text="e.g. l which is the symbol for litre",
                        max_length=2000,
                        verbose_name="Symbol",
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        blank=True, default="", verbose_name="Description"
                    ),
                ),
            ],
            options={
                "verbose_name": "Measurement Unit",
                "verbose_name_plural": "Measurement Units",
            },
        ),
        migrations.CreateModel(
            name="ProductCategory",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created"),
                ),
                (
                    "modified",
                    models.DateTimeField(auto_now=True, verbose_name="Modified"),
                ),
                ("name", models.CharField(max_length=2000, verbose_name="Name")),
                (
                    "description",
                    models.TextField(
                        blank=True, default="", verbose_name="Description"
                    ),
                ),
            ],
            options={
                "verbose_name": "Product Category",
                "verbose_name_plural": "Product Categories",
            },
        ),
        migrations.CreateModel(
            name="Supplier",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created"),
                ),
                (
                    "modified",
                    models.DateTimeField(auto_now=True, verbose_name="Modified"),
                ),
                ("name", models.CharField(max_length=2000, verbose_name="Name")),
                (
                    "contact_person",
                    models.CharField(max_length=2000, verbose_name="Contact Person"),
                ),
                (
                    "emails",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.EmailField(
                            max_length=254, verbose_name="Email Address"
                        ),
                        blank=True,
                        default=list,
                        size=None,
                        verbose_name="Email Address(es)",
                    ),
                ),
                (
                    "phones",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=phonenumber_field.modelfields.PhoneNumberField(
                            max_length=128, region=None, verbose_name="Telephone Number"
                        ),
                        blank=True,
                        default=list,
                        size=None,
                        verbose_name="Phone number(s)",
                    ),
                ),
            ],
            options={"verbose_name": "Supplier", "verbose_name_plural": "Suppliers"},
        ),
        migrations.CreateModel(
            name="Product",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(auto_now_add=True, verbose_name="Created"),
                ),
                (
                    "modified",
                    models.DateTimeField(auto_now=True, verbose_name="Modified"),
                ),
                (
                    "currency",
                    models.CharField(
                        choices=[("KES", "Kenya Shilling")],
                        db_index=True,
                        default="KES",
                        max_length=3,
                        verbose_name="Currency",
                    ),
                ),
                (
                    "internal_amount",
                    models.DecimalField(
                        decimal_places=2, default=0, max_digits=64, verbose_name="Price"
                    ),
                ),
                ("name", models.CharField(max_length=2000, verbose_name="Name")),
                (
                    "description",
                    models.TextField(
                        blank=True, default="", verbose_name="Description"
                    ),
                ),
                (
                    "category",
                    models.ManyToManyField(
                        to="products.ProductCategory", verbose_name="Category"
                    ),
                ),
                (
                    "supplier",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="products.Supplier",
                        verbose_name="Supplier",
                    ),
                ),
                (
                    "unit",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        to="products.MeasurementUnit",
                        verbose_name="Measurement Unit",
                    ),
                ),
            ],
            options={"verbose_name": "Product", "verbose_name_plural": "Products"},
        ),
    ]
