# coding: utf-8

"""
    SensorPush Public API

    This is a swagger definition for the SensorPush public REST API. Download the definition file [here](https://api.sensorpush.com/api/v1/support/swagger/swagger-v1.json).

    The version of the OpenAPI document: v1.0.20240803
    Contact: support@sensorpush.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional

try:
    from pydantic.v1 import BaseModel, Field, StrictStr
except ImportError:
    from pydantic import BaseModel, Field, StrictStr

class ReportListing(BaseModel):
    """
    ReportListing
    """
    last_modified: Optional[datetime] = Field(default=None, description="Date file was last modified")
    name: Optional[StrictStr] = Field(default=None, description="Name of the file")
    size: Optional[StrictStr] = Field(default=None, description="File size")
    __properties = ["last_modified", "name", "size"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ReportListing:
        """Create an instance of ReportListing from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ReportListing:
        """Create an instance of ReportListing from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ReportListing.parse_obj(obj)

        _obj = ReportListing.parse_obj({
            "last_modified": obj.get("last_modified"),
            "name": obj.get("name"),
            "size": obj.get("size")
        })
        return _obj


