# coding: utf-8

"""
    SensorPush Public API

    This is a swagger definition for the SensorPush public REST API. Download the definition file [here](https://api.sensorpush.com/api/v1/support/swagger/swagger-v1.json).

    The version of the OpenAPI document: v1.0.20240803
    Contact: support@sensorpush.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Dict, Optional, Union

try:
    from pydantic.v1 import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr
except ImportError:
    from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr

from sensorpush_api.models.sensor_alerts import SensorAlerts
from sensorpush_api.models.sensor_calibration import SensorCalibration
from sensorpush_api.models.tags import Tags

class Sensor(BaseModel):
    """
    Sensor
    """
    active: Optional[StrictBool] = Field(default=None, description="Is the sensor active?")
    address: Optional[StrictStr] = Field(default=None, description="MAC address")
    alerts: Optional[SensorAlerts] = None
    battery_voltage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Current battery voltage")
    calibration: Optional[SensorCalibration] = None
    device_id: Optional[StrictStr] = Field(default=None, alias="deviceId", description="Short device Id")
    id: Optional[StrictStr] = Field(default=None, description="Long device Id")
    name: Optional[StrictStr] = Field(default=None, description="Name of the sensor sensor")
    rssi: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Wireless signal strength in dB at last reading")
    tags: Optional[Dict[str, Tags]] = Field(default=None, description="List of tags associated with this device")
    type: Optional[StrictStr] = Field(default=None, description="Type of device hardward")
    __properties = ["active", "address", "alerts", "battery_voltage", "calibration", "deviceId", "id", "name", "rssi", "tags", "type"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Sensor:
        """Create an instance of Sensor from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of alerts
        if self.alerts:
            _dict['alerts'] = self.alerts.to_dict()
        # override the default output from pydantic by calling `to_dict()` of calibration
        if self.calibration:
            _dict['calibration'] = self.calibration.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each value in tags (dict)
        _field_dict = {}
        if self.tags:
            for _key in self.tags:
                if self.tags[_key]:
                    _field_dict[_key] = self.tags[_key].to_dict()
            _dict['tags'] = _field_dict
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Sensor:
        """Create an instance of Sensor from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Sensor.parse_obj(obj)

        _obj = Sensor.parse_obj({
            "active": obj.get("active"),
            "address": obj.get("address"),
            "alerts": SensorAlerts.from_dict(obj.get("alerts")) if obj.get("alerts") is not None else None,
            "battery_voltage": obj.get("battery_voltage"),
            "calibration": SensorCalibration.from_dict(obj.get("calibration")) if obj.get("calibration") is not None else None,
            "device_id": obj.get("deviceId"),
            "id": obj.get("id"),
            "name": obj.get("name"),
            "rssi": obj.get("rssi"),
            "tags": dict(
                (_k, Tags.from_dict(_v))
                for _k, _v in obj.get("tags").items()
            )
            if obj.get("tags") is not None
            else None,
            "type": obj.get("type")
        })
        return _obj


