# coding: utf-8

"""
    SensorPush Public API

    This is a swagger definition for the SensorPush public REST API. Download the definition file [here](https://api.sensorpush.com/api/v1/support/swagger/swagger-v1.json).

    The version of the OpenAPI document: v1.0.20240803
    Contact: support@sensorpush.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional

try:
    from pydantic.v1 import BaseModel
except ImportError:
    from pydantic import BaseModel

from sensorpush_api.models.sensor_alerts_humidity import SensorAlertsHumidity
from sensorpush_api.models.sensor_alerts_temperature import SensorAlertsTemperature

class SensorAlerts(BaseModel):
    """
    Alert settings  # noqa: E501
    """
    humidity: Optional[SensorAlertsHumidity] = None
    temperature: Optional[SensorAlertsTemperature] = None
    __properties = ["humidity", "temperature"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SensorAlerts:
        """Create an instance of SensorAlerts from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of humidity
        if self.humidity:
            _dict['humidity'] = self.humidity.to_dict()
        # override the default output from pydantic by calling `to_dict()` of temperature
        if self.temperature:
            _dict['temperature'] = self.temperature.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SensorAlerts:
        """Create an instance of SensorAlerts from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SensorAlerts.parse_obj(obj)

        _obj = SensorAlerts.parse_obj({
            "humidity": SensorAlertsHumidity.from_dict(obj.get("humidity")) if obj.get("humidity") is not None else None,
            "temperature": SensorAlertsTemperature.from_dict(obj.get("temperature")) if obj.get("temperature") is not None else None
        })
        return _obj


