# coding: utf-8

"""
    SensorPush Public API

    This is a swagger definition for the SensorPush public REST API. Download the definition file [here](https://api.sensorpush.com/api/v1/support/swagger/swagger-v1.json).

    The version of the OpenAPI document: v1.0.20240803
    Contact: support@sensorpush.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union

try:
    from pydantic.v1 import BaseModel, Field, StrictBool, StrictFloat, StrictInt
except ImportError:
    from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt

class SensorAlertsHumidity(BaseModel):
    """
    alert settings for humidity  # noqa: E501
    """
    enabled: Optional[StrictBool] = Field(default=None, description="Is enabled?")
    max: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Max threshold for alert")
    min: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Min threshold for alert")
    __properties = ["enabled", "max", "min"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> SensorAlertsHumidity:
        """Create an instance of SensorAlertsHumidity from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> SensorAlertsHumidity:
        """Create an instance of SensorAlertsHumidity from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return SensorAlertsHumidity.parse_obj(obj)

        _obj = SensorAlertsHumidity.parse_obj({
            "enabled": obj.get("enabled"),
            "max": obj.get("max"),
            "min": obj.get("min")
        })
        return _obj


