import argparse

class ArgparseHelper(argparse._HelpAction):
    '''
    Used to help print top level '--help' arguments from argparse
    when used with subparsers

    Usage:
    from scutils.arparse_helper import ArgparseHelper
    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument('-h', '--help', action=ArgparseHelper,
                        help='show this help message and exit')
    # add subparsers below these lines
    '''

    def __call__(self, parser, namespace, values, option_string=None):
        parser.print_help()
        print

        subparsers_actions = [
            action for action in parser._actions
            if isinstance(action, argparse._SubParsersAction)]
        for subparsers_action in subparsers_actions:
            for choice, subparser in subparsers_action.choices.items():
                print("Command '{}'".format(choice))
                print(subparser.format_usage())

        parser.exit()