"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnOutput = void 0;
const cfn_element_1 = require("./cfn-element");
class CfnOutput extends cfn_element_1.CfnElement {
    /**
     * Creates an CfnOutput value for this stack.
     * @param scope The parent construct.
     * @param props CfnOutput properties.
     */
    constructor(scope, id, props) {
        super(scope, id);
        if (props.value === undefined) {
            throw new Error(`Missing value for CloudFormation output at path "${this.node.path}"`);
        }
        this._description = props.description;
        this._value = props.value;
        this._condition = props.condition;
        this._export = props.exportName;
    }
    /**
     * @internal
     */
    _toCloudFormation() {
        return {
            Outputs: {
                [this.logicalId]: {
                    Description: this._description,
                    Value: this._value,
                    Export: this._export != null ? { Name: this._export } : undefined,
                    Condition: this._condition ? this._condition.logicalId : undefined,
                },
            },
        };
    }
}
exports.CfnOutput = CfnOutput;
//# sourceMappingURL=data:application/json;base64,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