"use strict";
const cfn_parse_1 = require("../lib/cfn-parse");
function parseCreationPolicy(policy) {
    return testCfnParser.parseCreationPolicy(policy);
}
function parseUpdatePolicy(policy) {
    return testCfnParser.parseUpdatePolicy(policy);
}
const testCfnParser = new cfn_parse_1.CfnParser({
    finder: {
        findCondition() { return undefined; },
        findRefTarget() { return undefined; },
        findResource() { return undefined; },
    },
});
module.exports = {
    'FromCloudFormation class': {
        '#parseCreationPolicy': {
            'returns undefined when given a non-object as the argument'(test) {
                test.equal(parseCreationPolicy('blah'), undefined);
                test.done();
            },
            'returns undefined when given an empty object as the argument'(test) {
                test.equal(parseCreationPolicy({}), undefined);
                test.done();
            },
            'returns undefined when given empty sub-objects as the argument'(test) {
                test.equal(parseCreationPolicy({
                    AutoScalingCreationPolicy: null,
                    ResourceSignal: {
                        Count: undefined,
                    },
                }), undefined);
                test.done();
            },
        },
        '#parseUpdatePolicy': {
            'returns undefined when given a non-object as the argument'(test) {
                test.equal(parseUpdatePolicy('blah'), undefined);
                test.done();
            },
            'returns undefined when given an empty object as the argument'(test) {
                test.equal(parseUpdatePolicy({}), undefined);
                test.done();
            },
            'returns undefined when given empty sub-objects as the argument'(test) {
                test.equal(parseUpdatePolicy({
                    AutoScalingReplacingUpdate: null,
                    AutoScalingRollingUpdate: {
                        PauseTime: undefined,
                    },
                }), undefined);
                test.done();
            },
        },
    },
};
//# sourceMappingURL=data:application/json;base64,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