"use strict";
const lib_1 = require("../lib");
const util_1 = require("./util");
module.exports = {
    'mappings can be added as another type of entity, and mapping.findInMap can be used to get a token'(test) {
        const stack = new lib_1.Stack();
        const mapping = new lib_1.CfnMapping(stack, 'MyMapping', { mapping: {
                TopLevelKey1: {
                    SecondLevelKey1: [1, 2, 3],
                    SecondLevelKey2: { Hello: 'World' },
                },
                TopLevelKey2: {
                    SecondLevelKey1: [99, 99, 99],
                },
            } });
        // findInMap can be used to take a reference
        new lib_1.CfnResource(stack, 'MyResource', {
            type: 'R',
            properties: {
                RefToValueInMap: mapping.findInMap('TopLevelKey1', 'SecondLevelKey1'),
            },
        });
        test.throws(() => mapping.findInMap('NotFoundTopLevel', 'NotFound'), 'cant take a reference on a non existing key');
        test.throws(() => mapping.findInMap('TopLevelKey1', 'NotFound'), 'cant take a reference on a non existing key');
        // set value can be used to set/modify a specific value
        mapping.setValue('TopLevelKey2', 'SecondLevelKey2', 'Hi');
        mapping.setValue('TopLevelKey1', 'SecondLevelKey1', [1, 2, 3, 4]);
        test.deepEqual(util_1.toCloudFormation(stack), { Mappings: { MyMapping: { TopLevelKey1: { SecondLevelKey1: [1, 2, 3, 4],
                        SecondLevelKey2: { Hello: 'World' } },
                    TopLevelKey2: { SecondLevelKey1: [99, 99, 99], SecondLevelKey2: 'Hi' } } },
            Resources: { MyResource: { Type: 'R',
                    Properties: { RefToValueInMap: { 'Fn::FindInMap': ['MyMapping', 'TopLevelKey1', 'SecondLevelKey1'] } } } } });
        test.done();
    },
    'allow using unresolved tokens in find-in-map'(test) {
        const stack = new lib_1.Stack();
        const mapping = new lib_1.CfnMapping(stack, 'mapping', {
            mapping: {
                instanceCount: {
                    'us-east-1': 12,
                },
            },
        });
        const v1 = mapping.findInMap('instanceCount', lib_1.Aws.REGION);
        const v2 = lib_1.Fn.findInMap(mapping.logicalId, 'instanceCount', lib_1.Aws.REGION);
        const expected = { 'Fn::FindInMap': ['mapping', 'instanceCount', { Ref: 'AWS::Region' }] };
        test.deepEqual(stack.resolve(v1), expected);
        test.deepEqual(stack.resolve(v2), expected);
        test.done();
    },
    'no validation if first key is token and second is a static string'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const mapping = new lib_1.CfnMapping(stack, 'mapping', {
            mapping: {
                'us-east-1': {
                    size: 12,
                },
            },
        });
        // WHEN
        const v = mapping.findInMap(lib_1.Aws.REGION, 'size');
        // THEN
        test.deepEqual(stack.resolve(v), {
            'Fn::FindInMap': ['mapping', { Ref: 'AWS::Region' }, 'size'],
        });
        test.done();
    },
    'validate first key if it is a string and second is a token'(test) {
        // GIVEN
        const stack = new lib_1.Stack();
        const mapping = new lib_1.CfnMapping(stack, 'mapping', {
            mapping: {
                size: {
                    'us-east-1': 12,
                },
            },
        });
        // WHEN
        const v = mapping.findInMap('size', lib_1.Aws.REGION);
        // THEN
        test.throws(() => mapping.findInMap('not-found', lib_1.Aws.REGION), /Mapping doesn't contain top-level key 'not-found'/);
        test.deepEqual(stack.resolve(v), { 'Fn::FindInMap': ['mapping', 'size', { Ref: 'AWS::Region' }] });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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