# Authorship policy for The Ersilia Model Hub

The Ersilia Model Hub distinguishes between contributors to the software and software authors.

We define as **contributors** every person who contributed their own work to the project, with the intention to benefit the project, in one or more of the following areas:

- Writing code to improve/extend the functionality of an existing feature, regardless of the size of the code contribution.
- Writing code to build in a new feature.
- Writing documentation around any aspect of the software project.
- Mentoring and guiding interns, students and open source contributors to the software project.
- Participating in the discussions around software development, via GitHub issues or during community calls. A minimum time engagement of 6 months is required.

We define as **authors** every person who has made a substantial contribution to:

- the conceptualization of the software;
- the source code, documentation and metadata, test code, setup or build configuration of the software;
- maintaining the software;
- safeguarding the continued existence or sustainability of the software project.

Authors are being determined for the Ersilia Model Hub project, independently of individual versions of Ersilia Model Hub. Authors will be reviewed each six months according to the guidelines below.

To qualify for authorship, contributors make a contribution that is substantial as defined for each of the relevant contribution areas as:

- Conceptualization of the software: designing the software structure, determining its components, specifying the requirements both in terms of infrastructure, service and costs AND planning and guiding and supervising its development. A contribution to the planning of a single component of the software does not qualify as substantial.
- Source code or documentation or metadata or test code or setup configuration or build configuration of the software: code and documentation contributions must be done autonomously (for example, code developed under an internship does not typically qualify as a substantial contribution). For code contributions and build configurations of the software, substantial is defined as the development of at least an entire feature of the software. For documentation, substantiality is defined by the extensiveness and exhaustiveness of the documentation added, for example documenting an entire new usage of the software, or preparing documentation for a different audience, or translating into another language. Regular documentation updates to keep up with software development do not qualify as substantial.
- Maintenance of the software: autonomously tackling open issues, opening PRs and merging PRs to ensure the functionalities of the software are maintained.
- Safeguarding the continued existence or sustainability of the software project: substantiality of contributions to safeguard the existence of the software is defined by leading the community engagement programs, social media campaigns and successfully raising funds to cover the expenses of the software maintenance and development.

In addition to these requirements, engagement is core to the Ersilia Community mission and vision. To qualify for authorship, a minimum of 6 months engagement with the project (via Slack, GitHub and on community calls) is required, and after 6 months of inactivity authorship will be archived if any of the below clauses are also fulfilled.

Contributors are no longer considered authors if and when:

- For conceptualization of the software, they _cease to be engaged with the project for more than six months AND the software has evolved enough that their original concept does no longer apply._
- For source code or documentation or metadata or test code or setup configuration or build configuration of the software, they _cease to be engaged with the project for more than six months_.
- For maintenance of the software, they _cease to be engaged with the project for more than six months_.
- For safeguarding the continued existence or sustainability of the software project, they _cease to be engaged with the project for more than six months_.

Authors are being acknowledged as such:

- in the citation metadata file `CITATION.cff` in the source code repository at [https://github.com/ersilia-os/ersilia](https://github.com/ersilia-os/ersilia);
- in publications of the Ersilia Model Hub made on Zenodo if they are an author of the version that is being published.

Past authors are being acknowledged as such in the section “Authorship”, on the README file of the software at [https://github.com/ersilia-os/ersilia](https://github.com/ersilia-os/ersilia).

All contributors are being acknowledged as such with their contribution roles, and independently of their status as authors in the Contributors section of the Ersilia [website](https://ersilia.io/about) and independently on the GitHub [repository](https://github.com/ersilia-os/ersilia) under the Contributors section, which collects only code contributions.

Decisions to acknowledge authorship are being made by the Ersilia Model Hub steering committee, which is composed of Ersilia’s employees and Board, every six months. Conflicts with regard to authorship should be reported to the legal owners of the software at <hello@ersilia.io>. They will be resolved by Ersilia’s Board. If a member of the Board is involved in the conflict, they will not participate in the process resolution.

This authorship policy is based on the ReSA Software Authorship Guidelines.