# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetBaremetalOptionResult',
    'AwaitableGetBaremetalOptionResult',
    'get_baremetal_option',
    'get_baremetal_option_output',
]

@pulumi.output_type
class GetBaremetalOptionResult:
    """
    A collection of values returned by getBaremetalOption.
    """
    def __init__(__self__, id=None, manageable=None, name=None, option_id=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if manageable and not isinstance(manageable, bool):
            raise TypeError("Expected argument 'manageable' to be a bool")
        pulumi.set(__self__, "manageable", manageable)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if option_id and not isinstance(option_id, str):
            raise TypeError("Expected argument 'option_id' to be a str")
        pulumi.set(__self__, "option_id", option_id)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def manageable(self) -> bool:
        """
        Is false if the option could not be added or removed.
        """
        return pulumi.get(self, "manageable")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the option.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="optionId")
    def option_id(self) -> Optional[str]:
        return pulumi.get(self, "option_id")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


class AwaitableGetBaremetalOptionResult(GetBaremetalOptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBaremetalOptionResult(
            id=self.id,
            manageable=self.manageable,
            name=self.name,
            option_id=self.option_id,
            zone=self.zone)


def get_baremetal_option(name: Optional[str] = None,
                         option_id: Optional[str] = None,
                         zone: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBaremetalOptionResult:
    """
    Gets information about a baremetal option.
    For more information, see [the documentation](https://developers.scaleway.com/en/products/baremetal/api).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    by_name = scaleway.get_baremetal_option(name="Remote Access")
    by_id = scaleway.get_baremetal_option(option_id="931df052-d713-4674-8b58-96a63244c8e2")
    ```


    :param str name: The option name. Only one of `name` and `option_id` should be specified.
    :param str option_id: The option id. Only one of `name` and `option_id` should be specified.
    :param str zone: `zone`) The zone in which the option exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['optionId'] = option_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getBaremetalOption:getBaremetalOption', __args__, opts=opts, typ=GetBaremetalOptionResult).value

    return AwaitableGetBaremetalOptionResult(
        id=pulumi.get(__ret__, 'id'),
        manageable=pulumi.get(__ret__, 'manageable'),
        name=pulumi.get(__ret__, 'name'),
        option_id=pulumi.get(__ret__, 'option_id'),
        zone=pulumi.get(__ret__, 'zone'))


@_utilities.lift_output_func(get_baremetal_option)
def get_baremetal_option_output(name: Optional[pulumi.Input[Optional[str]]] = None,
                                option_id: Optional[pulumi.Input[Optional[str]]] = None,
                                zone: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBaremetalOptionResult]:
    """
    Gets information about a baremetal option.
    For more information, see [the documentation](https://developers.scaleway.com/en/products/baremetal/api).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    by_name = scaleway.get_baremetal_option(name="Remote Access")
    by_id = scaleway.get_baremetal_option(option_id="931df052-d713-4674-8b58-96a63244c8e2")
    ```


    :param str name: The option name. Only one of `name` and `option_id` should be specified.
    :param str option_id: The option id. Only one of `name` and `option_id` should be specified.
    :param str zone: `zone`) The zone in which the option exists.
    """
    ...
