# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIpamIpResult',
    'AwaitableGetIpamIpResult',
    'get_ipam_ip',
    'get_ipam_ip_output',
]

@pulumi.output_type
class GetIpamIpResult:
    """
    A collection of values returned by getIpamIp.
    """
    def __init__(__self__, address=None, id=None, mac_address=None, private_network_id=None, region=None, resource=None, type=None):
        if address and not isinstance(address, str):
            raise TypeError("Expected argument 'address' to be a str")
        pulumi.set(__self__, "address", address)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if mac_address and not isinstance(mac_address, str):
            raise TypeError("Expected argument 'mac_address' to be a str")
        pulumi.set(__self__, "mac_address", mac_address)
        if private_network_id and not isinstance(private_network_id, str):
            raise TypeError("Expected argument 'private_network_id' to be a str")
        pulumi.set(__self__, "private_network_id", private_network_id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if resource and not isinstance(resource, dict):
            raise TypeError("Expected argument 'resource' to be a dict")
        pulumi.set(__self__, "resource", resource)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The IP address
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[str]:
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="privateNetworkId")
    def private_network_id(self) -> Optional[str]:
        return pulumi.get(self, "private_network_id")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def resource(self) -> Optional['outputs.GetIpamIpResourceResult']:
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


class AwaitableGetIpamIpResult(GetIpamIpResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpamIpResult(
            address=self.address,
            id=self.id,
            mac_address=self.mac_address,
            private_network_id=self.private_network_id,
            region=self.region,
            resource=self.resource,
            type=self.type)


def get_ipam_ip(mac_address: Optional[str] = None,
                private_network_id: Optional[str] = None,
                region: Optional[str] = None,
                resource: Optional[pulumi.InputType['GetIpamIpResourceArgs']] = None,
                type: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpamIpResult:
    """
    Gets information about IP managed by IPAM service. IPAM service is used for dhcp bundled in VPCs' private networks.

    ## Examples

    ### Instance Private Network IP

    ```python
    import pulumi
    import ediri_scaleway as scaleway
    import pulumi_scaleway as scaleway

    # Get Instance IP in a private network
    nic = scaleway.InstancePrivateNic("nic",
        server_id=scaleway_instance_server["server"]["id"],
        private_network_id=scaleway_vpc_private_network["pn"]["id"])
    by_mac = scaleway.get_ipam_ip_output(mac_address=nic.mac_address,
        type="ipv4")
    by_id = scaleway.get_ipam_ip_output(resource=scaleway.GetIpamIpResourceArgs(
            id=nic.id,
            type="instance_private_nic",
        ),
        type="ipv4")
    ```


    :param str mac_address: The Mac Address linked to the IP.
    :param str private_network_id: The ID of the private network the IP belong to.
    :param str region: `region`) The region in which the IP exists.
    :param pulumi.InputType['GetIpamIpResourceArgs'] resource: Filter by resource ID and type, both attributes must be set
    :param str type: The type of the resource to get the IP from. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1alpha1#pkg-constants) with type list.
    """
    __args__ = dict()
    __args__['macAddress'] = mac_address
    __args__['privateNetworkId'] = private_network_id
    __args__['region'] = region
    __args__['resource'] = resource
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getIpamIp:getIpamIp', __args__, opts=opts, typ=GetIpamIpResult).value

    return AwaitableGetIpamIpResult(
        address=pulumi.get(__ret__, 'address'),
        id=pulumi.get(__ret__, 'id'),
        mac_address=pulumi.get(__ret__, 'mac_address'),
        private_network_id=pulumi.get(__ret__, 'private_network_id'),
        region=pulumi.get(__ret__, 'region'),
        resource=pulumi.get(__ret__, 'resource'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_ipam_ip)
def get_ipam_ip_output(mac_address: Optional[pulumi.Input[Optional[str]]] = None,
                       private_network_id: Optional[pulumi.Input[Optional[str]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       resource: Optional[pulumi.Input[Optional[pulumi.InputType['GetIpamIpResourceArgs']]]] = None,
                       type: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpamIpResult]:
    """
    Gets information about IP managed by IPAM service. IPAM service is used for dhcp bundled in VPCs' private networks.

    ## Examples

    ### Instance Private Network IP

    ```python
    import pulumi
    import ediri_scaleway as scaleway
    import pulumi_scaleway as scaleway

    # Get Instance IP in a private network
    nic = scaleway.InstancePrivateNic("nic",
        server_id=scaleway_instance_server["server"]["id"],
        private_network_id=scaleway_vpc_private_network["pn"]["id"])
    by_mac = scaleway.get_ipam_ip_output(mac_address=nic.mac_address,
        type="ipv4")
    by_id = scaleway.get_ipam_ip_output(resource=scaleway.GetIpamIpResourceArgs(
            id=nic.id,
            type="instance_private_nic",
        ),
        type="ipv4")
    ```


    :param str mac_address: The Mac Address linked to the IP.
    :param str private_network_id: The ID of the private network the IP belong to.
    :param str region: `region`) The region in which the IP exists.
    :param pulumi.InputType['GetIpamIpResourceArgs'] resource: Filter by resource ID and type, both attributes must be set
    :param str type: The type of the resource to get the IP from. [Documentation](https://pkg.go.dev/github.com/scaleway/scaleway-sdk-go@master/api/ipam/v1alpha1#pkg-constants) with type list.
    """
    ...
