# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetLbFrontendResult',
    'AwaitableGetLbFrontendResult',
    'get_lb_frontend',
    'get_lb_frontend_output',
]

@pulumi.output_type
class GetLbFrontendResult:
    """
    A collection of values returned by getLbFrontend.
    """
    def __init__(__self__, acls=None, backend_id=None, certificate_id=None, certificate_ids=None, enable_http3=None, external_acls=None, frontend_id=None, id=None, inbound_port=None, lb_id=None, name=None, timeout_client=None):
        if acls and not isinstance(acls, list):
            raise TypeError("Expected argument 'acls' to be a list")
        pulumi.set(__self__, "acls", acls)
        if backend_id and not isinstance(backend_id, str):
            raise TypeError("Expected argument 'backend_id' to be a str")
        pulumi.set(__self__, "backend_id", backend_id)
        if certificate_id and not isinstance(certificate_id, str):
            raise TypeError("Expected argument 'certificate_id' to be a str")
        pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_ids and not isinstance(certificate_ids, list):
            raise TypeError("Expected argument 'certificate_ids' to be a list")
        pulumi.set(__self__, "certificate_ids", certificate_ids)
        if enable_http3 and not isinstance(enable_http3, bool):
            raise TypeError("Expected argument 'enable_http3' to be a bool")
        pulumi.set(__self__, "enable_http3", enable_http3)
        if external_acls and not isinstance(external_acls, bool):
            raise TypeError("Expected argument 'external_acls' to be a bool")
        pulumi.set(__self__, "external_acls", external_acls)
        if frontend_id and not isinstance(frontend_id, str):
            raise TypeError("Expected argument 'frontend_id' to be a str")
        pulumi.set(__self__, "frontend_id", frontend_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if inbound_port and not isinstance(inbound_port, int):
            raise TypeError("Expected argument 'inbound_port' to be a int")
        pulumi.set(__self__, "inbound_port", inbound_port)
        if lb_id and not isinstance(lb_id, str):
            raise TypeError("Expected argument 'lb_id' to be a str")
        pulumi.set(__self__, "lb_id", lb_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if timeout_client and not isinstance(timeout_client, str):
            raise TypeError("Expected argument 'timeout_client' to be a str")
        pulumi.set(__self__, "timeout_client", timeout_client)

    @property
    @pulumi.getter
    def acls(self) -> Sequence['outputs.GetLbFrontendAclResult']:
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter(name="backendId")
    def backend_id(self) -> str:
        return pulumi.get(self, "backend_id")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> str:
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="certificateIds")
    def certificate_ids(self) -> Sequence[str]:
        return pulumi.get(self, "certificate_ids")

    @property
    @pulumi.getter(name="enableHttp3")
    def enable_http3(self) -> bool:
        return pulumi.get(self, "enable_http3")

    @property
    @pulumi.getter(name="externalAcls")
    def external_acls(self) -> bool:
        return pulumi.get(self, "external_acls")

    @property
    @pulumi.getter(name="frontendId")
    def frontend_id(self) -> Optional[str]:
        return pulumi.get(self, "frontend_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inboundPort")
    def inbound_port(self) -> int:
        return pulumi.get(self, "inbound_port")

    @property
    @pulumi.getter(name="lbId")
    def lb_id(self) -> Optional[str]:
        return pulumi.get(self, "lb_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="timeoutClient")
    def timeout_client(self) -> str:
        return pulumi.get(self, "timeout_client")


class AwaitableGetLbFrontendResult(GetLbFrontendResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLbFrontendResult(
            acls=self.acls,
            backend_id=self.backend_id,
            certificate_id=self.certificate_id,
            certificate_ids=self.certificate_ids,
            enable_http3=self.enable_http3,
            external_acls=self.external_acls,
            frontend_id=self.frontend_id,
            id=self.id,
            inbound_port=self.inbound_port,
            lb_id=self.lb_id,
            name=self.name,
            timeout_client=self.timeout_client)


def get_lb_frontend(frontend_id: Optional[str] = None,
                    lb_id: Optional[str] = None,
                    name: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLbFrontendResult:
    """
    Get information about Scaleway Load-Balancer Frontends.
    For more information, see [the documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-frontends).

    ## Example Usage

    ```python
    import pulumi
    import ediri_scaleway as scaleway
    import pulumi_scaleway as scaleway

    ip01 = scaleway.LbIp("ip01")
    lb01 = scaleway.Lb("lb01",
        ip_id=ip01.id,
        type="lb-s")
    bkd01 = scaleway.LbBackend("bkd01",
        lb_id=lb01.id,
        forward_protocol="tcp",
        forward_port=80,
        proxy_protocol="none")
    frt01 = scaleway.LbFrontend("frt01",
        lb_id=lb01.id,
        backend_id=bkd01.id,
        inbound_port=80)
    by_id = scaleway.get_lb_frontend_output(frontend_id=frt01.id)
    by_name = scaleway.get_lb_frontend_output(name=frt01.name,
        lb_id=lb01.id)
    ```


    :param str frontend_id: The frontend id.
           - Only one of `name` and `frontend_id` should be specified.
    :param str lb_id: The load-balancer ID this frontend is attached to.
    :param str name: The name of the frontend.
           - When using the `name` you should specify the `lb-id`
    """
    __args__ = dict()
    __args__['frontendId'] = frontend_id
    __args__['lbId'] = lb_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getLbFrontend:getLbFrontend', __args__, opts=opts, typ=GetLbFrontendResult).value

    return AwaitableGetLbFrontendResult(
        acls=pulumi.get(__ret__, 'acls'),
        backend_id=pulumi.get(__ret__, 'backend_id'),
        certificate_id=pulumi.get(__ret__, 'certificate_id'),
        certificate_ids=pulumi.get(__ret__, 'certificate_ids'),
        enable_http3=pulumi.get(__ret__, 'enable_http3'),
        external_acls=pulumi.get(__ret__, 'external_acls'),
        frontend_id=pulumi.get(__ret__, 'frontend_id'),
        id=pulumi.get(__ret__, 'id'),
        inbound_port=pulumi.get(__ret__, 'inbound_port'),
        lb_id=pulumi.get(__ret__, 'lb_id'),
        name=pulumi.get(__ret__, 'name'),
        timeout_client=pulumi.get(__ret__, 'timeout_client'))


@_utilities.lift_output_func(get_lb_frontend)
def get_lb_frontend_output(frontend_id: Optional[pulumi.Input[Optional[str]]] = None,
                           lb_id: Optional[pulumi.Input[Optional[str]]] = None,
                           name: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLbFrontendResult]:
    """
    Get information about Scaleway Load-Balancer Frontends.
    For more information, see [the documentation](https://www.scaleway.com/en/developers/api/load-balancer/zoned-api/#path-frontends).

    ## Example Usage

    ```python
    import pulumi
    import ediri_scaleway as scaleway
    import pulumi_scaleway as scaleway

    ip01 = scaleway.LbIp("ip01")
    lb01 = scaleway.Lb("lb01",
        ip_id=ip01.id,
        type="lb-s")
    bkd01 = scaleway.LbBackend("bkd01",
        lb_id=lb01.id,
        forward_protocol="tcp",
        forward_port=80,
        proxy_protocol="none")
    frt01 = scaleway.LbFrontend("frt01",
        lb_id=lb01.id,
        backend_id=bkd01.id,
        inbound_port=80)
    by_id = scaleway.get_lb_frontend_output(frontend_id=frt01.id)
    by_name = scaleway.get_lb_frontend_output(name=frt01.name,
        lb_id=lb01.id)
    ```


    :param str frontend_id: The frontend id.
           - Only one of `name` and `frontend_id` should be specified.
    :param str lb_id: The load-balancer ID this frontend is attached to.
    :param str name: The name of the frontend.
           - When using the `name` you should specify the `lb-id`
    """
    ...
