# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetLbIpsResult',
    'AwaitableGetLbIpsResult',
    'get_lb_ips',
    'get_lb_ips_output',
]

@pulumi.output_type
class GetLbIpsResult:
    """
    A collection of values returned by getLbIps.
    """
    def __init__(__self__, id=None, ip_cidr_range=None, ips=None, organization_id=None, project_id=None, zone=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_cidr_range and not isinstance(ip_cidr_range, str):
            raise TypeError("Expected argument 'ip_cidr_range' to be a str")
        pulumi.set(__self__, "ip_cidr_range", ip_cidr_range)
        if ips and not isinstance(ips, list):
            raise TypeError("Expected argument 'ips' to be a list")
        pulumi.set(__self__, "ips", ips)
        if organization_id and not isinstance(organization_id, str):
            raise TypeError("Expected argument 'organization_id' to be a str")
        pulumi.set(__self__, "organization_id", organization_id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if zone and not isinstance(zone, str):
            raise TypeError("Expected argument 'zone' to be a str")
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipCidrRange")
    def ip_cidr_range(self) -> Optional[str]:
        return pulumi.get(self, "ip_cidr_range")

    @property
    @pulumi.getter
    def ips(self) -> Sequence['outputs.GetLbIpsIpResult']:
        """
        List of found IPs
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> str:
        """
        The organization ID the load-balancer is associated with.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The ID of the project the load-balancer is associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        The zone in which the load-balancer is.
        """
        return pulumi.get(self, "zone")


class AwaitableGetLbIpsResult(GetLbIpsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLbIpsResult(
            id=self.id,
            ip_cidr_range=self.ip_cidr_range,
            ips=self.ips,
            organization_id=self.organization_id,
            project_id=self.project_id,
            zone=self.zone)


def get_lb_ips(ip_cidr_range: Optional[str] = None,
               project_id: Optional[str] = None,
               zone: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLbIpsResult:
    """
    Gets information about multiple Load Balancer IPs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    my_key = scaleway.get_lb_ips(ip_cidr_range="0.0.0.0/0",
        zone="fr-par-2")
    ```


    :param str ip_cidr_range: The IP CIDR range used as a filter. IPs within a CIDR block like it are listed.
    :param str project_id: The ID of the project the load-balancer is associated with.
    :param str zone: `zone`) The zone in which IPs exist.
    """
    __args__ = dict()
    __args__['ipCidrRange'] = ip_cidr_range
    __args__['projectId'] = project_id
    __args__['zone'] = zone
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getLbIps:getLbIps', __args__, opts=opts, typ=GetLbIpsResult).value

    return AwaitableGetLbIpsResult(
        id=pulumi.get(__ret__, 'id'),
        ip_cidr_range=pulumi.get(__ret__, 'ip_cidr_range'),
        ips=pulumi.get(__ret__, 'ips'),
        organization_id=pulumi.get(__ret__, 'organization_id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        zone=pulumi.get(__ret__, 'zone'))


@_utilities.lift_output_func(get_lb_ips)
def get_lb_ips_output(ip_cidr_range: Optional[pulumi.Input[Optional[str]]] = None,
                      project_id: Optional[pulumi.Input[Optional[str]]] = None,
                      zone: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLbIpsResult]:
    """
    Gets information about multiple Load Balancer IPs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_scaleway as scaleway

    my_key = scaleway.get_lb_ips(ip_cidr_range="0.0.0.0/0",
        zone="fr-par-2")
    ```


    :param str ip_cidr_range: The IP CIDR range used as a filter. IPs within a CIDR block like it are listed.
    :param str project_id: The ID of the project the load-balancer is associated with.
    :param str zone: `zone`) The zone in which IPs exist.
    """
    ...
