# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetSecretVersionResult',
    'AwaitableGetSecretVersionResult',
    'get_secret_version',
    'get_secret_version_output',
]

@pulumi.output_type
class GetSecretVersionResult:
    """
    A collection of values returned by getSecretVersion.
    """
    def __init__(__self__, created_at=None, data=None, description=None, id=None, region=None, revision=None, secret_id=None, secret_name=None, status=None, updated_at=None):
        if created_at and not isinstance(created_at, str):
            raise TypeError("Expected argument 'created_at' to be a str")
        pulumi.set(__self__, "created_at", created_at)
        if data and not isinstance(data, str):
            raise TypeError("Expected argument 'data' to be a str")
        pulumi.set(__self__, "data", data)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if revision and not isinstance(revision, str):
            raise TypeError("Expected argument 'revision' to be a str")
        pulumi.set(__self__, "revision", revision)
        if secret_id and not isinstance(secret_id, str):
            raise TypeError("Expected argument 'secret_id' to be a str")
        pulumi.set(__self__, "secret_id", secret_id)
        if secret_name and not isinstance(secret_name, str):
            raise TypeError("Expected argument 'secret_name' to be a str")
        pulumi.set(__self__, "secret_name", secret_name)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if updated_at and not isinstance(updated_at, str):
            raise TypeError("Expected argument 'updated_at' to be a str")
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        Date and time of secret version's creation (RFC 3339 format).
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        The data payload of the secret version. more on the data section
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        (Optional) Description of the secret version (e.g. `my-new-description`).
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def revision(self) -> Optional[str]:
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[str]:
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> Optional[str]:
        return pulumi.get(self, "secret_name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Secret Version.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        Date and time of secret version's last update (RFC 3339 format).
        """
        return pulumi.get(self, "updated_at")


class AwaitableGetSecretVersionResult(GetSecretVersionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecretVersionResult(
            created_at=self.created_at,
            data=self.data,
            description=self.description,
            id=self.id,
            region=self.region,
            revision=self.revision,
            secret_id=self.secret_id,
            secret_name=self.secret_name,
            status=self.status,
            updated_at=self.updated_at)


def get_secret_version(region: Optional[str] = None,
                       revision: Optional[str] = None,
                       secret_id: Optional[str] = None,
                       secret_name: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecretVersionResult:
    """
    Use this data source to access information about an existing resource.

    :param str region: `region`) The region
           in which the resource exists.
    :param str revision: The revision for this Secret Version.
    :param str secret_id: The Secret ID associated wit the secret version.
           Only one of `secret_id` and `secret_name` should be specified.
    :param str secret_name: The Name of Secret associated wit the secret version.
           Only one of `secret_id` and `secret_name` should be specified.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['revision'] = revision
    __args__['secretId'] = secret_id
    __args__['secretName'] = secret_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('scaleway:index/getSecretVersion:getSecretVersion', __args__, opts=opts, typ=GetSecretVersionResult).value

    return AwaitableGetSecretVersionResult(
        created_at=pulumi.get(__ret__, 'created_at'),
        data=pulumi.get(__ret__, 'data'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        region=pulumi.get(__ret__, 'region'),
        revision=pulumi.get(__ret__, 'revision'),
        secret_id=pulumi.get(__ret__, 'secret_id'),
        secret_name=pulumi.get(__ret__, 'secret_name'),
        status=pulumi.get(__ret__, 'status'),
        updated_at=pulumi.get(__ret__, 'updated_at'))


@_utilities.lift_output_func(get_secret_version)
def get_secret_version_output(region: Optional[pulumi.Input[Optional[str]]] = None,
                              revision: Optional[pulumi.Input[Optional[str]]] = None,
                              secret_id: Optional[pulumi.Input[Optional[str]]] = None,
                              secret_name: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecretVersionResult]:
    """
    Use this data source to access information about an existing resource.

    :param str region: `region`) The region
           in which the resource exists.
    :param str revision: The revision for this Secret Version.
    :param str secret_id: The Secret ID associated wit the secret version.
           Only one of `secret_id` and `secret_name` should be specified.
    :param str secret_name: The Name of Secret associated wit the secret version.
           Only one of `secret_id` and `secret_name` should be specified.
    """
    ...
