# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['K8sPoolArgs', 'K8sPool']

@pulumi.input_type
class K8sPoolArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 node_type: pulumi.Input[str],
                 size: pulumi.Input[int],
                 autohealing: Optional[pulumi.Input[bool]] = None,
                 autoscaling: Optional[pulumi.Input[bool]] = None,
                 container_runtime: Optional[pulumi.Input[str]] = None,
                 kubelet_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 placement_group_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume_size_in_gb: Optional[pulumi.Input[int]] = None,
                 root_volume_type: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input['K8sPoolUpgradePolicyArgs']] = None,
                 wait_for_pool_ready: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a K8sPool resource.
        :param pulumi.Input[str] cluster_id: The ID of the Kubernetes cluster on which this pool will be created.
        :param pulumi.Input[str] node_type: The commercial type of the pool instances. Instances with insufficient memory are not eligible (DEV1-S, PLAY2-PICO, STARDUST). `external` is a special node type used to provision from other Cloud providers.
               
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[int] size: The size of the pool.
               > **Important:** This field will only be used at creation if autoscaling is enabled.
        :param pulumi.Input[bool] autohealing: Enables the autohealing feature for this pool.
        :param pulumi.Input[bool] autoscaling: Enables the autoscaling feature for this pool.
               > **Important:** When enabled, an update of the `size` will not be taken into account.
        :param pulumi.Input[str] container_runtime: The container runtime of the pool.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] kubelet_args: The Kubelet arguments to be used by this pool
        :param pulumi.Input[int] max_size: The maximum size of the pool, used by the autoscaling feature.
        :param pulumi.Input[int] min_size: The minimum size of the pool, used by the autoscaling feature.
        :param pulumi.Input[str] name: The name for the pool.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] placement_group_id: The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the nodes of the pool will be attached to.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] region: `region`) The region in which the pool should be created.
        :param pulumi.Input[int] root_volume_size_in_gb: The size of the system volume of the nodes in gigabyte
        :param pulumi.Input[str] root_volume_type: System volume type of the nodes composing the pool
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the pool.
               > Note: As mentionned in [this document](https://github.com/scaleway/scaleway-cloud-controller-manager/blob/master/docs/tags.md#taints), taints of a pool's nodes are applied using tags. (Example: "taint=taintName=taineValue:Effect")
        :param pulumi.Input['K8sPoolUpgradePolicyArgs'] upgrade_policy: The Pool upgrade policy
        :param pulumi.Input[bool] wait_for_pool_ready: Whether to wait for the pool to be ready.
        :param pulumi.Input[str] zone: `zone`) The zone in which the pool should be created.
               > **Important:** Updates to this field will recreate a new resource.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "size", size)
        if autohealing is not None:
            pulumi.set(__self__, "autohealing", autohealing)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if container_runtime is not None:
            pulumi.set(__self__, "container_runtime", container_runtime)
        if kubelet_args is not None:
            pulumi.set(__self__, "kubelet_args", kubelet_args)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_volume_size_in_gb is not None:
            pulumi.set(__self__, "root_volume_size_in_gb", root_volume_size_in_gb)
        if root_volume_type is not None:
            pulumi.set(__self__, "root_volume_type", root_volume_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if upgrade_policy is not None:
            pulumi.set(__self__, "upgrade_policy", upgrade_policy)
        if wait_for_pool_ready is not None:
            pulumi.set(__self__, "wait_for_pool_ready", wait_for_pool_ready)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The ID of the Kubernetes cluster on which this pool will be created.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[str]:
        """
        The commercial type of the pool instances. Instances with insufficient memory are not eligible (DEV1-S, PLAY2-PICO, STARDUST). `external` is a special node type used to provision from other Cloud providers.

        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        The size of the pool.
        > **Important:** This field will only be used at creation if autoscaling is enabled.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def autohealing(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables the autohealing feature for this pool.
        """
        return pulumi.get(self, "autohealing")

    @autohealing.setter
    def autohealing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autohealing", value)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables the autoscaling feature for this pool.
        > **Important:** When enabled, an update of the `size` will not be taken into account.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="containerRuntime")
    def container_runtime(self) -> Optional[pulumi.Input[str]]:
        """
        The container runtime of the pool.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "container_runtime")

    @container_runtime.setter
    def container_runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_runtime", value)

    @property
    @pulumi.getter(name="kubeletArgs")
    def kubelet_args(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Kubelet arguments to be used by this pool
        """
        return pulumi.get(self, "kubelet_args")

    @kubelet_args.setter
    def kubelet_args(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "kubelet_args", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum size of the pool, used by the autoscaling feature.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum size of the pool, used by the autoscaling feature.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the pool.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the nodes of the pool will be attached to.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "placement_group_id")

    @placement_group_id.setter
    def placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        `region`) The region in which the pool should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rootVolumeSizeInGb")
    def root_volume_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the system volume of the nodes in gigabyte
        """
        return pulumi.get(self, "root_volume_size_in_gb")

    @root_volume_size_in_gb.setter
    def root_volume_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "root_volume_size_in_gb", value)

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        System volume type of the nodes composing the pool
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_volume_type", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the pool.
        > Note: As mentionned in [this document](https://github.com/scaleway/scaleway-cloud-controller-manager/blob/master/docs/tags.md#taints), taints of a pool's nodes are applied using tags. (Example: "taint=taintName=taineValue:Effect")
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> Optional[pulumi.Input['K8sPoolUpgradePolicyArgs']]:
        """
        The Pool upgrade policy
        """
        return pulumi.get(self, "upgrade_policy")

    @upgrade_policy.setter
    def upgrade_policy(self, value: Optional[pulumi.Input['K8sPoolUpgradePolicyArgs']]):
        pulumi.set(self, "upgrade_policy", value)

    @property
    @pulumi.getter(name="waitForPoolReady")
    def wait_for_pool_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to wait for the pool to be ready.
        """
        return pulumi.get(self, "wait_for_pool_ready")

    @wait_for_pool_ready.setter
    def wait_for_pool_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_pool_ready", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the pool should be created.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _K8sPoolState:
    def __init__(__self__, *,
                 autohealing: Optional[pulumi.Input[bool]] = None,
                 autoscaling: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 container_runtime: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 current_size: Optional[pulumi.Input[int]] = None,
                 kubelet_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['K8sPoolNodeArgs']]]] = None,
                 placement_group_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume_size_in_gb: Optional[pulumi.Input[int]] = None,
                 root_volume_type: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 upgrade_policy: Optional[pulumi.Input['K8sPoolUpgradePolicyArgs']] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 wait_for_pool_ready: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering K8sPool resources.
        :param pulumi.Input[bool] autohealing: Enables the autohealing feature for this pool.
        :param pulumi.Input[bool] autoscaling: Enables the autoscaling feature for this pool.
               > **Important:** When enabled, an update of the `size` will not be taken into account.
        :param pulumi.Input[str] cluster_id: The ID of the Kubernetes cluster on which this pool will be created.
        :param pulumi.Input[str] container_runtime: The container runtime of the pool.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] created_at: The creation date of the pool.
        :param pulumi.Input[int] current_size: The actual size of the pool
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] kubelet_args: The Kubelet arguments to be used by this pool
        :param pulumi.Input[int] max_size: The maximum size of the pool, used by the autoscaling feature.
        :param pulumi.Input[int] min_size: The minimum size of the pool, used by the autoscaling feature.
        :param pulumi.Input[str] name: The name for the pool.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] node_type: The commercial type of the pool instances. Instances with insufficient memory are not eligible (DEV1-S, PLAY2-PICO, STARDUST). `external` is a special node type used to provision from other Cloud providers.
               
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['K8sPoolNodeArgs']]] nodes: (List of) The nodes in the default pool.
        :param pulumi.Input[str] placement_group_id: The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the nodes of the pool will be attached to.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] region: `region`) The region in which the pool should be created.
        :param pulumi.Input[int] root_volume_size_in_gb: The size of the system volume of the nodes in gigabyte
        :param pulumi.Input[str] root_volume_type: System volume type of the nodes composing the pool
        :param pulumi.Input[int] size: The size of the pool.
               > **Important:** This field will only be used at creation if autoscaling is enabled.
        :param pulumi.Input[str] status: The status of the node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the pool.
               > Note: As mentionned in [this document](https://github.com/scaleway/scaleway-cloud-controller-manager/blob/master/docs/tags.md#taints), taints of a pool's nodes are applied using tags. (Example: "taint=taintName=taineValue:Effect")
        :param pulumi.Input[str] updated_at: The last update date of the pool.
        :param pulumi.Input['K8sPoolUpgradePolicyArgs'] upgrade_policy: The Pool upgrade policy
        :param pulumi.Input[str] version: The version of the pool.
        :param pulumi.Input[bool] wait_for_pool_ready: Whether to wait for the pool to be ready.
        :param pulumi.Input[str] zone: `zone`) The zone in which the pool should be created.
               > **Important:** Updates to this field will recreate a new resource.
        """
        if autohealing is not None:
            pulumi.set(__self__, "autohealing", autohealing)
        if autoscaling is not None:
            pulumi.set(__self__, "autoscaling", autoscaling)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if container_runtime is not None:
            pulumi.set(__self__, "container_runtime", container_runtime)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if current_size is not None:
            pulumi.set(__self__, "current_size", current_size)
        if kubelet_args is not None:
            pulumi.set(__self__, "kubelet_args", kubelet_args)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if placement_group_id is not None:
            pulumi.set(__self__, "placement_group_id", placement_group_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if root_volume_size_in_gb is not None:
            pulumi.set(__self__, "root_volume_size_in_gb", root_volume_size_in_gb)
        if root_volume_type is not None:
            pulumi.set(__self__, "root_volume_type", root_volume_type)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if upgrade_policy is not None:
            pulumi.set(__self__, "upgrade_policy", upgrade_policy)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if wait_for_pool_ready is not None:
            pulumi.set(__self__, "wait_for_pool_ready", wait_for_pool_ready)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def autohealing(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables the autohealing feature for this pool.
        """
        return pulumi.get(self, "autohealing")

    @autohealing.setter
    def autohealing(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autohealing", value)

    @property
    @pulumi.getter
    def autoscaling(self) -> Optional[pulumi.Input[bool]]:
        """
        Enables the autoscaling feature for this pool.
        > **Important:** When enabled, an update of the `size` will not be taken into account.
        """
        return pulumi.get(self, "autoscaling")

    @autoscaling.setter
    def autoscaling(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "autoscaling", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Kubernetes cluster on which this pool will be created.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="containerRuntime")
    def container_runtime(self) -> Optional[pulumi.Input[str]]:
        """
        The container runtime of the pool.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "container_runtime")

    @container_runtime.setter
    def container_runtime(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_runtime", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The creation date of the pool.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter(name="currentSize")
    def current_size(self) -> Optional[pulumi.Input[int]]:
        """
        The actual size of the pool
        """
        return pulumi.get(self, "current_size")

    @current_size.setter
    def current_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "current_size", value)

    @property
    @pulumi.getter(name="kubeletArgs")
    def kubelet_args(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Kubelet arguments to be used by this pool
        """
        return pulumi.get(self, "kubelet_args")

    @kubelet_args.setter
    def kubelet_args(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "kubelet_args", value)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum size of the pool, used by the autoscaling feature.
        """
        return pulumi.get(self, "max_size")

    @max_size.setter
    def max_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_size", value)

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[pulumi.Input[int]]:
        """
        The minimum size of the pool, used by the autoscaling feature.
        """
        return pulumi.get(self, "min_size")

    @min_size.setter
    def min_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name for the pool.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        The commercial type of the pool instances. Instances with insufficient memory are not eligible (DEV1-S, PLAY2-PICO, STARDUST). `external` is a special node type used to provision from other Cloud providers.

        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['K8sPoolNodeArgs']]]]:
        """
        (List of) The nodes in the default pool.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['K8sPoolNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the nodes of the pool will be attached to.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "placement_group_id")

    @placement_group_id.setter
    def placement_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "placement_group_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        `region`) The region in which the pool should be created.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="rootVolumeSizeInGb")
    def root_volume_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the system volume of the nodes in gigabyte
        """
        return pulumi.get(self, "root_volume_size_in_gb")

    @root_volume_size_in_gb.setter
    def root_volume_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "root_volume_size_in_gb", value)

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> Optional[pulumi.Input[str]]:
        """
        System volume type of the nodes composing the pool
        """
        return pulumi.get(self, "root_volume_type")

    @root_volume_type.setter
    def root_volume_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_volume_type", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the pool.
        > **Important:** This field will only be used at creation if autoscaling is enabled.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the node.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the pool.
        > Note: As mentionned in [this document](https://github.com/scaleway/scaleway-cloud-controller-manager/blob/master/docs/tags.md#taints), taints of a pool's nodes are applied using tags. (Example: "taint=taintName=taineValue:Effect")
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The last update date of the pool.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> Optional[pulumi.Input['K8sPoolUpgradePolicyArgs']]:
        """
        The Pool upgrade policy
        """
        return pulumi.get(self, "upgrade_policy")

    @upgrade_policy.setter
    def upgrade_policy(self, value: Optional[pulumi.Input['K8sPoolUpgradePolicyArgs']]):
        pulumi.set(self, "upgrade_policy", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the pool.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="waitForPoolReady")
    def wait_for_pool_ready(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to wait for the pool to be ready.
        """
        return pulumi.get(self, "wait_for_pool_ready")

    @wait_for_pool_ready.setter
    def wait_for_pool_ready(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wait_for_pool_ready", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the pool should be created.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class K8sPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autohealing: Optional[pulumi.Input[bool]] = None,
                 autoscaling: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 container_runtime: Optional[pulumi.Input[str]] = None,
                 kubelet_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 placement_group_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume_size_in_gb: Optional[pulumi.Input[int]] = None,
                 root_volume_type: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input[pulumi.InputType['K8sPoolUpgradePolicyArgs']]] = None,
                 wait_for_pool_ready: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        Kubernetes pools can be imported using the `{region}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/k8sPool:K8sPool mypool fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] autohealing: Enables the autohealing feature for this pool.
        :param pulumi.Input[bool] autoscaling: Enables the autoscaling feature for this pool.
               > **Important:** When enabled, an update of the `size` will not be taken into account.
        :param pulumi.Input[str] cluster_id: The ID of the Kubernetes cluster on which this pool will be created.
        :param pulumi.Input[str] container_runtime: The container runtime of the pool.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] kubelet_args: The Kubelet arguments to be used by this pool
        :param pulumi.Input[int] max_size: The maximum size of the pool, used by the autoscaling feature.
        :param pulumi.Input[int] min_size: The minimum size of the pool, used by the autoscaling feature.
        :param pulumi.Input[str] name: The name for the pool.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] node_type: The commercial type of the pool instances. Instances with insufficient memory are not eligible (DEV1-S, PLAY2-PICO, STARDUST). `external` is a special node type used to provision from other Cloud providers.
               
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] placement_group_id: The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the nodes of the pool will be attached to.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] region: `region`) The region in which the pool should be created.
        :param pulumi.Input[int] root_volume_size_in_gb: The size of the system volume of the nodes in gigabyte
        :param pulumi.Input[str] root_volume_type: System volume type of the nodes composing the pool
        :param pulumi.Input[int] size: The size of the pool.
               > **Important:** This field will only be used at creation if autoscaling is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the pool.
               > Note: As mentionned in [this document](https://github.com/scaleway/scaleway-cloud-controller-manager/blob/master/docs/tags.md#taints), taints of a pool's nodes are applied using tags. (Example: "taint=taintName=taineValue:Effect")
        :param pulumi.Input[pulumi.InputType['K8sPoolUpgradePolicyArgs']] upgrade_policy: The Pool upgrade policy
        :param pulumi.Input[bool] wait_for_pool_ready: Whether to wait for the pool to be ready.
        :param pulumi.Input[str] zone: `zone`) The zone in which the pool should be created.
               > **Important:** Updates to this field will recreate a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: K8sPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Kubernetes pools can be imported using the `{region}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/k8sPool:K8sPool mypool fr-par/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param K8sPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(K8sPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 autohealing: Optional[pulumi.Input[bool]] = None,
                 autoscaling: Optional[pulumi.Input[bool]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 container_runtime: Optional[pulumi.Input[str]] = None,
                 kubelet_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 max_size: Optional[pulumi.Input[int]] = None,
                 min_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 placement_group_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 root_volume_size_in_gb: Optional[pulumi.Input[int]] = None,
                 root_volume_type: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 upgrade_policy: Optional[pulumi.Input[pulumi.InputType['K8sPoolUpgradePolicyArgs']]] = None,
                 wait_for_pool_ready: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = K8sPoolArgs.__new__(K8sPoolArgs)

            __props__.__dict__["autohealing"] = autohealing
            __props__.__dict__["autoscaling"] = autoscaling
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["container_runtime"] = container_runtime
            __props__.__dict__["kubelet_args"] = kubelet_args
            __props__.__dict__["max_size"] = max_size
            __props__.__dict__["min_size"] = min_size
            __props__.__dict__["name"] = name
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["placement_group_id"] = placement_group_id
            __props__.__dict__["region"] = region
            __props__.__dict__["root_volume_size_in_gb"] = root_volume_size_in_gb
            __props__.__dict__["root_volume_type"] = root_volume_type
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["tags"] = tags
            __props__.__dict__["upgrade_policy"] = upgrade_policy
            __props__.__dict__["wait_for_pool_ready"] = wait_for_pool_ready
            __props__.__dict__["zone"] = zone
            __props__.__dict__["created_at"] = None
            __props__.__dict__["current_size"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["version"] = None
        super(K8sPool, __self__).__init__(
            'scaleway:index/k8sPool:K8sPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            autohealing: Optional[pulumi.Input[bool]] = None,
            autoscaling: Optional[pulumi.Input[bool]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            container_runtime: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            current_size: Optional[pulumi.Input[int]] = None,
            kubelet_args: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            max_size: Optional[pulumi.Input[int]] = None,
            min_size: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_type: Optional[pulumi.Input[str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['K8sPoolNodeArgs']]]]] = None,
            placement_group_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            root_volume_size_in_gb: Optional[pulumi.Input[int]] = None,
            root_volume_type: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            upgrade_policy: Optional[pulumi.Input[pulumi.InputType['K8sPoolUpgradePolicyArgs']]] = None,
            version: Optional[pulumi.Input[str]] = None,
            wait_for_pool_ready: Optional[pulumi.Input[bool]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'K8sPool':
        """
        Get an existing K8sPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] autohealing: Enables the autohealing feature for this pool.
        :param pulumi.Input[bool] autoscaling: Enables the autoscaling feature for this pool.
               > **Important:** When enabled, an update of the `size` will not be taken into account.
        :param pulumi.Input[str] cluster_id: The ID of the Kubernetes cluster on which this pool will be created.
        :param pulumi.Input[str] container_runtime: The container runtime of the pool.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] created_at: The creation date of the pool.
        :param pulumi.Input[int] current_size: The actual size of the pool
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] kubelet_args: The Kubelet arguments to be used by this pool
        :param pulumi.Input[int] max_size: The maximum size of the pool, used by the autoscaling feature.
        :param pulumi.Input[int] min_size: The minimum size of the pool, used by the autoscaling feature.
        :param pulumi.Input[str] name: The name for the pool.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] node_type: The commercial type of the pool instances. Instances with insufficient memory are not eligible (DEV1-S, PLAY2-PICO, STARDUST). `external` is a special node type used to provision from other Cloud providers.
               
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['K8sPoolNodeArgs']]]] nodes: (List of) The nodes in the default pool.
        :param pulumi.Input[str] placement_group_id: The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the nodes of the pool will be attached to.
               > **Important:** Updates to this field will recreate a new resource.
        :param pulumi.Input[str] region: `region`) The region in which the pool should be created.
        :param pulumi.Input[int] root_volume_size_in_gb: The size of the system volume of the nodes in gigabyte
        :param pulumi.Input[str] root_volume_type: System volume type of the nodes composing the pool
        :param pulumi.Input[int] size: The size of the pool.
               > **Important:** This field will only be used at creation if autoscaling is enabled.
        :param pulumi.Input[str] status: The status of the node.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the pool.
               > Note: As mentionned in [this document](https://github.com/scaleway/scaleway-cloud-controller-manager/blob/master/docs/tags.md#taints), taints of a pool's nodes are applied using tags. (Example: "taint=taintName=taineValue:Effect")
        :param pulumi.Input[str] updated_at: The last update date of the pool.
        :param pulumi.Input[pulumi.InputType['K8sPoolUpgradePolicyArgs']] upgrade_policy: The Pool upgrade policy
        :param pulumi.Input[str] version: The version of the pool.
        :param pulumi.Input[bool] wait_for_pool_ready: Whether to wait for the pool to be ready.
        :param pulumi.Input[str] zone: `zone`) The zone in which the pool should be created.
               > **Important:** Updates to this field will recreate a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _K8sPoolState.__new__(_K8sPoolState)

        __props__.__dict__["autohealing"] = autohealing
        __props__.__dict__["autoscaling"] = autoscaling
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["container_runtime"] = container_runtime
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["current_size"] = current_size
        __props__.__dict__["kubelet_args"] = kubelet_args
        __props__.__dict__["max_size"] = max_size
        __props__.__dict__["min_size"] = min_size
        __props__.__dict__["name"] = name
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["placement_group_id"] = placement_group_id
        __props__.__dict__["region"] = region
        __props__.__dict__["root_volume_size_in_gb"] = root_volume_size_in_gb
        __props__.__dict__["root_volume_type"] = root_volume_type
        __props__.__dict__["size"] = size
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["upgrade_policy"] = upgrade_policy
        __props__.__dict__["version"] = version
        __props__.__dict__["wait_for_pool_ready"] = wait_for_pool_ready
        __props__.__dict__["zone"] = zone
        return K8sPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def autohealing(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables the autohealing feature for this pool.
        """
        return pulumi.get(self, "autohealing")

    @property
    @pulumi.getter
    def autoscaling(self) -> pulumi.Output[Optional[bool]]:
        """
        Enables the autoscaling feature for this pool.
        > **Important:** When enabled, an update of the `size` will not be taken into account.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The ID of the Kubernetes cluster on which this pool will be created.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="containerRuntime")
    def container_runtime(self) -> pulumi.Output[Optional[str]]:
        """
        The container runtime of the pool.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "container_runtime")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The creation date of the pool.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="currentSize")
    def current_size(self) -> pulumi.Output[int]:
        """
        The actual size of the pool
        """
        return pulumi.get(self, "current_size")

    @property
    @pulumi.getter(name="kubeletArgs")
    def kubelet_args(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The Kubelet arguments to be used by this pool
        """
        return pulumi.get(self, "kubelet_args")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> pulumi.Output[int]:
        """
        The maximum size of the pool, used by the autoscaling feature.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> pulumi.Output[Optional[int]]:
        """
        The minimum size of the pool, used by the autoscaling feature.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name for the pool.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[str]:
        """
        The commercial type of the pool instances. Instances with insufficient memory are not eligible (DEV1-S, PLAY2-PICO, STARDUST). `external` is a special node type used to provision from other Cloud providers.

        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.K8sPoolNode']]:
        """
        (List of) The nodes in the default pool.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="placementGroupId")
    def placement_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        The [placement group](https://developers.scaleway.com/en/products/instance/api/#placement-groups-d8f653) the nodes of the pool will be attached to.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "placement_group_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        `region`) The region in which the pool should be created.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rootVolumeSizeInGb")
    def root_volume_size_in_gb(self) -> pulumi.Output[Optional[int]]:
        """
        The size of the system volume of the nodes in gigabyte
        """
        return pulumi.get(self, "root_volume_size_in_gb")

    @property
    @pulumi.getter(name="rootVolumeType")
    def root_volume_type(self) -> pulumi.Output[Optional[str]]:
        """
        System volume type of the nodes composing the pool
        """
        return pulumi.get(self, "root_volume_type")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        The size of the pool.
        > **Important:** This field will only be used at creation if autoscaling is enabled.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the node.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The tags associated with the pool.
        > Note: As mentionned in [this document](https://github.com/scaleway/scaleway-cloud-controller-manager/blob/master/docs/tags.md#taints), taints of a pool's nodes are applied using tags. (Example: "taint=taintName=taineValue:Effect")
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The last update date of the pool.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="upgradePolicy")
    def upgrade_policy(self) -> pulumi.Output['outputs.K8sPoolUpgradePolicy']:
        """
        The Pool upgrade policy
        """
        return pulumi.get(self, "upgrade_policy")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The version of the pool.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="waitForPoolReady")
    def wait_for_pool_ready(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to wait for the pool to be ready.
        """
        return pulumi.get(self, "wait_for_pool_ready")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        `zone`) The zone in which the pool should be created.
        > **Important:** Updates to this field will recreate a new resource.
        """
        return pulumi.get(self, "zone")

