# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RedisClusterArgs', 'RedisCluster']

@pulumi.input_type
class RedisClusterArgs:
    def __init__(__self__, *,
                 node_type: pulumi.Input[str],
                 password: pulumi.Input[str],
                 user_name: pulumi.Input[str],
                 version: pulumi.Input[str],
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterAclArgs']]]] = None,
                 cluster_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 public_network: Optional[pulumi.Input['RedisClusterPublicNetworkArgs']] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tls_enabled: Optional[pulumi.Input[bool]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RedisCluster resource.
        :param pulumi.Input[str] node_type: The type of Redis Cluster you want to create (e.g. `RED1-M`).
               
               > **Important:** Updates to `node_type` will migrate the Redis Cluster to the desired `node_type`. Keep in mind that
               you cannot downgrade a Redis Cluster.
        :param pulumi.Input[str] password: Password for the first user of the Redis Cluster.
        :param pulumi.Input[str] user_name: Identifier for the first user of the Redis Cluster.
        :param pulumi.Input[str] version: Redis's Cluster version (e.g. `6.2.6`).
               
               > **Important:** Updates to `version` will migrate the Redis Cluster to the desired `version`. Keep in mind that you
               cannot downgrade a Redis Cluster.
        :param pulumi.Input[Sequence[pulumi.Input['RedisClusterAclArgs']]] acls: List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        :param pulumi.Input[int] cluster_size: The number of nodes in the Redis Cluster.
               
               > **Important:** You cannot set `cluster_size` to 2, you either have to choose Standalone mode (1 node) or Cluster mode
               which is minimum 3 (1 main node + 2 secondary nodes)
               
               > **Important:** You can set a bigger `cluster_size` than you initially did, it will migrate the Redis Cluster, but
               keep in mind that you cannot downgrade a Redis Cluster so setting a smaller `cluster_size` will not have any effect.
        :param pulumi.Input[str] name: The name of the Redis Cluster.
        :param pulumi.Input[Sequence[pulumi.Input['RedisClusterPrivateNetworkArgs']]] private_networks: Describes the private network you want to connect to your cluster. If not set, a public
               network will be provided. More details on the Private Network section
               
               > **Important:** The way to use private networks differs whether you are using redis in standalone or cluster mode.
               
               - Standalone mode (`cluster_size` = 1) : you can attach as many private networks as you want (each must be a separate
               block). If you detach your only private network, your cluster won't be reachable until you define a new private or
               public network. You can modify your private_network and its specs, you can have both a private and public network side
               by side.
               
               - Cluster mode (`cluster_size` > 1) : you can define a single private network as you create your cluster, you won't be
               able to edit or detach it afterward, unless you create another cluster. Your `service_ips` must be listed as follows:
               
               ```python
               import pulumi
               ```
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the Redis Cluster is
               associated with.
        :param pulumi.Input['RedisClusterPublicNetworkArgs'] public_network: (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
               > The `public_network` block exports:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Map of settings for redis cluster. Available settings can be found by listing redis versions
               with scaleway API or CLI
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the Redis Cluster.
        :param pulumi.Input[bool] tls_enabled: Whether TLS is enabled or not.
               
               > The changes on `tls_enabled` will force the resource creation.
        :param pulumi.Input[str] zone: `zone`) The zone in which the
               Redis Cluster should be created.
        """
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "version", version)
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_network is not None:
            pulumi.set(__self__, "public_network", public_network)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[str]:
        """
        The type of Redis Cluster you want to create (e.g. `RED1-M`).

        > **Important:** Updates to `node_type` will migrate the Redis Cluster to the desired `node_type`. Keep in mind that
        you cannot downgrade a Redis Cluster.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Password for the first user of the Redis Cluster.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        Identifier for the first user of the Redis Cluster.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def version(self) -> pulumi.Input[str]:
        """
        Redis's Cluster version (e.g. `6.2.6`).

        > **Important:** Updates to `version` will migrate the Redis Cluster to the desired `version`. Keep in mind that you
        cannot downgrade a Redis Cluster.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: pulumi.Input[str]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterAclArgs']]]]:
        """
        List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterAclArgs']]]]):
        pulumi.set(self, "acls", value)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes in the Redis Cluster.

        > **Important:** You cannot set `cluster_size` to 2, you either have to choose Standalone mode (1 node) or Cluster mode
        which is minimum 3 (1 main node + 2 secondary nodes)

        > **Important:** You can set a bigger `cluster_size` than you initially did, it will migrate the Redis Cluster, but
        keep in mind that you cannot downgrade a Redis Cluster so setting a smaller `cluster_size` will not have any effect.
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Redis Cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterPrivateNetworkArgs']]]]:
        """
        Describes the private network you want to connect to your cluster. If not set, a public
        network will be provided. More details on the Private Network section

        > **Important:** The way to use private networks differs whether you are using redis in standalone or cluster mode.

        - Standalone mode (`cluster_size` = 1) : you can attach as many private networks as you want (each must be a separate
        block). If you detach your only private network, your cluster won't be reachable until you define a new private or
        public network. You can modify your private_network and its specs, you can have both a private and public network side
        by side.

        - Cluster mode (`cluster_size` > 1) : you can define a single private network as you create your cluster, you won't be
        able to edit or detach it afterward, unless you create another cluster. Your `service_ips` must be listed as follows:

        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the Redis Cluster is
        associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> Optional[pulumi.Input['RedisClusterPublicNetworkArgs']]:
        """
        (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
        > The `public_network` block exports:
        """
        return pulumi.get(self, "public_network")

    @public_network.setter
    def public_network(self, value: Optional[pulumi.Input['RedisClusterPublicNetworkArgs']]):
        pulumi.set(self, "public_network", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of settings for redis cluster. Available settings can be found by listing redis versions
        with scaleway API or CLI
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the Redis Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether TLS is enabled or not.

        > The changes on `tls_enabled` will force the resource creation.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls_enabled", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the
        Redis Cluster should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _RedisClusterState:
    def __init__(__self__, *,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterAclArgs']]]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 cluster_size: Optional[pulumi.Input[int]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterPrivateNetworkArgs']]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 public_network: Optional[pulumi.Input['RedisClusterPublicNetworkArgs']] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tls_enabled: Optional[pulumi.Input[bool]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RedisCluster resources.
        :param pulumi.Input[Sequence[pulumi.Input['RedisClusterAclArgs']]] acls: List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        :param pulumi.Input[str] certificate: The PEM of the certificate used by redis, only when `tls_enabled` is true
        :param pulumi.Input[int] cluster_size: The number of nodes in the Redis Cluster.
               
               > **Important:** You cannot set `cluster_size` to 2, you either have to choose Standalone mode (1 node) or Cluster mode
               which is minimum 3 (1 main node + 2 secondary nodes)
               
               > **Important:** You can set a bigger `cluster_size` than you initially did, it will migrate the Redis Cluster, but
               keep in mind that you cannot downgrade a Redis Cluster so setting a smaller `cluster_size` will not have any effect.
        :param pulumi.Input[str] created_at: The date and time of creation of the Redis Cluster.
        :param pulumi.Input[str] name: The name of the Redis Cluster.
        :param pulumi.Input[str] node_type: The type of Redis Cluster you want to create (e.g. `RED1-M`).
               
               > **Important:** Updates to `node_type` will migrate the Redis Cluster to the desired `node_type`. Keep in mind that
               you cannot downgrade a Redis Cluster.
        :param pulumi.Input[str] password: Password for the first user of the Redis Cluster.
        :param pulumi.Input[Sequence[pulumi.Input['RedisClusterPrivateNetworkArgs']]] private_networks: Describes the private network you want to connect to your cluster. If not set, a public
               network will be provided. More details on the Private Network section
               
               > **Important:** The way to use private networks differs whether you are using redis in standalone or cluster mode.
               
               - Standalone mode (`cluster_size` = 1) : you can attach as many private networks as you want (each must be a separate
               block). If you detach your only private network, your cluster won't be reachable until you define a new private or
               public network. You can modify your private_network and its specs, you can have both a private and public network side
               by side.
               
               - Cluster mode (`cluster_size` > 1) : you can define a single private network as you create your cluster, you won't be
               able to edit or detach it afterward, unless you create another cluster. Your `service_ips` must be listed as follows:
               
               ```python
               import pulumi
               ```
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the Redis Cluster is
               associated with.
        :param pulumi.Input['RedisClusterPublicNetworkArgs'] public_network: (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
               > The `public_network` block exports:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Map of settings for redis cluster. Available settings can be found by listing redis versions
               with scaleway API or CLI
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the Redis Cluster.
        :param pulumi.Input[bool] tls_enabled: Whether TLS is enabled or not.
               
               > The changes on `tls_enabled` will force the resource creation.
        :param pulumi.Input[str] updated_at: The date and time of the last update of the Redis Cluster.
        :param pulumi.Input[str] user_name: Identifier for the first user of the Redis Cluster.
        :param pulumi.Input[str] version: Redis's Cluster version (e.g. `6.2.6`).
               
               > **Important:** Updates to `version` will migrate the Redis Cluster to the desired `version`. Keep in mind that you
               cannot downgrade a Redis Cluster.
        :param pulumi.Input[str] zone: `zone`) The zone in which the
               Redis Cluster should be created.
        """
        if acls is not None:
            pulumi.set(__self__, "acls", acls)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if cluster_size is not None:
            pulumi.set(__self__, "cluster_size", cluster_size)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if private_networks is not None:
            pulumi.set(__self__, "private_networks", private_networks)
        if project_id is not None:
            pulumi.set(__self__, "project_id", project_id)
        if public_network is not None:
            pulumi.set(__self__, "public_network", public_network)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tls_enabled is not None:
            pulumi.set(__self__, "tls_enabled", tls_enabled)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterAclArgs']]]]:
        """
        List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        """
        return pulumi.get(self, "acls")

    @acls.setter
    def acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterAclArgs']]]]):
        pulumi.set(self, "acls", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The PEM of the certificate used by redis, only when `tls_enabled` is true
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes in the Redis Cluster.

        > **Important:** You cannot set `cluster_size` to 2, you either have to choose Standalone mode (1 node) or Cluster mode
        which is minimum 3 (1 main node + 2 secondary nodes)

        > **Important:** You can set a bigger `cluster_size` than you initially did, it will migrate the Redis Cluster, but
        keep in mind that you cannot downgrade a Redis Cluster so setting a smaller `cluster_size` will not have any effect.
        """
        return pulumi.get(self, "cluster_size")

    @cluster_size.setter
    def cluster_size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cluster_size", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of creation of the Redis Cluster.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Redis Cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of Redis Cluster you want to create (e.g. `RED1-M`).

        > **Important:** Updates to `node_type` will migrate the Redis Cluster to the desired `node_type`. Keep in mind that
        you cannot downgrade a Redis Cluster.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_type", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Password for the first user of the Redis Cluster.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterPrivateNetworkArgs']]]]:
        """
        Describes the private network you want to connect to your cluster. If not set, a public
        network will be provided. More details on the Private Network section

        > **Important:** The way to use private networks differs whether you are using redis in standalone or cluster mode.

        - Standalone mode (`cluster_size` = 1) : you can attach as many private networks as you want (each must be a separate
        block). If you detach your only private network, your cluster won't be reachable until you define a new private or
        public network. You can modify your private_network and its specs, you can have both a private and public network side
        by side.

        - Cluster mode (`cluster_size` > 1) : you can define a single private network as you create your cluster, you won't be
        able to edit or detach it afterward, unless you create another cluster. Your `service_ips` must be listed as follows:

        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "private_networks")

    @private_networks.setter
    def private_networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RedisClusterPrivateNetworkArgs']]]]):
        pulumi.set(self, "private_networks", value)

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[pulumi.Input[str]]:
        """
        `project_id`) The ID of the project the Redis Cluster is
        associated with.
        """
        return pulumi.get(self, "project_id")

    @project_id.setter
    def project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_id", value)

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> Optional[pulumi.Input['RedisClusterPublicNetworkArgs']]:
        """
        (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
        > The `public_network` block exports:
        """
        return pulumi.get(self, "public_network")

    @public_network.setter
    def public_network(self, value: Optional[pulumi.Input['RedisClusterPublicNetworkArgs']]):
        pulumi.set(self, "public_network", value)

    @property
    @pulumi.getter
    def settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Map of settings for redis cluster. Available settings can be found by listing redis versions
        with scaleway API or CLI
        """
        return pulumi.get(self, "settings")

    @settings.setter
    def settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "settings", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The tags associated with the Redis Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether TLS is enabled or not.

        > The changes on `tls_enabled` will force the resource creation.
        """
        return pulumi.get(self, "tls_enabled")

    @tls_enabled.setter
    def tls_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tls_enabled", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the last update of the Redis Cluster.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Identifier for the first user of the Redis Cluster.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Redis's Cluster version (e.g. `6.2.6`).

        > **Important:** Updates to `version` will migrate the Redis Cluster to the desired `version`. Keep in mind that you
        cannot downgrade a Redis Cluster.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[str]]:
        """
        `zone`) The zone in which the
        Redis Cluster should be created.
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone", value)


class RedisCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RedisClusterAclArgs']]]]] = None,
                 cluster_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RedisClusterPrivateNetworkArgs']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 public_network: Optional[pulumi.Input[pulumi.InputType['RedisClusterPublicNetworkArgs']]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tls_enabled: Optional[pulumi.Input[bool]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates and manages Scaleway Redis Clusters.
        For more information, see [the documentation](https://developers.scaleway.com/en/products/redis/api/v1alpha1/).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import ediri_scaleway as scaleway

        main = scaleway.RedisCluster("main",
            acls=[scaleway.RedisClusterAclArgs(
                description="Allow all",
                ip="0.0.0.0/0",
            )],
            cluster_size=1,
            node_type="RED1-MICRO",
            password="thiZ_is_v&ry_s3cret",
            tags=[
                "test",
                "redis",
            ],
            tls_enabled=True,
            user_name="my_initial_user",
            version="6.2.6")
        ```

        ### With settings

        ```python
        import pulumi
        import ediri_scaleway as scaleway

        main = scaleway.RedisCluster("main",
            node_type="RED1-MICRO",
            password="thiZ_is_v&ry_s3cret",
            settings={
                "maxclients": "1000",
                "tcp-keepalive": "120",
            },
            user_name="my_initial_user",
            version="6.2.6")
        ```

        ### With a private network

        ```python
        import pulumi
        import ediri_scaleway as scaleway

        pn = scaleway.VpcPrivateNetwork("pn")
        main = scaleway.RedisCluster("main",
            version="6.2.6",
            node_type="RED1-MICRO",
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            cluster_size=1,
            private_networks=[scaleway.RedisClusterPrivateNetworkArgs(
                id=pn.id,
                service_ips=["10.12.1.1/20"],
            )],
            opts=pulumi.ResourceOptions(depends_on=[pn]))
        ```

        ## Import

        Redis Cluster can be imported using the `{zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/redisCluster:RedisCluster main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RedisClusterAclArgs']]]] acls: List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        :param pulumi.Input[int] cluster_size: The number of nodes in the Redis Cluster.
               
               > **Important:** You cannot set `cluster_size` to 2, you either have to choose Standalone mode (1 node) or Cluster mode
               which is minimum 3 (1 main node + 2 secondary nodes)
               
               > **Important:** You can set a bigger `cluster_size` than you initially did, it will migrate the Redis Cluster, but
               keep in mind that you cannot downgrade a Redis Cluster so setting a smaller `cluster_size` will not have any effect.
        :param pulumi.Input[str] name: The name of the Redis Cluster.
        :param pulumi.Input[str] node_type: The type of Redis Cluster you want to create (e.g. `RED1-M`).
               
               > **Important:** Updates to `node_type` will migrate the Redis Cluster to the desired `node_type`. Keep in mind that
               you cannot downgrade a Redis Cluster.
        :param pulumi.Input[str] password: Password for the first user of the Redis Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RedisClusterPrivateNetworkArgs']]]] private_networks: Describes the private network you want to connect to your cluster. If not set, a public
               network will be provided. More details on the Private Network section
               
               > **Important:** The way to use private networks differs whether you are using redis in standalone or cluster mode.
               
               - Standalone mode (`cluster_size` = 1) : you can attach as many private networks as you want (each must be a separate
               block). If you detach your only private network, your cluster won't be reachable until you define a new private or
               public network. You can modify your private_network and its specs, you can have both a private and public network side
               by side.
               
               - Cluster mode (`cluster_size` > 1) : you can define a single private network as you create your cluster, you won't be
               able to edit or detach it afterward, unless you create another cluster. Your `service_ips` must be listed as follows:
               
               ```python
               import pulumi
               ```
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the Redis Cluster is
               associated with.
        :param pulumi.Input[pulumi.InputType['RedisClusterPublicNetworkArgs']] public_network: (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
               > The `public_network` block exports:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Map of settings for redis cluster. Available settings can be found by listing redis versions
               with scaleway API or CLI
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the Redis Cluster.
        :param pulumi.Input[bool] tls_enabled: Whether TLS is enabled or not.
               
               > The changes on `tls_enabled` will force the resource creation.
        :param pulumi.Input[str] user_name: Identifier for the first user of the Redis Cluster.
        :param pulumi.Input[str] version: Redis's Cluster version (e.g. `6.2.6`).
               
               > **Important:** Updates to `version` will migrate the Redis Cluster to the desired `version`. Keep in mind that you
               cannot downgrade a Redis Cluster.
        :param pulumi.Input[str] zone: `zone`) The zone in which the
               Redis Cluster should be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RedisClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates and manages Scaleway Redis Clusters.
        For more information, see [the documentation](https://developers.scaleway.com/en/products/redis/api/v1alpha1/).

        ## Examples

        ### Basic

        ```python
        import pulumi
        import ediri_scaleway as scaleway

        main = scaleway.RedisCluster("main",
            acls=[scaleway.RedisClusterAclArgs(
                description="Allow all",
                ip="0.0.0.0/0",
            )],
            cluster_size=1,
            node_type="RED1-MICRO",
            password="thiZ_is_v&ry_s3cret",
            tags=[
                "test",
                "redis",
            ],
            tls_enabled=True,
            user_name="my_initial_user",
            version="6.2.6")
        ```

        ### With settings

        ```python
        import pulumi
        import ediri_scaleway as scaleway

        main = scaleway.RedisCluster("main",
            node_type="RED1-MICRO",
            password="thiZ_is_v&ry_s3cret",
            settings={
                "maxclients": "1000",
                "tcp-keepalive": "120",
            },
            user_name="my_initial_user",
            version="6.2.6")
        ```

        ### With a private network

        ```python
        import pulumi
        import ediri_scaleway as scaleway

        pn = scaleway.VpcPrivateNetwork("pn")
        main = scaleway.RedisCluster("main",
            version="6.2.6",
            node_type="RED1-MICRO",
            user_name="my_initial_user",
            password="thiZ_is_v&ry_s3cret",
            cluster_size=1,
            private_networks=[scaleway.RedisClusterPrivateNetworkArgs(
                id=pn.id,
                service_ips=["10.12.1.1/20"],
            )],
            opts=pulumi.ResourceOptions(depends_on=[pn]))
        ```

        ## Import

        Redis Cluster can be imported using the `{zone}/{id}`, e.g. bash

        ```sh
         $ pulumi import scaleway:index/redisCluster:RedisCluster main fr-par-1/11111111-1111-1111-1111-111111111111
        ```

        :param str resource_name: The name of the resource.
        :param RedisClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RedisClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RedisClusterAclArgs']]]]] = None,
                 cluster_size: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_type: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RedisClusterPrivateNetworkArgs']]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 public_network: Optional[pulumi.Input[pulumi.InputType['RedisClusterPublicNetworkArgs']]] = None,
                 settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tls_enabled: Optional[pulumi.Input[bool]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 zone: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RedisClusterArgs.__new__(RedisClusterArgs)

            __props__.__dict__["acls"] = acls
            __props__.__dict__["cluster_size"] = cluster_size
            __props__.__dict__["name"] = name
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["private_networks"] = private_networks
            __props__.__dict__["project_id"] = project_id
            __props__.__dict__["public_network"] = public_network
            __props__.__dict__["settings"] = settings
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tls_enabled"] = tls_enabled
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            if version is None and not opts.urn:
                raise TypeError("Missing required property 'version'")
            __props__.__dict__["version"] = version
            __props__.__dict__["zone"] = zone
            __props__.__dict__["certificate"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RedisCluster, __self__).__init__(
            'scaleway:index/redisCluster:RedisCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RedisClusterAclArgs']]]]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            cluster_size: Optional[pulumi.Input[int]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_type: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            private_networks: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RedisClusterPrivateNetworkArgs']]]]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            public_network: Optional[pulumi.Input[pulumi.InputType['RedisClusterPublicNetworkArgs']]] = None,
            settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tls_enabled: Optional[pulumi.Input[bool]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            zone: Optional[pulumi.Input[str]] = None) -> 'RedisCluster':
        """
        Get an existing RedisCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RedisClusterAclArgs']]]] acls: List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        :param pulumi.Input[str] certificate: The PEM of the certificate used by redis, only when `tls_enabled` is true
        :param pulumi.Input[int] cluster_size: The number of nodes in the Redis Cluster.
               
               > **Important:** You cannot set `cluster_size` to 2, you either have to choose Standalone mode (1 node) or Cluster mode
               which is minimum 3 (1 main node + 2 secondary nodes)
               
               > **Important:** You can set a bigger `cluster_size` than you initially did, it will migrate the Redis Cluster, but
               keep in mind that you cannot downgrade a Redis Cluster so setting a smaller `cluster_size` will not have any effect.
        :param pulumi.Input[str] created_at: The date and time of creation of the Redis Cluster.
        :param pulumi.Input[str] name: The name of the Redis Cluster.
        :param pulumi.Input[str] node_type: The type of Redis Cluster you want to create (e.g. `RED1-M`).
               
               > **Important:** Updates to `node_type` will migrate the Redis Cluster to the desired `node_type`. Keep in mind that
               you cannot downgrade a Redis Cluster.
        :param pulumi.Input[str] password: Password for the first user of the Redis Cluster.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RedisClusterPrivateNetworkArgs']]]] private_networks: Describes the private network you want to connect to your cluster. If not set, a public
               network will be provided. More details on the Private Network section
               
               > **Important:** The way to use private networks differs whether you are using redis in standalone or cluster mode.
               
               - Standalone mode (`cluster_size` = 1) : you can attach as many private networks as you want (each must be a separate
               block). If you detach your only private network, your cluster won't be reachable until you define a new private or
               public network. You can modify your private_network and its specs, you can have both a private and public network side
               by side.
               
               - Cluster mode (`cluster_size` > 1) : you can define a single private network as you create your cluster, you won't be
               able to edit or detach it afterward, unless you create another cluster. Your `service_ips` must be listed as follows:
               
               ```python
               import pulumi
               ```
        :param pulumi.Input[str] project_id: `project_id`) The ID of the project the Redis Cluster is
               associated with.
        :param pulumi.Input[pulumi.InputType['RedisClusterPublicNetworkArgs']] public_network: (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
               > The `public_network` block exports:
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] settings: Map of settings for redis cluster. Available settings can be found by listing redis versions
               with scaleway API or CLI
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: The tags associated with the Redis Cluster.
        :param pulumi.Input[bool] tls_enabled: Whether TLS is enabled or not.
               
               > The changes on `tls_enabled` will force the resource creation.
        :param pulumi.Input[str] updated_at: The date and time of the last update of the Redis Cluster.
        :param pulumi.Input[str] user_name: Identifier for the first user of the Redis Cluster.
        :param pulumi.Input[str] version: Redis's Cluster version (e.g. `6.2.6`).
               
               > **Important:** Updates to `version` will migrate the Redis Cluster to the desired `version`. Keep in mind that you
               cannot downgrade a Redis Cluster.
        :param pulumi.Input[str] zone: `zone`) The zone in which the
               Redis Cluster should be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RedisClusterState.__new__(_RedisClusterState)

        __props__.__dict__["acls"] = acls
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["cluster_size"] = cluster_size
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["name"] = name
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["password"] = password
        __props__.__dict__["private_networks"] = private_networks
        __props__.__dict__["project_id"] = project_id
        __props__.__dict__["public_network"] = public_network
        __props__.__dict__["settings"] = settings
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tls_enabled"] = tls_enabled
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["version"] = version
        __props__.__dict__["zone"] = zone
        return RedisCluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acls(self) -> pulumi.Output[Optional[Sequence['outputs.RedisClusterAcl']]]:
        """
        List of acl rules, this is cluster's authorized IPs. More details on the ACL section.
        """
        return pulumi.get(self, "acls")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        The PEM of the certificate used by redis, only when `tls_enabled` is true
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="clusterSize")
    def cluster_size(self) -> pulumi.Output[int]:
        """
        The number of nodes in the Redis Cluster.

        > **Important:** You cannot set `cluster_size` to 2, you either have to choose Standalone mode (1 node) or Cluster mode
        which is minimum 3 (1 main node + 2 secondary nodes)

        > **Important:** You can set a bigger `cluster_size` than you initially did, it will migrate the Redis Cluster, but
        keep in mind that you cannot downgrade a Redis Cluster so setting a smaller `cluster_size` will not have any effect.
        """
        return pulumi.get(self, "cluster_size")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The date and time of creation of the Redis Cluster.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Redis Cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[str]:
        """
        The type of Redis Cluster you want to create (e.g. `RED1-M`).

        > **Important:** Updates to `node_type` will migrate the Redis Cluster to the desired `node_type`. Keep in mind that
        you cannot downgrade a Redis Cluster.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Password for the first user of the Redis Cluster.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="privateNetworks")
    def private_networks(self) -> pulumi.Output[Optional[Sequence['outputs.RedisClusterPrivateNetwork']]]:
        """
        Describes the private network you want to connect to your cluster. If not set, a public
        network will be provided. More details on the Private Network section

        > **Important:** The way to use private networks differs whether you are using redis in standalone or cluster mode.

        - Standalone mode (`cluster_size` = 1) : you can attach as many private networks as you want (each must be a separate
        block). If you detach your only private network, your cluster won't be reachable until you define a new private or
        public network. You can modify your private_network and its specs, you can have both a private and public network side
        by side.

        - Cluster mode (`cluster_size` > 1) : you can define a single private network as you create your cluster, you won't be
        able to edit or detach it afterward, unless you create another cluster. Your `service_ips` must be listed as follows:

        ```python
        import pulumi
        ```
        """
        return pulumi.get(self, "private_networks")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        `project_id`) The ID of the project the Redis Cluster is
        associated with.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="publicNetwork")
    def public_network(self) -> pulumi.Output['outputs.RedisClusterPublicNetwork']:
        """
        (Optional) Public network details. Only one of `private_network` and `public_network` may be set.
        > The `public_network` block exports:
        """
        return pulumi.get(self, "public_network")

    @property
    @pulumi.getter
    def settings(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Map of settings for redis cluster. Available settings can be found by listing redis versions
        with scaleway API or CLI
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The tags associated with the Redis Cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsEnabled")
    def tls_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether TLS is enabled or not.

        > The changes on `tls_enabled` will force the resource creation.
        """
        return pulumi.get(self, "tls_enabled")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The date and time of the last update of the Redis Cluster.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        Identifier for the first user of the Redis Cluster.
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        Redis's Cluster version (e.g. `6.2.6`).

        > **Important:** Updates to `version` will migrate the Redis Cluster to the desired `version`. Keep in mind that you
        cannot downgrade a Redis Cluster.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def zone(self) -> pulumi.Output[str]:
        """
        `zone`) The zone in which the
        Redis Cluster should be created.
        """
        return pulumi.get(self, "zone")

