import spekpy as sp 
import larch 
from larch.xray import * 
# import torch study how an optional torch import will import torch
import skbeam
from skbeam.core.constants import XrfElement
from skbeam.core.fitting import gaussian
import scipy 
from scipy.interpolate import interp1d
import scipy 
import pandas as pd
import numpy as np 
import matplotlib.pyplot as plt 
import bokeh

reduced_list = [ "O", "F", 'Na', 'Mg', 'Al', 'Si',
       'P', 'S', "Cl",'Ar','K', 'Ca', 'Ti', "V", 'Cr','Mn', 'Fe',
       'Co', 'Ni', 'Cu', 'Zn',"Ge", 'As', 'Br',
       'Sr', 'Zr', 'Mo', 'Rh', 'Pd', 'Ag', 'Cd',
       'Sn','Sb',"Te","Cs", 'Ba',
        'Pt', 'Au', 'Hg',
       'Pb', 'Bi']
air_density = material_get("air")[1]
x_c = [0.1549716134352508, 0.2514732468521048, 0.34797488026895973, 0.44447651368581376, 0.5464611944558975, 0.6313387674839044, 0.6254170763424156, 0.659411969932445, 0.6735460475541046, 0.6942454472353194, 0.7114225905402289, 0.7198098453926427, 0.6945034729931185, 0.7367517957569563, 0.7412921437406848, 0.7440075576679979, 0.7562510216479588, 0.7252085381712083, 0.764394049922295, 0.7737517840718073, 0.7440075576679979, 0.7815011576643727, 0.7884985704770671, 0.7638091915379501, 0.7992906001881872, 0.8061139480055406, 0.7734593548796358, 0.8157076776434735, 0.8229634395545151, 0.7918823939864899, 0.8348694852358154, 0.8041644200577256, 0.7953915442925572, 0.8426301061050028, 0.8507991807041471, 0.8192036356551569, 0.8588658807111296, 0.8304830473532308, 0.8673291255669398, 0.8777216091656772, 0.8436423610009838, 0.8304830473532308, 0.8826042504286447, 0.8568016746487368, 0.8939819576534989, 0.8655745504139052, 0.904278414083767, 0.8743474261790745, 0.9122093110603275, 0.9076843540867143, 0.8831203019442428, 0.9201613329527314, 0.8918931777094112, 0.9308228139173469, 0.9021281994354409, 0.935757556535254, 0.9079767832788876, 0.9466192122445101, 0.9182118050049173, 0.9565354201896001, 0.9269846807700857, 0.9653660122426979, 0.9379507754765459, 0.969874295622021, 0.9457837002668752, 0.9810840813219581, 0.9543999175362377, 0.992550383857135, 0.963329451797212, 0.9997995496209846, 0.9942433949697111, 0.9664626217133439, 1.005940562656603, 0.9796219353610969, 0.9766976434393735, 1.0207447905103235, 0.9840083732436815, 1.021146880649562, 0.9946611509585281, 1.032259189952108, 1.005940562656603, 1.044979859811603, 1.0180032668337091, 1.0521135929995955, 1.0498049414824457, 1.0254358421347547, 1.005940562656603, 1.060771036188906, 1.0351834818738315, 1.0673506930127825, 1.0673506930127825, 1.0410320657172774, 1.0766718735132743, 1.0498049414824457, 1.0439563576389999, 1.087089663484412, 1.094701423339485, 1.0693002209605975, 1.0629642551301988, 1.0585778172476141, 1.107705921532558, 1.0790478606996743, 1.112564745033267, 1.0848964445431202, 1.1223273811411723, 1.0956188482561036, 1.089282882425704, 1.131341080946953, 1.102442196073457, 1.1388496304989078, 1.1503555944832238, 1.1199879476037937, 1.11560150972121, 1.1112150718386253, 1.1530152446020754, 1.1270062482159284, 1.1693353737828671, 1.1408235275460692, 1.1316851152906855, 1.176280567096959, 1.1463065748992998, 1.1834225877519362, 1.156332718630921, 1.1492308668210232, 1.1938263186272957, 1.1638523264296374, 1.1983955247549876, 1.1738784701612577, 1.2114765091548376, 1.1813980779599742, 1.2214243236385558, 1.1916330996860038, 1.2289178216879701, 1.2001970974567637, 1.1857845158425588, 1.2376906974531385, 1.2077167052554802, 1.2184391089684636, 1.2536698640254098, 1.251581084081323, 1.2238003108249558, 1.262442739790579, 1.2439048177868006, 1.2340353325509854, 1.2806700931974078, 1.251581084081323, 1.2981869865837812, 1.2691268356116598, 1.2662025436899365, 1.3083123473627465, 1.2778997113768282, 1.3117379464710508, 1.2854193191755448, 1.3314142535443567, 1.302756192711473, 1.3529565373677155, 1.3227388541765785, 1.3129912144375027, 1.3568555932633455, 1.3363855498112853, 1.3173776523200873, 1.3692838339306679, 1.351372545910115, 1.382199456584944, 1.404875544820058, 1.3744013447936831, 1.3656284690285139, 1.3890228044022965, 1.4196509145298153, 1.4204589425608178, 1.4069863119214512, 1.4387357670715861, 1.4195189915859778, 1.4580016903205832, 1.4370647431163155, 1.4299628913064177, 1.4709029782105372, 1.4577436645627841, 1.4916808418648833, 1.5090907903648008, 1.4767515620539822, 1.488448729740874, 1.5296137621774353, 1.501608043388627, 1.5451799930222982, 1.5284140526710868, 1.51476735703638, 1.573838053855182, 1.5460990561976962, 1.5644803197056687, 1.6216867804243718, 1.5937232389228972, 1.6134622093945268, 1.654548510894732, 1.6699797744201321, 1.6551333692790768, 1.6962984017156382, 1.706674014399443, 1.7397289570146315, 1.7033841859875043, 1.75351490464561, 1.7428621269307634, 1.720929937517842, 1.782632497066194, 1.7621624536141347, 1.8092069999048501, 1.7884810809096399, 1.8343506884818073, 1.81158298709125, 1.830590884582449, 1.8695205207903847, 1.8569095118779542, 1.8980323670271826, 1.8762098385613255, 1.9352805353801266, 1.908084620508105, 1.959259729138254, 1.940251831647056, 1.9950823051793591, 1.953411145294809, 2.0317821687969806, 1.9928890862380673, 2.0323670271813263, 2.0649519943090944, 2.065265311300708, 2.1019651749183295, 2.1025500333026743, 2.1474465151597135, 2.14860763106981, 2.1913108939855563, 2.2356913243269974, 2.1990516667195292, 2.277459243870723, 2.247302483427956, 2.2780075486060465, 2.337468151014411, 2.326258365314473, 2.391022830522041, 2.403752101240129, 2.4520798729991284, 2.4651622315963095, 2.521977046075496, 2.5280345079133504, 2.6007762694662064, 2.5850582003869462, 2.6855076278981267, 2.6464683307431267, 2.780150247164742, 2.7341970883948123, 2.874563100637509, 2.971064734054363, 3.067566367471218, 3.164068000888072, 3.260569634304926, 3.357071267721781, 3.453572901138635, 3.550074534555489, 3.646576167972344, 3.743077801389199, 3.839579434806052, 3.936081068222907, 4.032582701639762, 4.129084335056615, 4.22558596847347, 4.322087601890325, 4.418589235307178, 4.515090868724033, 4.611592502140888, 4.708094135557741, 4.804595768974596, 4.901097402391451, 4.997599035808304, 5.094100669225159, 5.190602302642014, 5.287103936058867, 5.383605569475722, 5.480107202892577, 5.57660883630943, 5.673110469726285, 5.76961210314314, 5.866113736559993, 5.962615369976848, 6.059117003393703, 6.155618636810556, 6.252120270227411, 6.348621903644266, 6.445123537061119, 6.541625170477974, 6.638126803894829, 6.734628437311682, 6.831130070728537, 6.927631704145392, 7.024133337562245, 7.1206349709791, 7.217136604395955, 7.313638237812808, 7.410139871229663, 7.506641504646518, 7.603143138063371, 7.699644771480226, 7.7961464048970806, 7.892648038313934, 7.989149671730789, 8.085651305147643, 8.182152938564496, 8.278654571981352, 8.375156205398206, 8.471657838815059, 8.568159472231915, 8.664661105648769, 8.761162739065622, 8.857664372482478, 8.954166005899332, 9.0485788593721, 9.140485176911959, 9.2309502362904, 9.317801706365568, 9.404814782046941, 9.486079315450606, 9.569299412492327, 9.637418212551285, 9.71865946543545, 9.76001730832839, 9.84077476291668, 9.901088283802217, 9.981140775159378, 10.041454296044911, 10.121543341051098, 10.17301087887342, 10.253136477528624, 10.30460401535095, 10.385398023588262, 10.426755866481201, 10.509664362723452, 10.539357173005563, 10.623711747670644, 10.65340455795275, 10.740177297091567, 10.756260902661044, 10.84545180627359, 10.861535411843068, 10.950726315455611, 10.966809921025089, 11.056000824637636, 11.072084430207113, 11.164930698721815, 11.164930698721815, 11.261432332138668, 11.261432332138668, 11.357933965555521, 11.357933965555521, 11.454435598972378, 11.454435598972378, 11.546550794506647, 11.55093723238923, 11.638665990040916, 11.726394747692602, 11.818071299438614, 11.779032002283614, 11.91062513876114, 11.90916299280028, 11.989581020647659, 11.996891750451965, 12.0734954844884, 12.135978384978909, 12.209341558565132, 12.191357163246536, 12.28785879666339, 12.290198230200769, 12.349707570807826, 12.425173373857334, 12.406292619493165, 12.50359178707049, 12.498407815027434, 12.584541504358182, 12.59344730248343, 12.669113355958007, 12.671672111389515, 12.749631075575447, 12.75106663706429, 12.828586957461962, 12.839087823908148, 12.907681540941606, 12.937051603285866, 12.987781710971404, 13.026242506898413, 13.073762250626409, 13.113971264550099, 13.160394398807448, 13.202431095182213, 13.240114584264415, 13.281386977068731, 13.312690192867173, 13.390189708025876, 13.37130895366171, 13.469006888319267, 13.454651273430809, 13.548101471798912, 13.529220717434743, 13.627057353685426, 13.608176599321261, 13.704887110732525, 13.691518919090363, 13.77765260842111, 13.777054457800755, 13.854861510718028, 13.856448983475534, 13.935252293609608, 13.944470170319391, 14.020501760284183, 14.023133623013734, 14.100792645004532, 14.101650861111992, 14.17960982529792, 14.19011069174411, 14.258704408777565, 14.279301595356657, 14.338804578807363, 14.354748326937106, 14.423688508991717, 14.43721335912969, 14.50420622860916, 14.52143296647531, 14.583162110495675, 14.600388848361824, 14.662117992382193, 14.687240318436995, 14.742356864005117, 14.774091788512166, 14.82703418660805, 14.853924957975199, 14.907897215400041, 14.948233372450762, 14.986853097286556, 15.027189254337276, 15.065670277579947, 15.105414063243362, 15.144764861059592, 15.233456273815943, 15.209226426464525, 15.319618446509566, 15.301341621998795, 15.407493418757333, 15.384683941767896, 15.48676831430804, 15.48264772114561, 15.565990040914713, 15.577687208601606, 15.652622189095752, 15.725572828643017, 15.753144723904978, 15.817325236081736, 15.87042422097618, 15.912811062831043, 15.951996574582129, 15.998785245329696, 16.043137006142494, 16.08651400298138, 16.125194409764173, 16.218107139458912, 16.20670240096419, 16.301010815439753, 16.3891782168797, 16.38951563517836, 16.48524120650829, 16.446201909353295, 16.577795045830822, 16.577795045830822, 16.67429667924768, 16.67429667924768, 16.77079831266453, 16.77079831266453, 16.8629135081988, 16.867299946081385, 16.957117483677163, 17.051530337149927, 17.051530337149927, 17.14803197056678, 17.14803197056678, 17.24014716610105, 17.244533603983633, 17.33435114157941, 17.425108630150024, 17.441192235719495, 17.530383139332045, 17.54646674490152, 17.63931301341622, 17.63931301341622, 17.732159281930922, 17.748242887500396, 17.835015626639212, 17.86470843692132, 17.949063011586404, 17.97875582186851, 18.06552856100733, 18.081612166576804, 18.17080307018935, 18.186886675758824, 18.276077579371375, 18.29216118494085, 18.378933924079664, 18.40862673436177, 18.49539947350059, 18.51148307907006, 18.60067398268261, 18.616757588252085, 18.7035303273909, 18.733223137673008, 18.819995876811827, 18.8360794823813, 18.922852221520117, 18.952545031802224, 19.03931777094104, 19.055401376510513, 19.144592280123064, 19.160675885692537, 19.249866789305088, 19.265950394874558, 19.35514129848711, 19.371224904056582, 19.457997643195398, 19.48769045347751, 19.57204502814259, 19.6017378384247, 19.688510577563516, 19.70459418313299, 19.793785086745537, 19.80986869231501, 19.89905959592756, 19.915143201497035, 20.000469862213023, 20.041827705105955, 20.12473620134821, 20.15442901163032, 20.237337507872574, 20.278695350765506, 20.360157768584934, 20.40151561147787, 20.484424107720123, 20.51411691800223, 20.598471492667315, 20.628164302949422, 20.712518877614507, 20.742211687896614, 20.8265662625617, 20.856259072843805, 20.94061364750889, 20.970306457790997, 21.05321495403325, 21.094572796926187, 21.17603521474561, 21.217393057638546, 21.29885547545797, 21.340213318350905, 21.421675736170332, 21.463033579063264, 21.54382758730058, 21.595295125122906, 21.67542072377811, 21.726888261600433, 21.80768226983775, 21.849040112730684, 21.930502530550108, 21.971860373443043, 22.054768869685297, 22.084461679967404, 22.16670176662755, 22.218169304449873, 22.298258349456056, 22.358571870341592, 22.439329324929886, 22.480687167822822, 22.562149585642246, 22.60350742853518, 22.684748681419347, 22.752867481478305, 22.833887569427212, 22.90200636948617, 22.982542659139206, 23.04285618002474, 23.122908671381904, 23.183222192267436, 23.26467590683709, 23.33973273282798, 23.421186447397634, 23.48149996828317, 23.562953682852825, 23.638010508843713, 23.719464223413368, 23.7797777442989, 23.861231458868556, 23.936288284859444, 24.01914322264159, 24.094200048632477, 24.179930540137654, 24.266782010212818, 24.352512501717996, 24.427569327708884, 24.50902304227854, 24.56933656316407, 24.650790277733726, 24.725847103724615, 24.809984625682958, 24.891249159086623, 24.975386681044967, 25.05044350703585, 25.138033012691263, 25.22993933023113, 25.318811420062733, 25.4000759534664, 25.485496059600937, 25.566760593004602, 25.65218069913914, 25.733445232542806, 25.818865338677345, 25.90012987208101, 25.989001961912617, 26.08090827945248, 26.169780369284087, 26.251044902687752, 26.33646500882229, 26.417729542225956, 26.508690412001652, 26.605192045418505, 26.6961529151942, 26.777417448597866, 26.86155497055621, 26.936611796547098, 27.022342288052272, 27.10919375812744, 27.197799803355643, 27.28465127343081, 27.37720511275334, 27.473706746170194, 27.566260585492724, 27.65311205556789, 27.74566589489042, 27.840078748363187, 27.931985065903046, 28.026397919375814, 28.118951758698348, 28.205803228773508, 28.298357068096042, 28.39485870151289, 28.48927155498566, 28.581177872525526, 28.675590725998287, 28.772092359415144, 28.866505212887912, 28.95841153042777, 29.05073560395645, 29.14264192149631, 29.237054774969078, 29.333556408385935, 29.430058041802784, 29.52655967521964, 29.623061308636498, 29.719562942053347, 29.816064575470204, 29.91256620888706, 29.982749215008408]
y_c = [0.00019827115267201378, 0.00034641215977382345, 0.00034641215977382345, 0.00034641215977382345, 0.0010253917756568587, 0.006986832803110632, 4.087133262631326e-05, 0.015521606574761426, 0.0245784402288467, 0.03368830529737532, 0.04120158561834075, 0.04862708576918551, 0.007068310357016605, 0.059710672049512414, 0.052582577275048115, 0.06870995977040528, 0.07532665343375844, 0.01514816778602568, 0.08292843957425089, 0.09125725619575031, 0.0248672760019526, 0.09798368092376575, 0.1049868706761602, 0.03402380110757641, 0.11372091957634556, 0.12346804917324539, 0.0410851891127606, 0.13364083148840644, 0.14231135013213492, 0.04776634853305062, 0.1510195331421914, 0.06114903676210681, 0.05357841404500996, 0.15914407555446797, 0.16803293582134904, 0.07243464794896393, 0.1778236957561392, 0.0828327357807741, 0.18785342288205498, 0.19699980060001265, 0.09318555830485853, 0.08807057853187228, 0.2050787363372356, 0.1037210586779781, 0.21577047809815575, 0.11502606928243198, 0.22648656422625613, 0.1253239267899925, 0.23878975895022103, 0.23147107340638629, 0.13282891481088732, 0.24867189034209192, 0.141404427359491, 0.2576796865794745, 0.1508988256549233, 0.2656916460468953, 0.15936343819959942, 0.2753913548452256, 0.16893705078355137, 0.2864755694467701, 0.17975222609368946, 0.29615142603720734, 0.18978172499116297, 0.3054044093581033, 0.1988800518439967, 0.31527224644227125, 0.20855551137033113, 0.32555620670623187, 0.21824067060546382, 0.33757114410274536, 0.33069262794077225, 0.22576764463296806, 0.34693640694170924, 0.23907564510427715, 0.2310184203291309, 0.3551472104394957, 0.24749499234122785, 0.36346471073406394, 0.2559057176148022, 0.37348644986449875, 0.2667440644515141, 0.38473035230352315, 0.2773361464592907, 0.39615865131191363, 0.38872275244491583, 0.28950119791052986, 0.2825303405207965, 0.4055614469188171, 0.29900691253289347, 0.41645227995758227, 0.4107216919995288, 0.3059958760457171, 0.42660981501119366, 0.31888969895133734, 0.3111380150033385, 0.4362241663720986, 0.44660376770008114, 0.3388705602031866, 0.3304663014021445, 0.32517026039825625, 0.45533517929382206, 0.3482555673382821, 0.462867326499352, 0.3558601390361731, 0.47050811044342333, 0.36768947278844777, 0.36074879227053147, 0.47938650115401427, 0.3780142739315592, 0.48983639684222946, 0.4984918200687025, 0.39765133439377875, 0.38906224225285735, 0.38383409921055733, 0.507184725427817, 0.406810769412042, 0.5160653794037942, 0.4196163249675976, 0.41253230430855037, 0.523432308236126, 0.42788629668905387, 0.5304310211998442, 0.4398984160649061, 0.43335434586229926, 0.5371476964769648, 0.4476581831035702, 0.5445146253092966, 0.4556507431533944, 0.5528806241478564, 0.464116648992577, 0.5610817279368446, 0.4718298574290092, 0.5685165547307648, 0.48300392196468567, 0.4764469188170143, 0.574808432504615, 0.49073264993519505, 0.5001659400651979, 0.5850836573583128, 0.5774790856604219, 0.5097621853030125, 0.5965052954137942, 0.5215311653116532, 0.5155561446918818, 0.6077258407595518, 0.5308428857580502, 0.6169278013432309, 0.5441751355013551, 0.5371024311692393, 0.6249533404029693, 0.5533617297042537, 0.6329614199868707, 0.561532764395967, 0.6421179450924945, 0.5710061466556695, 0.6522875508948327, 0.585385426076483, 0.5780222693531284, 0.6602405282946111, 0.5992567281550434, 0.5926882290562037, 0.6662896194179334, 0.6091534847413693, 0.6744977285521648, 0.6844005072773841, 0.6244305260987393, 0.6167693727661916, 0.6356299176518336, 0.6960846743936548, 0.6893749263579594, 0.6459978286118266, 0.7039956207533091, 0.6543783770135838, 0.7115496018131537, 0.6667940042754466, 0.6600430069518087, 0.7201327029574645, 0.6769835483680925, 0.7295133423874286, 0.738868546358098, 0.6853010486626606, 0.6945351714386709, 0.7456571135945473, 0.7020039472133852, 0.7528549939122581, 0.713365539452496, 0.7063494167550373, 0.7594094104709164, 0.7238282920096283, 0.7327843564667531, 0.7651830004713092, 0.743116162955108, 0.7520447449039709, 0.7716491496799027, 0.7786659687667112, 0.7612381289030282, 0.785476656606031, 0.7928929130172946, 0.7997964113181506, 0.7677291740308709, 0.8072457876752681, 0.7783212560386474, 0.7715314598798163, 0.81408990220337, 0.787147991045128, 0.821402512666431, 0.7949155178508307, 0.8286627447019813, 0.8015876242095756, 0.8090790326381525, 0.8356610845999766, 0.815733032873807, 0.843163809355485, 0.8220747024861554, 0.8497770708141865, 0.8283394210753703, 0.856928989434822, 0.8354913396960058, 0.8637029427359493, 0.8405610541612664, 0.8698205490750561, 0.848391952397785, 0.8567143025467523, 0.8767539009241025, 0.8641442794862733, 0.8826396842229294, 0.8716130552609875, 0.8881322299156497, 0.8787423412277602, 0.8940465417697656, 0.899922511245573, 0.8860979537331607, 0.9063258881230118, 0.8922540355838342, 0.8990438317426654, 0.9124423628294256, 0.90529044420879, 0.9183747808066317, 0.9133476689839364, 0.9240445759148668, 0.9192321589882567, 0.9297983751059044, 0.9246413632614588, 0.9354031901732063, 0.9290999960724247, 0.9423491516436905, 0.9365235065394133, 0.9476975710750898, 0.9422269353128315, 0.9525474254742549, 0.9569175851837571, 0.9606334554452265, 0.964102424028193, 0.9670405540023781, 0.969793507717686, 0.972213144167015, 0.9744352592735415, 0.9761882611909125, 0.9778425024368822, 0.9795337789346275, 0.9808917381663936, 0.9822990777338605, 0.9833360647835729, 0.9843607067493602, 0.985360658547297, 0.9861137086667311, 0.9870766252128926, 0.9878790556680271, 0.9885086549482097, 0.989199979648018, 0.9897431633407244, 0.9901875863620297, 0.9907307700547363, 0.9909776717332393, 0.9914344398384697, 0.9918541726919247, 0.9924590818042569, 0.9928047441541611, 0.9931504065040652, 0.993557794273595, 0.9935948295253705, 0.9937306254485471, 0.9942120837216278, 0.9944960206519062, 0.994644161659008, 0.994644161659008, 0.9946688518268583, 0.9946688518268583, 0.9948169928339601, 0.9947923026661099, 0.9949157535053613, 0.9949157535053613, 0.9949157535053613, 0.9949527887571368, 0.9949157535053613, 0.9949157535053613, 0.9949157535053613, 0.9949157535053613, 0.9949157535053613, 0.9949157535053613, 0.9949527887571368, 0.9949157535053613, 0.9949157535053613, 0.9947799575821846, 0.9947552674143344, 0.9944836755679811, 0.9936935901967716, 0.9935084139378945, 0.99229859571323, 0.9914344398384697, 0.9905332487119339, 0.9894962616622215, 0.9884469295285839, 0.9872465170821482, 0.9854359047731265, 0.9842421939436787, 0.9823546306115236, 0.9812218067260765, 0.9786774199549777, 0.9776616832664492, 0.9746741729565634, 0.9745075661936745, 0.9707246797623257, 0.9705743342759516, 0.9669927168021681, 0.9663646606574763, 0.9626811962413104, 0.9618901849888065, 0.9577076705549665, 0.9570558501237187, 0.952800911197518, 0.952081839451935, 0.947619973404703, 0.9472200469496335, 0.9423731770762525, 0.9422478269933203, 0.9374009571199392, 0.9371798535014337, 0.9320422410745848, 0.932019608420722, 0.9268140980322848, 0.926791465378422, 0.9214048937590826, 0.9213143631436316, 0.9158598935627039, 0.9158331458808661, 0.9103272384502502, 0.9105988302966035, 0.9049447818588859, 0.9050188523624367, 0.899340113756869, 0.899340113756869, 0.893735445654852, 0.8940465417697656, 0.8884517497348887, 0.8853012843171911, 0.8796929126899966, 0.8733512430776482, 0.8794892188052317, 0.8708970403933289, 0.8647779937944309, 0.8596358548368094, 0.8652759121794118, 0.8557072197376039, 0.8504628402262284, 0.8446983032873808, 0.8518954872157418, 0.8452082924210886, 0.8389315030831469, 0.8350703723341583, 0.8293746189824849, 0.8369850948509486, 0.8241708977366455, 0.8299237068457642, 0.8176526934241676, 0.8233602372255608, 0.8119646960056559, 0.8178378696830448, 0.8058631382756516, 0.8120258041710853, 0.8000609488308323, 0.8056162365971486, 0.7945282042612489, 0.7983375751148818, 0.788057233313354, 0.7916745218176822, 0.7816369398295433, 0.785065786889753, 0.7756958681905661, 0.7785928478850007, 0.7698154932142208, 0.7727536231884059, 0.7640133037694015, 0.7579577717327268, 0.7655564392600449, 0.7518163608513557, 0.7591197125014729, 0.7462320889749541, 0.7536063980205021, 0.7403043017197659, 0.7477671733239073, 0.7340582515556006, 0.7414119241192413, 0.7284347718971262, 0.7347307646989514, 0.7225349975031843, 0.7287014257099094, 0.7161798607589102, 0.7219659479203488, 0.7100035615968808, 0.7159909273005775, 0.7042062028370757, 0.7101517026039827, 0.6979794498537872, 0.7034977023683282, 0.6922207365740956, 0.696707906209497, 0.6855844488501597, 0.6907872039589962, 0.6796089362161739, 0.6848121833392249, 0.6735361836819951, 0.6786198892423708, 0.6674994376425979, 0.6726448686225994, 0.6615984875263774, 0.6659274969561291, 0.655461370587241, 0.659391186520561, 0.6492619914856994, 0.6536153332547818, 0.6436412211003019, 0.6468708024036762, 0.6380086423737584, 0.6410315777070815, 0.6319209057703226, 0.6353281489336633, 0.6262593429336941, 0.6204940609447502, 0.6275606221279606, 0.6135329032638153, 0.6212053729232945, 0.608155384706021, 0.6150673971957112, 0.6016013796501603, 0.6082594949137898, 0.5964517160699558, 0.6012705314009663, 0.5916244943246535, 0.5852388526990862, 0.5891032166843408, 0.5811956056631505, 0.5749775818124315, 0.5783481795687523, 0.5700685081384976, 0.5721558854718983, 0.5644728539072831, 0.5665067750677507, 0.5585664170870959, 0.5573812890302817, 0.5519222929185814, 0.5487718275008838, 0.5463546600683399, 0.5403336777514933, 0.5367674678920703, 0.5427153293272065, 0.5340737705796031, 0.5282222007990831, 0.5280493696241311, 0.5221484195079106, 0.5220743490043597, 0.5160993283845883, 0.5160993283845883, 0.5104946602825713, 0.50716266334506, 0.5042974281521472, 0.4985446190430285, 0.49871745021798053, 0.4928658804374606, 0.4930683398138329, 0.48758218451749746, 0.484310149416194, 0.4815166332822749, 0.4759716330858962, 0.4754963473547781, 0.4699966124661248, 0.46992871450453644, 0.464200595563268, 0.46399895919249046, 0.4584086936883863, 0.4577906481405952, 0.45240059457450776, 0.45150225231349317, 0.44619576546936046, 0.44571177487137204, 0.4401215093672677, 0.4396914889438751, 0.4344407132477123, 0.4343728152861238, 0.4290767742822357, 0.428646753858843, 0.4233193753342216, 0.42289805977769934, 0.4176020187738111, 0.41742095754290887, 0.41232861042378544, 0.412079651231295, 0.40698208119204937, 0.4066025489965046, 0.4014196712619301, 0.40134132746009743, 0.3963691075037842, 0.3961915282196301, 0.39105391579278126, 0.39105391579278126, 0.38600683398138336, 0.3862105278661484, 0.38125397667020167, 0.38152556851655484, 0.3764105887435686, 0.3763966609565762, 0.3714453326807515, 0.3710483907514661, 0.3661806291975964, 0.36638432308236135, 0.3614277718864146, 0.36163146577117944, 0.35669754722909564, 0.3572407309218021, 0.3523520776874435, 0.35238764328637084, 0.34784817956875236, 0.34754525020166593, 0.3428028387307286, 0.34257153798246054, 0.338090272517632, 0.3375276894073289, 0.3330464239425004, 0.33294196554005684, 0.3284084708740065, 0.3286173876788936, 0.32406300133235455, 0.3241047846933319, 0.3195921817077704, 0.31975931515168, 0.3153511705685619, 0.31564365409540396, 0.3112772928732632, 0.31120267972866067, 0.30697360669258866, 0.3068184113518154, 0.3026863354037268, 0.30253114006295356, 0.2984960612028481, 0.2983214664444782, 0.29424758874917956, 0.2939009858214525, 0.28977278975688303, 0.28926581831035714, 0.2854997447075921, 0.285246258984329, 0.28121118012422375, 0.28132757662980357, 0.2772924977696982, 0.27762079560594943, 0.27342156782771854, 0.2736040218373198, 0.2698741604807353, 0.26930721250147294, 0.26577651849888073, 0.26563344779410525, 0.26167596660438663, 0.2619087596155465, 0.258106473766601, 0.2578154825026512, 0.2545723563373742, 0.25370965282542857, 0.25040262269630365, 0.24968470160245082, 0.24635770148462355, 0.24578056881112298, 0.24243659420289865, 0.24165576764463303, 0.23869843420656434, 0.2377855838340992, 0.2346453031106398, 0.23388522315174842, 0.2308826244059543, 0.23014706315541422, 0.2269728334511606, 0.22635609363340015, 0.22348929081078261, 0.22250854247672913, 0.21967191652592866, 0.2184889831507011, 0.21612613408742787, 0.21484361703520427, 0.21232384823848238, 0.21169579209379052, 0.2086573583127136, 0.20824997054318373, 0.20563967113101078, 0.20455489200200938, 0.20196762230780207, 0.20117349410209084, 0.19854810625400943, 0.19731516549119954, 0.19550455318217774, 0.19414863599436916, 0.19176148660800107, 0.1909181224535358, 0.18855956168257337, 0.1875446658356743, 0.18548628552647084, 0.18439991814105794, 0.18221288906252908, 0.18108431943532688, 0.17906678000527432, 0.17788171382857998, 0.17580903921167368, 0.17500855798031667, 0.17285011751719348, 0.1717332122925973, 0.17023945713765443, 0.1690907145913565, 0.16691797982053047, 0.16634938402524124, 0.16417664925441522, 0.16357311181807477, 0.161712707670555, 0.16083003416990693, 0.15895605043006955, 0.1577709223732554, 0.15642530822541423, 0.15542535642747735, 0.15357853187227521, 0.1522279796908641, 0.1510798868858254, 0.1495020675879637, 0.14836396842229294, 0.1472640214445623, 0.14563447036644273, 0.14462340799297324, 0.14352469552363512, 0.1423372160222638, 0.14086286028491757, 0.1396977195068393, 0.1385496267018007, 0.13743562984284086, 0.1361940671166546, 0.13527582801707938, 0.13386613700505545, 0.13284619792838248, 0.13169810512334368, 0.13057470248615533, 0.12950068018466743, 0.12826617179215272, 0.12721683965851516, 0.1262292329445034, 0.1252910065661922, 0.12449104512784259]

### VERSION ANTIGUA 

def Primary_gen(k, theta, d, phys, mu_source, z, mas, target, filters):
    """__This function creates the primary spectrum that will create the Xrays based on the spekpy 
    package. It creates returns two tuples of arrays: the primary spectrum (with characteristic and bremstrahlung lines) and a
    spectrum only of the bremsstrahlung component__

    Args:
        k (float): Tube potential in keV 
        theta (float): Anode angle in degrees
        d (float): Spectrum bin width in keV 
        phys (string): Physics Model
        mu_source (string): Source of photon coefficients
        z (float): Point-of-interest is at a focus-to-detector-distance
        mas (float): Exposure setting in mili-Ampers
        target (string): Anode target material
        filters (list): List of  tuple(element_name, thickness) for Element Filtration in [mm]

    Returns:
        _type_: _description_
    """
    s=sp.Spek(kvp = k  , dk = d , th = theta, targ = target,  physics=phys, brem=True, char=True , mu_data_source=mu_source, z = z ,mas = mas ) # Create the spectrum model
    s.multi_filter(filters)
    Prim_s = s.get_spectrum(edges=True)
    bs=sp.Spek(kvp = k  , dk = d , th = theta, targ = target,  physics=phys, brem=True, char=False , mu_data_source=mu_source, z = z ,mas = mas ) # Create the spectrum model
    bs.multi_filter(filters)
    bPrim_s = bs.get_spectrum(edges=True)

    return Prim_s, bPrim_s

def sum_prima(element, prim_spectra_X, prim_spectra_y, x = np.arange(0, 30, 0.01), gauss_a = 0.05):
    """_This function generates the X-ray spectra given an element and the primary spectrum__

    Args:
        element (int, string): Element that will generate the Xrays (can be either the atomic number or symbol)
        prim_spectra_X (np.array): X component of Primary spectrum 
        prim_spectra_y (np.array): Y component of Primary spectrum 
        x (_type_, optional): Range of the spectra binning, the generated spectra will correspond to the Y component of this variable. Defaults to np.arange(0, 30, 0.01).
        gauss_a (float, optional): Width of the gaussian generated by each xray line. Defaults to 0.05.

    Returns:
        np.array: the xray spectra of an element as the sum of all peaks of an element within the given x range. 
    """
    spec_tot = np.zeros(len(x))
    e = XrfElement(element)
    lines = e.emission_line.all
    std = gauss_a
    area = std * np.sqrt(2 * np.pi)
    error = np.random.random(1)/100
    f = np.random.randint(3)
    for en,counts in zip(prim_spectra_X,prim_spectra_y): 
        ratio = [val for val in e.cs(en).all if val[1] > 0] #csb, cross section in barns 
        spec= np.zeros(len(x))
        for item in ratio:
            for data in lines:
                if item[0] == data[0]:
                    e_peak = data[1] + ((-1)**f)*error # que error meto [ +- 0.05] de desplazamiento de los picos ? 
                    spec += gaussian(x, area, e_peak, std) * item[1]
        spec_tot += spec*counts 
    return spec_tot

reduced_lines_list = []
energies = []
for i in reduced_list: 
    e = XrfElement(i)
    lines = e.emission_line.all
    for line in lines: 
        name = line[0]
        energy = line[1]
        if (energy!=0) and (energy < 40): 
            reduced_lines_list.append(i + "_"+ name)
            energies.append(energy)
tuple_list = sorted(zip(energies, reduced_lines_list))
unziped_l = list(zip(*tuple_list))
energies = unziped_l[0]
reduced_lines_l = unziped_l[1]
peaks_dic  = dict(zip(reduced_lines_l, energies)) 

#incluir algo para introducir uno su propia reduced_list, o los elementos que quieran o todos

def multi_trans_gen(a, Prim_s, bPrim_s):
    """
    Interesa solo la absorción por lo que no uso el componente fotoelectrico.
    Se devuelve solo aquello transmitido no lo que excita

    la lista de las proporciones de los elementos tiene que ser con todos los elementos, es decir, la mayoria 0 excepto algunos, 
    hacer en manera random el orden de los estratos. Porque de momento están ordenados por Z. 

    """
  
    mask = [b not in a for b in np.arange(0,41,1)]
    c = np.random.random(len(reduced_list)) #/np.sum(c) para normalizar
    c = c/np.sum(c)
    c[mask]=0
    n = c[c> 0] 
    el_list = []
    peaks_pos = np.zeros(len(peaks_dic))
    for el in a:
        el_list.append(reduced_list[el]) 
        mask_lines =  [a[:len(reduced_list[el])]==reduced_list[el] for a in peaks_dic.keys()  ] #ponemos las lineas que tiene que haber.
        peaks_pos[np.where(mask_lines)[0]]=1

  # y = materials
  # y = y/np.min(y[~np.array(mask)])
  # y = y/np.sum(y)
    posi = list(zip(*sorted(zip(a, np.arange(len(a))))))[1]
    n  = list(zip(*sorted(zip( n , posi))))[0]
    final_spectra = np.zeros(600)
    for i in range(len(el_list)-1, -1, -1): 
        gaus = np.random.uniform(low = 0.03 , high = 0.2  )
        w = n[i]
        pos = a[i]
        prod_s = sum_prima(element = el_list[i], prim_spectra_X = Prim_s[0], prim_spectra_y = Prim_s[1], x = np.arange(0, 30, 0.05), gauss_a = gaus )
        q = np.zeros(600)
        factor = 0 
        for j in range(i):
            q = q + np.array(material_mu(el_list[j], np.arange(0,30,0.05)*1000, XrfElement( el_list[j]).density,  kind = "photo")* XrfElement( el_list[j]).density*0.5*n[i]*10**(-4)) 
            factor = factor + XrfElement( el_list[j]).density*n[i]*10**(-4)
        if i!=0:
            # plt.plot(  np.arange(0,30,0.05)   , prod_s*factor*(1 - np.exp(-q))/q )
            # plt.show()
            final_spectra = final_spectra + Narea(prod_s*factor*(1 - np.exp(-q))/q)*w
        else: 
            final_spectra = final_spectra + Narea(prod_s)*w

    air_z = np.random.random(1)
    factor = np.random.random_integers(5)
    q_air = np.array(material_mu("air",  np.arange(0,30,0.05)*1000 )*air_density*air_z*1000*factor)

    air_spectra = Narea(final_spectra* np.exp(-q_air))

    return air_spectra, peaks_pos, c  # c es reduced list con elementos 0s y 1s. 

def ind_trans_gen(N, Prim_s, bPrim_s):
    """
    Interesa solo la absorción por lo que no uso el componente fotoelectrico.
    Se devuelve solo aquello transmitido no lo que excita

    la lista de las proporciones de los elementos tiene que ser con todos los elementos, es decir, la mayoria 0 excepto algunos, 
    hacer en manera random el orden de los estratos. Porque de momento están ordenados por Z. 

    """
    c = np.zeros(len(reduced_list))
    c[N]=1  
    el_list = []
    el_list.append(reduced_list[N]) 

    peaks_pos = np.zeros(len(peaks_dic))
    mask_lines =  [a[:len(reduced_list[N])]==reduced_list[N] for a in peaks_dic.keys()  ] #ponemos las lineas que tiene que haber.
    peaks_pos[np.where(mask_lines)[0]]=1
  
    final_spectra = np.zeros(600)
    gaus = np.random.uniform(low = 0.03 , high = 0.2  ) #0.05
    prod_s =  sum_prima(element = reduced_list[N], prim_spectra_X = Prim_s[0], prim_spectra_y = Prim_s[1], x = np.arange(0, 30, 0.05), gauss_a = gaus )

    air_z = np.random.random(1)
    factor = np.random.random_integers(5)
    q_air = np.array(material_mu("air",  np.arange(0,30,0.05)*1000 )*air_density*air_z*1000*factor)

    air_spectra =  Narea(prod_s*np.exp(-q_air))

    return air_spectra, peaks_pos, c  #la verdad que para lo que hace se podria omitir el ultimo calculo.

def pair_trans_gen(a, Prim_s, bPrim_s ):
    """
    Interesa solo la absorción por lo que no uso el componente fotoelectrico.
    Se devuelve solo aquello transmitido no lo que excita

    la lista de las proporciones de los elementos tiene que ser con todos los elementos, es decir, la mayoria 0 excepto algunos, 
    hacer en manera random el orden de los estratos. Porque de momento están ordenados por Z. 
    """
    mask = [b not in a for b in np.arange(0,41,1)]
    c = np.random.random(len(reduced_list)) #/np.sum(c) para normalizar
    c = c/np.sum(c)
    c[mask]=0
    n = c[c> 0] 
    el_list = []
    peaks_pos = np.zeros(len(peaks_dic))
    for el in a:
        el_list.append(reduced_list[el]) 
        mask_lines =  [a[:len(reduced_list[el])]==reduced_list[el] for a in peaks_dic.keys()  ] #ponemos las lineas que tiene que haber.
        peaks_pos[np.where(mask_lines)[0]]=1

    posi = list(zip(*sorted(zip(a, np.arange(len(a))))))[1]
    n  = list(zip(*sorted(zip( n , posi))))[0]
    final_spectra = np.zeros(600)
    for i in range(len(el_list)-1, -1, -1): 
        gaus = np.random.uniform(low = 0.03 , high = 0.2  )
        w = n[i]
        pos = a[i]
        prod_s = sum_prima(element = el_list[i], prim_spectra_X = Prim_s[0], prim_spectra_y = Prim_s[1], x = np.arange(0, 30, 0.05), gauss_a = gaus )        
        q = np.zeros(600)
        factor = 0 
        for j in range(i):
            q = q + np.array(material_mu(el_list[j], np.arange(0,30,0.05)*1000, XrfElement( el_list[j]).density,  kind = "photo")* XrfElement( el_list[j]).density*0.5*n[i]*10**(-4)) 
            factor = factor + XrfElement( el_list[j]).density*n[i]*10**(-4)

        if i!=0:
            # plt.plot(  np.arange(0,30,0.05)   , prod_s*factor*(1 - np.exp(-q))/q )
            # plt.show()
            final_spectra = final_spectra + Narea(prod_s*factor*(1 - np.exp(-q))/q)*w
        else: 
            final_spectra = final_spectra + Narea(prod_s)*w

    air_z = np.random.random(1)
    factor = np.random.random_integers(5)
    q_air = np.array(material_mu("air",  np.arange(0,30,0.05)*1000 )*air_density*air_z*1000*factor)

    air_spectra = Narea(final_spectra*np.exp(-q_air))
  
    return air_spectra, peaks_pos, c  

def Narea(array):
    a = array/np.max(array) 
    return a/np.sum(a)

def escape_peaks(spectra, peaks_pos,c): # he quitado c porque no lo he usado, podria usarlo para seleccionar solo algun pico de algun elemento.
    """
    En este caso hay que coger la linea de un pico (deberia ser uno de los más grandes) y restarle la Ka1 del silicio 1.73998 KeV (que depende del detector pero casi todos son de silicio). 
    para crear un nuevo pico con esa energia. 
    Faltaria meter la probabilidad de que se dieran escape peaks en funcion de la intensidad y la energia de los picos. 
    """
    #LA PROBABILIDAD DE QUE SE DE ESTO SERIA LA CROSS SECTION DE LA KA1 DEL SILICO POR EL PICO DE ENERGIA NO ????? 
    x = np.arange(0,30,0.05)
    area = 0.05 * np.sqrt(2 * np.pi)
    els = list(np.array(reduced_list)[c.astype(bool)])
    import scipy 
    peaks = scipy.signal.find_peaks(spectra, prominence = np.max(spectra)/15)
    prominences = sorted((zip(peaks[1]["prominences"], peaks[0])))
    proms = list(zip(*prominences))[0]
    peaks_i = list(zip(*prominences))[1]
    N = round(0.6*len(proms)/2)
    f_spectra = spectra.copy()
    a = np.random.choice(range(round(len(proms)/2)), N , replace = False) 
   
    escape = np.around(np.array(proms),6)[np.argsort(-np.array(proms))[sorted(a)]]
    dictionary = dict( zip(np.around(peaks[1]["prominences"], 6), peaks[0]))
    for i in escape: 
        pos = dictionary[i]
        y_alt = spectra[pos]
        if x[pos] > 1.75:
            perc = np.random.randint(15)/100
            f_spectra -= gaussian(np.arange(0, 30, 0.05), area, x[pos], 0.05) * y_alt *perc
            f_spectra += gaussian(np.arange(0, 30, 0.05), np.sqrt(2 * np.pi)*0.1, x[pos]-1.73998, 0.1) * y_alt *perc

  
    return f_spectra, peaks_pos,c

def sum_peaks(spectra, peaks_pos,c):
    """
    Simplemente hay que sumar dos picos, es decir coger dos lineas de dos elementos y sumarlas para crear otro pico. 
    """
    x = np.arange(0,30,0.05)
    area = 0.05 * np.sqrt(2 * np.pi)
    els = list(np.array(reduced_list)[c.astype(bool)])
    import scipy 
    peaks = scipy.signal.find_peaks(spectra, prominence = np.max(spectra)/15)
    prominences = sorted((zip(peaks[1]["prominences"], peaks[0])))
    proms = list(zip(*prominences))[0]
    peaks_i = list(zip(*prominences))[1]
    N = round(0.6*len(proms)/2) 
    f_spectra = spectra.copy()

    a = np.random.choice(range(round(len(proms)/2)), N , replace = False) # a son los picos que van a tener scape peaks.  # deberia de haber un minimo de dos picos para funcionar

    escape = np.around(np.array(proms),6)[np.argsort(-np.array(proms))[sorted(a)]]
    dictionary = dict( zip(np.around(peaks[1]["prominences"], 6), peaks[0]))
    # print(a, escape)
    if len(escape)>1: 
        # print("mas de dos picos")
        for i in range(len(escape)-1):
            # print("escape peak created") 
            pos1 = dictionary[escape[i]]
            pos2 = dictionary[escape[i+1]]
            y_alt = spectra[pos1]
            perc = np.random.randint(15)/100
            f_spectra -= gaussian(np.arange(0, 30, 0.05), area, x[pos1], 0.05) * y_alt *perc/2
            f_spectra -= gaussian(np.arange(0, 30, 0.05), area, x[pos2], 0.05) * y_alt *perc/2
            f_spectra += gaussian(np.arange(0, 30, 0.05), area, x[pos1] + x[pos2], 0.1) * y_alt *perc

    return f_spectra, peaks_pos,c

def decalibration(spectra, params = []):
    """
    El objetivo es descalibrar el espectro con transformaciones no solo lineales sino tambien no lineales ligeramente.  
    """
    from scipy.interpolate import interp1d
    x = np.arange(0,30,0.05)
    if params ==[]:
        a = np.random.uniform(low=-0.03, high=0.03)
        b = np.random.uniform(low=-0.03, high=0.03)
        c = np.random.uniform(low=-0.05, high=0.05)*10**(-3)
        params = [a,b,c]
    a = params[0]
    b = params[1]
    c = params[2]
    x_tr = a + (1+b)*x + c *x**2 
    decal = interp1d(x_tr, spectra, bounds_error= False, fill_value = 0 )
    return decal(x), [a,b,c]


copia_inter = interp1d(x_c, y_c, bounds_error = False, fill_value = 0 )
eff_inter = copia_inter(np.arange(0,30,0.05)) #modificar esto para que no sea un estandard

def detector_eff(spectra_y, spectra_x, alpha = "", beta = ""):
    """
    Crear ventana de eficiencia de la red Neuronal. 
    """
    try:
        np.testing.assert_array_equal(np.shape(spectra_x), np.shape(spectra_y))
        if alpha =="": 
            alpha = np.random.uniform(low = 0.01 , high = 40 )# de vez en cuando podria dar un uno y un 0, que es como no tener eficiencia. 
        if beta =="": 
            beta = np.random.uniform(low = 0.01 , high = 40)
        n = np.random.randint(50)
        new_eff = np.zeros(len(spectra_y))
        eff_inter = copia_inter(spectra_x)
        if n!=0: 
            print(np.shape(new_eff), np.shape(eff_inter))
            new_eff[n:] = eff_inter[:-n]
        else: 
            new_eff = eff_inter
        #y_c tendria que ser de la misma dimension que espectra es decir de 0 a 30, 600 bins.
        eff = sigmoid(new_eff, alpha,beta)
        return eff * spectra_y
    
    except AssertionError:
        raise ValueError("Arrays do not have the same dimensions.")
    

def sigmoid(x, a, b):
    """_summary_

    Args:
        x (_type_): _description_
        a (_type_): _description_
        b (_type_): _description_

    Returns:
        _type_: _description_
    """
    if type(x) != np.ndarray: 
        x = np.array(x)
    return 1/(1 + b*np.exp(-x*a)) 

def select_values(array, dictionary):
    mask = [value == 1 for value in array]
    selected_keys = [key for i, key in enumerate(dictionary.keys()) if mask[i]]
    selected_values = [value for i, value in enumerate(dictionary.values()) if mask[i]]
    
    return selected_values, selected_keys

def spectra_gen(a, Prim, brems, s_counts = 30000,n_counts = 2000, b_counts = 3000, c_counts = 3000,plot = True,  escape = True, sum = True, decal = True, char_r = 15, brem_r = 5,noise_f = 1000, prop = "" ):
    #convertir a en numeros en caso de que sean los nombres de los elementos: 

    spec, peaks, els = multi_trans_gen( a, Prim,brems)
    if escape == True: 
        spec = escape_peaks(spec,peaks, els)[0]
    if sum == True:
        spec = sum_peaks(spec,peaks, els)[0]
    if decal == True: 
        spec, params = decalibration(spec)
    spec = detector_eff(spec, np.arange(0,30,0.05))
    if prop == "":
        prop =  np.random.uniform()
    if (spec <0).any(): 
            spec[spec<0 ] = 0 

    brem = Narea(np.histogram(np.random.choice(brems[0], size = b_counts, p = Narea(brems[1])), bins = 600, range=(0.0,30))[0])
    char = Narea(np.histogram(np.random.choice(Prim[0], size = c_counts, p = Narea(Prim[1])), bins = 600, range=(0.0,30))[0])
    spec = Narea( np.histogram(np.random.choice(np.arange(0,30,0.05), size = s_counts, p = Narea(spec) ), bins = 600, range=(0.0,30))[0])
    noise = np.random.random(600)
    noise = Narea (np.histogram(np.random.choice(np.arange(0,30,0.05), size = n_counts, p = Narea(noise) ), bins = 600, range=(0.0,30))[0])
    final_d = ((brem/brem_r)*prop) + spec + noise/noise_f + ((char/char_r)*prop)
    if plot:
        from bokeh.plotting import figure, show
        from bokeh.models import HoverTool, ColumnDataSource
        from bokeh.io import output_notebook

        output_notebook()

        es, names = select_values(peaks, peaks_dic)
        box_indices = np.digitize(es, np.arange(0,30,0.05))-1 #para evitar error
        xs = np.arange(0, 30, 0.05)[box_indices]
        ys = spec[box_indices]

        source = ColumnDataSource(data=dict(xs=xs, ys=ys, y0=np.zeros_like(es), names=names))
        # Create a figure object
        p = figure()

        # Add a line plot
        p.line(np.arange(0, 30, 0.05), final_d)

        # Add vertical lines with associated tooltips
        p.segment(x0='xs', y0='y0', x1='xs', y1='ys', line_color="green", source=source)
        hover = HoverTool(tooltips=[("Text", "@names")], renderers=[p.renderers[-1]])
        p.add_tools(hover)

        # Show the plot
        show(p)
    if decal == True: 
        return final_d, params
    else: 
        return final_d

# def plot_spectra(spec, c):
#     return 

#### VERSION NUEVA 



# air_mu = torch.tensor(material_mu("air",  np.arange(0,30,0.1)*1000 , air_density, kind = "photo")).cuda()

# num_to_el = dict(zip(np.arange(len(reduced_list)), reduced_list))

# reduced_lines_list = []
# energies = []
# for i in reduced_list: 
#     e = XrfElement(i)
#     lines = e.emission_line.all
#     for line in lines: 
#         name = line[0]
#         energy = line[1]
#         if (energy!=0) and (energy < 40): 
#             reduced_lines_list.append(i + "_"+ name)
#             energies.append(energy)
# tuple_list = sorted(zip(energies, reduced_lines_list))
# unziped_l = list(zip(*tuple_list))
# energies = unziped_l[0]
# reduced_lines_l = unziped_l[1]
# peaks_dic  = dict(zip(reduced_lines_l, energies)) 
# peaks_dic_el =  [key.split('_')[0] for key in peaks_dic.keys()]
# el_to_number = dict(zip(reduced_list, np.arange(len(reduced_list))))
# peaks_dic_n = [el_to_number[el] for el in peaks_dic_el]
# peaks_dic_ncpu = torch.tensor(peaks_dic_n)
# peaks_dic_n = torch.tensor(peaks_dic_n).cuda() #+ 1 ahora que solo uso el nombre no hace falta este cambio. 

# lin_e_dic = {} #nested dictionary with all elements, each having a list of the names of the lines and a tensor of the energies of those lines
# for elem in reduced_list: 
#     lin = list(filter(lambda x: x[1] != 0, XrfElement(elem).emission_line.all)) #convertir lista en torch type.
#     lines, ens , pos  = [], [], []
#     j = 0 
#     for i in lin:
#         lines.append(i[0])
#         ens.append(i[1])
#         pos.append(j)
#         j +=1 

#     el_d = {"lines": lines, "energies" :torch.tensor(ens), "pos" : dict(zip(lines, pos))   }
#     # print(el_d)
#     lin_e_dic[elem] = el_d

# from skbeam.core.constants import XrfElement
# from skbeam.core.fitting import gaussian




# def Primary_gen(k, theta, d, phys, mu_source, z, mas, target, filters):
#     s=sp.Spek(kvp = k  , dk = d , th = theta, targ = target,  physics=phys, brem=True, char=True , mu_data_source=mu_source, z = z ,mas = mas ) # Create the spectrum model
#     s.multi_filter(filters)
#     # s.filter('Be',0.127).filter('Air',10) # Add the filtration [mm]
#     Prim_s = s.get_spectrum(edges=True)
#     bs=sp.Spek(kvp = k  , dk = d , th = theta, targ = target,  physics=phys, brem=True, char=True , mu_data_source=mu_source, z = z ,mas = mas ) # Create the spectrum model
#     bs.multi_filter(filters)
#     # s.filter('Be',0.127).filter('Air',10) # Add the filtration [mm]
#     bPrim_s = bs.get_spectrum(edges=True)

#     return Prim_s, bPrim_s

# Prim, brems = Primary_gen(30, 46, 0.1, "casim", "nist", 1, 9, "Mo", [('Be',0.127),('Air',10)])

# css_tens  = torch.zeros((len(reduced_list), len(Prim[0]),25))
# cens_tens = torch.zeros((len(reduced_list),len(Prim[0]),25))
# for i in range(len(reduced_list)):
#     elem_d = {}
#     a, lin = zip(* XrfElement(reduced_list[i]).emission_line.all)
    
#     for en,j in zip(Prim[0],range(len(Prim[0]))):
#         rs =  XrfElement(reduced_list[i]).cs(en).all    
#         r_names, cs = zip(*rs)
#         values = list( map(lin_e_dic[reduced_list[i]]["pos"].get, r_names) )
#         css_tens[i,j,:] = torch.tensor(cs)
#         cens_tens[i,j,:] = torch.tensor(lin)

# def Narea_t(array):
#     """ Importante que la suma no sea 0 osea que sean todos zeros si no obviamente dará un error. 
#     """
#     tam = array.size()
#     if len(tam) > 1 : 
#         a = array/torch.max(array, dim = -1 ).values.unsqueeze(-1) #mriar que pasa en 3 dim 
#         a = a/torch.sum(a, dim = -1 ).unsqueeze(-1)
#     else: 
#         a = array/torch.max(array) 
#         a = a/torch.sum(a)
#     return a



# def escape_peaks_t(spectra,gauss): # he quitado c porque no lo he usado, podria usarlo para seleccionar solo algun pico de algun elemento.
#     """
#     En este caso hay que coger la linea de un pico (deberia ser uno de los más grandes) y restarle la Ka1 del silicio 1.73998 KeV (que depende del detector pero casi todos son de silicio). 
#     para crear un nuevo pico con esa energia. 
#     Faltaria meter la probabilidad de que se dieran escape peaks en funcion de la intensidad y la energia de los picos. 
#     """
#     #LA PROBABILIDAD DE QUE SE DE ESTO SERIA LA CROSS SECTION DE LA KA1 DEL SILICO POR EL PICO DE ENERGIA NO ????? 
#     import scipy 
#     peaks, prominences, proms, x, area, N, proms_t, peaks_it, a, perc = None, None,  None, None,  None, None,  None, None,  None, None    
#     x = torch.arange(0,30,0.1)
#     area = 0.05 * torch.sqrt(torch.tensor(2 * torch.pi)).cuda().detach()
#     for i in range(spectra.size(0)) :
#         std = gauss[i].item()
#         area = std* torch.sqrt(torch.tensor(2 * torch.pi)).cuda().detach()
#         peaks = scipy.signal.find_peaks(spectra[i].cpu().detach().numpy(), prominence = torch.max(spectra[i]).cpu().detach().numpy()/15)
#         prominences = sorted((zip(peaks[1]["prominences"], peaks[0])))
#         if len(prominences) > 0: 
            
#             proms = list(zip(*prominences))[0] #peak prominence
#             peaks_i = list(zip(*prominences))[1] #peak index, estan ordenadas de menor a mayor
#             N = round(0.6*len(proms)/2) #numero de elementos que se cogen
#             proms_t = torch.flip(torch.tensor(proms), dims = [0]) #ahora si ordenadas por importancia
#             peaks_it = torch.flip(torch.tensor(peaks_i), dims = [0])
#             a = torch.randperm(round(len(proms_t)/2))[:N]
#             #sorted(a) ??
#             proms_t = proms_t[a]
#             peaks_it = peaks_it[a]
#             peaks_it = peaks_it[x[peaks_it] > 1.75]
#             if peaks_it.numel()!=0: 
#                 for peak in peaks_it: 
#                     # print("Escape peak a " ,x[peak])
#                     perc =  torch.randint(low = 1,high = 15, size =  (1,))/100
#                     spectra[i] -= s_gauss(x.cuda().detach(), area, x[peak].cuda().detach(), std).cuda().detach()*perc.cuda().detach() * spectra[i][peak]
#                     spectra[i] += s_gauss(x.cuda().detach(), area*2, (x[peak]-1.73998).cuda().detach(), std*2).cuda().detach()*perc.cuda().detach() * spectra[i][peak]
    
#     del peaks, prominences, proms, x, area, N, proms_t, peaks_it, a, perc
    
#     return spectra.cuda().detach()

# def sum_peaks_t(spectra,gauss):
#     """
#     Simplemente hay que sumar dos picos, es decir coger dos lineas de dos elementos y sumarlas para crear otro pico. 
#     """
#     import scipy 
#     peaks, prominences, proms, x, area, N, proms_t, peaks_it, a, perc = None, None,  None, None,  None, None,  None, None,  None, None    
#     x = torch.arange(0,30,0.1)
#     area = 0.05 * torch.sqrt(torch.tensor(2 * torch.pi)).cuda().detach()
#     # print(spectra.size())
#     # print(spectra.size(0))
#     for i in range(spectra.size(0)) :
#         std = gauss[i].item()
#         area = std * torch.sqrt(torch.tensor(2 * torch.pi)).cuda().detach()
#         peaks = scipy.signal.find_peaks(spectra[i].cpu().detach().numpy(), prominence = torch.max(spectra[i]).cpu().detach().numpy()/15)
#         prominences = sorted((zip(peaks[1]["prominences"], peaks[0])))
#         if len(prominences) > 0: 
#             proms = list(zip(*prominences))[0] #peak prominence
#             peaks_i = list(zip(*prominences))[1] #peak index, estan ordenadas de menor a mayor
#             N = round(0.6*len(proms)/2) #numero de elementos que se cogen
#             proms_t = torch.flip(torch.tensor(proms), dims = [0]) #ahora si ordenadas por importancia
#             peaks_it = torch.flip(torch.tensor(peaks_i), dims = [0])
#             a = torch.randperm(round(len(proms_t)/2))[:N]
#             proms_t = proms_t[a]
#             peaks_it = peaks_it[a]
#             if len(peaks_it)>1: 
#             # print("mas de dos picos")
#                 for i in range(len(peaks_it)-1):
#                     pos1 = peaks_it[i]
#                     pos2 = peaks_it[i+1]
#                     # print(" Picos sumados" ,x[pos1], x[pos2])
#                     y_alt = spectra[i][pos1]
#                     perc =  torch.randint(low = 1,high = 15, size =  (1,))/100
#                     spectra[i] -= s_gauss(x.cuda().detach(), area, x[pos1].cuda().detach(), std).cuda().detach()*perc.cuda().detach() * y_alt *perc.cuda().detach()/2
#                     spectra[i] -= s_gauss(x.cuda().detach(), area, x[pos2].cuda().detach(), std).cuda().detach()*perc.cuda().detach() * y_alt *perc.cuda().detach()/2

#                     spectra[i] += s_gauss(x.cuda().detach(), area*2, x[pos1].cuda().detach() + x[pos2].cuda().detach(), std*2).cuda().detach()*perc.cuda().detach() * y_alt

    
#     del peaks, prominences, proms, x, area, N, proms_t, peaks_it, a, perc
#     return spectra.cuda().detach()



# def decalibration_t(spectra):
#     x = torch.arange(0, 30, 0.1)
#     a = torch.tensor(np.random.uniform(-0.03, 0.03))
#     b = torch.tensor(np.random.uniform(-0.03, 0.03))
#     c = torch.tensor(np.random.uniform(-0.05, 0.05) * 10**(-3))
#     x_tr = a + (1 + b) * x + c * x**2
#     decal = interp1d(x_tr, spectra.cpu(), bounds_error=False, fill_value=0)
#     return torch.tensor(decal(torch.tensor(x))).cuda().detach()



# copia = pd.read_table("src\multiel_spectra\copia_eff.csv", delimiter = ";", header = None)
# x_c =  copia[0].values
# x_c = [float(str(c).replace(",", ".")) for c in x_c]
# y_c = copia[1].values # .replace(",", ".").replace( "\n", "")  
# y_c = [abs(float(str(c).replace(",", "."))) for c in y_c]

# from scipy.interpolate import interp1d
# copia_inter = interp1d(x_c, y_c, bounds_error = False, fill_value = 0 )
# eff_inter = torch.tensor(copia_inter(torch.arange(0,30,0.1)))

# def detector_eff_t(spectra):
#     """
#     Crear ventana de eficiencia de la red Neuronal. 
#     """

#     alpha = torch.tensor(np.random.uniform(low = 0.01 , high = 40 ))# de vez en cuando podria dar un uno y un 0, que es como no tener eficiencia. 
#     beta = torch.tensor(np.random.uniform(low = 0.01 , high = 40))
#     n =  torch.randint(low = 1,high = 50, size =  (1,))
#     new_eff = torch.zeros((300))
#     if n!=0: 
#         new_eff[n:] = eff_inter[:-n]
#     else: 
#         new_eff = eff_inter
   
#     eff = torch.tensor(sigmoid_t(new_eff, alpha,beta)).cuda().detach()

#     return eff * spectra

# def sigmoid_t(x, a, b):
#     return 1/(1 + b*torch.exp(-x*a)) 

# def q_creat(element,prop): 
#     elem =  num_to_el[element]
#     z = zip(elem, prop)
#     mus = [material_mu(elem, np.arange(0,30,0.1)*1000, XrfElement(elem).density,  kind = "photo")* XrfElement(eleme).density*0.5*p*10**(-4) for element,p in z]
#     return torch.tensor(mus)

# def density(el):
#     # try: 
#     #     den = XrfElement(el).density 
#     # except: 
#     #     den = XrfElement(el.item()).density 
#     elem =  num_to_el[el]
#     return  XrfElement(elem).density 

# def mus(el,dens): 
#     elem = num_to_el[el]
#     return material_mu(elem, np.arange(0,30,0.1)*1000, dens,  kind = "photo")

# from functools import partial

# def multigen_opt(els, Prim_s, cens_tens, css_tens):
    
#     """
#     Interesa solo la absorción por lo que no uso el componente fotoelectrico.
#     Se devuelve solo aquello transmitido no lo que excita

#     la lista de las proporciones de los elementos tiene que ser con todos los elementos, es decir, la mayoria 0 excepto algunos, 
#     hacer en manera random el orden de los estratos. Porque de momento están ordenados por Z. 

#     """
#     mask, mask_non0,n,peaks_pos, column, mask_col,d1,d2,low,high,sig,sums,factors = None, None, None, None, None,None, None, None,None, None, None,None, None 
#     air_z, air_f, q_air, summed_f, summed_qs,qs, vec_el, props, dens, muss, fact, q, f1,f2 = None, None, None, None, None, None,None, None, None,None, None, None,None, None 
#     std,area, cs, centers, new_x, posi, x,Prim_y  = None, None, None, None, None, None , None, None
    
#     air_mu = torch.tensor(material_mu("air",  np.arange(0,30,0.1)*1000 , air_density, kind = "photo")).cuda().detach()

#     mask = torch.full((els.size(0),41), True)
#     mask = mask.scatter_(1, els, False).cuda().detach()
#     c = torch.rand((els.size(0), len(reduced_list))).cuda().detach()
#     c = c/torch.sum(c, dim = 0 )
#     c[mask] = 0
#     mask_non0 = ~ mask
#     c = Narea_t(c)
#     n = torch.masked_select(c, mask_non0).view(c.size(0), -1).cuda().detach()
#     peaks_pos = torch.zeros((els.size(0) ,len(peaks_dic)))
#     for col in range(els.size(0)):
#         column = els[col,:].cuda().detach()
#         mask_col = torch.isin(peaks_dic_n, column).cuda().detach()
#         peaks_pos[col,: ][mask_col ] = 1  

#     d1, d2 = els.size() 
#     posi = torch.arange(d2).repeat(d1, 1).cuda().detach()
#     low = 0.02
#     high = 0.2

#     sums = torch.empty((d1,d2, 300)).cuda().detach()
#     factors = torch.empty((d1,d2)).cuda().detach()
#     qs = torch.empty((d1,d2, 300)).cuda().detach() #hay uno para cada energia. 
#     x = torch.arange(0,30,0.1).cuda().detach()
    
#     std = (torch.rand(d1) * (high - low) + low).cuda().detach()
#     s2pi = torch.sqrt(torch.tensor(2*torch.pi)).cuda().detach()

#     Prim_y = torch.tensor(Prim_s[1]).unsqueeze(0).unsqueeze(-1).cuda().detach()


#     for i in range(d1):# si invierto el orden de esto puedo hacer que se sumen al anterior 

#         vec_el = els[i].clone()
#         props = n[i].clone().cuda().detach()
#         dens = list(map(lambda x: density(x.item()), vec_el))
#         muss = torch.tensor(list(map( lambda x,y: mus(x.item(),y), vec_el, dens))).cuda().detach()
#         fact = torch.tensor( torch.tensor(dens).cuda().detach()*props*10**(-4)).cuda().detach()  #should be a vector of dim = d2
#         q = muss*fact[:,None]*10**(-4)

#         sig = std[i]
#         area = sig * s2pi
#         cs = css_tens[vec_el].unsqueeze(-1)
#         new_x = x.repeat(cs.size())
#         centers = cens_tens[vec_el].unsqueeze(-1)
#         #centers + noise ??? con un noise de 0.001 keV approx más o menos 
#         sums[i,:,:] = torch.sum(torch.sum((1/area)*torch.exp(-1 * ( ( new_x.cuda().detach() - centers.cuda().detach())** 2)/ (2 *sig** 2))*cs.cuda().detach(), dim = 2)*Prim_y, dim = 1)

#         qs[i,:,:] = q
#         factors[i,:] = fact  

#     final_spectra = torch.zeros((d1,d2,300))

#     if d2 > 1: 

#         f1, f2 = factors.size()
#         summed_f = torch.zeros((f1,f2)).cuda()
#         summed_qs = torch.zeros((f1,f2,300)).cuda()    
#         for i in range(f2): #no pogo el -1 porque a pesar de que la ultima fila no esta sumada tiene que trasferirse a summ
#             summed_f[:,i] = torch.sum(factors[:,i:], dim = 1)
#             summed_qs[:,i,:] = torch.sum(qs[:,i:,:], dim = 1)
            
#         # if torch.isnan(summed_f).any(): 
#         #     print("There is a nan in summed_f", summed_f)
#         # if torch.isnan(summed_qs).any(): 
#         #     print("There is a nan in summed_qs", summed_qs)


#         last_row = Narea_t(sums[:,-1,:]) *n[:,-1].unsqueeze(-1) #ultimo elemento 
#         final_spectra =  Narea_t( sums*summed_f.unsqueeze(-1)*((1-torch.exp(-summed_qs))/summed_qs))*n.unsqueeze(-1)
#         final_spectra[:,-1,:] = last_row
#         final_spectra = torch.sum(final_spectra, dim = 1)
# #         if torch.isnan(final_spectra).any(): 
# #             print("There is a nan in final_spectra")
# #             for w in range(d1):
# #                 if (torch.isnan(final_spectra[w])).any():
# #                     torch.set_printoptions(threshold=torch.inf)
# #                     print("Nan is at row", w)
# #                     print(sums[w])
# #                     print(els[w])
# #                     indx_0 = [(sums[w][j]==0).all().cpu() for j in range(sums[w].size(0))]
# #                     print(indx_0)
# #                     pos = np.where(indx_0)[0]
# #                     print(els[w][pos])
# #                     pdb.set_trace()
   
# #                     torch.set_printoptions(edgeitems=3, threshold=1000, linewidth=75, sci_mode=False)
            
#     else:
        
#         final_spectra = Narea_t(sums)*n.unsqueeze(-1)
#         final_spectra = final_spectra.squeeze(dim = 1)

#     air_z = torch.rand(1).cuda().detach()
#     q_air = air_mu*air_z*air_density
#     air_spectra = Narea_t( final_spectra*air_z*air_density*((1-torch.exp(-q_air))/q_air).unsqueeze(0) )
#     if torch.isnan(air_spectra).any(): 
#             print("There is a nan in air_spectra")
            
    
#     del mask, mask_non0,n, column, mask_col,d1,d2,low,high,sums,factors
#     del air_z, air_f, q_air, summed_f, summed_qs,qs, vec_el, props, dens, muss, fact, q, f1,f2
#     del final_spectra, x, area,sig, cs, centers, new_x, posi, Prim_y
    
#     return air_spectra, peaks_pos, c, std

# s2pi = torch.sqrt(torch.tensor(2*torch.pi))
# def s_gauss(x, area, center, sigma):
#     """1 dimensional gaussian
#     Parameters
#     ----------
#     x : array
#         independent variable
#     area : float
#         Area of the normally distributed peak
#     center : float
#         center position
#     sigma : float
#         standard deviation
#     """
#     return ((1/area) *torch.exp(-1 * (1.0 * x - center.item()) ** 2 / (2 * sigma ** 2)))





# parser = argparse.ArgumentParser()
# parser.add_argument('--tsize', help='Train_size')
# parser.add_argument('--bsize', help='Batch_size')
# parser.add_argument('--path', help='path')
# parser.add_argument('--fcreated', help='files that have already been created')
# # parser.add_argument('--batchsize', help='Batch_size')
# # parser.add_argument('--veces', help='50K veces')

# args = parser.parse_args()
# train_size =int( args.tsize)
# batch_size = int(args.bsize)
# files_c = int(args.fcreated)
# path = args.path


# decal = True

# a, spec, peaks, c, noise, brems_choice, char_choice, brem, char = None, None,  None, None, None, None, None, None, None
# final_d_choice, h_final_d, final_d,prop, new_spec, Primary = None, None,  None, None, None, None

# x = torch.arange(0,30,0.1).cuda().detach()
# physics = ['casim', 'kqp', "legacy", 'spekcalc','spekpy-v1' ] 
# Targets = ["W", "Mo", "Rh"]
# mu_source = ["pene", "nist"]
# __all__ = ['Prim', 'brems', 'air_density', 'Primary_gen', 'Narea_t'] #used to export variables
# __all__ = ['copia_inter','eff_inter', 'y_c', 'x_c', 'detector_eff']