#!/usr/bin/env python

# Built-in
import os
import argparse

# Common
import numpy as np


_save = True
_here = os.path.abspath(os.path.dirname(__file__))
#_Cls, _name = os.path.split(__file__)[1].split('_')[1:3]
#assert not any([any([ss in s for ss in ['WEST','Notes','.']])
#               for s in [_Cls,_name])


def get_notes():
    """ By convention : D is a length of the element, d is a gap  """

    # CreoVew coordinates : (-X,Y,Y)
    notes = {}

    # Low Divertor coils
    notes['DivLow11'] = [[ 544.028, -707.593, -1904.619],
                         [ 544.028, -739.007, -1904.619],
                         [ 552.107, -739.007, -1932.902],
                         [ 552.107, -707.593, -1932.902]]

    notes['DivLow12'] = [[ 506.027, -741.593, -1915.066],
                         [ 506.027, -773.007, -1915.066],
                         [ 513.541, -773.007, -1943.504],
                         [ 513.541, -741.593, -1943.504]]

    notes['DivLow13'] = [[ 591.045, -707.593, -1924.058],
                         [ 591.045, -739.007, -1924.058],
                         [ 599.682, -739.007, -1952.176],
                         [ 599.682, -707.593, -1952.176]]

    notes['DivLow14'] = [[ 629.245, -741.593, -1911.906],
                         [ 629.245, -773.007, -1911.906],
                         [ 638.441, -773.007, -1939.846],
                         [ 638.441, -741.593, -1939.846]]

    notes['DivLow15'] = [[ 719.986, -741.593, -1913.844],
                         [ 719.986, -773.007, -1913.844],
                         [ 730.343, -773.007, -1941.374],
                         [ 730.343, -741.593, -1941.374]]

    notes['DivLow16'] = [[866.309, -775.593, -1852.211],
                         [866.309, -807.007, -1852.211],
                         [878.771, -807.007, -1878.855],
                         [878.771, -775.593, -1878.855]]

    notes['DivLow17'] = [[782.893, -741.593, -1923.577],
                         [782.893, -773.007, -1923.577],
                         [793.981, -773.007, -1950.821],
                         [793.981, -741.593, -1950.821]]

    notes['DivLow18'] = [[832.314, -775.593, -1902.715],
                         [832.314, -807.007, -1902.715],
                         [844.102, -807.007, -1929.663],
                         [844.102, -775.593, -1929.663]]

    notes['DivLow1'] = [notes['DivLow14'][3],
                        notes['DivLow13'][3],
                        notes['DivLow11'][0],
                        notes['DivLow12'][1],
                        notes['DivLow14'][2],
                        notes['DivLow15'][1],
                        notes['DivLow16'][1],
                        notes['DivLow18'][2],
                        notes['DivLow17'][3],
                        notes['DivLow15'][0]]

    # Div Low 2

    notes['DivLow21'] = [[2070.226, -770.213, -525.144],
                         [2070.226, -801.627, -525.144],
                         [2098.737, -801.627, -532.377],
                         [2098.737, -770.213, -532.377]]

    notes['DivLow22'] = [[2059.565, -804.213, -565.509],
                         [2059.565, -835.627, -565.509],
                         [2087.930, -835.627, -573.298],
                         [2087.930, -804.213, -573.298]]

    notes['DivLow23'] = [[2111.217, -770.213, -492.023],
                         [2111.217, -801.627, -492.023],
                         [2139.864, -801.627, -498.699],
                         [2139.864, -770.213, -498.699]]

    notes['DivLow24'] = [[2036.407, -804.213, 743.216],
                         [2036.407, -835.627, 743.216],
                         [2064.039, -835.627, 753.301],
                         [2064.039, -804.213, 753.301]]

    notes['DivLow25'] = [[2160.173, -804.213, -415.621],
                         [2160.173, -835.627, -415.621],
                         [2189.057, -835.627, -421.178],
                         [2189.057, -804.213, -421.178]]

    notes['DivLow26'] = [[2185.593, -838.213, -249.547],
                         [2185.593, -869.627, -249.547],
                         [2214.817, -869.627, -252.884],
                         [2214.817, -838.213, -252.884]]

    notes['DivLow27'] = [[2221.021, -838.213, -219.014],
                         [2221.021, -869.627, -219.014],
                         [2250.293, -869.627, -221.901],
                         [2250.293, -838.213, -221.901]]

    notes['DivLow28'] = [[2214.719, -804.213, -275.533],
                         [2214.719, -835.627, -275.533],
                         [2243.908, -835.627, -279.164],
                         [2243.908, -804.213, -279.164]]

    notes['DivLow2'] = [notes['DivLow24'][3],
                        notes['DivLow23'][3],
                        notes['DivLow21'][0],
                        notes['DivLow22'][1],
                        notes['DivLow24'][2],
                        notes['DivLow25'][1],
                        notes['DivLow26'][1],
                        notes['DivLow27'][2],
                        notes['DivLow28'][3],
                        notes['DivLow25'][0]]

    # Upper Divertor coils

    notes['DivUp11'] = [[1915.066, 775.907, -506.027],
                        [1915.066, 744.493, -506.027],
                        [1943.504, 744.493, -513.541],
                        [1943.504, 775.907, -513.541]]

    notes['DivUp12'] = [[1904.619, 741.907, -544.028],
                        [1904.619, 710.493, -544.028],
                        [1932.902, 710.493, -552.107],
                        [1932.902, 741.907, -552.107]]

    notes['DivUp13'] = [[1911.907, 775.907, -629.241],
                        [1911.907, 744.493, -629.241],
                        [1939.848, 744.493, -638.437],
                        [1939.848, 775.907, -638.437]]

    notes['DivUp14'] = [[1924.058, 741.907, -591.045],
                        [1924.058, 710.493, -591.045],
                        [1952.176, 710.493, -599.682],
                        [1952.176, 741.907, -599.682]]

    notes['DivUp15'] = [[1852.211, 809.907, -866.309],
                        [1852.211, 778.493, -866.309],
                        [1878.855, 778.493, -878.771],
                        [1878.855, 809.907, -878.771]]

    notes['DivUp16'] = [[1913.844, 775.907, -719.986],
                        [1913.844, 744.493, -719.986],
                        [1941.374, 744.493, -730.343],
                        [1941.374, 775.907, -730.343]]

    notes['DivUp17'] = [[1902.715, 809.907, -832.314],
                        [1902.715, 778.493, -832.314],
                        [1929.663, 778.493, -844.102],
                        [1929.663, 809.907, -844.102]]

    notes['DivUp18'] = [[1923.577, 775.907, -782.893],
                        [1923.577, 744.493, -782.893],
                        [1950.821, 744.493, -793.981],
                        [1950.821, 775.907, -793.981]]

    notes['DivUp1'] = [notes['DivUp13'][3],
                       notes['DivUp11'][0],
                       notes['DivUp12'][1],
                       notes['DivUp14'][2],
                       notes['DivUp13'][2],
                       notes['DivUp16'][1],
                       notes['DivUp18'][2],
                       notes['DivUp17'][3],
                       notes['DivUp15'][0],
                       notes['DivUp16'][0]]

    # Div Up 2

    notes['DivUp21'] = [[565.509, 838.527, -2059.565],
                        [565.509, 807.113, -2059.565],
                        [573.298, 807.113, -2087.930],
                        [573.298, 838.527, -2087.930]]

    notes['DivUp22'] = [[525.144, 804.527, -2070.226],
                        [525.144, 773.113, -2070.226],
                        [532.377, 773.113, -2098.737],
                        [532.377, 804.527, -2098.737]]

    notes['DivUp23'] = [[492.023, 804.527, -2111.217],
                        [492.023, 773.113, -2111.217],
                        [498.699, 773.113, -2139.864],
                        [498.699, 804.527, -2139.864]]

    notes['DivUp24'] = [[-743.216, 838.527, -2036.407],
                        [-743.216, 807.113, -2036.407],
                        [-753.301, 807.113, -2064.039],
                        [-753.301, 838.527, -2064.039]]

    notes['DivUp25'] = [[249.547, 872.527, -2185.593],
                        [249.547, 841.113, -2185.593],
                        [252.884, 841.113, -2214.817],
                        [252.884, 872.527, -2214.817]]

    notes['DivUp26'] = [[415.621, 838.527, -2160.173],
                        [415.621, 807.113, -2160.173],
                        [421.178, 807.113, -2189.057],
                        [421.178, 838.527, -2189.057]]

    notes['DivUp27'] = [[275.533, 838.527, -2214.719],
                        [275.533, 807.113, -2214.719],
                        [279.164, 807.113, -2243.908],
                        [279.164, 838.527, -2243.908]]

    notes['DivUp28'] = [[219.014, 872.527, -2221.021],
                        [219.014, 841.113, -2221.021],
                        [221.901, 841.113, -2250.293],
                        [221.901, 872.527, -2250.293]]

    notes['DivUp2'] = [notes['DivUp24'][3],
                       notes['DivUp21'][0],
                       notes['DivUp22'][1],
                       notes['DivUp23'][2],
                       notes['DivUp24'][2],
                       notes['DivUp26'][1],
                       notes['DivUp27'][2],
                       notes['DivUp28'][3],
                       notes['DivUp25'][0],
                       notes['DivUp26'][0]]

    # Central Solenoid

    notes['CS'] = [[0.,  875., 669.],
                   [0., -845., 669.],
                   [0., -845., 812.],
                   [0.,  875., 812.]]

    # External PF coils

    notes['Bu'] = [[0., 2400., 1082.],
                   [0., 1200., 1082.],
                   [-577.5, 1200., 1000.259],
                   [0., 2400., 1155.]]

    notes['Bl'] = [[-1083., -1200., 0.],
                   [-1083., -2400., 0.],
                   [-1155., -2400., 0.],
                   [-816.708, -1200., -816.708]]

    notes['Du'] = [[-1374., 2109., 2379.838],
                   [-1374., 1746., 2379.838],
                   [-1507.5, 1746., 2611.067],
                   [-1507.5, 2109., 2611.067]]

    notes['Dl'] = [[-1374., -1746., 2379.838],
                   [-1374., -2109., 2379.838],
                   [-1507.5, -2109., 2611.067],
                   [-1507.5, -1746., 2611.067]]

    notes['Eu'] = [[-1814., 1736., 3141.94],
                   [-1814., 1346., 3141.94],
                   [-1957.5, 1346., 3390.489],
                   [-1957.5, 1736., 3390.489]]

    notes['El'] = [[-1814., -1346., 3141.94],
                   [-1814., -1736., 3141.94],
                   [-1957.5, -1736., 3390.489],
                   [-1957.5, -1346., 3390.489]]

    notes['Fu'] = [[-2115., 838., 3663.287],
                   [-2115., 450., 3663.287],
                   [-2259.5, 450., 3913.569],
                   [-2259.5, 838., 3913.569]]

    notes['Fl'] = [[-2115., -452., 3663.287],
                   [-2115., -840., 3663.287],
                   [-2259.5, -840., 3913.569],
                   [-2259.5, -452., 3913.569]]

    for k in notes.keys():
        notes[k] = np.array(notes[k])*1.e-3

    return notes



def make_Poly(save=_save, path=_here):
    notes = get_notes()

    lPoly = []
    for k in notes.keys():
        if k[-2] in ['1','2']:
            continue
        Poly = np.array([np.hypot(notes[k][:,0],notes[k][:,2]), notes[k][:,1]])
        lPoly.append(Poly)
        if save:
            if 'CS' in k:
                name = 'WEST_CoilCS_V0.txt'
            else:
                name = 'WEST_CoilPF_{0}_V0.txt'.format(k)
            pathfilext = os.path.join(path,name)
            np.savetxt(pathfilext, Poly.T)
    return lPoly, notes


if __name__=='__main__':

    # Parse input arguments
    msg = 'Launch creation of polygons txt from bash'
    parser = argparse.ArgumentParser(description = msg)

    parser.add_argument('-save', type=bool, help='save ?', default=_save)
    parser.add_argument('-path', type=str, help='saving path ?', default=_here)

    args = parser.parse_args()

    # Call wrapper function
    make_Poly(save=args.save, path=args.path)
