# pylint: disable=missing-module-docstring,missing-function-docstring,missing-class-docstring,invalid-name
# Generated by Django 3.2.16 on 2023-09-18 19:03
import uuid

import django.core.serializers.json
import django.db.models.deletion
import nautobot.extras.models.mixins
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("ipam", "0008_prefix_vlan_vlangroup_location"),
        ("nautobot_bgp_models", "0002_viewsets_migration"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="addressfamily",
            name="export_policy",
        ),
        migrations.RemoveField(
            model_name="addressfamily",
            name="import_policy",
        ),
        migrations.RemoveField(
            model_name="addressfamily",
            name="multipath",
        ),
        migrations.RemoveField(
            model_name="peerendpoint",
            name="export_policy",
        ),
        migrations.RemoveField(
            model_name="peerendpoint",
            name="import_policy",
        ),
        migrations.RemoveField(
            model_name="peergroup",
            name="export_policy",
        ),
        migrations.RemoveField(
            model_name="peergroup",
            name="import_policy",
        ),
        migrations.RemoveField(
            model_name="peergrouptemplate",
            name="export_policy",
        ),
        migrations.RemoveField(
            model_name="peergrouptemplate",
            name="import_policy",
        ),
        migrations.AddField(
            model_name="addressfamily",
            name="extra_attributes",
            field=models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True),
        ),
        migrations.AddField(
            model_name="peergroup",
            name="vrf",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="peer_groups",
                to="ipam.vrf",
            ),
        ),
        migrations.AlterField(
            model_name="addressfamily",
            name="vrf",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="address_families",
                to="ipam.vrf",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="peergroup",
            unique_together={("name", "routing_instance", "vrf")},
        ),
        migrations.CreateModel(
            name="PeerGroupAddressFamily",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                (
                    "extra_attributes",
                    models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True),
                ),
                ("afi_safi", models.CharField(max_length=64)),
                ("import_policy", models.CharField(blank=True, default="", max_length=100)),
                ("export_policy", models.CharField(blank=True, default="", max_length=100)),
                ("multipath", models.BooleanField(blank=True, null=True)),
                (
                    "peer_group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="address_families",
                        to="nautobot_bgp_models.peergroup",
                    ),
                ),
            ],
            options={
                "verbose_name": "BGP peer-group address family",
                "verbose_name_plural": "BGP Peer-Group Address Families",
                "ordering": ["-peer_group"],
                "unique_together": {("peer_group", "afi_safi")},
            },
            bases=(
                models.Model,
                nautobot.extras.models.mixins.DynamicGroupMixin,
                nautobot.extras.models.mixins.NotesMixin,
            ),
        ),
        migrations.CreateModel(
            name="PeerEndpointAddressFamily",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                (
                    "extra_attributes",
                    models.JSONField(blank=True, encoder=django.core.serializers.json.DjangoJSONEncoder, null=True),
                ),
                ("afi_safi", models.CharField(max_length=64)),
                ("import_policy", models.CharField(blank=True, default="", max_length=100)),
                ("export_policy", models.CharField(blank=True, default="", max_length=100)),
                ("multipath", models.BooleanField(blank=True, null=True)),
                (
                    "peer_endpoint",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="address_families",
                        to="nautobot_bgp_models.peerendpoint",
                    ),
                ),
            ],
            options={
                "verbose_name": "BGP peer-endpoint address family",
                "verbose_name_plural": "BGP Peer-Endpoint Address Families",
                "ordering": ["-peer_endpoint"],
                "unique_together": {("peer_endpoint", "afi_safi")},
            },
            bases=(
                models.Model,
                nautobot.extras.models.mixins.DynamicGroupMixin,
                nautobot.extras.models.mixins.NotesMixin,
            ),
        ),
    ]
