# pylint: disable=missing-module-docstring,missing-function-docstring,missing-class-docstring,invalid-name
# Generated by Django 3.2.17 on 2023-02-12 19:21

from django.db import migrations
from nautobot.core.utils.migrations import update_object_change_ct_for_replaced_models


def create_roles(apps, schema_editor):  # pylint: disable=unused-argument
    ContentType = apps.get_model("contenttypes.ContentType")  # pylint: disable=invalid-name
    PeeringRole = apps.get_model("nautobot_bgp_models.PeeringRole")  # pylint: disable=invalid-name
    NautobotRole = apps.get_model("extras.Role")  # pylint: disable=invalid-name
    PeerGroup = apps.get_model("nautobot_bgp_models.PeerGroup")  # pylint: disable=invalid-name
    PeerGroupTemplate = apps.get_model("nautobot_bgp_models.PeerGroupTemplate")  # pylint: disable=invalid-name
    PeerEndpoint = apps.get_model("nautobot_bgp_models.PeerEndpoint")  # pylint: disable=invalid-name
    pg_ct = ContentType.objects.get_for_model(PeerGroup)
    pgt_ct = ContentType.objects.get_for_model(PeerGroupTemplate)
    pe_ct = ContentType.objects.get_for_model(PeerEndpoint)
    for role in PeeringRole.objects.all():
        nb_role, _ = NautobotRole.objects.get_or_create(
            name=role.name,
            color=role.color,
            description=role.description,
        )
        nb_role.content_types.add(pg_ct)
        nb_role.content_types.add(pgt_ct)
        nb_role.content_types.add(pe_ct)
    for group in PeerGroup.objects.exclude(role__isnull=True).exclude(role__name__exact=""):
        group.role_new = NautobotRole.objects.get(name=group.role.name)
        group.save()
    for group in PeerGroupTemplate.objects.exclude(role__isnull=True).exclude(role__name__exact=""):
        group.role_new = NautobotRole.objects.get(name=group.role.name)
        group.save()
    for peer in PeerEndpoint.objects.exclude(role__isnull=True).exclude(role__name__exact=""):
        peer.role_new = NautobotRole.objects.get(name=peer.role.name)
        peer.save()


def reverse_create_roles(apps, schema_editor):  # pylint: disable=unused-argument
    PeeringRole = apps.get_model("nautobot_bgp_models.PeeringRole")  # pylint: disable=invalid-name
    PeerGroup = apps.get_model("nautobot_bgp_models.PeerGroup")  # pylint: disable=invalid-name
    PeerGroupTemplate = apps.get_model("nautobot_bgp_models.PeerGroupTemplate")  # pylint: disable=invalid-name
    PeerEndpoint = apps.get_model("nautobot_bgp_models.PeerEndpoint")  # pylint: disable=invalid-name
    for group in PeerGroup.objects.exclude(role_new__isnull=True).exclude(role_new__name__exact=""):
        group.role, _ = PeeringRole.objects.get_or_create(
            name=group.role_new.name,
            # slug=group.role_new.slug,
            color=group.role_new.color,
            description=group.role_new.description,
        )
        group.save()
    for group in PeerGroupTemplate.objects.exclude(role_new__isnull=True).exclude(role_new__name__exact=""):
        group.role, _ = PeeringRole.objects.get_or_create(
            name=group.role_new.name,
            # slug=group.role_new.slug,
            color=group.role_new.color,
            description=group.role_new.description,
        )
        group.save()
    for peer in PeerEndpoint.objects.exclude(role_new__isnull=True).exclude(role_new__name__exact=""):
        peer.role, _ = PeeringRole.objects.get_or_create(
            name=peer.role_new.name,
            # slug=peer.role_new.slug,
            color=peer.role_new.color,
            description=peer.role_new.description,
        )
        peer.save()


def update_object_change_ct_for_replaced_role(apps, schema):  # pylint: disable=unused-argument
    """Transfer data from legacy_role to new_role."""

    update_object_change_ct_for_replaced_models(
        apps=apps,
        new_app_model={"app_name": "extras", "model": "role"},
        replaced_apps_models=[
            {"app_name": "nautobot_bgp_models", "model": "peeringrole"},
        ],
    )


def reverse_update_object_change_ct_for_replaced_role(apps, schema):  # pylint: disable=unused-argument
    """Transfer data from new_role to legacy_role."""

    update_object_change_ct_for_replaced_models(
        apps=apps,
        new_app_model={"app_name": "extras", "model": "role"},
        replaced_apps_models=[
            {"app_name": "nautobot_bgp_models", "model": "peeringrole"},
        ],
        reverse_migration=True,
    )


class Migration(migrations.Migration):
    dependencies = [
        ("nautobot_bgp_models", "0004_use_upstream_role_part1"),
    ]

    operations = [
        migrations.RunPython(code=create_roles, reverse_code=reverse_create_roles),
        migrations.RunPython(
            code=update_object_change_ct_for_replaced_role,
            reverse_code=reverse_update_object_change_ct_for_replaced_role,
        ),
    ]
