import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MonitorActionRuleSuppressionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#description MonitorActionRuleSuppression#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#enabled MonitorActionRuleSuppression#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#id MonitorActionRuleSuppression#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#name MonitorActionRuleSuppression#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#resource_group_name MonitorActionRuleSuppression#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#tags MonitorActionRuleSuppression#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#condition MonitorActionRuleSuppression#condition}
    */
    readonly condition?: MonitorActionRuleSuppressionCondition;
    /**
    * scope block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#scope MonitorActionRuleSuppression#scope}
    */
    readonly scope?: MonitorActionRuleSuppressionScope;
    /**
    * suppression block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#suppression MonitorActionRuleSuppression#suppression}
    */
    readonly suppression: MonitorActionRuleSuppressionSuppression;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#timeouts MonitorActionRuleSuppression#timeouts}
    */
    readonly timeouts?: MonitorActionRuleSuppressionTimeouts;
}
export interface MonitorActionRuleSuppressionConditionAlertContext {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionAlertContextToTerraform(struct?: MonitorActionRuleSuppressionConditionAlertContextOutputReference | MonitorActionRuleSuppressionConditionAlertContext): any;
export declare class MonitorActionRuleSuppressionConditionAlertContextOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleSuppressionConditionAlertContext | undefined;
    set internalValue(value: MonitorActionRuleSuppressionConditionAlertContext | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleSuppressionConditionAlertRuleId {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionAlertRuleIdToTerraform(struct?: MonitorActionRuleSuppressionConditionAlertRuleIdOutputReference | MonitorActionRuleSuppressionConditionAlertRuleId): any;
export declare class MonitorActionRuleSuppressionConditionAlertRuleIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleSuppressionConditionAlertRuleId | undefined;
    set internalValue(value: MonitorActionRuleSuppressionConditionAlertRuleId | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleSuppressionConditionDescription {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionDescriptionToTerraform(struct?: MonitorActionRuleSuppressionConditionDescriptionOutputReference | MonitorActionRuleSuppressionConditionDescription): any;
export declare class MonitorActionRuleSuppressionConditionDescriptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleSuppressionConditionDescription | undefined;
    set internalValue(value: MonitorActionRuleSuppressionConditionDescription | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleSuppressionConditionMonitor {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionMonitorToTerraform(struct?: MonitorActionRuleSuppressionConditionMonitorOutputReference | MonitorActionRuleSuppressionConditionMonitor): any;
export declare class MonitorActionRuleSuppressionConditionMonitorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleSuppressionConditionMonitor | undefined;
    set internalValue(value: MonitorActionRuleSuppressionConditionMonitor | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleSuppressionConditionMonitorService {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionMonitorServiceToTerraform(struct?: MonitorActionRuleSuppressionConditionMonitorServiceOutputReference | MonitorActionRuleSuppressionConditionMonitorService): any;
export declare class MonitorActionRuleSuppressionConditionMonitorServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleSuppressionConditionMonitorService | undefined;
    set internalValue(value: MonitorActionRuleSuppressionConditionMonitorService | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleSuppressionConditionSeverity {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionSeverityToTerraform(struct?: MonitorActionRuleSuppressionConditionSeverityOutputReference | MonitorActionRuleSuppressionConditionSeverity): any;
export declare class MonitorActionRuleSuppressionConditionSeverityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleSuppressionConditionSeverity | undefined;
    set internalValue(value: MonitorActionRuleSuppressionConditionSeverity | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleSuppressionConditionTargetResourceType {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#operator MonitorActionRuleSuppression#operator}
    */
    readonly operator: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#values MonitorActionRuleSuppression#values}
    */
    readonly values: string[];
}
export declare function monitorActionRuleSuppressionConditionTargetResourceTypeToTerraform(struct?: MonitorActionRuleSuppressionConditionTargetResourceTypeOutputReference | MonitorActionRuleSuppressionConditionTargetResourceType): any;
export declare class MonitorActionRuleSuppressionConditionTargetResourceTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleSuppressionConditionTargetResourceType | undefined;
    set internalValue(value: MonitorActionRuleSuppressionConditionTargetResourceType | undefined);
    private _operator?;
    get operator(): string;
    set operator(value: string);
    get operatorInput(): string | undefined;
    private _values?;
    get values(): string[];
    set values(value: string[]);
    get valuesInput(): string[] | undefined;
}
export interface MonitorActionRuleSuppressionCondition {
    /**
    * alert_context block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#alert_context MonitorActionRuleSuppression#alert_context}
    */
    readonly alertContext?: MonitorActionRuleSuppressionConditionAlertContext;
    /**
    * alert_rule_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#alert_rule_id MonitorActionRuleSuppression#alert_rule_id}
    */
    readonly alertRuleId?: MonitorActionRuleSuppressionConditionAlertRuleId;
    /**
    * description block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#description MonitorActionRuleSuppression#description}
    */
    readonly description?: MonitorActionRuleSuppressionConditionDescription;
    /**
    * monitor block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#monitor MonitorActionRuleSuppression#monitor}
    */
    readonly monitor?: MonitorActionRuleSuppressionConditionMonitor;
    /**
    * monitor_service block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#monitor_service MonitorActionRuleSuppression#monitor_service}
    */
    readonly monitorService?: MonitorActionRuleSuppressionConditionMonitorService;
    /**
    * severity block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#severity MonitorActionRuleSuppression#severity}
    */
    readonly severity?: MonitorActionRuleSuppressionConditionSeverity;
    /**
    * target_resource_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#target_resource_type MonitorActionRuleSuppression#target_resource_type}
    */
    readonly targetResourceType?: MonitorActionRuleSuppressionConditionTargetResourceType;
}
export declare function monitorActionRuleSuppressionConditionToTerraform(struct?: MonitorActionRuleSuppressionConditionOutputReference | MonitorActionRuleSuppressionCondition): any;
export declare class MonitorActionRuleSuppressionConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleSuppressionCondition | undefined;
    set internalValue(value: MonitorActionRuleSuppressionCondition | undefined);
    private _alertContext;
    get alertContext(): MonitorActionRuleSuppressionConditionAlertContextOutputReference;
    putAlertContext(value: MonitorActionRuleSuppressionConditionAlertContext): void;
    resetAlertContext(): void;
    get alertContextInput(): MonitorActionRuleSuppressionConditionAlertContext | undefined;
    private _alertRuleId;
    get alertRuleId(): MonitorActionRuleSuppressionConditionAlertRuleIdOutputReference;
    putAlertRuleId(value: MonitorActionRuleSuppressionConditionAlertRuleId): void;
    resetAlertRuleId(): void;
    get alertRuleIdInput(): MonitorActionRuleSuppressionConditionAlertRuleId | undefined;
    private _description;
    get description(): MonitorActionRuleSuppressionConditionDescriptionOutputReference;
    putDescription(value: MonitorActionRuleSuppressionConditionDescription): void;
    resetDescription(): void;
    get descriptionInput(): MonitorActionRuleSuppressionConditionDescription | undefined;
    private _monitor;
    get monitor(): MonitorActionRuleSuppressionConditionMonitorOutputReference;
    putMonitor(value: MonitorActionRuleSuppressionConditionMonitor): void;
    resetMonitor(): void;
    get monitorInput(): MonitorActionRuleSuppressionConditionMonitor | undefined;
    private _monitorService;
    get monitorService(): MonitorActionRuleSuppressionConditionMonitorServiceOutputReference;
    putMonitorService(value: MonitorActionRuleSuppressionConditionMonitorService): void;
    resetMonitorService(): void;
    get monitorServiceInput(): MonitorActionRuleSuppressionConditionMonitorService | undefined;
    private _severity;
    get severity(): MonitorActionRuleSuppressionConditionSeverityOutputReference;
    putSeverity(value: MonitorActionRuleSuppressionConditionSeverity): void;
    resetSeverity(): void;
    get severityInput(): MonitorActionRuleSuppressionConditionSeverity | undefined;
    private _targetResourceType;
    get targetResourceType(): MonitorActionRuleSuppressionConditionTargetResourceTypeOutputReference;
    putTargetResourceType(value: MonitorActionRuleSuppressionConditionTargetResourceType): void;
    resetTargetResourceType(): void;
    get targetResourceTypeInput(): MonitorActionRuleSuppressionConditionTargetResourceType | undefined;
}
export interface MonitorActionRuleSuppressionScope {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#resource_ids MonitorActionRuleSuppression#resource_ids}
    */
    readonly resourceIds: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#type MonitorActionRuleSuppression#type}
    */
    readonly type: string;
}
export declare function monitorActionRuleSuppressionScopeToTerraform(struct?: MonitorActionRuleSuppressionScopeOutputReference | MonitorActionRuleSuppressionScope): any;
export declare class MonitorActionRuleSuppressionScopeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleSuppressionScope | undefined;
    set internalValue(value: MonitorActionRuleSuppressionScope | undefined);
    private _resourceIds?;
    get resourceIds(): string[];
    set resourceIds(value: string[]);
    get resourceIdsInput(): string[] | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface MonitorActionRuleSuppressionSuppressionSchedule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#end_date_utc MonitorActionRuleSuppression#end_date_utc}
    */
    readonly endDateUtc: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#recurrence_monthly MonitorActionRuleSuppression#recurrence_monthly}
    */
    readonly recurrenceMonthly?: number[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#recurrence_weekly MonitorActionRuleSuppression#recurrence_weekly}
    */
    readonly recurrenceWeekly?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#start_date_utc MonitorActionRuleSuppression#start_date_utc}
    */
    readonly startDateUtc: string;
}
export declare function monitorActionRuleSuppressionSuppressionScheduleToTerraform(struct?: MonitorActionRuleSuppressionSuppressionScheduleOutputReference | MonitorActionRuleSuppressionSuppressionSchedule): any;
export declare class MonitorActionRuleSuppressionSuppressionScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleSuppressionSuppressionSchedule | undefined;
    set internalValue(value: MonitorActionRuleSuppressionSuppressionSchedule | undefined);
    private _endDateUtc?;
    get endDateUtc(): string;
    set endDateUtc(value: string);
    get endDateUtcInput(): string | undefined;
    private _recurrenceMonthly?;
    get recurrenceMonthly(): number[];
    set recurrenceMonthly(value: number[]);
    resetRecurrenceMonthly(): void;
    get recurrenceMonthlyInput(): number[] | undefined;
    private _recurrenceWeekly?;
    get recurrenceWeekly(): string[];
    set recurrenceWeekly(value: string[]);
    resetRecurrenceWeekly(): void;
    get recurrenceWeeklyInput(): string[] | undefined;
    private _startDateUtc?;
    get startDateUtc(): string;
    set startDateUtc(value: string);
    get startDateUtcInput(): string | undefined;
}
export interface MonitorActionRuleSuppressionSuppression {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#recurrence_type MonitorActionRuleSuppression#recurrence_type}
    */
    readonly recurrenceType: string;
    /**
    * schedule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#schedule MonitorActionRuleSuppression#schedule}
    */
    readonly schedule?: MonitorActionRuleSuppressionSuppressionSchedule;
}
export declare function monitorActionRuleSuppressionSuppressionToTerraform(struct?: MonitorActionRuleSuppressionSuppressionOutputReference | MonitorActionRuleSuppressionSuppression): any;
export declare class MonitorActionRuleSuppressionSuppressionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleSuppressionSuppression | undefined;
    set internalValue(value: MonitorActionRuleSuppressionSuppression | undefined);
    private _recurrenceType?;
    get recurrenceType(): string;
    set recurrenceType(value: string);
    get recurrenceTypeInput(): string | undefined;
    private _schedule;
    get schedule(): MonitorActionRuleSuppressionSuppressionScheduleOutputReference;
    putSchedule(value: MonitorActionRuleSuppressionSuppressionSchedule): void;
    resetSchedule(): void;
    get scheduleInput(): MonitorActionRuleSuppressionSuppressionSchedule | undefined;
}
export interface MonitorActionRuleSuppressionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#create MonitorActionRuleSuppression#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#delete MonitorActionRuleSuppression#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#read MonitorActionRuleSuppression#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression#update MonitorActionRuleSuppression#update}
    */
    readonly update?: string;
}
export declare function monitorActionRuleSuppressionTimeoutsToTerraform(struct?: MonitorActionRuleSuppressionTimeoutsOutputReference | MonitorActionRuleSuppressionTimeouts | cdktf.IResolvable): any;
export declare class MonitorActionRuleSuppressionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): MonitorActionRuleSuppressionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: MonitorActionRuleSuppressionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression azurerm_monitor_action_rule_suppression}
*/
export declare class MonitorActionRuleSuppression extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_monitor_action_rule_suppression";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/monitor_action_rule_suppression azurerm_monitor_action_rule_suppression} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MonitorActionRuleSuppressionConfig
    */
    constructor(scope: Construct, id: string, config: MonitorActionRuleSuppressionConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _condition;
    get condition(): MonitorActionRuleSuppressionConditionOutputReference;
    putCondition(value: MonitorActionRuleSuppressionCondition): void;
    resetCondition(): void;
    get conditionInput(): MonitorActionRuleSuppressionCondition | undefined;
    private _scope;
    get scope(): MonitorActionRuleSuppressionScopeOutputReference;
    putScope(value: MonitorActionRuleSuppressionScope): void;
    resetScope(): void;
    get scopeInput(): MonitorActionRuleSuppressionScope | undefined;
    private _suppression;
    get suppression(): MonitorActionRuleSuppressionSuppressionOutputReference;
    putSuppression(value: MonitorActionRuleSuppressionSuppression): void;
    get suppressionInput(): MonitorActionRuleSuppressionSuppression | undefined;
    private _timeouts;
    get timeouts(): MonitorActionRuleSuppressionTimeoutsOutputReference;
    putTimeouts(value: MonitorActionRuleSuppressionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | MonitorActionRuleSuppressionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
