import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkInterfaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#dns_servers NetworkInterface#dns_servers}
    */
    readonly dnsServers?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#edge_zone NetworkInterface#edge_zone}
    */
    readonly edgeZone?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#enable_accelerated_networking NetworkInterface#enable_accelerated_networking}
    */
    readonly enableAcceleratedNetworking?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#enable_ip_forwarding NetworkInterface#enable_ip_forwarding}
    */
    readonly enableIpForwarding?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#id NetworkInterface#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#internal_dns_name_label NetworkInterface#internal_dns_name_label}
    */
    readonly internalDnsNameLabel?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#location NetworkInterface#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#name NetworkInterface#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#resource_group_name NetworkInterface#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#tags NetworkInterface#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * ip_configuration block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#ip_configuration NetworkInterface#ip_configuration}
    */
    readonly ipConfiguration: NetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#timeouts NetworkInterface#timeouts}
    */
    readonly timeouts?: NetworkInterfaceTimeouts;
}
export interface NetworkInterfaceIpConfiguration {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#gateway_load_balancer_frontend_ip_configuration_id NetworkInterface#gateway_load_balancer_frontend_ip_configuration_id}
    */
    readonly gatewayLoadBalancerFrontendIpConfigurationId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#name NetworkInterface#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#primary NetworkInterface#primary}
    */
    readonly primary?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#private_ip_address NetworkInterface#private_ip_address}
    */
    readonly privateIpAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#private_ip_address_allocation NetworkInterface#private_ip_address_allocation}
    */
    readonly privateIpAddressAllocation: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#private_ip_address_version NetworkInterface#private_ip_address_version}
    */
    readonly privateIpAddressVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#public_ip_address_id NetworkInterface#public_ip_address_id}
    */
    readonly publicIpAddressId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#subnet_id NetworkInterface#subnet_id}
    */
    readonly subnetId?: string;
}
export declare function networkInterfaceIpConfigurationToTerraform(struct?: NetworkInterfaceIpConfiguration | cdktf.IResolvable): any;
export declare class NetworkInterfaceIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetworkInterfaceIpConfiguration | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkInterfaceIpConfiguration | cdktf.IResolvable | undefined);
    private _gatewayLoadBalancerFrontendIpConfigurationId?;
    get gatewayLoadBalancerFrontendIpConfigurationId(): string;
    set gatewayLoadBalancerFrontendIpConfigurationId(value: string);
    resetGatewayLoadBalancerFrontendIpConfigurationId(): void;
    get gatewayLoadBalancerFrontendIpConfigurationIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _primary?;
    get primary(): boolean | cdktf.IResolvable;
    set primary(value: boolean | cdktf.IResolvable);
    resetPrimary(): void;
    get primaryInput(): boolean | cdktf.IResolvable | undefined;
    private _privateIpAddress?;
    get privateIpAddress(): string;
    set privateIpAddress(value: string);
    resetPrivateIpAddress(): void;
    get privateIpAddressInput(): string | undefined;
    private _privateIpAddressAllocation?;
    get privateIpAddressAllocation(): string;
    set privateIpAddressAllocation(value: string);
    get privateIpAddressAllocationInput(): string | undefined;
    private _privateIpAddressVersion?;
    get privateIpAddressVersion(): string;
    set privateIpAddressVersion(value: string);
    resetPrivateIpAddressVersion(): void;
    get privateIpAddressVersionInput(): string | undefined;
    private _publicIpAddressId?;
    get publicIpAddressId(): string;
    set publicIpAddressId(value: string);
    resetPublicIpAddressId(): void;
    get publicIpAddressIdInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    resetSubnetId(): void;
    get subnetIdInput(): string | undefined;
}
export declare class NetworkInterfaceIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: NetworkInterfaceIpConfiguration[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetworkInterfaceIpConfigurationOutputReference;
}
export interface NetworkInterfaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#create NetworkInterface#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#delete NetworkInterface#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#read NetworkInterface#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface#update NetworkInterface#update}
    */
    readonly update?: string;
}
export declare function networkInterfaceTimeoutsToTerraform(struct?: NetworkInterfaceTimeoutsOutputReference | NetworkInterfaceTimeouts | cdktf.IResolvable): any;
export declare class NetworkInterfaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkInterfaceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: NetworkInterfaceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface azurerm_network_interface}
*/
export declare class NetworkInterface extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_network_interface";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/network_interface azurerm_network_interface} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkInterfaceConfig
    */
    constructor(scope: Construct, id: string, config: NetworkInterfaceConfig);
    get appliedDnsServers(): string[];
    private _dnsServers?;
    get dnsServers(): string[];
    set dnsServers(value: string[]);
    resetDnsServers(): void;
    get dnsServersInput(): string[] | undefined;
    private _edgeZone?;
    get edgeZone(): string;
    set edgeZone(value: string);
    resetEdgeZone(): void;
    get edgeZoneInput(): string | undefined;
    private _enableAcceleratedNetworking?;
    get enableAcceleratedNetworking(): boolean | cdktf.IResolvable;
    set enableAcceleratedNetworking(value: boolean | cdktf.IResolvable);
    resetEnableAcceleratedNetworking(): void;
    get enableAcceleratedNetworkingInput(): boolean | cdktf.IResolvable | undefined;
    private _enableIpForwarding?;
    get enableIpForwarding(): boolean | cdktf.IResolvable;
    set enableIpForwarding(value: boolean | cdktf.IResolvable);
    resetEnableIpForwarding(): void;
    get enableIpForwardingInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _internalDnsNameLabel?;
    get internalDnsNameLabel(): string;
    set internalDnsNameLabel(value: string);
    resetInternalDnsNameLabel(): void;
    get internalDnsNameLabelInput(): string | undefined;
    get internalDomainNameSuffix(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get macAddress(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    get privateIpAddresses(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get virtualMachineId(): string;
    private _ipConfiguration;
    get ipConfiguration(): NetworkInterfaceIpConfigurationList;
    putIpConfiguration(value: NetworkInterfaceIpConfiguration[] | cdktf.IResolvable): void;
    get ipConfigurationInput(): cdktf.IResolvable | NetworkInterfaceIpConfiguration[] | undefined;
    private _timeouts;
    get timeouts(): NetworkInterfaceTimeoutsOutputReference;
    putTimeouts(value: NetworkInterfaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | NetworkInterfaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
