import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ActiveDirectoryDomainServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#domain_name ActiveDirectoryDomainService#domain_name}.
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#filtered_sync_enabled ActiveDirectoryDomainService#filtered_sync_enabled}.
     *
     * @stability stable
     */
    readonly filteredSyncEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#location ActiveDirectoryDomainService#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#name ActiveDirectoryDomainService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#resource_group_name ActiveDirectoryDomainService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#sku ActiveDirectoryDomainService#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#tags ActiveDirectoryDomainService#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * initial_replica_set block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#initial_replica_set ActiveDirectoryDomainService#initial_replica_set}
     *
     * @stability stable
     */
    readonly initialReplicaSet: ActiveDirectoryDomainServiceInitialReplicaSet;
    /**
     * notifications block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#notifications ActiveDirectoryDomainService#notifications}
     *
     * @stability stable
     */
    readonly notifications?: ActiveDirectoryDomainServiceNotifications;
    /**
     * secure_ldap block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#secure_ldap ActiveDirectoryDomainService#secure_ldap}
     *
     * @stability stable
     */
    readonly secureLdap?: ActiveDirectoryDomainServiceSecureLdap;
    /**
     * security block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#security ActiveDirectoryDomainService#security}
     *
     * @stability stable
     */
    readonly security?: ActiveDirectoryDomainServiceSecurity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#timeouts ActiveDirectoryDomainService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ActiveDirectoryDomainServiceTimeouts;
}
/**
 * @stability stable
 */
export interface ActiveDirectoryDomainServiceInitialReplicaSet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#subnet_id ActiveDirectoryDomainService#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function activeDirectoryDomainServiceInitialReplicaSetToTerraform(struct?: ActiveDirectoryDomainServiceInitialReplicaSetOutputReference | ActiveDirectoryDomainServiceInitialReplicaSet): any;
/**
 * @stability stable
 */
export declare class ActiveDirectoryDomainServiceInitialReplicaSetOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ActiveDirectoryDomainServiceInitialReplicaSet | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ActiveDirectoryDomainServiceInitialReplicaSet | undefined);
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ActiveDirectoryDomainServiceNotifications {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#additional_recipients ActiveDirectoryDomainService#additional_recipients}.
     *
     * @stability stable
     */
    readonly additionalRecipients?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#notify_dc_admins ActiveDirectoryDomainService#notify_dc_admins}.
     *
     * @stability stable
     */
    readonly notifyDcAdmins?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#notify_global_admins ActiveDirectoryDomainService#notify_global_admins}.
     *
     * @stability stable
     */
    readonly notifyGlobalAdmins?: boolean | cdktf.IResolvable;
}
export declare function activeDirectoryDomainServiceNotificationsToTerraform(struct?: ActiveDirectoryDomainServiceNotificationsOutputReference | ActiveDirectoryDomainServiceNotifications): any;
/**
 * @stability stable
 */
export declare class ActiveDirectoryDomainServiceNotificationsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ActiveDirectoryDomainServiceNotifications | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ActiveDirectoryDomainServiceNotifications | undefined);
    private _additionalRecipients?;
    /**
     * @stability stable
     */
    get additionalRecipients(): string[];
    /**
     * @stability stable
     */
    set additionalRecipients(value: string[]);
    /**
     * @stability stable
     */
    resetAdditionalRecipients(): void;
    /**
     * @stability stable
     */
    get additionalRecipientsInput(): string[] | undefined;
    private _notifyDcAdmins?;
    /**
     * @stability stable
     */
    get notifyDcAdmins(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set notifyDcAdmins(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNotifyDcAdmins(): void;
    /**
     * @stability stable
     */
    get notifyDcAdminsInput(): boolean | cdktf.IResolvable | undefined;
    private _notifyGlobalAdmins?;
    /**
     * @stability stable
     */
    get notifyGlobalAdmins(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set notifyGlobalAdmins(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNotifyGlobalAdmins(): void;
    /**
     * @stability stable
     */
    get notifyGlobalAdminsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ActiveDirectoryDomainServiceSecureLdap {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#enabled ActiveDirectoryDomainService#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#external_access_enabled ActiveDirectoryDomainService#external_access_enabled}.
     *
     * @stability stable
     */
    readonly externalAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#pfx_certificate ActiveDirectoryDomainService#pfx_certificate}.
     *
     * @stability stable
     */
    readonly pfxCertificate: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#pfx_certificate_password ActiveDirectoryDomainService#pfx_certificate_password}.
     *
     * @stability stable
     */
    readonly pfxCertificatePassword: string;
}
export declare function activeDirectoryDomainServiceSecureLdapToTerraform(struct?: ActiveDirectoryDomainServiceSecureLdapOutputReference | ActiveDirectoryDomainServiceSecureLdap): any;
/**
 * @stability stable
 */
export declare class ActiveDirectoryDomainServiceSecureLdapOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ActiveDirectoryDomainServiceSecureLdap | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ActiveDirectoryDomainServiceSecureLdap | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _externalAccessEnabled?;
    /**
     * @stability stable
     */
    get externalAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set externalAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetExternalAccessEnabled(): void;
    /**
     * @stability stable
     */
    get externalAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _pfxCertificate?;
    /**
     * @stability stable
     */
    get pfxCertificate(): string;
    /**
     * @stability stable
     */
    set pfxCertificate(value: string);
    /**
     * @stability stable
     */
    get pfxCertificateInput(): string | undefined;
    private _pfxCertificatePassword?;
    /**
     * @stability stable
     */
    get pfxCertificatePassword(): string;
    /**
     * @stability stable
     */
    set pfxCertificatePassword(value: string);
    /**
     * @stability stable
     */
    get pfxCertificatePasswordInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ActiveDirectoryDomainServiceSecurity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#ntlm_v1_enabled ActiveDirectoryDomainService#ntlm_v1_enabled}.
     *
     * @stability stable
     */
    readonly ntlmV1Enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#sync_kerberos_passwords ActiveDirectoryDomainService#sync_kerberos_passwords}.
     *
     * @stability stable
     */
    readonly syncKerberosPasswords?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#sync_ntlm_passwords ActiveDirectoryDomainService#sync_ntlm_passwords}.
     *
     * @stability stable
     */
    readonly syncNtlmPasswords?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#sync_on_prem_passwords ActiveDirectoryDomainService#sync_on_prem_passwords}.
     *
     * @stability stable
     */
    readonly syncOnPremPasswords?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#tls_v1_enabled ActiveDirectoryDomainService#tls_v1_enabled}.
     *
     * @stability stable
     */
    readonly tlsV1Enabled?: boolean | cdktf.IResolvable;
}
export declare function activeDirectoryDomainServiceSecurityToTerraform(struct?: ActiveDirectoryDomainServiceSecurityOutputReference | ActiveDirectoryDomainServiceSecurity): any;
/**
 * @stability stable
 */
export declare class ActiveDirectoryDomainServiceSecurityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ActiveDirectoryDomainServiceSecurity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ActiveDirectoryDomainServiceSecurity | undefined);
    private _ntlmV1Enabled?;
    /**
     * @stability stable
     */
    get ntlmV1Enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set ntlmV1Enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNtlmV1Enabled(): void;
    /**
     * @stability stable
     */
    get ntlmV1EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _syncKerberosPasswords?;
    /**
     * @stability stable
     */
    get syncKerberosPasswords(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set syncKerberosPasswords(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSyncKerberosPasswords(): void;
    /**
     * @stability stable
     */
    get syncKerberosPasswordsInput(): boolean | cdktf.IResolvable | undefined;
    private _syncNtlmPasswords?;
    /**
     * @stability stable
     */
    get syncNtlmPasswords(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set syncNtlmPasswords(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSyncNtlmPasswords(): void;
    /**
     * @stability stable
     */
    get syncNtlmPasswordsInput(): boolean | cdktf.IResolvable | undefined;
    private _syncOnPremPasswords?;
    /**
     * @stability stable
     */
    get syncOnPremPasswords(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set syncOnPremPasswords(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSyncOnPremPasswords(): void;
    /**
     * @stability stable
     */
    get syncOnPremPasswordsInput(): boolean | cdktf.IResolvable | undefined;
    private _tlsV1Enabled?;
    /**
     * @stability stable
     */
    get tlsV1Enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tlsV1Enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTlsV1Enabled(): void;
    /**
     * @stability stable
     */
    get tlsV1EnabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ActiveDirectoryDomainServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#create ActiveDirectoryDomainService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#delete ActiveDirectoryDomainService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#read ActiveDirectoryDomainService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html#update ActiveDirectoryDomainService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function activeDirectoryDomainServiceTimeoutsToTerraform(struct?: ActiveDirectoryDomainServiceTimeoutsOutputReference | ActiveDirectoryDomainServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class ActiveDirectoryDomainServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ActiveDirectoryDomainServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ActiveDirectoryDomainServiceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html azurerm_active_directory_domain_service}.
 *
 * @stability stable
 */
export declare class ActiveDirectoryDomainService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/active_directory_domain_service.html azurerm_active_directory_domain_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ActiveDirectoryDomainServiceConfig);
    /**
     * @stability stable
     */
    get deploymentId(): string;
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    set domainName(value: string);
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    private _filteredSyncEnabled?;
    /**
     * @stability stable
     */
    get filteredSyncEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set filteredSyncEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFilteredSyncEnabled(): void;
    /**
     * @stability stable
     */
    get filteredSyncEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get resourceId(): string;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    /**
     * @stability stable
     */
    get syncOwner(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get version(): number;
    private _initialReplicaSet;
    /**
     * @stability stable
     */
    get initialReplicaSet(): ActiveDirectoryDomainServiceInitialReplicaSetOutputReference;
    /**
     * @stability stable
     */
    putInitialReplicaSet(value: ActiveDirectoryDomainServiceInitialReplicaSet): void;
    /**
     * @stability stable
     */
    get initialReplicaSetInput(): ActiveDirectoryDomainServiceInitialReplicaSet | undefined;
    private _notifications;
    /**
     * @stability stable
     */
    get notifications(): ActiveDirectoryDomainServiceNotificationsOutputReference;
    /**
     * @stability stable
     */
    putNotifications(value: ActiveDirectoryDomainServiceNotifications): void;
    /**
     * @stability stable
     */
    resetNotifications(): void;
    /**
     * @stability stable
     */
    get notificationsInput(): ActiveDirectoryDomainServiceNotifications | undefined;
    private _secureLdap;
    /**
     * @stability stable
     */
    get secureLdap(): ActiveDirectoryDomainServiceSecureLdapOutputReference;
    /**
     * @stability stable
     */
    putSecureLdap(value: ActiveDirectoryDomainServiceSecureLdap): void;
    /**
     * @stability stable
     */
    resetSecureLdap(): void;
    /**
     * @stability stable
     */
    get secureLdapInput(): ActiveDirectoryDomainServiceSecureLdap | undefined;
    private _security;
    /**
     * @stability stable
     */
    get security(): ActiveDirectoryDomainServiceSecurityOutputReference;
    /**
     * @stability stable
     */
    putSecurity(value: ActiveDirectoryDomainServiceSecurity): void;
    /**
     * @stability stable
     */
    resetSecurity(): void;
    /**
     * @stability stable
     */
    get securityInput(): ActiveDirectoryDomainServiceSecurity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ActiveDirectoryDomainServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ActiveDirectoryDomainServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ActiveDirectoryDomainServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
