import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementNotificationRecipientUserConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_user.html#api_management_id ApiManagementNotificationRecipientUser#api_management_id}.
     *
     * @stability stable
     */
    readonly apiManagementId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_user.html#notification_type ApiManagementNotificationRecipientUser#notification_type}.
     *
     * @stability stable
     */
    readonly notificationType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_user.html#user_id ApiManagementNotificationRecipientUser#user_id}.
     *
     * @stability stable
     */
    readonly userId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_user.html#timeouts ApiManagementNotificationRecipientUser#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementNotificationRecipientUserTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementNotificationRecipientUserTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_user.html#create ApiManagementNotificationRecipientUser#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_user.html#delete ApiManagementNotificationRecipientUser#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_user.html#read ApiManagementNotificationRecipientUser#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function apiManagementNotificationRecipientUserTimeoutsToTerraform(struct?: ApiManagementNotificationRecipientUserTimeoutsOutputReference | ApiManagementNotificationRecipientUserTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementNotificationRecipientUserTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementNotificationRecipientUserTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementNotificationRecipientUserTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_user.html azurerm_api_management_notification_recipient_user}.
 *
 * @stability stable
 */
export declare class ApiManagementNotificationRecipientUser extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_notification_recipient_user.html azurerm_api_management_notification_recipient_user} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementNotificationRecipientUserConfig);
    private _apiManagementId?;
    /**
     * @stability stable
     */
    get apiManagementId(): string;
    /**
     * @stability stable
     */
    set apiManagementId(value: string);
    /**
     * @stability stable
     */
    get apiManagementIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _notificationType?;
    /**
     * @stability stable
     */
    get notificationType(): string;
    /**
     * @stability stable
     */
    set notificationType(value: string);
    /**
     * @stability stable
     */
    get notificationTypeInput(): string | undefined;
    private _userId?;
    /**
     * @stability stable
     */
    get userId(): string;
    /**
     * @stability stable
     */
    set userId(value: string);
    /**
     * @stability stable
     */
    get userIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementNotificationRecipientUserTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementNotificationRecipientUserTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementNotificationRecipientUserTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
