import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServiceSlotConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#app_service_name AppServiceSlot#app_service_name}.
     *
     * @stability stable
     */
    readonly appServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#app_service_plan_id AppServiceSlot#app_service_plan_id}.
     *
     * @stability stable
     */
    readonly appServicePlanId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#app_settings AppServiceSlot#app_settings}.
     *
     * @stability stable
     */
    readonly appSettings?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#client_affinity_enabled AppServiceSlot#client_affinity_enabled}.
     *
     * @stability stable
     */
    readonly clientAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#enabled AppServiceSlot#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#https_only AppServiceSlot#https_only}.
     *
     * @stability stable
     */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#key_vault_reference_identity_id AppServiceSlot#key_vault_reference_identity_id}.
     *
     * @stability stable
     */
    readonly keyVaultReferenceIdentityId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#location AppServiceSlot#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#name AppServiceSlot#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#resource_group_name AppServiceSlot#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#tags AppServiceSlot#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * auth_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#auth_settings AppServiceSlot#auth_settings}
     *
     * @stability stable
     */
    readonly authSettings?: AppServiceSlotAuthSettings;
    /**
     * connection_string block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#connection_string AppServiceSlot#connection_string}
     *
     * @stability stable
     */
    readonly connectionString?: AppServiceSlotConnectionString[];
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#identity AppServiceSlot#identity}
     *
     * @stability stable
     */
    readonly identity?: AppServiceSlotIdentity;
    /**
     * logs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#logs AppServiceSlot#logs}
     *
     * @stability stable
     */
    readonly logs?: AppServiceSlotLogs;
    /**
     * site_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#site_config AppServiceSlot#site_config}
     *
     * @stability stable
     */
    readonly siteConfig?: AppServiceSlotSiteConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#timeouts AppServiceSlot#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServiceSlotTimeouts;
}
/**
 * @stability stable
 */
export declare class AppServiceSlotSiteCredential extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export interface AppServiceSlotAuthSettingsActiveDirectory {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#allowed_audiences AppServiceSlot#allowed_audiences}.
     *
     * @stability stable
     */
    readonly allowedAudiences?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#client_id AppServiceSlot#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#client_secret AppServiceSlot#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret?: string;
}
export declare function appServiceSlotAuthSettingsActiveDirectoryToTerraform(struct?: AppServiceSlotAuthSettingsActiveDirectoryOutputReference | AppServiceSlotAuthSettingsActiveDirectory): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotAuthSettingsActiveDirectory | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotAuthSettingsActiveDirectory | undefined);
    private _allowedAudiences?;
    /**
     * @stability stable
     */
    get allowedAudiences(): string[];
    /**
     * @stability stable
     */
    set allowedAudiences(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedAudiences(): void;
    /**
     * @stability stable
     */
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    resetClientSecret(): void;
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotAuthSettingsFacebook {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#app_id AppServiceSlot#app_id}.
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#app_secret AppServiceSlot#app_secret}.
     *
     * @stability stable
     */
    readonly appSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#oauth_scopes AppServiceSlot#oauth_scopes}.
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
}
export declare function appServiceSlotAuthSettingsFacebookToTerraform(struct?: AppServiceSlotAuthSettingsFacebookOutputReference | AppServiceSlotAuthSettingsFacebook): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotAuthSettingsFacebook | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotAuthSettingsFacebook | undefined);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    private _appSecret?;
    /**
     * @stability stable
     */
    get appSecret(): string;
    /**
     * @stability stable
     */
    set appSecret(value: string);
    /**
     * @stability stable
     */
    get appSecretInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotAuthSettingsGoogle {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#client_id AppServiceSlot#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#client_secret AppServiceSlot#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#oauth_scopes AppServiceSlot#oauth_scopes}.
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
}
export declare function appServiceSlotAuthSettingsGoogleToTerraform(struct?: AppServiceSlotAuthSettingsGoogleOutputReference | AppServiceSlotAuthSettingsGoogle): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotAuthSettingsGoogle | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotAuthSettingsGoogle | undefined);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotAuthSettingsMicrosoft {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#client_id AppServiceSlot#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#client_secret AppServiceSlot#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#oauth_scopes AppServiceSlot#oauth_scopes}.
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
}
export declare function appServiceSlotAuthSettingsMicrosoftToTerraform(struct?: AppServiceSlotAuthSettingsMicrosoftOutputReference | AppServiceSlotAuthSettingsMicrosoft): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotAuthSettingsMicrosoft | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotAuthSettingsMicrosoft | undefined);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotAuthSettingsTwitter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#consumer_key AppServiceSlot#consumer_key}.
     *
     * @stability stable
     */
    readonly consumerKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#consumer_secret AppServiceSlot#consumer_secret}.
     *
     * @stability stable
     */
    readonly consumerSecret: string;
}
export declare function appServiceSlotAuthSettingsTwitterToTerraform(struct?: AppServiceSlotAuthSettingsTwitterOutputReference | AppServiceSlotAuthSettingsTwitter): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotAuthSettingsTwitter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotAuthSettingsTwitter | undefined);
    private _consumerKey?;
    /**
     * @stability stable
     */
    get consumerKey(): string;
    /**
     * @stability stable
     */
    set consumerKey(value: string);
    /**
     * @stability stable
     */
    get consumerKeyInput(): string | undefined;
    private _consumerSecret?;
    /**
     * @stability stable
     */
    get consumerSecret(): string;
    /**
     * @stability stable
     */
    set consumerSecret(value: string);
    /**
     * @stability stable
     */
    get consumerSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotAuthSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#additional_login_params AppServiceSlot#additional_login_params}.
     *
     * @stability stable
     */
    readonly additionalLoginParams?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#allowed_external_redirect_urls AppServiceSlot#allowed_external_redirect_urls}.
     *
     * @stability stable
     */
    readonly allowedExternalRedirectUrls?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#default_provider AppServiceSlot#default_provider}.
     *
     * @stability stable
     */
    readonly defaultProvider?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#enabled AppServiceSlot#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#issuer AppServiceSlot#issuer}.
     *
     * @stability stable
     */
    readonly issuer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#runtime_version AppServiceSlot#runtime_version}.
     *
     * @stability stable
     */
    readonly runtimeVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#token_refresh_extension_hours AppServiceSlot#token_refresh_extension_hours}.
     *
     * @stability stable
     */
    readonly tokenRefreshExtensionHours?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#token_store_enabled AppServiceSlot#token_store_enabled}.
     *
     * @stability stable
     */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#unauthenticated_client_action AppServiceSlot#unauthenticated_client_action}.
     *
     * @stability stable
     */
    readonly unauthenticatedClientAction?: string;
    /**
     * active_directory block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#active_directory AppServiceSlot#active_directory}
     *
     * @stability stable
     */
    readonly activeDirectory?: AppServiceSlotAuthSettingsActiveDirectory;
    /**
     * facebook block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#facebook AppServiceSlot#facebook}
     *
     * @stability stable
     */
    readonly facebook?: AppServiceSlotAuthSettingsFacebook;
    /**
     * google block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#google AppServiceSlot#google}
     *
     * @stability stable
     */
    readonly google?: AppServiceSlotAuthSettingsGoogle;
    /**
     * microsoft block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#microsoft AppServiceSlot#microsoft}
     *
     * @stability stable
     */
    readonly microsoft?: AppServiceSlotAuthSettingsMicrosoft;
    /**
     * twitter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#twitter AppServiceSlot#twitter}
     *
     * @stability stable
     */
    readonly twitter?: AppServiceSlotAuthSettingsTwitter;
}
export declare function appServiceSlotAuthSettingsToTerraform(struct?: AppServiceSlotAuthSettingsOutputReference | AppServiceSlotAuthSettings): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotAuthSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotAuthSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotAuthSettings | undefined);
    private _additionalLoginParams?;
    /**
     * @stability stable
     */
    get additionalLoginParams(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalLoginParams(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalLoginParams(): void;
    /**
     * @stability stable
     */
    get additionalLoginParamsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _allowedExternalRedirectUrls?;
    /**
     * @stability stable
     */
    get allowedExternalRedirectUrls(): string[];
    /**
     * @stability stable
     */
    set allowedExternalRedirectUrls(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedExternalRedirectUrls(): void;
    /**
     * @stability stable
     */
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _defaultProvider?;
    /**
     * @stability stable
     */
    get defaultProvider(): string;
    /**
     * @stability stable
     */
    set defaultProvider(value: string);
    /**
     * @stability stable
     */
    resetDefaultProvider(): void;
    /**
     * @stability stable
     */
    get defaultProviderInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    set issuer(value: string);
    /**
     * @stability stable
     */
    resetIssuer(): void;
    /**
     * @stability stable
     */
    get issuerInput(): string | undefined;
    private _runtimeVersion?;
    /**
     * @stability stable
     */
    get runtimeVersion(): string;
    /**
     * @stability stable
     */
    set runtimeVersion(value: string);
    /**
     * @stability stable
     */
    resetRuntimeVersion(): void;
    /**
     * @stability stable
     */
    get runtimeVersionInput(): string | undefined;
    private _tokenRefreshExtensionHours?;
    /**
     * @stability stable
     */
    get tokenRefreshExtensionHours(): number;
    /**
     * @stability stable
     */
    set tokenRefreshExtensionHours(value: number);
    /**
     * @stability stable
     */
    resetTokenRefreshExtensionHours(): void;
    /**
     * @stability stable
     */
    get tokenRefreshExtensionHoursInput(): number | undefined;
    private _tokenStoreEnabled?;
    /**
     * @stability stable
     */
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTokenStoreEnabled(): void;
    /**
     * @stability stable
     */
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _unauthenticatedClientAction?;
    /**
     * @stability stable
     */
    get unauthenticatedClientAction(): string;
    /**
     * @stability stable
     */
    set unauthenticatedClientAction(value: string);
    /**
     * @stability stable
     */
    resetUnauthenticatedClientAction(): void;
    /**
     * @stability stable
     */
    get unauthenticatedClientActionInput(): string | undefined;
    private _activeDirectory;
    /**
     * @stability stable
     */
    get activeDirectory(): AppServiceSlotAuthSettingsActiveDirectoryOutputReference;
    /**
     * @stability stable
     */
    putActiveDirectory(value: AppServiceSlotAuthSettingsActiveDirectory): void;
    /**
     * @stability stable
     */
    resetActiveDirectory(): void;
    /**
     * @stability stable
     */
    get activeDirectoryInput(): AppServiceSlotAuthSettingsActiveDirectory | undefined;
    private _facebook;
    /**
     * @stability stable
     */
    get facebook(): AppServiceSlotAuthSettingsFacebookOutputReference;
    /**
     * @stability stable
     */
    putFacebook(value: AppServiceSlotAuthSettingsFacebook): void;
    /**
     * @stability stable
     */
    resetFacebook(): void;
    /**
     * @stability stable
     */
    get facebookInput(): AppServiceSlotAuthSettingsFacebook | undefined;
    private _google;
    /**
     * @stability stable
     */
    get google(): AppServiceSlotAuthSettingsGoogleOutputReference;
    /**
     * @stability stable
     */
    putGoogle(value: AppServiceSlotAuthSettingsGoogle): void;
    /**
     * @stability stable
     */
    resetGoogle(): void;
    /**
     * @stability stable
     */
    get googleInput(): AppServiceSlotAuthSettingsGoogle | undefined;
    private _microsoft;
    /**
     * @stability stable
     */
    get microsoft(): AppServiceSlotAuthSettingsMicrosoftOutputReference;
    /**
     * @stability stable
     */
    putMicrosoft(value: AppServiceSlotAuthSettingsMicrosoft): void;
    /**
     * @stability stable
     */
    resetMicrosoft(): void;
    /**
     * @stability stable
     */
    get microsoftInput(): AppServiceSlotAuthSettingsMicrosoft | undefined;
    private _twitter;
    /**
     * @stability stable
     */
    get twitter(): AppServiceSlotAuthSettingsTwitterOutputReference;
    /**
     * @stability stable
     */
    putTwitter(value: AppServiceSlotAuthSettingsTwitter): void;
    /**
     * @stability stable
     */
    resetTwitter(): void;
    /**
     * @stability stable
     */
    get twitterInput(): AppServiceSlotAuthSettingsTwitter | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotConnectionString {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#name AppServiceSlot#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#type AppServiceSlot#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#value AppServiceSlot#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function appServiceSlotConnectionStringToTerraform(struct?: AppServiceSlotConnectionString): any;
/**
 * @stability stable
 */
export interface AppServiceSlotIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#identity_ids AppServiceSlot#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#type AppServiceSlot#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function appServiceSlotIdentityToTerraform(struct?: AppServiceSlotIdentityOutputReference | AppServiceSlotIdentity): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotLogsApplicationLogsAzureBlobStorage {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#level AppServiceSlot#level}.
     *
     * @stability stable
     */
    readonly level: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#retention_in_days AppServiceSlot#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#sas_url AppServiceSlot#sas_url}.
     *
     * @stability stable
     */
    readonly sasUrl: string;
}
export declare function appServiceSlotLogsApplicationLogsAzureBlobStorageToTerraform(struct?: AppServiceSlotLogsApplicationLogsAzureBlobStorageOutputReference | AppServiceSlotLogsApplicationLogsAzureBlobStorage): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotLogsApplicationLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotLogsApplicationLogsAzureBlobStorage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotLogsApplicationLogsAzureBlobStorage | undefined);
    private _level?;
    /**
     * @stability stable
     */
    get level(): string;
    /**
     * @stability stable
     */
    set level(value: string);
    /**
     * @stability stable
     */
    get levelInput(): string | undefined;
    private _retentionInDays?;
    /**
     * @stability stable
     */
    get retentionInDays(): number;
    /**
     * @stability stable
     */
    set retentionInDays(value: number);
    /**
     * @stability stable
     */
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    /**
     * @stability stable
     */
    get sasUrl(): string;
    /**
     * @stability stable
     */
    set sasUrl(value: string);
    /**
     * @stability stable
     */
    get sasUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotLogsApplicationLogs {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#file_system_level AppServiceSlot#file_system_level}.
     *
     * @stability stable
     */
    readonly fileSystemLevel?: string;
    /**
     * azure_blob_storage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#azure_blob_storage AppServiceSlot#azure_blob_storage}
     *
     * @stability stable
     */
    readonly azureBlobStorage?: AppServiceSlotLogsApplicationLogsAzureBlobStorage;
}
export declare function appServiceSlotLogsApplicationLogsToTerraform(struct?: AppServiceSlotLogsApplicationLogsOutputReference | AppServiceSlotLogsApplicationLogs): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotLogsApplicationLogsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotLogsApplicationLogs | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotLogsApplicationLogs | undefined);
    private _fileSystemLevel?;
    /**
     * @stability stable
     */
    get fileSystemLevel(): string;
    /**
     * @stability stable
     */
    set fileSystemLevel(value: string);
    /**
     * @stability stable
     */
    resetFileSystemLevel(): void;
    /**
     * @stability stable
     */
    get fileSystemLevelInput(): string | undefined;
    private _azureBlobStorage;
    /**
     * @stability stable
     */
    get azureBlobStorage(): AppServiceSlotLogsApplicationLogsAzureBlobStorageOutputReference;
    /**
     * @stability stable
     */
    putAzureBlobStorage(value: AppServiceSlotLogsApplicationLogsAzureBlobStorage): void;
    /**
     * @stability stable
     */
    resetAzureBlobStorage(): void;
    /**
     * @stability stable
     */
    get azureBlobStorageInput(): AppServiceSlotLogsApplicationLogsAzureBlobStorage | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotLogsHttpLogsAzureBlobStorage {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#retention_in_days AppServiceSlot#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#sas_url AppServiceSlot#sas_url}.
     *
     * @stability stable
     */
    readonly sasUrl: string;
}
export declare function appServiceSlotLogsHttpLogsAzureBlobStorageToTerraform(struct?: AppServiceSlotLogsHttpLogsAzureBlobStorageOutputReference | AppServiceSlotLogsHttpLogsAzureBlobStorage): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotLogsHttpLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotLogsHttpLogsAzureBlobStorage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotLogsHttpLogsAzureBlobStorage | undefined);
    private _retentionInDays?;
    /**
     * @stability stable
     */
    get retentionInDays(): number;
    /**
     * @stability stable
     */
    set retentionInDays(value: number);
    /**
     * @stability stable
     */
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    /**
     * @stability stable
     */
    get sasUrl(): string;
    /**
     * @stability stable
     */
    set sasUrl(value: string);
    /**
     * @stability stable
     */
    get sasUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotLogsHttpLogsFileSystem {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#retention_in_days AppServiceSlot#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#retention_in_mb AppServiceSlot#retention_in_mb}.
     *
     * @stability stable
     */
    readonly retentionInMb: number;
}
export declare function appServiceSlotLogsHttpLogsFileSystemToTerraform(struct?: AppServiceSlotLogsHttpLogsFileSystemOutputReference | AppServiceSlotLogsHttpLogsFileSystem): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotLogsHttpLogsFileSystemOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotLogsHttpLogsFileSystem | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotLogsHttpLogsFileSystem | undefined);
    private _retentionInDays?;
    /**
     * @stability stable
     */
    get retentionInDays(): number;
    /**
     * @stability stable
     */
    set retentionInDays(value: number);
    /**
     * @stability stable
     */
    get retentionInDaysInput(): number | undefined;
    private _retentionInMb?;
    /**
     * @stability stable
     */
    get retentionInMb(): number;
    /**
     * @stability stable
     */
    set retentionInMb(value: number);
    /**
     * @stability stable
     */
    get retentionInMbInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotLogsHttpLogs {
    /**
     * azure_blob_storage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#azure_blob_storage AppServiceSlot#azure_blob_storage}
     *
     * @stability stable
     */
    readonly azureBlobStorage?: AppServiceSlotLogsHttpLogsAzureBlobStorage;
    /**
     * file_system block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#file_system AppServiceSlot#file_system}
     *
     * @stability stable
     */
    readonly fileSystem?: AppServiceSlotLogsHttpLogsFileSystem;
}
export declare function appServiceSlotLogsHttpLogsToTerraform(struct?: AppServiceSlotLogsHttpLogsOutputReference | AppServiceSlotLogsHttpLogs): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotLogsHttpLogsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotLogsHttpLogs | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotLogsHttpLogs | undefined);
    private _azureBlobStorage;
    /**
     * @stability stable
     */
    get azureBlobStorage(): AppServiceSlotLogsHttpLogsAzureBlobStorageOutputReference;
    /**
     * @stability stable
     */
    putAzureBlobStorage(value: AppServiceSlotLogsHttpLogsAzureBlobStorage): void;
    /**
     * @stability stable
     */
    resetAzureBlobStorage(): void;
    /**
     * @stability stable
     */
    get azureBlobStorageInput(): AppServiceSlotLogsHttpLogsAzureBlobStorage | undefined;
    private _fileSystem;
    /**
     * @stability stable
     */
    get fileSystem(): AppServiceSlotLogsHttpLogsFileSystemOutputReference;
    /**
     * @stability stable
     */
    putFileSystem(value: AppServiceSlotLogsHttpLogsFileSystem): void;
    /**
     * @stability stable
     */
    resetFileSystem(): void;
    /**
     * @stability stable
     */
    get fileSystemInput(): AppServiceSlotLogsHttpLogsFileSystem | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotLogs {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#detailed_error_messages_enabled AppServiceSlot#detailed_error_messages_enabled}.
     *
     * @stability stable
     */
    readonly detailedErrorMessagesEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#failed_request_tracing_enabled AppServiceSlot#failed_request_tracing_enabled}.
     *
     * @stability stable
     */
    readonly failedRequestTracingEnabled?: boolean | cdktf.IResolvable;
    /**
     * application_logs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#application_logs AppServiceSlot#application_logs}
     *
     * @stability stable
     */
    readonly applicationLogs?: AppServiceSlotLogsApplicationLogs;
    /**
     * http_logs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#http_logs AppServiceSlot#http_logs}
     *
     * @stability stable
     */
    readonly httpLogs?: AppServiceSlotLogsHttpLogs;
}
export declare function appServiceSlotLogsToTerraform(struct?: AppServiceSlotLogsOutputReference | AppServiceSlotLogs): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotLogsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotLogs | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotLogs | undefined);
    private _detailedErrorMessagesEnabled?;
    /**
     * @stability stable
     */
    get detailedErrorMessagesEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set detailedErrorMessagesEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDetailedErrorMessagesEnabled(): void;
    /**
     * @stability stable
     */
    get detailedErrorMessagesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _failedRequestTracingEnabled?;
    /**
     * @stability stable
     */
    get failedRequestTracingEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set failedRequestTracingEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFailedRequestTracingEnabled(): void;
    /**
     * @stability stable
     */
    get failedRequestTracingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _applicationLogs;
    /**
     * @stability stable
     */
    get applicationLogs(): AppServiceSlotLogsApplicationLogsOutputReference;
    /**
     * @stability stable
     */
    putApplicationLogs(value: AppServiceSlotLogsApplicationLogs): void;
    /**
     * @stability stable
     */
    resetApplicationLogs(): void;
    /**
     * @stability stable
     */
    get applicationLogsInput(): AppServiceSlotLogsApplicationLogs | undefined;
    private _httpLogs;
    /**
     * @stability stable
     */
    get httpLogs(): AppServiceSlotLogsHttpLogsOutputReference;
    /**
     * @stability stable
     */
    putHttpLogs(value: AppServiceSlotLogsHttpLogs): void;
    /**
     * @stability stable
     */
    resetHttpLogs(): void;
    /**
     * @stability stable
     */
    get httpLogsInput(): AppServiceSlotLogsHttpLogs | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotSiteConfigIpRestrictionHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#x_azure_fdid AppServiceSlot#x_azure_fdid}.
     *
     * @stability stable
     */
    readonly xAzureFdid?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#x_fd_health_probe AppServiceSlot#x_fd_health_probe}.
     *
     * @stability stable
     */
    readonly xFdHealthProbe?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#x_forwarded_for AppServiceSlot#x_forwarded_for}.
     *
     * @stability stable
     */
    readonly xForwardedFor?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#x_forwarded_host AppServiceSlot#x_forwarded_host}.
     *
     * @stability stable
     */
    readonly xForwardedHost?: string[];
}
export declare function appServiceSlotSiteConfigIpRestrictionHeadersToTerraform(struct?: AppServiceSlotSiteConfigIpRestrictionHeaders): any;
/**
 * @stability stable
 */
export interface AppServiceSlotSiteConfigIpRestriction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#action AppServiceSlot#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#headers AppServiceSlot#headers}.
     *
     * @stability stable
     */
    readonly headers?: AppServiceSlotSiteConfigIpRestrictionHeaders[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#ip_address AppServiceSlot#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#name AppServiceSlot#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#priority AppServiceSlot#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#service_tag AppServiceSlot#service_tag}.
     *
     * @stability stable
     */
    readonly serviceTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#virtual_network_subnet_id AppServiceSlot#virtual_network_subnet_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetId?: string;
}
export declare function appServiceSlotSiteConfigIpRestrictionToTerraform(struct?: AppServiceSlotSiteConfigIpRestriction): any;
/**
 * @stability stable
 */
export interface AppServiceSlotSiteConfigScmIpRestrictionHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#x_azure_fdid AppServiceSlot#x_azure_fdid}.
     *
     * @stability stable
     */
    readonly xAzureFdid?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#x_fd_health_probe AppServiceSlot#x_fd_health_probe}.
     *
     * @stability stable
     */
    readonly xFdHealthProbe?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#x_forwarded_for AppServiceSlot#x_forwarded_for}.
     *
     * @stability stable
     */
    readonly xForwardedFor?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#x_forwarded_host AppServiceSlot#x_forwarded_host}.
     *
     * @stability stable
     */
    readonly xForwardedHost?: string[];
}
export declare function appServiceSlotSiteConfigScmIpRestrictionHeadersToTerraform(struct?: AppServiceSlotSiteConfigScmIpRestrictionHeaders): any;
/**
 * @stability stable
 */
export interface AppServiceSlotSiteConfigScmIpRestriction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#action AppServiceSlot#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#headers AppServiceSlot#headers}.
     *
     * @stability stable
     */
    readonly headers?: AppServiceSlotSiteConfigScmIpRestrictionHeaders[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#ip_address AppServiceSlot#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#name AppServiceSlot#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#priority AppServiceSlot#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#service_tag AppServiceSlot#service_tag}.
     *
     * @stability stable
     */
    readonly serviceTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#virtual_network_subnet_id AppServiceSlot#virtual_network_subnet_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetId?: string;
}
export declare function appServiceSlotSiteConfigScmIpRestrictionToTerraform(struct?: AppServiceSlotSiteConfigScmIpRestriction): any;
/**
 * @stability stable
 */
export interface AppServiceSlotSiteConfigCors {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#allowed_origins AppServiceSlot#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#support_credentials AppServiceSlot#support_credentials}.
     *
     * @stability stable
     */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function appServiceSlotSiteConfigCorsToTerraform(struct?: AppServiceSlotSiteConfigCorsOutputReference | AppServiceSlotSiteConfigCors): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotSiteConfigCors | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotSiteConfigCors | undefined);
    private _allowedOrigins?;
    /**
     * @stability stable
     */
    get allowedOrigins(): string[];
    /**
     * @stability stable
     */
    set allowedOrigins(value: string[]);
    /**
     * @stability stable
     */
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    /**
     * @stability stable
     */
    get supportCredentials(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set supportCredentials(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSupportCredentials(): void;
    /**
     * @stability stable
     */
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotSiteConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#acr_use_managed_identity_credentials AppServiceSlot#acr_use_managed_identity_credentials}.
     *
     * @stability stable
     */
    readonly acrUseManagedIdentityCredentials?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#acr_user_managed_identity_client_id AppServiceSlot#acr_user_managed_identity_client_id}.
     *
     * @stability stable
     */
    readonly acrUserManagedIdentityClientId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#always_on AppServiceSlot#always_on}.
     *
     * @stability stable
     */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#app_command_line AppServiceSlot#app_command_line}.
     *
     * @stability stable
     */
    readonly appCommandLine?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#auto_swap_slot_name AppServiceSlot#auto_swap_slot_name}.
     *
     * @stability stable
     */
    readonly autoSwapSlotName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#default_documents AppServiceSlot#default_documents}.
     *
     * @stability stable
     */
    readonly defaultDocuments?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#dotnet_framework_version AppServiceSlot#dotnet_framework_version}.
     *
     * @stability stable
     */
    readonly dotnetFrameworkVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#ftps_state AppServiceSlot#ftps_state}.
     *
     * @stability stable
     */
    readonly ftpsState?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#health_check_path AppServiceSlot#health_check_path}.
     *
     * @stability stable
     */
    readonly healthCheckPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#http2_enabled AppServiceSlot#http2_enabled}.
     *
     * @stability stable
     */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#ip_restriction AppServiceSlot#ip_restriction}.
     *
     * @stability stable
     */
    readonly ipRestriction?: AppServiceSlotSiteConfigIpRestriction[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#java_container AppServiceSlot#java_container}.
     *
     * @stability stable
     */
    readonly javaContainer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#java_container_version AppServiceSlot#java_container_version}.
     *
     * @stability stable
     */
    readonly javaContainerVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#java_version AppServiceSlot#java_version}.
     *
     * @stability stable
     */
    readonly javaVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#linux_fx_version AppServiceSlot#linux_fx_version}.
     *
     * @stability stable
     */
    readonly linuxFxVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#local_mysql_enabled AppServiceSlot#local_mysql_enabled}.
     *
     * @stability stable
     */
    readonly localMysqlEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#managed_pipeline_mode AppServiceSlot#managed_pipeline_mode}.
     *
     * @stability stable
     */
    readonly managedPipelineMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#min_tls_version AppServiceSlot#min_tls_version}.
     *
     * @stability stable
     */
    readonly minTlsVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#number_of_workers AppServiceSlot#number_of_workers}.
     *
     * @stability stable
     */
    readonly numberOfWorkers?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#php_version AppServiceSlot#php_version}.
     *
     * @stability stable
     */
    readonly phpVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#python_version AppServiceSlot#python_version}.
     *
     * @stability stable
     */
    readonly pythonVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#remote_debugging_enabled AppServiceSlot#remote_debugging_enabled}.
     *
     * @stability stable
     */
    readonly remoteDebuggingEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#remote_debugging_version AppServiceSlot#remote_debugging_version}.
     *
     * @stability stable
     */
    readonly remoteDebuggingVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#scm_ip_restriction AppServiceSlot#scm_ip_restriction}.
     *
     * @stability stable
     */
    readonly scmIpRestriction?: AppServiceSlotSiteConfigScmIpRestriction[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#scm_type AppServiceSlot#scm_type}.
     *
     * @stability stable
     */
    readonly scmType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#scm_use_main_ip_restriction AppServiceSlot#scm_use_main_ip_restriction}.
     *
     * @stability stable
     */
    readonly scmUseMainIpRestriction?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#use_32_bit_worker_process AppServiceSlot#use_32_bit_worker_process}.
     *
     * @stability stable
     */
    readonly use32BitWorkerProcess?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#vnet_route_all_enabled AppServiceSlot#vnet_route_all_enabled}.
     *
     * @stability stable
     */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#websockets_enabled AppServiceSlot#websockets_enabled}.
     *
     * @stability stable
     */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#windows_fx_version AppServiceSlot#windows_fx_version}.
     *
     * @stability stable
     */
    readonly windowsFxVersion?: string;
    /**
     * cors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#cors AppServiceSlot#cors}
     *
     * @stability stable
     */
    readonly cors?: AppServiceSlotSiteConfigCors;
}
export declare function appServiceSlotSiteConfigToTerraform(struct?: AppServiceSlotSiteConfigOutputReference | AppServiceSlotSiteConfig): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotSiteConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotSiteConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotSiteConfig | undefined);
    private _acrUseManagedIdentityCredentials?;
    /**
     * @stability stable
     */
    get acrUseManagedIdentityCredentials(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set acrUseManagedIdentityCredentials(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAcrUseManagedIdentityCredentials(): void;
    /**
     * @stability stable
     */
    get acrUseManagedIdentityCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _acrUserManagedIdentityClientId?;
    /**
     * @stability stable
     */
    get acrUserManagedIdentityClientId(): string;
    /**
     * @stability stable
     */
    set acrUserManagedIdentityClientId(value: string);
    /**
     * @stability stable
     */
    resetAcrUserManagedIdentityClientId(): void;
    /**
     * @stability stable
     */
    get acrUserManagedIdentityClientIdInput(): string | undefined;
    private _alwaysOn?;
    /**
     * @stability stable
     */
    get alwaysOn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alwaysOn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAlwaysOn(): void;
    /**
     * @stability stable
     */
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _appCommandLine?;
    /**
     * @stability stable
     */
    get appCommandLine(): string;
    /**
     * @stability stable
     */
    set appCommandLine(value: string);
    /**
     * @stability stable
     */
    resetAppCommandLine(): void;
    /**
     * @stability stable
     */
    get appCommandLineInput(): string | undefined;
    private _autoSwapSlotName?;
    /**
     * @stability stable
     */
    get autoSwapSlotName(): string;
    /**
     * @stability stable
     */
    set autoSwapSlotName(value: string);
    /**
     * @stability stable
     */
    resetAutoSwapSlotName(): void;
    /**
     * @stability stable
     */
    get autoSwapSlotNameInput(): string | undefined;
    private _defaultDocuments?;
    /**
     * @stability stable
     */
    get defaultDocuments(): string[];
    /**
     * @stability stable
     */
    set defaultDocuments(value: string[]);
    /**
     * @stability stable
     */
    resetDefaultDocuments(): void;
    /**
     * @stability stable
     */
    get defaultDocumentsInput(): string[] | undefined;
    private _dotnetFrameworkVersion?;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersion(): string;
    /**
     * @stability stable
     */
    set dotnetFrameworkVersion(value: string);
    /**
     * @stability stable
     */
    resetDotnetFrameworkVersion(): void;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersionInput(): string | undefined;
    private _ftpsState?;
    /**
     * @stability stable
     */
    get ftpsState(): string;
    /**
     * @stability stable
     */
    set ftpsState(value: string);
    /**
     * @stability stable
     */
    resetFtpsState(): void;
    /**
     * @stability stable
     */
    get ftpsStateInput(): string | undefined;
    private _healthCheckPath?;
    /**
     * @stability stable
     */
    get healthCheckPath(): string;
    /**
     * @stability stable
     */
    set healthCheckPath(value: string);
    /**
     * @stability stable
     */
    resetHealthCheckPath(): void;
    /**
     * @stability stable
     */
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    /**
     * @stability stable
     */
    get http2Enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set http2Enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttp2Enabled(): void;
    /**
     * @stability stable
     */
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestriction?;
    /**
     * @stability stable
     */
    get ipRestriction(): AppServiceSlotSiteConfigIpRestriction[];
    /**
     * @stability stable
     */
    set ipRestriction(value: AppServiceSlotSiteConfigIpRestriction[]);
    /**
     * @stability stable
     */
    resetIpRestriction(): void;
    /**
     * @stability stable
     */
    get ipRestrictionInput(): AppServiceSlotSiteConfigIpRestriction[] | undefined;
    private _javaContainer?;
    /**
     * @stability stable
     */
    get javaContainer(): string;
    /**
     * @stability stable
     */
    set javaContainer(value: string);
    /**
     * @stability stable
     */
    resetJavaContainer(): void;
    /**
     * @stability stable
     */
    get javaContainerInput(): string | undefined;
    private _javaContainerVersion?;
    /**
     * @stability stable
     */
    get javaContainerVersion(): string;
    /**
     * @stability stable
     */
    set javaContainerVersion(value: string);
    /**
     * @stability stable
     */
    resetJavaContainerVersion(): void;
    /**
     * @stability stable
     */
    get javaContainerVersionInput(): string | undefined;
    private _javaVersion?;
    /**
     * @stability stable
     */
    get javaVersion(): string;
    /**
     * @stability stable
     */
    set javaVersion(value: string);
    /**
     * @stability stable
     */
    resetJavaVersion(): void;
    /**
     * @stability stable
     */
    get javaVersionInput(): string | undefined;
    private _linuxFxVersion?;
    /**
     * @stability stable
     */
    get linuxFxVersion(): string;
    /**
     * @stability stable
     */
    set linuxFxVersion(value: string);
    /**
     * @stability stable
     */
    resetLinuxFxVersion(): void;
    /**
     * @stability stable
     */
    get linuxFxVersionInput(): string | undefined;
    private _localMysqlEnabled?;
    /**
     * @stability stable
     */
    get localMysqlEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set localMysqlEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocalMysqlEnabled(): void;
    /**
     * @stability stable
     */
    get localMysqlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _managedPipelineMode?;
    /**
     * @stability stable
     */
    get managedPipelineMode(): string;
    /**
     * @stability stable
     */
    set managedPipelineMode(value: string);
    /**
     * @stability stable
     */
    resetManagedPipelineMode(): void;
    /**
     * @stability stable
     */
    get managedPipelineModeInput(): string | undefined;
    private _minTlsVersion?;
    /**
     * @stability stable
     */
    get minTlsVersion(): string;
    /**
     * @stability stable
     */
    set minTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinTlsVersion(): void;
    /**
     * @stability stable
     */
    get minTlsVersionInput(): string | undefined;
    private _numberOfWorkers?;
    /**
     * @stability stable
     */
    get numberOfWorkers(): number;
    /**
     * @stability stable
     */
    set numberOfWorkers(value: number);
    /**
     * @stability stable
     */
    resetNumberOfWorkers(): void;
    /**
     * @stability stable
     */
    get numberOfWorkersInput(): number | undefined;
    private _phpVersion?;
    /**
     * @stability stable
     */
    get phpVersion(): string;
    /**
     * @stability stable
     */
    set phpVersion(value: string);
    /**
     * @stability stable
     */
    resetPhpVersion(): void;
    /**
     * @stability stable
     */
    get phpVersionInput(): string | undefined;
    private _pythonVersion?;
    /**
     * @stability stable
     */
    get pythonVersion(): string;
    /**
     * @stability stable
     */
    set pythonVersion(value: string);
    /**
     * @stability stable
     */
    resetPythonVersion(): void;
    /**
     * @stability stable
     */
    get pythonVersionInput(): string | undefined;
    private _remoteDebuggingEnabled?;
    /**
     * @stability stable
     */
    get remoteDebuggingEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set remoteDebuggingEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRemoteDebuggingEnabled(): void;
    /**
     * @stability stable
     */
    get remoteDebuggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _remoteDebuggingVersion?;
    /**
     * @stability stable
     */
    get remoteDebuggingVersion(): string;
    /**
     * @stability stable
     */
    set remoteDebuggingVersion(value: string);
    /**
     * @stability stable
     */
    resetRemoteDebuggingVersion(): void;
    /**
     * @stability stable
     */
    get remoteDebuggingVersionInput(): string | undefined;
    private _scmIpRestriction?;
    /**
     * @stability stable
     */
    get scmIpRestriction(): AppServiceSlotSiteConfigScmIpRestriction[];
    /**
     * @stability stable
     */
    set scmIpRestriction(value: AppServiceSlotSiteConfigScmIpRestriction[]);
    /**
     * @stability stable
     */
    resetScmIpRestriction(): void;
    /**
     * @stability stable
     */
    get scmIpRestrictionInput(): AppServiceSlotSiteConfigScmIpRestriction[] | undefined;
    private _scmType?;
    /**
     * @stability stable
     */
    get scmType(): string;
    /**
     * @stability stable
     */
    set scmType(value: string);
    /**
     * @stability stable
     */
    resetScmType(): void;
    /**
     * @stability stable
     */
    get scmTypeInput(): string | undefined;
    private _scmUseMainIpRestriction?;
    /**
     * @stability stable
     */
    get scmUseMainIpRestriction(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set scmUseMainIpRestriction(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetScmUseMainIpRestriction(): void;
    /**
     * @stability stable
     */
    get scmUseMainIpRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorkerProcess?;
    /**
     * @stability stable
     */
    get use32BitWorkerProcess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set use32BitWorkerProcess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUse32BitWorkerProcess(): void;
    /**
     * @stability stable
     */
    get use32BitWorkerProcessInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVnetRouteAllEnabled(): void;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    /**
     * @stability stable
     */
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWebsocketsEnabled(): void;
    /**
     * @stability stable
     */
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _windowsFxVersion?;
    /**
     * @stability stable
     */
    get windowsFxVersion(): string;
    /**
     * @stability stable
     */
    set windowsFxVersion(value: string);
    /**
     * @stability stable
     */
    resetWindowsFxVersion(): void;
    /**
     * @stability stable
     */
    get windowsFxVersionInput(): string | undefined;
    private _cors;
    /**
     * @stability stable
     */
    get cors(): AppServiceSlotSiteConfigCorsOutputReference;
    /**
     * @stability stable
     */
    putCors(value: AppServiceSlotSiteConfigCors): void;
    /**
     * @stability stable
     */
    resetCors(): void;
    /**
     * @stability stable
     */
    get corsInput(): AppServiceSlotSiteConfigCors | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSlotTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#create AppServiceSlot#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#delete AppServiceSlot#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#read AppServiceSlot#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html#update AppServiceSlot#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appServiceSlotTimeoutsToTerraform(struct?: AppServiceSlotTimeoutsOutputReference | AppServiceSlotTimeouts): any;
/**
 * @stability stable
 */
export declare class AppServiceSlotTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSlotTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSlotTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html azurerm_app_service_slot}.
 *
 * @stability stable
 */
export declare class AppServiceSlot extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_slot.html azurerm_app_service_slot} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServiceSlotConfig);
    private _appServiceName?;
    /**
     * @stability stable
     */
    get appServiceName(): string;
    /**
     * @stability stable
     */
    set appServiceName(value: string);
    /**
     * @stability stable
     */
    get appServiceNameInput(): string | undefined;
    private _appServicePlanId?;
    /**
     * @stability stable
     */
    get appServicePlanId(): string;
    /**
     * @stability stable
     */
    set appServicePlanId(value: string);
    /**
     * @stability stable
     */
    get appServicePlanIdInput(): string | undefined;
    private _appSettings?;
    /**
     * @stability stable
     */
    get appSettings(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set appSettings(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAppSettings(): void;
    /**
     * @stability stable
     */
    get appSettingsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _clientAffinityEnabled?;
    /**
     * @stability stable
     */
    get clientAffinityEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientAffinityEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientAffinityEnabled(): void;
    /**
     * @stability stable
     */
    get clientAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get defaultSiteHostname(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpsOnly?;
    /**
     * @stability stable
     */
    get httpsOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set httpsOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttpsOnly(): void;
    /**
     * @stability stable
     */
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultReferenceIdentityId?;
    /**
     * @stability stable
     */
    get keyVaultReferenceIdentityId(): string;
    /**
     * @stability stable
     */
    set keyVaultReferenceIdentityId(value: string);
    /**
     * @stability stable
     */
    resetKeyVaultReferenceIdentityId(): void;
    /**
     * @stability stable
     */
    get keyVaultReferenceIdentityIdInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    siteCredential(index: string): AppServiceSlotSiteCredential;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _authSettings;
    /**
     * @stability stable
     */
    get authSettings(): AppServiceSlotAuthSettingsOutputReference;
    /**
     * @stability stable
     */
    putAuthSettings(value: AppServiceSlotAuthSettings): void;
    /**
     * @stability stable
     */
    resetAuthSettings(): void;
    /**
     * @stability stable
     */
    get authSettingsInput(): AppServiceSlotAuthSettings | undefined;
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): AppServiceSlotConnectionString[];
    /**
     * @stability stable
     */
    set connectionString(value: AppServiceSlotConnectionString[]);
    /**
     * @stability stable
     */
    resetConnectionString(): void;
    /**
     * @stability stable
     */
    get connectionStringInput(): AppServiceSlotConnectionString[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): AppServiceSlotIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: AppServiceSlotIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): AppServiceSlotIdentity | undefined;
    private _logs;
    /**
     * @stability stable
     */
    get logs(): AppServiceSlotLogsOutputReference;
    /**
     * @stability stable
     */
    putLogs(value: AppServiceSlotLogs): void;
    /**
     * @stability stable
     */
    resetLogs(): void;
    /**
     * @stability stable
     */
    get logsInput(): AppServiceSlotLogs | undefined;
    private _siteConfig;
    /**
     * @stability stable
     */
    get siteConfig(): AppServiceSlotSiteConfigOutputReference;
    /**
     * @stability stable
     */
    putSiteConfig(value: AppServiceSlotSiteConfig): void;
    /**
     * @stability stable
     */
    resetSiteConfig(): void;
    /**
     * @stability stable
     */
    get siteConfigInput(): AppServiceSlotSiteConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServiceSlotTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServiceSlotTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServiceSlotTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
