import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#app_service_plan_id AppService#app_service_plan_id}.
     *
     * @stability stable
     */
    readonly appServicePlanId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#app_settings AppService#app_settings}.
     *
     * @stability stable
     */
    readonly appSettings?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#client_affinity_enabled AppService#client_affinity_enabled}.
     *
     * @stability stable
     */
    readonly clientAffinityEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#client_cert_enabled AppService#client_cert_enabled}.
     *
     * @stability stable
     */
    readonly clientCertEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#enabled AppService#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#https_only AppService#https_only}.
     *
     * @stability stable
     */
    readonly httpsOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#key_vault_reference_identity_id AppService#key_vault_reference_identity_id}.
     *
     * @stability stable
     */
    readonly keyVaultReferenceIdentityId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#location AppService#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#name AppService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#resource_group_name AppService#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#tags AppService#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * auth_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#auth_settings AppService#auth_settings}
     *
     * @stability stable
     */
    readonly authSettings?: AppServiceAuthSettings;
    /**
     * backup block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#backup AppService#backup}
     *
     * @stability stable
     */
    readonly backup?: AppServiceBackup;
    /**
     * connection_string block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#connection_string AppService#connection_string}
     *
     * @stability stable
     */
    readonly connectionString?: AppServiceConnectionString[];
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#identity AppService#identity}
     *
     * @stability stable
     */
    readonly identity?: AppServiceIdentity;
    /**
     * logs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#logs AppService#logs}
     *
     * @stability stable
     */
    readonly logs?: AppServiceLogs;
    /**
     * site_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#site_config AppService#site_config}
     *
     * @stability stable
     */
    readonly siteConfig?: AppServiceSiteConfig;
    /**
     * source_control block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#source_control AppService#source_control}
     *
     * @stability stable
     */
    readonly sourceControl?: AppServiceSourceControl;
    /**
     * storage_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#storage_account AppService#storage_account}
     *
     * @stability stable
     */
    readonly storageAccount?: AppServiceStorageAccount[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#timeouts AppService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppServiceTimeouts;
}
/**
 * @stability stable
 */
export declare class AppServiceSiteCredential extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    get username(): string;
}
/**
 * @stability stable
 */
export interface AppServiceAuthSettingsActiveDirectory {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#allowed_audiences AppService#allowed_audiences}.
     *
     * @stability stable
     */
    readonly allowedAudiences?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#client_id AppService#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#client_secret AppService#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret?: string;
}
export declare function appServiceAuthSettingsActiveDirectoryToTerraform(struct?: AppServiceAuthSettingsActiveDirectoryOutputReference | AppServiceAuthSettingsActiveDirectory): any;
/**
 * @stability stable
 */
export declare class AppServiceAuthSettingsActiveDirectoryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceAuthSettingsActiveDirectory | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceAuthSettingsActiveDirectory | undefined);
    private _allowedAudiences?;
    /**
     * @stability stable
     */
    get allowedAudiences(): string[];
    /**
     * @stability stable
     */
    set allowedAudiences(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedAudiences(): void;
    /**
     * @stability stable
     */
    get allowedAudiencesInput(): string[] | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    resetClientSecret(): void;
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceAuthSettingsFacebook {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#app_id AppService#app_id}.
     *
     * @stability stable
     */
    readonly appId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#app_secret AppService#app_secret}.
     *
     * @stability stable
     */
    readonly appSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#oauth_scopes AppService#oauth_scopes}.
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
}
export declare function appServiceAuthSettingsFacebookToTerraform(struct?: AppServiceAuthSettingsFacebookOutputReference | AppServiceAuthSettingsFacebook): any;
/**
 * @stability stable
 */
export declare class AppServiceAuthSettingsFacebookOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceAuthSettingsFacebook | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceAuthSettingsFacebook | undefined);
    private _appId?;
    /**
     * @stability stable
     */
    get appId(): string;
    /**
     * @stability stable
     */
    set appId(value: string);
    /**
     * @stability stable
     */
    get appIdInput(): string | undefined;
    private _appSecret?;
    /**
     * @stability stable
     */
    get appSecret(): string;
    /**
     * @stability stable
     */
    set appSecret(value: string);
    /**
     * @stability stable
     */
    get appSecretInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceAuthSettingsGoogle {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#client_id AppService#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#client_secret AppService#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#oauth_scopes AppService#oauth_scopes}.
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
}
export declare function appServiceAuthSettingsGoogleToTerraform(struct?: AppServiceAuthSettingsGoogleOutputReference | AppServiceAuthSettingsGoogle): any;
/**
 * @stability stable
 */
export declare class AppServiceAuthSettingsGoogleOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceAuthSettingsGoogle | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceAuthSettingsGoogle | undefined);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceAuthSettingsMicrosoft {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#client_id AppService#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#client_secret AppService#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#oauth_scopes AppService#oauth_scopes}.
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
}
export declare function appServiceAuthSettingsMicrosoftToTerraform(struct?: AppServiceAuthSettingsMicrosoftOutputReference | AppServiceAuthSettingsMicrosoft): any;
/**
 * @stability stable
 */
export declare class AppServiceAuthSettingsMicrosoftOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceAuthSettingsMicrosoft | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceAuthSettingsMicrosoft | undefined);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceAuthSettingsTwitter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#consumer_key AppService#consumer_key}.
     *
     * @stability stable
     */
    readonly consumerKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#consumer_secret AppService#consumer_secret}.
     *
     * @stability stable
     */
    readonly consumerSecret: string;
}
export declare function appServiceAuthSettingsTwitterToTerraform(struct?: AppServiceAuthSettingsTwitterOutputReference | AppServiceAuthSettingsTwitter): any;
/**
 * @stability stable
 */
export declare class AppServiceAuthSettingsTwitterOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceAuthSettingsTwitter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceAuthSettingsTwitter | undefined);
    private _consumerKey?;
    /**
     * @stability stable
     */
    get consumerKey(): string;
    /**
     * @stability stable
     */
    set consumerKey(value: string);
    /**
     * @stability stable
     */
    get consumerKeyInput(): string | undefined;
    private _consumerSecret?;
    /**
     * @stability stable
     */
    get consumerSecret(): string;
    /**
     * @stability stable
     */
    set consumerSecret(value: string);
    /**
     * @stability stable
     */
    get consumerSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceAuthSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#additional_login_params AppService#additional_login_params}.
     *
     * @stability stable
     */
    readonly additionalLoginParams?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#allowed_external_redirect_urls AppService#allowed_external_redirect_urls}.
     *
     * @stability stable
     */
    readonly allowedExternalRedirectUrls?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#default_provider AppService#default_provider}.
     *
     * @stability stable
     */
    readonly defaultProvider?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#enabled AppService#enabled}.
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#issuer AppService#issuer}.
     *
     * @stability stable
     */
    readonly issuer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#runtime_version AppService#runtime_version}.
     *
     * @stability stable
     */
    readonly runtimeVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#token_refresh_extension_hours AppService#token_refresh_extension_hours}.
     *
     * @stability stable
     */
    readonly tokenRefreshExtensionHours?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#token_store_enabled AppService#token_store_enabled}.
     *
     * @stability stable
     */
    readonly tokenStoreEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#unauthenticated_client_action AppService#unauthenticated_client_action}.
     *
     * @stability stable
     */
    readonly unauthenticatedClientAction?: string;
    /**
     * active_directory block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#active_directory AppService#active_directory}
     *
     * @stability stable
     */
    readonly activeDirectory?: AppServiceAuthSettingsActiveDirectory;
    /**
     * facebook block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#facebook AppService#facebook}
     *
     * @stability stable
     */
    readonly facebook?: AppServiceAuthSettingsFacebook;
    /**
     * google block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#google AppService#google}
     *
     * @stability stable
     */
    readonly google?: AppServiceAuthSettingsGoogle;
    /**
     * microsoft block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#microsoft AppService#microsoft}
     *
     * @stability stable
     */
    readonly microsoft?: AppServiceAuthSettingsMicrosoft;
    /**
     * twitter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#twitter AppService#twitter}
     *
     * @stability stable
     */
    readonly twitter?: AppServiceAuthSettingsTwitter;
}
export declare function appServiceAuthSettingsToTerraform(struct?: AppServiceAuthSettingsOutputReference | AppServiceAuthSettings): any;
/**
 * @stability stable
 */
export declare class AppServiceAuthSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceAuthSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceAuthSettings | undefined);
    private _additionalLoginParams?;
    /**
     * @stability stable
     */
    get additionalLoginParams(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalLoginParams(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalLoginParams(): void;
    /**
     * @stability stable
     */
    get additionalLoginParamsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _allowedExternalRedirectUrls?;
    /**
     * @stability stable
     */
    get allowedExternalRedirectUrls(): string[];
    /**
     * @stability stable
     */
    set allowedExternalRedirectUrls(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedExternalRedirectUrls(): void;
    /**
     * @stability stable
     */
    get allowedExternalRedirectUrlsInput(): string[] | undefined;
    private _defaultProvider?;
    /**
     * @stability stable
     */
    get defaultProvider(): string;
    /**
     * @stability stable
     */
    set defaultProvider(value: string);
    /**
     * @stability stable
     */
    resetDefaultProvider(): void;
    /**
     * @stability stable
     */
    get defaultProviderInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _issuer?;
    /**
     * @stability stable
     */
    get issuer(): string;
    /**
     * @stability stable
     */
    set issuer(value: string);
    /**
     * @stability stable
     */
    resetIssuer(): void;
    /**
     * @stability stable
     */
    get issuerInput(): string | undefined;
    private _runtimeVersion?;
    /**
     * @stability stable
     */
    get runtimeVersion(): string;
    /**
     * @stability stable
     */
    set runtimeVersion(value: string);
    /**
     * @stability stable
     */
    resetRuntimeVersion(): void;
    /**
     * @stability stable
     */
    get runtimeVersionInput(): string | undefined;
    private _tokenRefreshExtensionHours?;
    /**
     * @stability stable
     */
    get tokenRefreshExtensionHours(): number;
    /**
     * @stability stable
     */
    set tokenRefreshExtensionHours(value: number);
    /**
     * @stability stable
     */
    resetTokenRefreshExtensionHours(): void;
    /**
     * @stability stable
     */
    get tokenRefreshExtensionHoursInput(): number | undefined;
    private _tokenStoreEnabled?;
    /**
     * @stability stable
     */
    get tokenStoreEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tokenStoreEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTokenStoreEnabled(): void;
    /**
     * @stability stable
     */
    get tokenStoreEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _unauthenticatedClientAction?;
    /**
     * @stability stable
     */
    get unauthenticatedClientAction(): string;
    /**
     * @stability stable
     */
    set unauthenticatedClientAction(value: string);
    /**
     * @stability stable
     */
    resetUnauthenticatedClientAction(): void;
    /**
     * @stability stable
     */
    get unauthenticatedClientActionInput(): string | undefined;
    private _activeDirectory;
    /**
     * @stability stable
     */
    get activeDirectory(): AppServiceAuthSettingsActiveDirectoryOutputReference;
    /**
     * @stability stable
     */
    putActiveDirectory(value: AppServiceAuthSettingsActiveDirectory): void;
    /**
     * @stability stable
     */
    resetActiveDirectory(): void;
    /**
     * @stability stable
     */
    get activeDirectoryInput(): AppServiceAuthSettingsActiveDirectory | undefined;
    private _facebook;
    /**
     * @stability stable
     */
    get facebook(): AppServiceAuthSettingsFacebookOutputReference;
    /**
     * @stability stable
     */
    putFacebook(value: AppServiceAuthSettingsFacebook): void;
    /**
     * @stability stable
     */
    resetFacebook(): void;
    /**
     * @stability stable
     */
    get facebookInput(): AppServiceAuthSettingsFacebook | undefined;
    private _google;
    /**
     * @stability stable
     */
    get google(): AppServiceAuthSettingsGoogleOutputReference;
    /**
     * @stability stable
     */
    putGoogle(value: AppServiceAuthSettingsGoogle): void;
    /**
     * @stability stable
     */
    resetGoogle(): void;
    /**
     * @stability stable
     */
    get googleInput(): AppServiceAuthSettingsGoogle | undefined;
    private _microsoft;
    /**
     * @stability stable
     */
    get microsoft(): AppServiceAuthSettingsMicrosoftOutputReference;
    /**
     * @stability stable
     */
    putMicrosoft(value: AppServiceAuthSettingsMicrosoft): void;
    /**
     * @stability stable
     */
    resetMicrosoft(): void;
    /**
     * @stability stable
     */
    get microsoftInput(): AppServiceAuthSettingsMicrosoft | undefined;
    private _twitter;
    /**
     * @stability stable
     */
    get twitter(): AppServiceAuthSettingsTwitterOutputReference;
    /**
     * @stability stable
     */
    putTwitter(value: AppServiceAuthSettingsTwitter): void;
    /**
     * @stability stable
     */
    resetTwitter(): void;
    /**
     * @stability stable
     */
    get twitterInput(): AppServiceAuthSettingsTwitter | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceBackupSchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#frequency_interval AppService#frequency_interval}.
     *
     * @stability stable
     */
    readonly frequencyInterval: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#frequency_unit AppService#frequency_unit}.
     *
     * @stability stable
     */
    readonly frequencyUnit: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#keep_at_least_one_backup AppService#keep_at_least_one_backup}.
     *
     * @stability stable
     */
    readonly keepAtLeastOneBackup?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#retention_period_in_days AppService#retention_period_in_days}.
     *
     * @stability stable
     */
    readonly retentionPeriodInDays?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#start_time AppService#start_time}.
     *
     * @stability stable
     */
    readonly startTime?: string;
}
export declare function appServiceBackupScheduleToTerraform(struct?: AppServiceBackupScheduleOutputReference | AppServiceBackupSchedule): any;
/**
 * @stability stable
 */
export declare class AppServiceBackupScheduleOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceBackupSchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceBackupSchedule | undefined);
    private _frequencyInterval?;
    /**
     * @stability stable
     */
    get frequencyInterval(): number;
    /**
     * @stability stable
     */
    set frequencyInterval(value: number);
    /**
     * @stability stable
     */
    get frequencyIntervalInput(): number | undefined;
    private _frequencyUnit?;
    /**
     * @stability stable
     */
    get frequencyUnit(): string;
    /**
     * @stability stable
     */
    set frequencyUnit(value: string);
    /**
     * @stability stable
     */
    get frequencyUnitInput(): string | undefined;
    private _keepAtLeastOneBackup?;
    /**
     * @stability stable
     */
    get keepAtLeastOneBackup(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set keepAtLeastOneBackup(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetKeepAtLeastOneBackup(): void;
    /**
     * @stability stable
     */
    get keepAtLeastOneBackupInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPeriodInDays?;
    /**
     * @stability stable
     */
    get retentionPeriodInDays(): number;
    /**
     * @stability stable
     */
    set retentionPeriodInDays(value: number);
    /**
     * @stability stable
     */
    resetRetentionPeriodInDays(): void;
    /**
     * @stability stable
     */
    get retentionPeriodInDaysInput(): number | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    resetStartTime(): void;
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceBackup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#enabled AppService#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#name AppService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#storage_account_url AppService#storage_account_url}.
     *
     * @stability stable
     */
    readonly storageAccountUrl: string;
    /**
     * schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#schedule AppService#schedule}
     *
     * @stability stable
     */
    readonly schedule: AppServiceBackupSchedule;
}
export declare function appServiceBackupToTerraform(struct?: AppServiceBackupOutputReference | AppServiceBackup): any;
/**
 * @stability stable
 */
export declare class AppServiceBackupOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceBackup | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceBackup | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _storageAccountUrl?;
    /**
     * @stability stable
     */
    get storageAccountUrl(): string;
    /**
     * @stability stable
     */
    set storageAccountUrl(value: string);
    /**
     * @stability stable
     */
    get storageAccountUrlInput(): string | undefined;
    private _schedule;
    /**
     * @stability stable
     */
    get schedule(): AppServiceBackupScheduleOutputReference;
    /**
     * @stability stable
     */
    putSchedule(value: AppServiceBackupSchedule): void;
    /**
     * @stability stable
     */
    get scheduleInput(): AppServiceBackupSchedule | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceConnectionString {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#name AppService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#type AppService#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#value AppService#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function appServiceConnectionStringToTerraform(struct?: AppServiceConnectionString): any;
/**
 * @stability stable
 */
export interface AppServiceIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#identity_ids AppService#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#type AppService#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function appServiceIdentityToTerraform(struct?: AppServiceIdentityOutputReference | AppServiceIdentity): any;
/**
 * @stability stable
 */
export declare class AppServiceIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceLogsApplicationLogsAzureBlobStorage {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#level AppService#level}.
     *
     * @stability stable
     */
    readonly level: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#retention_in_days AppService#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#sas_url AppService#sas_url}.
     *
     * @stability stable
     */
    readonly sasUrl: string;
}
export declare function appServiceLogsApplicationLogsAzureBlobStorageToTerraform(struct?: AppServiceLogsApplicationLogsAzureBlobStorageOutputReference | AppServiceLogsApplicationLogsAzureBlobStorage): any;
/**
 * @stability stable
 */
export declare class AppServiceLogsApplicationLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceLogsApplicationLogsAzureBlobStorage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceLogsApplicationLogsAzureBlobStorage | undefined);
    private _level?;
    /**
     * @stability stable
     */
    get level(): string;
    /**
     * @stability stable
     */
    set level(value: string);
    /**
     * @stability stable
     */
    get levelInput(): string | undefined;
    private _retentionInDays?;
    /**
     * @stability stable
     */
    get retentionInDays(): number;
    /**
     * @stability stable
     */
    set retentionInDays(value: number);
    /**
     * @stability stable
     */
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    /**
     * @stability stable
     */
    get sasUrl(): string;
    /**
     * @stability stable
     */
    set sasUrl(value: string);
    /**
     * @stability stable
     */
    get sasUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceLogsApplicationLogs {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#file_system_level AppService#file_system_level}.
     *
     * @stability stable
     */
    readonly fileSystemLevel?: string;
    /**
     * azure_blob_storage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#azure_blob_storage AppService#azure_blob_storage}
     *
     * @stability stable
     */
    readonly azureBlobStorage?: AppServiceLogsApplicationLogsAzureBlobStorage;
}
export declare function appServiceLogsApplicationLogsToTerraform(struct?: AppServiceLogsApplicationLogsOutputReference | AppServiceLogsApplicationLogs): any;
/**
 * @stability stable
 */
export declare class AppServiceLogsApplicationLogsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceLogsApplicationLogs | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceLogsApplicationLogs | undefined);
    private _fileSystemLevel?;
    /**
     * @stability stable
     */
    get fileSystemLevel(): string;
    /**
     * @stability stable
     */
    set fileSystemLevel(value: string);
    /**
     * @stability stable
     */
    resetFileSystemLevel(): void;
    /**
     * @stability stable
     */
    get fileSystemLevelInput(): string | undefined;
    private _azureBlobStorage;
    /**
     * @stability stable
     */
    get azureBlobStorage(): AppServiceLogsApplicationLogsAzureBlobStorageOutputReference;
    /**
     * @stability stable
     */
    putAzureBlobStorage(value: AppServiceLogsApplicationLogsAzureBlobStorage): void;
    /**
     * @stability stable
     */
    resetAzureBlobStorage(): void;
    /**
     * @stability stable
     */
    get azureBlobStorageInput(): AppServiceLogsApplicationLogsAzureBlobStorage | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceLogsHttpLogsAzureBlobStorage {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#retention_in_days AppService#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#sas_url AppService#sas_url}.
     *
     * @stability stable
     */
    readonly sasUrl: string;
}
export declare function appServiceLogsHttpLogsAzureBlobStorageToTerraform(struct?: AppServiceLogsHttpLogsAzureBlobStorageOutputReference | AppServiceLogsHttpLogsAzureBlobStorage): any;
/**
 * @stability stable
 */
export declare class AppServiceLogsHttpLogsAzureBlobStorageOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceLogsHttpLogsAzureBlobStorage | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceLogsHttpLogsAzureBlobStorage | undefined);
    private _retentionInDays?;
    /**
     * @stability stable
     */
    get retentionInDays(): number;
    /**
     * @stability stable
     */
    set retentionInDays(value: number);
    /**
     * @stability stable
     */
    get retentionInDaysInput(): number | undefined;
    private _sasUrl?;
    /**
     * @stability stable
     */
    get sasUrl(): string;
    /**
     * @stability stable
     */
    set sasUrl(value: string);
    /**
     * @stability stable
     */
    get sasUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceLogsHttpLogsFileSystem {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#retention_in_days AppService#retention_in_days}.
     *
     * @stability stable
     */
    readonly retentionInDays: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#retention_in_mb AppService#retention_in_mb}.
     *
     * @stability stable
     */
    readonly retentionInMb: number;
}
export declare function appServiceLogsHttpLogsFileSystemToTerraform(struct?: AppServiceLogsHttpLogsFileSystemOutputReference | AppServiceLogsHttpLogsFileSystem): any;
/**
 * @stability stable
 */
export declare class AppServiceLogsHttpLogsFileSystemOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceLogsHttpLogsFileSystem | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceLogsHttpLogsFileSystem | undefined);
    private _retentionInDays?;
    /**
     * @stability stable
     */
    get retentionInDays(): number;
    /**
     * @stability stable
     */
    set retentionInDays(value: number);
    /**
     * @stability stable
     */
    get retentionInDaysInput(): number | undefined;
    private _retentionInMb?;
    /**
     * @stability stable
     */
    get retentionInMb(): number;
    /**
     * @stability stable
     */
    set retentionInMb(value: number);
    /**
     * @stability stable
     */
    get retentionInMbInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceLogsHttpLogs {
    /**
     * azure_blob_storage block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#azure_blob_storage AppService#azure_blob_storage}
     *
     * @stability stable
     */
    readonly azureBlobStorage?: AppServiceLogsHttpLogsAzureBlobStorage;
    /**
     * file_system block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#file_system AppService#file_system}
     *
     * @stability stable
     */
    readonly fileSystem?: AppServiceLogsHttpLogsFileSystem;
}
export declare function appServiceLogsHttpLogsToTerraform(struct?: AppServiceLogsHttpLogsOutputReference | AppServiceLogsHttpLogs): any;
/**
 * @stability stable
 */
export declare class AppServiceLogsHttpLogsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceLogsHttpLogs | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceLogsHttpLogs | undefined);
    private _azureBlobStorage;
    /**
     * @stability stable
     */
    get azureBlobStorage(): AppServiceLogsHttpLogsAzureBlobStorageOutputReference;
    /**
     * @stability stable
     */
    putAzureBlobStorage(value: AppServiceLogsHttpLogsAzureBlobStorage): void;
    /**
     * @stability stable
     */
    resetAzureBlobStorage(): void;
    /**
     * @stability stable
     */
    get azureBlobStorageInput(): AppServiceLogsHttpLogsAzureBlobStorage | undefined;
    private _fileSystem;
    /**
     * @stability stable
     */
    get fileSystem(): AppServiceLogsHttpLogsFileSystemOutputReference;
    /**
     * @stability stable
     */
    putFileSystem(value: AppServiceLogsHttpLogsFileSystem): void;
    /**
     * @stability stable
     */
    resetFileSystem(): void;
    /**
     * @stability stable
     */
    get fileSystemInput(): AppServiceLogsHttpLogsFileSystem | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceLogs {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#detailed_error_messages_enabled AppService#detailed_error_messages_enabled}.
     *
     * @stability stable
     */
    readonly detailedErrorMessagesEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#failed_request_tracing_enabled AppService#failed_request_tracing_enabled}.
     *
     * @stability stable
     */
    readonly failedRequestTracingEnabled?: boolean | cdktf.IResolvable;
    /**
     * application_logs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#application_logs AppService#application_logs}
     *
     * @stability stable
     */
    readonly applicationLogs?: AppServiceLogsApplicationLogs;
    /**
     * http_logs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#http_logs AppService#http_logs}
     *
     * @stability stable
     */
    readonly httpLogs?: AppServiceLogsHttpLogs;
}
export declare function appServiceLogsToTerraform(struct?: AppServiceLogsOutputReference | AppServiceLogs): any;
/**
 * @stability stable
 */
export declare class AppServiceLogsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceLogs | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceLogs | undefined);
    private _detailedErrorMessagesEnabled?;
    /**
     * @stability stable
     */
    get detailedErrorMessagesEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set detailedErrorMessagesEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDetailedErrorMessagesEnabled(): void;
    /**
     * @stability stable
     */
    get detailedErrorMessagesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _failedRequestTracingEnabled?;
    /**
     * @stability stable
     */
    get failedRequestTracingEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set failedRequestTracingEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetFailedRequestTracingEnabled(): void;
    /**
     * @stability stable
     */
    get failedRequestTracingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _applicationLogs;
    /**
     * @stability stable
     */
    get applicationLogs(): AppServiceLogsApplicationLogsOutputReference;
    /**
     * @stability stable
     */
    putApplicationLogs(value: AppServiceLogsApplicationLogs): void;
    /**
     * @stability stable
     */
    resetApplicationLogs(): void;
    /**
     * @stability stable
     */
    get applicationLogsInput(): AppServiceLogsApplicationLogs | undefined;
    private _httpLogs;
    /**
     * @stability stable
     */
    get httpLogs(): AppServiceLogsHttpLogsOutputReference;
    /**
     * @stability stable
     */
    putHttpLogs(value: AppServiceLogsHttpLogs): void;
    /**
     * @stability stable
     */
    resetHttpLogs(): void;
    /**
     * @stability stable
     */
    get httpLogsInput(): AppServiceLogsHttpLogs | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSiteConfigIpRestrictionHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#x_azure_fdid AppService#x_azure_fdid}.
     *
     * @stability stable
     */
    readonly xAzureFdid?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#x_fd_health_probe AppService#x_fd_health_probe}.
     *
     * @stability stable
     */
    readonly xFdHealthProbe?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#x_forwarded_for AppService#x_forwarded_for}.
     *
     * @stability stable
     */
    readonly xForwardedFor?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#x_forwarded_host AppService#x_forwarded_host}.
     *
     * @stability stable
     */
    readonly xForwardedHost?: string[];
}
export declare function appServiceSiteConfigIpRestrictionHeadersToTerraform(struct?: AppServiceSiteConfigIpRestrictionHeaders): any;
/**
 * @stability stable
 */
export interface AppServiceSiteConfigIpRestriction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#action AppService#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#headers AppService#headers}.
     *
     * @stability stable
     */
    readonly headers?: AppServiceSiteConfigIpRestrictionHeaders[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#ip_address AppService#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#name AppService#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#priority AppService#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#service_tag AppService#service_tag}.
     *
     * @stability stable
     */
    readonly serviceTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#virtual_network_subnet_id AppService#virtual_network_subnet_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetId?: string;
}
export declare function appServiceSiteConfigIpRestrictionToTerraform(struct?: AppServiceSiteConfigIpRestriction): any;
/**
 * @stability stable
 */
export interface AppServiceSiteConfigScmIpRestrictionHeaders {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#x_azure_fdid AppService#x_azure_fdid}.
     *
     * @stability stable
     */
    readonly xAzureFdid?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#x_fd_health_probe AppService#x_fd_health_probe}.
     *
     * @stability stable
     */
    readonly xFdHealthProbe?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#x_forwarded_for AppService#x_forwarded_for}.
     *
     * @stability stable
     */
    readonly xForwardedFor?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#x_forwarded_host AppService#x_forwarded_host}.
     *
     * @stability stable
     */
    readonly xForwardedHost?: string[];
}
export declare function appServiceSiteConfigScmIpRestrictionHeadersToTerraform(struct?: AppServiceSiteConfigScmIpRestrictionHeaders): any;
/**
 * @stability stable
 */
export interface AppServiceSiteConfigScmIpRestriction {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#action AppService#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#headers AppService#headers}.
     *
     * @stability stable
     */
    readonly headers?: AppServiceSiteConfigScmIpRestrictionHeaders[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#ip_address AppService#ip_address}.
     *
     * @stability stable
     */
    readonly ipAddress?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#name AppService#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#priority AppService#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#service_tag AppService#service_tag}.
     *
     * @stability stable
     */
    readonly serviceTag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#virtual_network_subnet_id AppService#virtual_network_subnet_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkSubnetId?: string;
}
export declare function appServiceSiteConfigScmIpRestrictionToTerraform(struct?: AppServiceSiteConfigScmIpRestriction): any;
/**
 * @stability stable
 */
export interface AppServiceSiteConfigCors {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#allowed_origins AppService#allowed_origins}.
     *
     * @stability stable
     */
    readonly allowedOrigins: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#support_credentials AppService#support_credentials}.
     *
     * @stability stable
     */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function appServiceSiteConfigCorsToTerraform(struct?: AppServiceSiteConfigCorsOutputReference | AppServiceSiteConfigCors): any;
/**
 * @stability stable
 */
export declare class AppServiceSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSiteConfigCors | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSiteConfigCors | undefined);
    private _allowedOrigins?;
    /**
     * @stability stable
     */
    get allowedOrigins(): string[];
    /**
     * @stability stable
     */
    set allowedOrigins(value: string[]);
    /**
     * @stability stable
     */
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    /**
     * @stability stable
     */
    get supportCredentials(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set supportCredentials(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSupportCredentials(): void;
    /**
     * @stability stable
     */
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSiteConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#acr_use_managed_identity_credentials AppService#acr_use_managed_identity_credentials}.
     *
     * @stability stable
     */
    readonly acrUseManagedIdentityCredentials?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#acr_user_managed_identity_client_id AppService#acr_user_managed_identity_client_id}.
     *
     * @stability stable
     */
    readonly acrUserManagedIdentityClientId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#always_on AppService#always_on}.
     *
     * @stability stable
     */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#app_command_line AppService#app_command_line}.
     *
     * @stability stable
     */
    readonly appCommandLine?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#auto_swap_slot_name AppService#auto_swap_slot_name}.
     *
     * @stability stable
     */
    readonly autoSwapSlotName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#default_documents AppService#default_documents}.
     *
     * @stability stable
     */
    readonly defaultDocuments?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#dotnet_framework_version AppService#dotnet_framework_version}.
     *
     * @stability stable
     */
    readonly dotnetFrameworkVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#ftps_state AppService#ftps_state}.
     *
     * @stability stable
     */
    readonly ftpsState?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#health_check_path AppService#health_check_path}.
     *
     * @stability stable
     */
    readonly healthCheckPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#http2_enabled AppService#http2_enabled}.
     *
     * @stability stable
     */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#ip_restriction AppService#ip_restriction}.
     *
     * @stability stable
     */
    readonly ipRestriction?: AppServiceSiteConfigIpRestriction[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#java_container AppService#java_container}.
     *
     * @stability stable
     */
    readonly javaContainer?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#java_container_version AppService#java_container_version}.
     *
     * @stability stable
     */
    readonly javaContainerVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#java_version AppService#java_version}.
     *
     * @stability stable
     */
    readonly javaVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#linux_fx_version AppService#linux_fx_version}.
     *
     * @stability stable
     */
    readonly linuxFxVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#local_mysql_enabled AppService#local_mysql_enabled}.
     *
     * @stability stable
     */
    readonly localMysqlEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#managed_pipeline_mode AppService#managed_pipeline_mode}.
     *
     * @stability stable
     */
    readonly managedPipelineMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#min_tls_version AppService#min_tls_version}.
     *
     * @stability stable
     */
    readonly minTlsVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#number_of_workers AppService#number_of_workers}.
     *
     * @stability stable
     */
    readonly numberOfWorkers?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#php_version AppService#php_version}.
     *
     * @stability stable
     */
    readonly phpVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#python_version AppService#python_version}.
     *
     * @stability stable
     */
    readonly pythonVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#remote_debugging_enabled AppService#remote_debugging_enabled}.
     *
     * @stability stable
     */
    readonly remoteDebuggingEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#remote_debugging_version AppService#remote_debugging_version}.
     *
     * @stability stable
     */
    readonly remoteDebuggingVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#scm_ip_restriction AppService#scm_ip_restriction}.
     *
     * @stability stable
     */
    readonly scmIpRestriction?: AppServiceSiteConfigScmIpRestriction[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#scm_type AppService#scm_type}.
     *
     * @stability stable
     */
    readonly scmType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#scm_use_main_ip_restriction AppService#scm_use_main_ip_restriction}.
     *
     * @stability stable
     */
    readonly scmUseMainIpRestriction?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#use_32_bit_worker_process AppService#use_32_bit_worker_process}.
     *
     * @stability stable
     */
    readonly use32BitWorkerProcess?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#vnet_route_all_enabled AppService#vnet_route_all_enabled}.
     *
     * @stability stable
     */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#websockets_enabled AppService#websockets_enabled}.
     *
     * @stability stable
     */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#windows_fx_version AppService#windows_fx_version}.
     *
     * @stability stable
     */
    readonly windowsFxVersion?: string;
    /**
     * cors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#cors AppService#cors}
     *
     * @stability stable
     */
    readonly cors?: AppServiceSiteConfigCors;
}
export declare function appServiceSiteConfigToTerraform(struct?: AppServiceSiteConfigOutputReference | AppServiceSiteConfig): any;
/**
 * @stability stable
 */
export declare class AppServiceSiteConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSiteConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSiteConfig | undefined);
    private _acrUseManagedIdentityCredentials?;
    /**
     * @stability stable
     */
    get acrUseManagedIdentityCredentials(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set acrUseManagedIdentityCredentials(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAcrUseManagedIdentityCredentials(): void;
    /**
     * @stability stable
     */
    get acrUseManagedIdentityCredentialsInput(): boolean | cdktf.IResolvable | undefined;
    private _acrUserManagedIdentityClientId?;
    /**
     * @stability stable
     */
    get acrUserManagedIdentityClientId(): string;
    /**
     * @stability stable
     */
    set acrUserManagedIdentityClientId(value: string);
    /**
     * @stability stable
     */
    resetAcrUserManagedIdentityClientId(): void;
    /**
     * @stability stable
     */
    get acrUserManagedIdentityClientIdInput(): string | undefined;
    private _alwaysOn?;
    /**
     * @stability stable
     */
    get alwaysOn(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set alwaysOn(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAlwaysOn(): void;
    /**
     * @stability stable
     */
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _appCommandLine?;
    /**
     * @stability stable
     */
    get appCommandLine(): string;
    /**
     * @stability stable
     */
    set appCommandLine(value: string);
    /**
     * @stability stable
     */
    resetAppCommandLine(): void;
    /**
     * @stability stable
     */
    get appCommandLineInput(): string | undefined;
    private _autoSwapSlotName?;
    /**
     * @stability stable
     */
    get autoSwapSlotName(): string;
    /**
     * @stability stable
     */
    set autoSwapSlotName(value: string);
    /**
     * @stability stable
     */
    resetAutoSwapSlotName(): void;
    /**
     * @stability stable
     */
    get autoSwapSlotNameInput(): string | undefined;
    private _defaultDocuments?;
    /**
     * @stability stable
     */
    get defaultDocuments(): string[];
    /**
     * @stability stable
     */
    set defaultDocuments(value: string[]);
    /**
     * @stability stable
     */
    resetDefaultDocuments(): void;
    /**
     * @stability stable
     */
    get defaultDocumentsInput(): string[] | undefined;
    private _dotnetFrameworkVersion?;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersion(): string;
    /**
     * @stability stable
     */
    set dotnetFrameworkVersion(value: string);
    /**
     * @stability stable
     */
    resetDotnetFrameworkVersion(): void;
    /**
     * @stability stable
     */
    get dotnetFrameworkVersionInput(): string | undefined;
    private _ftpsState?;
    /**
     * @stability stable
     */
    get ftpsState(): string;
    /**
     * @stability stable
     */
    set ftpsState(value: string);
    /**
     * @stability stable
     */
    resetFtpsState(): void;
    /**
     * @stability stable
     */
    get ftpsStateInput(): string | undefined;
    private _healthCheckPath?;
    /**
     * @stability stable
     */
    get healthCheckPath(): string;
    /**
     * @stability stable
     */
    set healthCheckPath(value: string);
    /**
     * @stability stable
     */
    resetHealthCheckPath(): void;
    /**
     * @stability stable
     */
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    /**
     * @stability stable
     */
    get http2Enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set http2Enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttp2Enabled(): void;
    /**
     * @stability stable
     */
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestriction?;
    /**
     * @stability stable
     */
    get ipRestriction(): AppServiceSiteConfigIpRestriction[];
    /**
     * @stability stable
     */
    set ipRestriction(value: AppServiceSiteConfigIpRestriction[]);
    /**
     * @stability stable
     */
    resetIpRestriction(): void;
    /**
     * @stability stable
     */
    get ipRestrictionInput(): AppServiceSiteConfigIpRestriction[] | undefined;
    private _javaContainer?;
    /**
     * @stability stable
     */
    get javaContainer(): string;
    /**
     * @stability stable
     */
    set javaContainer(value: string);
    /**
     * @stability stable
     */
    resetJavaContainer(): void;
    /**
     * @stability stable
     */
    get javaContainerInput(): string | undefined;
    private _javaContainerVersion?;
    /**
     * @stability stable
     */
    get javaContainerVersion(): string;
    /**
     * @stability stable
     */
    set javaContainerVersion(value: string);
    /**
     * @stability stable
     */
    resetJavaContainerVersion(): void;
    /**
     * @stability stable
     */
    get javaContainerVersionInput(): string | undefined;
    private _javaVersion?;
    /**
     * @stability stable
     */
    get javaVersion(): string;
    /**
     * @stability stable
     */
    set javaVersion(value: string);
    /**
     * @stability stable
     */
    resetJavaVersion(): void;
    /**
     * @stability stable
     */
    get javaVersionInput(): string | undefined;
    private _linuxFxVersion?;
    /**
     * @stability stable
     */
    get linuxFxVersion(): string;
    /**
     * @stability stable
     */
    set linuxFxVersion(value: string);
    /**
     * @stability stable
     */
    resetLinuxFxVersion(): void;
    /**
     * @stability stable
     */
    get linuxFxVersionInput(): string | undefined;
    private _localMysqlEnabled?;
    /**
     * @stability stable
     */
    get localMysqlEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set localMysqlEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLocalMysqlEnabled(): void;
    /**
     * @stability stable
     */
    get localMysqlEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _managedPipelineMode?;
    /**
     * @stability stable
     */
    get managedPipelineMode(): string;
    /**
     * @stability stable
     */
    set managedPipelineMode(value: string);
    /**
     * @stability stable
     */
    resetManagedPipelineMode(): void;
    /**
     * @stability stable
     */
    get managedPipelineModeInput(): string | undefined;
    private _minTlsVersion?;
    /**
     * @stability stable
     */
    get minTlsVersion(): string;
    /**
     * @stability stable
     */
    set minTlsVersion(value: string);
    /**
     * @stability stable
     */
    resetMinTlsVersion(): void;
    /**
     * @stability stable
     */
    get minTlsVersionInput(): string | undefined;
    private _numberOfWorkers?;
    /**
     * @stability stable
     */
    get numberOfWorkers(): number;
    /**
     * @stability stable
     */
    set numberOfWorkers(value: number);
    /**
     * @stability stable
     */
    resetNumberOfWorkers(): void;
    /**
     * @stability stable
     */
    get numberOfWorkersInput(): number | undefined;
    private _phpVersion?;
    /**
     * @stability stable
     */
    get phpVersion(): string;
    /**
     * @stability stable
     */
    set phpVersion(value: string);
    /**
     * @stability stable
     */
    resetPhpVersion(): void;
    /**
     * @stability stable
     */
    get phpVersionInput(): string | undefined;
    private _pythonVersion?;
    /**
     * @stability stable
     */
    get pythonVersion(): string;
    /**
     * @stability stable
     */
    set pythonVersion(value: string);
    /**
     * @stability stable
     */
    resetPythonVersion(): void;
    /**
     * @stability stable
     */
    get pythonVersionInput(): string | undefined;
    private _remoteDebuggingEnabled?;
    /**
     * @stability stable
     */
    get remoteDebuggingEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set remoteDebuggingEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRemoteDebuggingEnabled(): void;
    /**
     * @stability stable
     */
    get remoteDebuggingEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _remoteDebuggingVersion?;
    /**
     * @stability stable
     */
    get remoteDebuggingVersion(): string;
    /**
     * @stability stable
     */
    set remoteDebuggingVersion(value: string);
    /**
     * @stability stable
     */
    resetRemoteDebuggingVersion(): void;
    /**
     * @stability stable
     */
    get remoteDebuggingVersionInput(): string | undefined;
    private _scmIpRestriction?;
    /**
     * @stability stable
     */
    get scmIpRestriction(): AppServiceSiteConfigScmIpRestriction[];
    /**
     * @stability stable
     */
    set scmIpRestriction(value: AppServiceSiteConfigScmIpRestriction[]);
    /**
     * @stability stable
     */
    resetScmIpRestriction(): void;
    /**
     * @stability stable
     */
    get scmIpRestrictionInput(): AppServiceSiteConfigScmIpRestriction[] | undefined;
    private _scmType?;
    /**
     * @stability stable
     */
    get scmType(): string;
    /**
     * @stability stable
     */
    set scmType(value: string);
    /**
     * @stability stable
     */
    resetScmType(): void;
    /**
     * @stability stable
     */
    get scmTypeInput(): string | undefined;
    private _scmUseMainIpRestriction?;
    /**
     * @stability stable
     */
    get scmUseMainIpRestriction(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set scmUseMainIpRestriction(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetScmUseMainIpRestriction(): void;
    /**
     * @stability stable
     */
    get scmUseMainIpRestrictionInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorkerProcess?;
    /**
     * @stability stable
     */
    get use32BitWorkerProcess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set use32BitWorkerProcess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUse32BitWorkerProcess(): void;
    /**
     * @stability stable
     */
    get use32BitWorkerProcessInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetVnetRouteAllEnabled(): void;
    /**
     * @stability stable
     */
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    /**
     * @stability stable
     */
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetWebsocketsEnabled(): void;
    /**
     * @stability stable
     */
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _windowsFxVersion?;
    /**
     * @stability stable
     */
    get windowsFxVersion(): string;
    /**
     * @stability stable
     */
    set windowsFxVersion(value: string);
    /**
     * @stability stable
     */
    resetWindowsFxVersion(): void;
    /**
     * @stability stable
     */
    get windowsFxVersionInput(): string | undefined;
    private _cors;
    /**
     * @stability stable
     */
    get cors(): AppServiceSiteConfigCorsOutputReference;
    /**
     * @stability stable
     */
    putCors(value: AppServiceSiteConfigCors): void;
    /**
     * @stability stable
     */
    resetCors(): void;
    /**
     * @stability stable
     */
    get corsInput(): AppServiceSiteConfigCors | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceSourceControl {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#branch AppService#branch}.
     *
     * @stability stable
     */
    readonly branch?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#manual_integration AppService#manual_integration}.
     *
     * @stability stable
     */
    readonly manualIntegration?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#repo_url AppService#repo_url}.
     *
     * @stability stable
     */
    readonly repoUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#rollback_enabled AppService#rollback_enabled}.
     *
     * @stability stable
     */
    readonly rollbackEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#use_mercurial AppService#use_mercurial}.
     *
     * @stability stable
     */
    readonly useMercurial?: boolean | cdktf.IResolvable;
}
export declare function appServiceSourceControlToTerraform(struct?: AppServiceSourceControlOutputReference | AppServiceSourceControl): any;
/**
 * @stability stable
 */
export declare class AppServiceSourceControlOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceSourceControl | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceSourceControl | undefined);
    private _branch?;
    /**
     * @stability stable
     */
    get branch(): string;
    /**
     * @stability stable
     */
    set branch(value: string);
    /**
     * @stability stable
     */
    resetBranch(): void;
    /**
     * @stability stable
     */
    get branchInput(): string | undefined;
    private _manualIntegration?;
    /**
     * @stability stable
     */
    get manualIntegration(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set manualIntegration(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetManualIntegration(): void;
    /**
     * @stability stable
     */
    get manualIntegrationInput(): boolean | cdktf.IResolvable | undefined;
    private _repoUrl?;
    /**
     * @stability stable
     */
    get repoUrl(): string;
    /**
     * @stability stable
     */
    set repoUrl(value: string);
    /**
     * @stability stable
     */
    resetRepoUrl(): void;
    /**
     * @stability stable
     */
    get repoUrlInput(): string | undefined;
    private _rollbackEnabled?;
    /**
     * @stability stable
     */
    get rollbackEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set rollbackEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRollbackEnabled(): void;
    /**
     * @stability stable
     */
    get rollbackEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _useMercurial?;
    /**
     * @stability stable
     */
    get useMercurial(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useMercurial(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseMercurial(): void;
    /**
     * @stability stable
     */
    get useMercurialInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface AppServiceStorageAccount {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#access_key AppService#access_key}.
     *
     * @stability stable
     */
    readonly accessKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#account_name AppService#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#mount_path AppService#mount_path}.
     *
     * @stability stable
     */
    readonly mountPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#name AppService#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#share_name AppService#share_name}.
     *
     * @stability stable
     */
    readonly shareName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#type AppService#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function appServiceStorageAccountToTerraform(struct?: AppServiceStorageAccount): any;
/**
 * @stability stable
 */
export interface AppServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#create AppService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#delete AppService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#read AppService#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html#update AppService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appServiceTimeoutsToTerraform(struct?: AppServiceTimeoutsOutputReference | AppServiceTimeouts): any;
/**
 * @stability stable
 */
export declare class AppServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppServiceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html azurerm_app_service}.
 *
 * @stability stable
 */
export declare class AppService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service.html azurerm_app_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppServiceConfig);
    private _appServicePlanId?;
    /**
     * @stability stable
     */
    get appServicePlanId(): string;
    /**
     * @stability stable
     */
    set appServicePlanId(value: string);
    /**
     * @stability stable
     */
    get appServicePlanIdInput(): string | undefined;
    private _appSettings?;
    /**
     * @stability stable
     */
    get appSettings(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set appSettings(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAppSettings(): void;
    /**
     * @stability stable
     */
    get appSettingsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _clientAffinityEnabled?;
    /**
     * @stability stable
     */
    get clientAffinityEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientAffinityEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientAffinityEnabled(): void;
    /**
     * @stability stable
     */
    get clientAffinityEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _clientCertEnabled?;
    /**
     * @stability stable
     */
    get clientCertEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set clientCertEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetClientCertEnabled(): void;
    /**
     * @stability stable
     */
    get clientCertEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get customDomainVerificationId(): string;
    /**
     * @stability stable
     */
    get defaultSiteHostname(): string;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpsOnly?;
    /**
     * @stability stable
     */
    get httpsOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set httpsOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttpsOnly(): void;
    /**
     * @stability stable
     */
    get httpsOnlyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultReferenceIdentityId?;
    /**
     * @stability stable
     */
    get keyVaultReferenceIdentityId(): string;
    /**
     * @stability stable
     */
    set keyVaultReferenceIdentityId(value: string);
    /**
     * @stability stable
     */
    resetKeyVaultReferenceIdentityId(): void;
    /**
     * @stability stable
     */
    get keyVaultReferenceIdentityIdInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get outboundIpAddressList(): string[];
    /**
     * @stability stable
     */
    get outboundIpAddresses(): string;
    /**
     * @stability stable
     */
    get possibleOutboundIpAddressList(): string[];
    /**
     * @stability stable
     */
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    siteCredential(index: string): AppServiceSiteCredential;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _authSettings;
    /**
     * @stability stable
     */
    get authSettings(): AppServiceAuthSettingsOutputReference;
    /**
     * @stability stable
     */
    putAuthSettings(value: AppServiceAuthSettings): void;
    /**
     * @stability stable
     */
    resetAuthSettings(): void;
    /**
     * @stability stable
     */
    get authSettingsInput(): AppServiceAuthSettings | undefined;
    private _backup;
    /**
     * @stability stable
     */
    get backup(): AppServiceBackupOutputReference;
    /**
     * @stability stable
     */
    putBackup(value: AppServiceBackup): void;
    /**
     * @stability stable
     */
    resetBackup(): void;
    /**
     * @stability stable
     */
    get backupInput(): AppServiceBackup | undefined;
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): AppServiceConnectionString[];
    /**
     * @stability stable
     */
    set connectionString(value: AppServiceConnectionString[]);
    /**
     * @stability stable
     */
    resetConnectionString(): void;
    /**
     * @stability stable
     */
    get connectionStringInput(): AppServiceConnectionString[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): AppServiceIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: AppServiceIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): AppServiceIdentity | undefined;
    private _logs;
    /**
     * @stability stable
     */
    get logs(): AppServiceLogsOutputReference;
    /**
     * @stability stable
     */
    putLogs(value: AppServiceLogs): void;
    /**
     * @stability stable
     */
    resetLogs(): void;
    /**
     * @stability stable
     */
    get logsInput(): AppServiceLogs | undefined;
    private _siteConfig;
    /**
     * @stability stable
     */
    get siteConfig(): AppServiceSiteConfigOutputReference;
    /**
     * @stability stable
     */
    putSiteConfig(value: AppServiceSiteConfig): void;
    /**
     * @stability stable
     */
    resetSiteConfig(): void;
    /**
     * @stability stable
     */
    get siteConfigInput(): AppServiceSiteConfig | undefined;
    private _sourceControl;
    /**
     * @stability stable
     */
    get sourceControl(): AppServiceSourceControlOutputReference;
    /**
     * @stability stable
     */
    putSourceControl(value: AppServiceSourceControl): void;
    /**
     * @stability stable
     */
    resetSourceControl(): void;
    /**
     * @stability stable
     */
    get sourceControlInput(): AppServiceSourceControl | undefined;
    private _storageAccount?;
    /**
     * @stability stable
     */
    get storageAccount(): AppServiceStorageAccount[];
    /**
     * @stability stable
     */
    set storageAccount(value: AppServiceStorageAccount[]);
    /**
     * @stability stable
     */
    resetStorageAccount(): void;
    /**
     * @stability stable
     */
    get storageAccountInput(): AppServiceStorageAccount[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppServiceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
