import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BackupPolicyFileShareConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#name BackupPolicyFileShare#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#recovery_vault_name BackupPolicyFileShare#recovery_vault_name}.
     *
     * @stability stable
     */
    readonly recoveryVaultName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#resource_group_name BackupPolicyFileShare#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#tags BackupPolicyFileShare#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#timezone BackupPolicyFileShare#timezone}.
     *
     * @stability stable
     */
    readonly timezone?: string;
    /**
     * backup block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#backup BackupPolicyFileShare#backup}
     *
     * @stability stable
     */
    readonly backup: BackupPolicyFileShareBackup;
    /**
     * retention_daily block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#retention_daily BackupPolicyFileShare#retention_daily}
     *
     * @stability stable
     */
    readonly retentionDaily: BackupPolicyFileShareRetentionDaily;
    /**
     * retention_monthly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#retention_monthly BackupPolicyFileShare#retention_monthly}
     *
     * @stability stable
     */
    readonly retentionMonthly?: BackupPolicyFileShareRetentionMonthly;
    /**
     * retention_weekly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#retention_weekly BackupPolicyFileShare#retention_weekly}
     *
     * @stability stable
     */
    readonly retentionWeekly?: BackupPolicyFileShareRetentionWeekly;
    /**
     * retention_yearly block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#retention_yearly BackupPolicyFileShare#retention_yearly}
     *
     * @stability stable
     */
    readonly retentionYearly?: BackupPolicyFileShareRetentionYearly;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#timeouts BackupPolicyFileShare#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BackupPolicyFileShareTimeouts;
}
/**
 * @stability stable
 */
export interface BackupPolicyFileShareBackup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#frequency BackupPolicyFileShare#frequency}.
     *
     * @stability stable
     */
    readonly frequency: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#time BackupPolicyFileShare#time}.
     *
     * @stability stable
     */
    readonly time: string;
}
export declare function backupPolicyFileShareBackupToTerraform(struct?: BackupPolicyFileShareBackupOutputReference | BackupPolicyFileShareBackup): any;
/**
 * @stability stable
 */
export declare class BackupPolicyFileShareBackupOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupPolicyFileShareBackup | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupPolicyFileShareBackup | undefined);
    private _frequency?;
    /**
     * @stability stable
     */
    get frequency(): string;
    /**
     * @stability stable
     */
    set frequency(value: string);
    /**
     * @stability stable
     */
    get frequencyInput(): string | undefined;
    private _time?;
    /**
     * @stability stable
     */
    get time(): string;
    /**
     * @stability stable
     */
    set time(value: string);
    /**
     * @stability stable
     */
    get timeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BackupPolicyFileShareRetentionDaily {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#count BackupPolicyFileShare#count}.
     *
     * @stability stable
     */
    readonly count: number;
}
export declare function backupPolicyFileShareRetentionDailyToTerraform(struct?: BackupPolicyFileShareRetentionDailyOutputReference | BackupPolicyFileShareRetentionDaily): any;
/**
 * @stability stable
 */
export declare class BackupPolicyFileShareRetentionDailyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupPolicyFileShareRetentionDaily | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupPolicyFileShareRetentionDaily | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface BackupPolicyFileShareRetentionMonthly {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#count BackupPolicyFileShare#count}.
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#weekdays BackupPolicyFileShare#weekdays}.
     *
     * @stability stable
     */
    readonly weekdays: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#weeks BackupPolicyFileShare#weeks}.
     *
     * @stability stable
     */
    readonly weeks: string[];
}
export declare function backupPolicyFileShareRetentionMonthlyToTerraform(struct?: BackupPolicyFileShareRetentionMonthlyOutputReference | BackupPolicyFileShareRetentionMonthly): any;
/**
 * @stability stable
 */
export declare class BackupPolicyFileShareRetentionMonthlyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupPolicyFileShareRetentionMonthly | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupPolicyFileShareRetentionMonthly | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _weekdays?;
    /**
     * @stability stable
     */
    get weekdays(): string[];
    /**
     * @stability stable
     */
    set weekdays(value: string[]);
    /**
     * @stability stable
     */
    get weekdaysInput(): string[] | undefined;
    private _weeks?;
    /**
     * @stability stable
     */
    get weeks(): string[];
    /**
     * @stability stable
     */
    set weeks(value: string[]);
    /**
     * @stability stable
     */
    get weeksInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface BackupPolicyFileShareRetentionWeekly {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#count BackupPolicyFileShare#count}.
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#weekdays BackupPolicyFileShare#weekdays}.
     *
     * @stability stable
     */
    readonly weekdays: string[];
}
export declare function backupPolicyFileShareRetentionWeeklyToTerraform(struct?: BackupPolicyFileShareRetentionWeeklyOutputReference | BackupPolicyFileShareRetentionWeekly): any;
/**
 * @stability stable
 */
export declare class BackupPolicyFileShareRetentionWeeklyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupPolicyFileShareRetentionWeekly | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupPolicyFileShareRetentionWeekly | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _weekdays?;
    /**
     * @stability stable
     */
    get weekdays(): string[];
    /**
     * @stability stable
     */
    set weekdays(value: string[]);
    /**
     * @stability stable
     */
    get weekdaysInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface BackupPolicyFileShareRetentionYearly {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#count BackupPolicyFileShare#count}.
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#months BackupPolicyFileShare#months}.
     *
     * @stability stable
     */
    readonly months: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#weekdays BackupPolicyFileShare#weekdays}.
     *
     * @stability stable
     */
    readonly weekdays: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#weeks BackupPolicyFileShare#weeks}.
     *
     * @stability stable
     */
    readonly weeks: string[];
}
export declare function backupPolicyFileShareRetentionYearlyToTerraform(struct?: BackupPolicyFileShareRetentionYearlyOutputReference | BackupPolicyFileShareRetentionYearly): any;
/**
 * @stability stable
 */
export declare class BackupPolicyFileShareRetentionYearlyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupPolicyFileShareRetentionYearly | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupPolicyFileShareRetentionYearly | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _months?;
    /**
     * @stability stable
     */
    get months(): string[];
    /**
     * @stability stable
     */
    set months(value: string[]);
    /**
     * @stability stable
     */
    get monthsInput(): string[] | undefined;
    private _weekdays?;
    /**
     * @stability stable
     */
    get weekdays(): string[];
    /**
     * @stability stable
     */
    set weekdays(value: string[]);
    /**
     * @stability stable
     */
    get weekdaysInput(): string[] | undefined;
    private _weeks?;
    /**
     * @stability stable
     */
    get weeks(): string[];
    /**
     * @stability stable
     */
    set weeks(value: string[]);
    /**
     * @stability stable
     */
    get weeksInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface BackupPolicyFileShareTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#create BackupPolicyFileShare#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#delete BackupPolicyFileShare#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#read BackupPolicyFileShare#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html#update BackupPolicyFileShare#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function backupPolicyFileShareTimeoutsToTerraform(struct?: BackupPolicyFileShareTimeoutsOutputReference | BackupPolicyFileShareTimeouts): any;
/**
 * @stability stable
 */
export declare class BackupPolicyFileShareTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BackupPolicyFileShareTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BackupPolicyFileShareTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html azurerm_backup_policy_file_share}.
 *
 * @stability stable
 */
export declare class BackupPolicyFileShare extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/backup_policy_file_share.html azurerm_backup_policy_file_share} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BackupPolicyFileShareConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _recoveryVaultName?;
    /**
     * @stability stable
     */
    get recoveryVaultName(): string;
    /**
     * @stability stable
     */
    set recoveryVaultName(value: string);
    /**
     * @stability stable
     */
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timezone?;
    /**
     * @stability stable
     */
    get timezone(): string;
    /**
     * @stability stable
     */
    set timezone(value: string);
    /**
     * @stability stable
     */
    resetTimezone(): void;
    /**
     * @stability stable
     */
    get timezoneInput(): string | undefined;
    private _backup;
    /**
     * @stability stable
     */
    get backup(): BackupPolicyFileShareBackupOutputReference;
    /**
     * @stability stable
     */
    putBackup(value: BackupPolicyFileShareBackup): void;
    /**
     * @stability stable
     */
    get backupInput(): BackupPolicyFileShareBackup | undefined;
    private _retentionDaily;
    /**
     * @stability stable
     */
    get retentionDaily(): BackupPolicyFileShareRetentionDailyOutputReference;
    /**
     * @stability stable
     */
    putRetentionDaily(value: BackupPolicyFileShareRetentionDaily): void;
    /**
     * @stability stable
     */
    get retentionDailyInput(): BackupPolicyFileShareRetentionDaily | undefined;
    private _retentionMonthly;
    /**
     * @stability stable
     */
    get retentionMonthly(): BackupPolicyFileShareRetentionMonthlyOutputReference;
    /**
     * @stability stable
     */
    putRetentionMonthly(value: BackupPolicyFileShareRetentionMonthly): void;
    /**
     * @stability stable
     */
    resetRetentionMonthly(): void;
    /**
     * @stability stable
     */
    get retentionMonthlyInput(): BackupPolicyFileShareRetentionMonthly | undefined;
    private _retentionWeekly;
    /**
     * @stability stable
     */
    get retentionWeekly(): BackupPolicyFileShareRetentionWeeklyOutputReference;
    /**
     * @stability stable
     */
    putRetentionWeekly(value: BackupPolicyFileShareRetentionWeekly): void;
    /**
     * @stability stable
     */
    resetRetentionWeekly(): void;
    /**
     * @stability stable
     */
    get retentionWeeklyInput(): BackupPolicyFileShareRetentionWeekly | undefined;
    private _retentionYearly;
    /**
     * @stability stable
     */
    get retentionYearly(): BackupPolicyFileShareRetentionYearlyOutputReference;
    /**
     * @stability stable
     */
    putRetentionYearly(value: BackupPolicyFileShareRetentionYearly): void;
    /**
     * @stability stable
     */
    resetRetentionYearly(): void;
    /**
     * @stability stable
     */
    get retentionYearlyInput(): BackupPolicyFileShareRetentionYearly | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BackupPolicyFileShareTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BackupPolicyFileShareTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BackupPolicyFileShareTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
