import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BotWebAppConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#developer_app_insights_api_key BotWebApp#developer_app_insights_api_key}.
     *
     * @stability stable
     */
    readonly developerAppInsightsApiKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#developer_app_insights_application_id BotWebApp#developer_app_insights_application_id}.
     *
     * @stability stable
     */
    readonly developerAppInsightsApplicationId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#developer_app_insights_key BotWebApp#developer_app_insights_key}.
     *
     * @stability stable
     */
    readonly developerAppInsightsKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#display_name BotWebApp#display_name}.
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#endpoint BotWebApp#endpoint}.
     *
     * @stability stable
     */
    readonly endpoint?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#location BotWebApp#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#luis_app_ids BotWebApp#luis_app_ids}.
     *
     * @stability stable
     */
    readonly luisAppIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#luis_key BotWebApp#luis_key}.
     *
     * @stability stable
     */
    readonly luisKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#microsoft_app_id BotWebApp#microsoft_app_id}.
     *
     * @stability stable
     */
    readonly microsoftAppId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#name BotWebApp#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#resource_group_name BotWebApp#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#sku BotWebApp#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#tags BotWebApp#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#timeouts BotWebApp#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BotWebAppTimeouts;
}
/**
 * @stability stable
 */
export interface BotWebAppTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#create BotWebApp#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#delete BotWebApp#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#read BotWebApp#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html#update BotWebApp#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function botWebAppTimeoutsToTerraform(struct?: BotWebAppTimeoutsOutputReference | BotWebAppTimeouts): any;
/**
 * @stability stable
 */
export declare class BotWebAppTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BotWebAppTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BotWebAppTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html azurerm_bot_web_app}.
 *
 * @stability stable
 */
export declare class BotWebApp extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/bot_web_app.html azurerm_bot_web_app} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BotWebAppConfig);
    private _developerAppInsightsApiKey?;
    /**
     * @stability stable
     */
    get developerAppInsightsApiKey(): string;
    /**
     * @stability stable
     */
    set developerAppInsightsApiKey(value: string);
    /**
     * @stability stable
     */
    resetDeveloperAppInsightsApiKey(): void;
    /**
     * @stability stable
     */
    get developerAppInsightsApiKeyInput(): string | undefined;
    private _developerAppInsightsApplicationId?;
    /**
     * @stability stable
     */
    get developerAppInsightsApplicationId(): string;
    /**
     * @stability stable
     */
    set developerAppInsightsApplicationId(value: string);
    /**
     * @stability stable
     */
    resetDeveloperAppInsightsApplicationId(): void;
    /**
     * @stability stable
     */
    get developerAppInsightsApplicationIdInput(): string | undefined;
    private _developerAppInsightsKey?;
    /**
     * @stability stable
     */
    get developerAppInsightsKey(): string;
    /**
     * @stability stable
     */
    set developerAppInsightsKey(value: string);
    /**
     * @stability stable
     */
    resetDeveloperAppInsightsKey(): void;
    /**
     * @stability stable
     */
    get developerAppInsightsKeyInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _endpoint?;
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    set endpoint(value: string);
    /**
     * @stability stable
     */
    resetEndpoint(): void;
    /**
     * @stability stable
     */
    get endpointInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _luisAppIds?;
    /**
     * @stability stable
     */
    get luisAppIds(): string[];
    /**
     * @stability stable
     */
    set luisAppIds(value: string[]);
    /**
     * @stability stable
     */
    resetLuisAppIds(): void;
    /**
     * @stability stable
     */
    get luisAppIdsInput(): string[] | undefined;
    private _luisKey?;
    /**
     * @stability stable
     */
    get luisKey(): string;
    /**
     * @stability stable
     */
    set luisKey(value: string);
    /**
     * @stability stable
     */
    resetLuisKey(): void;
    /**
     * @stability stable
     */
    get luisKeyInput(): string | undefined;
    private _microsoftAppId?;
    /**
     * @stability stable
     */
    get microsoftAppId(): string;
    /**
     * @stability stable
     */
    set microsoftAppId(value: string);
    /**
     * @stability stable
     */
    get microsoftAppIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BotWebAppTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BotWebAppTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BotWebAppTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
