import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CosmosdbCassandraDatacenterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#availability_zones_enabled CosmosdbCassandraDatacenter#availability_zones_enabled}.
     *
     * @stability stable
     */
    readonly availabilityZonesEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#cassandra_cluster_id CosmosdbCassandraDatacenter#cassandra_cluster_id}.
     *
     * @stability stable
     */
    readonly cassandraClusterId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#delegated_management_subnet_id CosmosdbCassandraDatacenter#delegated_management_subnet_id}.
     *
     * @stability stable
     */
    readonly delegatedManagementSubnetId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#disk_count CosmosdbCassandraDatacenter#disk_count}.
     *
     * @stability stable
     */
    readonly diskCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#location CosmosdbCassandraDatacenter#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#name CosmosdbCassandraDatacenter#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#node_count CosmosdbCassandraDatacenter#node_count}.
     *
     * @stability stable
     */
    readonly nodeCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#sku_name CosmosdbCassandraDatacenter#sku_name}.
     *
     * @stability stable
     */
    readonly skuName?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#timeouts CosmosdbCassandraDatacenter#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: CosmosdbCassandraDatacenterTimeouts;
}
/**
 * @stability stable
 */
export interface CosmosdbCassandraDatacenterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#create CosmosdbCassandraDatacenter#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#delete CosmosdbCassandraDatacenter#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#read CosmosdbCassandraDatacenter#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html#update CosmosdbCassandraDatacenter#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function cosmosdbCassandraDatacenterTimeoutsToTerraform(struct?: CosmosdbCassandraDatacenterTimeoutsOutputReference | CosmosdbCassandraDatacenterTimeouts): any;
/**
 * @stability stable
 */
export declare class CosmosdbCassandraDatacenterTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CosmosdbCassandraDatacenterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CosmosdbCassandraDatacenterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html azurerm_cosmosdb_cassandra_datacenter}.
 *
 * @stability stable
 */
export declare class CosmosdbCassandraDatacenter extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_cassandra_datacenter.html azurerm_cosmosdb_cassandra_datacenter} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CosmosdbCassandraDatacenterConfig);
    private _availabilityZonesEnabled?;
    /**
     * @stability stable
     */
    get availabilityZonesEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set availabilityZonesEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAvailabilityZonesEnabled(): void;
    /**
     * @stability stable
     */
    get availabilityZonesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cassandraClusterId?;
    /**
     * @stability stable
     */
    get cassandraClusterId(): string;
    /**
     * @stability stable
     */
    set cassandraClusterId(value: string);
    /**
     * @stability stable
     */
    get cassandraClusterIdInput(): string | undefined;
    private _delegatedManagementSubnetId?;
    /**
     * @stability stable
     */
    get delegatedManagementSubnetId(): string;
    /**
     * @stability stable
     */
    set delegatedManagementSubnetId(value: string);
    /**
     * @stability stable
     */
    get delegatedManagementSubnetIdInput(): string | undefined;
    private _diskCount?;
    /**
     * @stability stable
     */
    get diskCount(): number;
    /**
     * @stability stable
     */
    set diskCount(value: number);
    /**
     * @stability stable
     */
    resetDiskCount(): void;
    /**
     * @stability stable
     */
    get diskCountInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeCount?;
    /**
     * @stability stable
     */
    get nodeCount(): number;
    /**
     * @stability stable
     */
    set nodeCount(value: number);
    /**
     * @stability stable
     */
    resetNodeCount(): void;
    /**
     * @stability stable
     */
    get nodeCountInput(): number | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    resetSkuName(): void;
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): CosmosdbCassandraDatacenterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: CosmosdbCassandraDatacenterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): CosmosdbCassandraDatacenterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
