import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermBlueprintDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_definition.html#name DataAzurermBlueprintDefinition#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_definition.html#scope_id DataAzurermBlueprintDefinition#scope_id}.
     *
     * @stability stable
     */
    readonly scopeId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_definition.html#timeouts DataAzurermBlueprintDefinition#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermBlueprintDefinitionTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermBlueprintDefinitionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_definition.html#read DataAzurermBlueprintDefinition#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermBlueprintDefinitionTimeoutsToTerraform(struct?: DataAzurermBlueprintDefinitionTimeoutsOutputReference | DataAzurermBlueprintDefinitionTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermBlueprintDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermBlueprintDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermBlueprintDefinitionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_definition.html azurerm_blueprint_definition}.
 *
 * @stability stable
 */
export declare class DataAzurermBlueprintDefinition extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/blueprint_definition.html azurerm_blueprint_definition} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermBlueprintDefinitionConfig);
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lastModified(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _scopeId?;
    /**
     * @stability stable
     */
    get scopeId(): string;
    /**
     * @stability stable
     */
    set scopeId(value: string);
    /**
     * @stability stable
     */
    get scopeIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get targetScope(): string;
    /**
     * @stability stable
     */
    get timeCreated(): string;
    /**
     * @stability stable
     */
    get versions(): string[];
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermBlueprintDefinitionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermBlueprintDefinitionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermBlueprintDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
