import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermCosmosdbMongoDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database.html#account_name DataAzurermCosmosdbMongoDatabase#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database.html#name DataAzurermCosmosdbMongoDatabase#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database.html#resource_group_name DataAzurermCosmosdbMongoDatabase#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database.html#timeouts DataAzurermCosmosdbMongoDatabase#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermCosmosdbMongoDatabaseTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermCosmosdbMongoDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database.html#read DataAzurermCosmosdbMongoDatabase#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermCosmosdbMongoDatabaseTimeoutsToTerraform(struct?: DataAzurermCosmosdbMongoDatabaseTimeoutsOutputReference | DataAzurermCosmosdbMongoDatabaseTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermCosmosdbMongoDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermCosmosdbMongoDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermCosmosdbMongoDatabaseTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database.html azurerm_cosmosdb_mongo_database}.
 *
 * @stability stable
 */
export declare class DataAzurermCosmosdbMongoDatabase extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_mongo_database.html azurerm_cosmosdb_mongo_database} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermCosmosdbMongoDatabaseConfig);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermCosmosdbMongoDatabaseTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermCosmosdbMongoDatabaseTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermCosmosdbMongoDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
