import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDiskEncryptionSetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_encryption_set.html#name DataAzurermDiskEncryptionSet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_encryption_set.html#resource_group_name DataAzurermDiskEncryptionSet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_encryption_set.html#timeouts DataAzurermDiskEncryptionSet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDiskEncryptionSetTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermDiskEncryptionSetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/disk_encryption_set.html#read DataAzurermDiskEncryptionSet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDiskEncryptionSetTimeoutsToTerraform(struct?: DataAzurermDiskEncryptionSetTimeoutsOutputReference | DataAzurermDiskEncryptionSetTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermDiskEncryptionSetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDiskEncryptionSetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDiskEncryptionSetTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/disk_encryption_set.html azurerm_disk_encryption_set}.
 *
 * @stability stable
 */
export declare class DataAzurermDiskEncryptionSet extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/disk_encryption_set.html azurerm_disk_encryption_set} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDiskEncryptionSetConfig);
    /**
     * @stability stable
     */
    get autoKeyRotationEnabled(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDiskEncryptionSetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDiskEncryptionSetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDiskEncryptionSetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
