import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermEventgridDomainTopicConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain_topic.html#domain_name DataAzurermEventgridDomainTopic#domain_name}.
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain_topic.html#name DataAzurermEventgridDomainTopic#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain_topic.html#resource_group_name DataAzurermEventgridDomainTopic#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain_topic.html#timeouts DataAzurermEventgridDomainTopic#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermEventgridDomainTopicTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermEventgridDomainTopicTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain_topic.html#read DataAzurermEventgridDomainTopic#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermEventgridDomainTopicTimeoutsToTerraform(struct?: DataAzurermEventgridDomainTopicTimeoutsOutputReference | DataAzurermEventgridDomainTopicTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermEventgridDomainTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermEventgridDomainTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermEventgridDomainTopicTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain_topic.html azurerm_eventgrid_domain_topic}.
 *
 * @stability stable
 */
export declare class DataAzurermEventgridDomainTopic extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain_topic.html azurerm_eventgrid_domain_topic} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermEventgridDomainTopicConfig);
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    set domainName(value: string);
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermEventgridDomainTopicTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermEventgridDomainTopicTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermEventgridDomainTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
