import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermEventgridSystemTopicConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_system_topic.html#name DataAzurermEventgridSystemTopic#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_system_topic.html#resource_group_name DataAzurermEventgridSystemTopic#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_system_topic.html#identity DataAzurermEventgridSystemTopic#identity}
     *
     * @stability stable
     */
    readonly identity?: DataAzurermEventgridSystemTopicIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_system_topic.html#timeouts DataAzurermEventgridSystemTopic#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermEventgridSystemTopicTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermEventgridSystemTopicIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_system_topic.html#identity_ids DataAzurermEventgridSystemTopic#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_system_topic.html#type DataAzurermEventgridSystemTopic#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function dataAzurermEventgridSystemTopicIdentityToTerraform(struct?: DataAzurermEventgridSystemTopicIdentityOutputReference | DataAzurermEventgridSystemTopicIdentity): any;
/**
 * @stability stable
 */
export declare class DataAzurermEventgridSystemTopicIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermEventgridSystemTopicIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermEventgridSystemTopicIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataAzurermEventgridSystemTopicTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_system_topic.html#read DataAzurermEventgridSystemTopic#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermEventgridSystemTopicTimeoutsToTerraform(struct?: DataAzurermEventgridSystemTopicTimeoutsOutputReference | DataAzurermEventgridSystemTopicTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermEventgridSystemTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermEventgridSystemTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermEventgridSystemTopicTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_system_topic.html azurerm_eventgrid_system_topic}.
 *
 * @stability stable
 */
export declare class DataAzurermEventgridSystemTopic extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_system_topic.html azurerm_eventgrid_system_topic} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermEventgridSystemTopicConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get metricArmResourceId(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get sourceArmResourceId(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get topicType(): string;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): DataAzurermEventgridSystemTopicIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: DataAzurermEventgridSystemTopicIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): DataAzurermEventgridSystemTopicIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermEventgridSystemTopicTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermEventgridSystemTopicTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermEventgridSystemTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
