import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermNetworkServiceTagsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags.html#location DataAzurermNetworkServiceTags#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags.html#location_filter DataAzurermNetworkServiceTags#location_filter}.
     *
     * @stability stable
     */
    readonly locationFilter?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags.html#service DataAzurermNetworkServiceTags#service}.
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags.html#timeouts DataAzurermNetworkServiceTags#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermNetworkServiceTagsTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermNetworkServiceTagsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags.html#read DataAzurermNetworkServiceTags#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermNetworkServiceTagsTimeoutsToTerraform(struct?: DataAzurermNetworkServiceTagsTimeoutsOutputReference | DataAzurermNetworkServiceTagsTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermNetworkServiceTagsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermNetworkServiceTagsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermNetworkServiceTagsTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags.html azurerm_network_service_tags}.
 *
 * @stability stable
 */
export declare class DataAzurermNetworkServiceTags extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/network_service_tags.html azurerm_network_service_tags} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkServiceTagsConfig);
    /**
     * @stability stable
     */
    get addressPrefixes(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get ipv4Cidrs(): string[];
    /**
     * @stability stable
     */
    get ipv6Cidrs(): string[];
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _locationFilter?;
    /**
     * @stability stable
     */
    get locationFilter(): string;
    /**
     * @stability stable
     */
    set locationFilter(value: string);
    /**
     * @stability stable
     */
    resetLocationFilter(): void;
    /**
     * @stability stable
     */
    get locationFilterInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermNetworkServiceTagsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermNetworkServiceTagsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermNetworkServiceTagsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
