import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermSentinelAlertRuleTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template.html#display_name DataAzurermSentinelAlertRuleTemplate#display_name}.
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template.html#log_analytics_workspace_id DataAzurermSentinelAlertRuleTemplate#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template.html#name DataAzurermSentinelAlertRuleTemplate#name}.
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template.html#timeouts DataAzurermSentinelAlertRuleTemplate#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermSentinelAlertRuleTemplateTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermSentinelAlertRuleTemplateScheduledTemplate extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    get queryFrequency(): string;
    /**
     * @stability stable
     */
    get queryPeriod(): string;
    /**
     * @stability stable
     */
    get severity(): string;
    /**
     * @stability stable
     */
    get tactics(): string[];
    /**
     * @stability stable
     */
    get triggerOperator(): string;
    /**
     * @stability stable
     */
    get triggerThreshold(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplate extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get productFilter(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermSentinelAlertRuleTemplateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template.html#read DataAzurermSentinelAlertRuleTemplate#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermSentinelAlertRuleTemplateTimeoutsToTerraform(struct?: DataAzurermSentinelAlertRuleTemplateTimeoutsOutputReference | DataAzurermSentinelAlertRuleTemplateTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermSentinelAlertRuleTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermSentinelAlertRuleTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermSentinelAlertRuleTemplateTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template.html azurerm_sentinel_alert_rule_template}.
 *
 * @stability stable
 */
export declare class DataAzurermSentinelAlertRuleTemplate extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/sentinel_alert_rule_template.html azurerm_sentinel_alert_rule_template} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermSentinelAlertRuleTemplateConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    scheduledTemplate(index: string): DataAzurermSentinelAlertRuleTemplateScheduledTemplate;
    /**
     * @stability stable
     */
    securityIncidentTemplate(index: string): DataAzurermSentinelAlertRuleTemplateSecurityIncidentTemplate;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermSentinelAlertRuleTemplateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermSentinelAlertRuleTemplateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermSentinelAlertRuleTemplateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
