import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermSharedImageVersionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version.html#gallery_name DataAzurermSharedImageVersion#gallery_name}.
     *
     * @stability stable
     */
    readonly galleryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version.html#image_name DataAzurermSharedImageVersion#image_name}.
     *
     * @stability stable
     */
    readonly imageName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version.html#name DataAzurermSharedImageVersion#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version.html#resource_group_name DataAzurermSharedImageVersion#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version.html#timeouts DataAzurermSharedImageVersion#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermSharedImageVersionTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermSharedImageVersionTargetRegion extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get regionalReplicaCount(): number;
    /**
     * @stability stable
     */
    get storageAccountType(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermSharedImageVersionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version.html#read DataAzurermSharedImageVersion#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermSharedImageVersionTimeoutsToTerraform(struct?: DataAzurermSharedImageVersionTimeoutsOutputReference | DataAzurermSharedImageVersionTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermSharedImageVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermSharedImageVersionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermSharedImageVersionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version.html azurerm_shared_image_version}.
 *
 * @stability stable
 */
export declare class DataAzurermSharedImageVersion extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/shared_image_version.html azurerm_shared_image_version} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermSharedImageVersionConfig);
    /**
     * @stability stable
     */
    get excludeFromLatest(): any;
    private _galleryName?;
    /**
     * @stability stable
     */
    get galleryName(): string;
    /**
     * @stability stable
     */
    set galleryName(value: string);
    /**
     * @stability stable
     */
    get galleryNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _imageName?;
    /**
     * @stability stable
     */
    get imageName(): string;
    /**
     * @stability stable
     */
    set imageName(value: string);
    /**
     * @stability stable
     */
    get imageNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    get managedImageId(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get osDiskImageSizeGb(): number;
    /**
     * @stability stable
     */
    get osDiskSnapshotId(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    targetRegion(index: string): DataAzurermSharedImageVersionTargetRegion;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermSharedImageVersionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermSharedImageVersionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermSharedImageVersionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
