import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermStorageEncryptionScopeConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_encryption_scope.html#name DataAzurermStorageEncryptionScope#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_encryption_scope.html#storage_account_id DataAzurermStorageEncryptionScope#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_encryption_scope.html#timeouts DataAzurermStorageEncryptionScope#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermStorageEncryptionScopeTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageEncryptionScopeTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_encryption_scope.html#read DataAzurermStorageEncryptionScope#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermStorageEncryptionScopeTimeoutsToTerraform(struct?: DataAzurermStorageEncryptionScopeTimeoutsOutputReference | DataAzurermStorageEncryptionScopeTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageEncryptionScopeTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageEncryptionScopeTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageEncryptionScopeTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_encryption_scope.html azurerm_storage_encryption_scope}.
 *
 * @stability stable
 */
export declare class DataAzurermStorageEncryptionScope extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_encryption_scope.html azurerm_storage_encryption_scope} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermStorageEncryptionScopeConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get keyVaultKeyId(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get source(): string;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermStorageEncryptionScopeTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermStorageEncryptionScopeTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermStorageEncryptionScopeTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
