import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermVirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine.html#name DataAzurermVirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine.html#resource_group_name DataAzurermVirtualMachine#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine.html#timeouts DataAzurermVirtualMachine#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermVirtualMachineTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermVirtualMachineIdentity extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    get principalId(): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    get type(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermVirtualMachineTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine.html#read DataAzurermVirtualMachine#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermVirtualMachineTimeoutsToTerraform(struct?: DataAzurermVirtualMachineTimeoutsOutputReference | DataAzurermVirtualMachineTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermVirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermVirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermVirtualMachineTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine.html azurerm_virtual_machine}.
 *
 * @stability stable
 */
export declare class DataAzurermVirtualMachine extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/virtual_machine.html azurerm_virtual_machine} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermVirtualMachineConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    identity(index: string): DataAzurermVirtualMachineIdentity;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get privateIpAddress(): string;
    /**
     * @stability stable
     */
    get privateIpAddresses(): string[];
    /**
     * @stability stable
     */
    get publicIpAddress(): string;
    /**
     * @stability stable
     */
    get publicIpAddresses(): string[];
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermVirtualMachineTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermVirtualMachineTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermVirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
