import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryDatasetParquetConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#additional_properties DataFactoryDatasetParquet#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#annotations DataFactoryDatasetParquet#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#compression_codec DataFactoryDatasetParquet#compression_codec}.
     *
     * @stability stable
     */
    readonly compressionCodec?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#compression_level DataFactoryDatasetParquet#compression_level}.
     *
     * @stability stable
     */
    readonly compressionLevel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#data_factory_name DataFactoryDatasetParquet#data_factory_name}.
     *
     * @stability stable
     */
    readonly dataFactoryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#description DataFactoryDatasetParquet#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#folder DataFactoryDatasetParquet#folder}.
     *
     * @stability stable
     */
    readonly folder?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#linked_service_name DataFactoryDatasetParquet#linked_service_name}.
     *
     * @stability stable
     */
    readonly linkedServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#name DataFactoryDatasetParquet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#parameters DataFactoryDatasetParquet#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#resource_group_name DataFactoryDatasetParquet#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * azure_blob_storage_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#azure_blob_storage_location DataFactoryDatasetParquet#azure_blob_storage_location}
     *
     * @stability stable
     */
    readonly azureBlobStorageLocation?: DataFactoryDatasetParquetAzureBlobStorageLocation;
    /**
     * http_server_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#http_server_location DataFactoryDatasetParquet#http_server_location}
     *
     * @stability stable
     */
    readonly httpServerLocation?: DataFactoryDatasetParquetHttpServerLocation;
    /**
     * schema_column block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#schema_column DataFactoryDatasetParquet#schema_column}
     *
     * @stability stable
     */
    readonly schemaColumn?: DataFactoryDatasetParquetSchemaColumn[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#timeouts DataFactoryDatasetParquet#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryDatasetParquetTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetParquetAzureBlobStorageLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#container DataFactoryDatasetParquet#container}.
     *
     * @stability stable
     */
    readonly container: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#dynamic_filename_enabled DataFactoryDatasetParquet#dynamic_filename_enabled}.
     *
     * @stability stable
     */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#dynamic_path_enabled DataFactoryDatasetParquet#dynamic_path_enabled}.
     *
     * @stability stable
     */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#filename DataFactoryDatasetParquet#filename}.
     *
     * @stability stable
     */
    readonly filename?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#path DataFactoryDatasetParquet#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function dataFactoryDatasetParquetAzureBlobStorageLocationToTerraform(struct?: DataFactoryDatasetParquetAzureBlobStorageLocationOutputReference | DataFactoryDatasetParquetAzureBlobStorageLocation): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetParquetAzureBlobStorageLocationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetParquetAzureBlobStorageLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetParquetAzureBlobStorageLocation | undefined);
    private _container?;
    /**
     * @stability stable
     */
    get container(): string;
    /**
     * @stability stable
     */
    set container(value: string);
    /**
     * @stability stable
     */
    get containerInput(): string | undefined;
    private _dynamicFilenameEnabled?;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicFilenameEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    /**
     * @stability stable
     */
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicPathEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetParquetHttpServerLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#dynamic_filename_enabled DataFactoryDatasetParquet#dynamic_filename_enabled}.
     *
     * @stability stable
     */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#dynamic_path_enabled DataFactoryDatasetParquet#dynamic_path_enabled}.
     *
     * @stability stable
     */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#filename DataFactoryDatasetParquet#filename}.
     *
     * @stability stable
     */
    readonly filename: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#path DataFactoryDatasetParquet#path}.
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#relative_url DataFactoryDatasetParquet#relative_url}.
     *
     * @stability stable
     */
    readonly relativeUrl: string;
}
export declare function dataFactoryDatasetParquetHttpServerLocationToTerraform(struct?: DataFactoryDatasetParquetHttpServerLocationOutputReference | DataFactoryDatasetParquetHttpServerLocation): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetParquetHttpServerLocationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetParquetHttpServerLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetParquetHttpServerLocation | undefined);
    private _dynamicFilenameEnabled?;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicFilenameEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    /**
     * @stability stable
     */
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicPathEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _relativeUrl?;
    /**
     * @stability stable
     */
    get relativeUrl(): string;
    /**
     * @stability stable
     */
    set relativeUrl(value: string);
    /**
     * @stability stable
     */
    get relativeUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetParquetSchemaColumn {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#description DataFactoryDatasetParquet#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#name DataFactoryDatasetParquet#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#type DataFactoryDatasetParquet#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function dataFactoryDatasetParquetSchemaColumnToTerraform(struct?: DataFactoryDatasetParquetSchemaColumn): any;
/**
 * @stability stable
 */
export interface DataFactoryDatasetParquetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#create DataFactoryDatasetParquet#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#delete DataFactoryDatasetParquet#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#read DataFactoryDatasetParquet#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html#update DataFactoryDatasetParquet#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryDatasetParquetTimeoutsToTerraform(struct?: DataFactoryDatasetParquetTimeoutsOutputReference | DataFactoryDatasetParquetTimeouts): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetParquetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetParquetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetParquetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html azurerm_data_factory_dataset_parquet}.
 *
 * @stability stable
 */
export declare class DataFactoryDatasetParquet extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_parquet.html azurerm_data_factory_dataset_parquet} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryDatasetParquetConfig);
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _compressionCodec?;
    /**
     * @stability stable
     */
    get compressionCodec(): string;
    /**
     * @stability stable
     */
    set compressionCodec(value: string);
    /**
     * @stability stable
     */
    resetCompressionCodec(): void;
    /**
     * @stability stable
     */
    get compressionCodecInput(): string | undefined;
    private _compressionLevel?;
    /**
     * @stability stable
     */
    get compressionLevel(): string;
    /**
     * @stability stable
     */
    set compressionLevel(value: string);
    /**
     * @stability stable
     */
    resetCompressionLevel(): void;
    /**
     * @stability stable
     */
    get compressionLevelInput(): string | undefined;
    private _dataFactoryName?;
    /**
     * @stability stable
     */
    get dataFactoryName(): string;
    /**
     * @stability stable
     */
    set dataFactoryName(value: string);
    /**
     * @stability stable
     */
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _folder?;
    /**
     * @stability stable
     */
    get folder(): string;
    /**
     * @stability stable
     */
    set folder(value: string);
    /**
     * @stability stable
     */
    resetFolder(): void;
    /**
     * @stability stable
     */
    get folderInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _linkedServiceName?;
    /**
     * @stability stable
     */
    get linkedServiceName(): string;
    /**
     * @stability stable
     */
    set linkedServiceName(value: string);
    /**
     * @stability stable
     */
    get linkedServiceNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _azureBlobStorageLocation;
    /**
     * @stability stable
     */
    get azureBlobStorageLocation(): DataFactoryDatasetParquetAzureBlobStorageLocationOutputReference;
    /**
     * @stability stable
     */
    putAzureBlobStorageLocation(value: DataFactoryDatasetParquetAzureBlobStorageLocation): void;
    /**
     * @stability stable
     */
    resetAzureBlobStorageLocation(): void;
    /**
     * @stability stable
     */
    get azureBlobStorageLocationInput(): DataFactoryDatasetParquetAzureBlobStorageLocation | undefined;
    private _httpServerLocation;
    /**
     * @stability stable
     */
    get httpServerLocation(): DataFactoryDatasetParquetHttpServerLocationOutputReference;
    /**
     * @stability stable
     */
    putHttpServerLocation(value: DataFactoryDatasetParquetHttpServerLocation): void;
    /**
     * @stability stable
     */
    resetHttpServerLocation(): void;
    /**
     * @stability stable
     */
    get httpServerLocationInput(): DataFactoryDatasetParquetHttpServerLocation | undefined;
    private _schemaColumn?;
    /**
     * @stability stable
     */
    get schemaColumn(): DataFactoryDatasetParquetSchemaColumn[];
    /**
     * @stability stable
     */
    set schemaColumn(value: DataFactoryDatasetParquetSchemaColumn[]);
    /**
     * @stability stable
     */
    resetSchemaColumn(): void;
    /**
     * @stability stable
     */
    get schemaColumnInput(): DataFactoryDatasetParquetSchemaColumn[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryDatasetParquetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryDatasetParquetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryDatasetParquetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
