import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceAzureSqlDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#additional_properties DataFactoryLinkedServiceAzureSqlDatabase#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#annotations DataFactoryLinkedServiceAzureSqlDatabase#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#connection_string DataFactoryLinkedServiceAzureSqlDatabase#connection_string}.
     *
     * @stability stable
     */
    readonly connectionString?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#data_factory_name DataFactoryLinkedServiceAzureSqlDatabase#data_factory_name}.
     *
     * @stability stable
     */
    readonly dataFactoryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#description DataFactoryLinkedServiceAzureSqlDatabase#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#integration_runtime_name DataFactoryLinkedServiceAzureSqlDatabase#integration_runtime_name}.
     *
     * @stability stable
     */
    readonly integrationRuntimeName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#name DataFactoryLinkedServiceAzureSqlDatabase#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#parameters DataFactoryLinkedServiceAzureSqlDatabase#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#resource_group_name DataFactoryLinkedServiceAzureSqlDatabase#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#service_principal_id DataFactoryLinkedServiceAzureSqlDatabase#service_principal_id}.
     *
     * @stability stable
     */
    readonly servicePrincipalId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#service_principal_key DataFactoryLinkedServiceAzureSqlDatabase#service_principal_key}.
     *
     * @stability stable
     */
    readonly servicePrincipalKey?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#tenant_id DataFactoryLinkedServiceAzureSqlDatabase#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#use_managed_identity DataFactoryLinkedServiceAzureSqlDatabase#use_managed_identity}.
     *
     * @stability stable
     */
    readonly useManagedIdentity?: boolean | cdktf.IResolvable;
    /**
     * key_vault_connection_string block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#key_vault_connection_string DataFactoryLinkedServiceAzureSqlDatabase#key_vault_connection_string}
     *
     * @stability stable
     */
    readonly keyVaultConnectionString?: DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultConnectionString;
    /**
     * key_vault_password block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#key_vault_password DataFactoryLinkedServiceAzureSqlDatabase#key_vault_password}
     *
     * @stability stable
     */
    readonly keyVaultPassword?: DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultPassword;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#timeouts DataFactoryLinkedServiceAzureSqlDatabase#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryLinkedServiceAzureSqlDatabaseTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultConnectionString {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#linked_service_name DataFactoryLinkedServiceAzureSqlDatabase#linked_service_name}.
     *
     * @stability stable
     */
    readonly linkedServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#secret_name DataFactoryLinkedServiceAzureSqlDatabase#secret_name}.
     *
     * @stability stable
     */
    readonly secretName: string;
}
export declare function dataFactoryLinkedServiceAzureSqlDatabaseKeyVaultConnectionStringToTerraform(struct?: DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultConnectionStringOutputReference | DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultConnectionString): any;
/**
 * @stability stable
 */
export declare class DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultConnectionStringOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultConnectionString | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultConnectionString | undefined);
    private _linkedServiceName?;
    /**
     * @stability stable
     */
    get linkedServiceName(): string;
    /**
     * @stability stable
     */
    set linkedServiceName(value: string);
    /**
     * @stability stable
     */
    get linkedServiceNameInput(): string | undefined;
    private _secretName?;
    /**
     * @stability stable
     */
    get secretName(): string;
    /**
     * @stability stable
     */
    set secretName(value: string);
    /**
     * @stability stable
     */
    get secretNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultPassword {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#linked_service_name DataFactoryLinkedServiceAzureSqlDatabase#linked_service_name}.
     *
     * @stability stable
     */
    readonly linkedServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#secret_name DataFactoryLinkedServiceAzureSqlDatabase#secret_name}.
     *
     * @stability stable
     */
    readonly secretName: string;
}
export declare function dataFactoryLinkedServiceAzureSqlDatabaseKeyVaultPasswordToTerraform(struct?: DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultPasswordOutputReference | DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultPassword): any;
/**
 * @stability stable
 */
export declare class DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultPasswordOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultPassword | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultPassword | undefined);
    private _linkedServiceName?;
    /**
     * @stability stable
     */
    get linkedServiceName(): string;
    /**
     * @stability stable
     */
    set linkedServiceName(value: string);
    /**
     * @stability stable
     */
    get linkedServiceNameInput(): string | undefined;
    private _secretName?;
    /**
     * @stability stable
     */
    get secretName(): string;
    /**
     * @stability stable
     */
    set secretName(value: string);
    /**
     * @stability stable
     */
    get secretNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryLinkedServiceAzureSqlDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#create DataFactoryLinkedServiceAzureSqlDatabase#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#delete DataFactoryLinkedServiceAzureSqlDatabase#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#read DataFactoryLinkedServiceAzureSqlDatabase#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html#update DataFactoryLinkedServiceAzureSqlDatabase#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryLinkedServiceAzureSqlDatabaseTimeoutsToTerraform(struct?: DataFactoryLinkedServiceAzureSqlDatabaseTimeoutsOutputReference | DataFactoryLinkedServiceAzureSqlDatabaseTimeouts): any;
/**
 * @stability stable
 */
export declare class DataFactoryLinkedServiceAzureSqlDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryLinkedServiceAzureSqlDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryLinkedServiceAzureSqlDatabaseTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html azurerm_data_factory_linked_service_azure_sql_database}.
 *
 * @stability stable
 */
export declare class DataFactoryLinkedServiceAzureSqlDatabase extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_linked_service_azure_sql_database.html azurerm_data_factory_linked_service_azure_sql_database} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryLinkedServiceAzureSqlDatabaseConfig);
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    set connectionString(value: string);
    /**
     * @stability stable
     */
    resetConnectionString(): void;
    /**
     * @stability stable
     */
    get connectionStringInput(): string | undefined;
    private _dataFactoryName?;
    /**
     * @stability stable
     */
    get dataFactoryName(): string;
    /**
     * @stability stable
     */
    set dataFactoryName(value: string);
    /**
     * @stability stable
     */
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _integrationRuntimeName?;
    /**
     * @stability stable
     */
    get integrationRuntimeName(): string;
    /**
     * @stability stable
     */
    set integrationRuntimeName(value: string);
    /**
     * @stability stable
     */
    resetIntegrationRuntimeName(): void;
    /**
     * @stability stable
     */
    get integrationRuntimeNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _servicePrincipalId?;
    /**
     * @stability stable
     */
    get servicePrincipalId(): string;
    /**
     * @stability stable
     */
    set servicePrincipalId(value: string);
    /**
     * @stability stable
     */
    resetServicePrincipalId(): void;
    /**
     * @stability stable
     */
    get servicePrincipalIdInput(): string | undefined;
    private _servicePrincipalKey?;
    /**
     * @stability stable
     */
    get servicePrincipalKey(): string;
    /**
     * @stability stable
     */
    set servicePrincipalKey(value: string);
    /**
     * @stability stable
     */
    resetServicePrincipalKey(): void;
    /**
     * @stability stable
     */
    get servicePrincipalKeyInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    resetTenantId(): void;
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
    private _useManagedIdentity?;
    /**
     * @stability stable
     */
    get useManagedIdentity(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set useManagedIdentity(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUseManagedIdentity(): void;
    /**
     * @stability stable
     */
    get useManagedIdentityInput(): boolean | cdktf.IResolvable | undefined;
    private _keyVaultConnectionString;
    /**
     * @stability stable
     */
    get keyVaultConnectionString(): DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultConnectionStringOutputReference;
    /**
     * @stability stable
     */
    putKeyVaultConnectionString(value: DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultConnectionString): void;
    /**
     * @stability stable
     */
    resetKeyVaultConnectionString(): void;
    /**
     * @stability stable
     */
    get keyVaultConnectionStringInput(): DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultConnectionString | undefined;
    private _keyVaultPassword;
    /**
     * @stability stable
     */
    get keyVaultPassword(): DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultPasswordOutputReference;
    /**
     * @stability stable
     */
    putKeyVaultPassword(value: DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultPassword): void;
    /**
     * @stability stable
     */
    resetKeyVaultPassword(): void;
    /**
     * @stability stable
     */
    get keyVaultPasswordInput(): DataFactoryLinkedServiceAzureSqlDatabaseKeyVaultPassword | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryLinkedServiceAzureSqlDatabaseTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryLinkedServiceAzureSqlDatabaseTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryLinkedServiceAzureSqlDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
