import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataShareDatasetDataLakeGen2Config extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen2.html#file_path DataShareDatasetDataLakeGen2#file_path}.
     *
     * @stability stable
     */
    readonly filePath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen2.html#file_system_name DataShareDatasetDataLakeGen2#file_system_name}.
     *
     * @stability stable
     */
    readonly fileSystemName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen2.html#folder_path DataShareDatasetDataLakeGen2#folder_path}.
     *
     * @stability stable
     */
    readonly folderPath?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen2.html#name DataShareDatasetDataLakeGen2#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen2.html#share_id DataShareDatasetDataLakeGen2#share_id}.
     *
     * @stability stable
     */
    readonly shareId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen2.html#storage_account_id DataShareDatasetDataLakeGen2#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen2.html#timeouts DataShareDatasetDataLakeGen2#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataShareDatasetDataLakeGen2Timeouts;
}
/**
 * @stability stable
 */
export interface DataShareDatasetDataLakeGen2Timeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen2.html#create DataShareDatasetDataLakeGen2#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen2.html#delete DataShareDatasetDataLakeGen2#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen2.html#read DataShareDatasetDataLakeGen2#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataShareDatasetDataLakeGen2TimeoutsToTerraform(struct?: DataShareDatasetDataLakeGen2TimeoutsOutputReference | DataShareDatasetDataLakeGen2Timeouts): any;
/**
 * @stability stable
 */
export declare class DataShareDatasetDataLakeGen2TimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataShareDatasetDataLakeGen2Timeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataShareDatasetDataLakeGen2Timeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen2.html azurerm_data_share_dataset_data_lake_gen2}.
 *
 * @stability stable
 */
export declare class DataShareDatasetDataLakeGen2 extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_share_dataset_data_lake_gen2.html azurerm_data_share_dataset_data_lake_gen2} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataShareDatasetDataLakeGen2Config);
    /**
     * @stability stable
     */
    get displayName(): string;
    private _filePath?;
    /**
     * @stability stable
     */
    get filePath(): string;
    /**
     * @stability stable
     */
    set filePath(value: string);
    /**
     * @stability stable
     */
    resetFilePath(): void;
    /**
     * @stability stable
     */
    get filePathInput(): string | undefined;
    private _fileSystemName?;
    /**
     * @stability stable
     */
    get fileSystemName(): string;
    /**
     * @stability stable
     */
    set fileSystemName(value: string);
    /**
     * @stability stable
     */
    get fileSystemNameInput(): string | undefined;
    private _folderPath?;
    /**
     * @stability stable
     */
    get folderPath(): string;
    /**
     * @stability stable
     */
    set folderPath(value: string);
    /**
     * @stability stable
     */
    resetFolderPath(): void;
    /**
     * @stability stable
     */
    get folderPathInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _shareId?;
    /**
     * @stability stable
     */
    get shareId(): string;
    /**
     * @stability stable
     */
    set shareId(value: string);
    /**
     * @stability stable
     */
    get shareIdInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataShareDatasetDataLakeGen2TimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataShareDatasetDataLakeGen2Timeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataShareDatasetDataLakeGen2Timeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
