import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DigitalTwinsEndpointEventgridConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html#dead_letter_storage_secret DigitalTwinsEndpointEventgrid#dead_letter_storage_secret}.
     *
     * @stability stable
     */
    readonly deadLetterStorageSecret?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html#digital_twins_id DigitalTwinsEndpointEventgrid#digital_twins_id}.
     *
     * @stability stable
     */
    readonly digitalTwinsId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html#eventgrid_topic_endpoint DigitalTwinsEndpointEventgrid#eventgrid_topic_endpoint}.
     *
     * @stability stable
     */
    readonly eventgridTopicEndpoint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html#eventgrid_topic_primary_access_key DigitalTwinsEndpointEventgrid#eventgrid_topic_primary_access_key}.
     *
     * @stability stable
     */
    readonly eventgridTopicPrimaryAccessKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html#eventgrid_topic_secondary_access_key DigitalTwinsEndpointEventgrid#eventgrid_topic_secondary_access_key}.
     *
     * @stability stable
     */
    readonly eventgridTopicSecondaryAccessKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html#name DigitalTwinsEndpointEventgrid#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html#timeouts DigitalTwinsEndpointEventgrid#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DigitalTwinsEndpointEventgridTimeouts;
}
/**
 * @stability stable
 */
export interface DigitalTwinsEndpointEventgridTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html#create DigitalTwinsEndpointEventgrid#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html#delete DigitalTwinsEndpointEventgrid#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html#read DigitalTwinsEndpointEventgrid#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html#update DigitalTwinsEndpointEventgrid#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function digitalTwinsEndpointEventgridTimeoutsToTerraform(struct?: DigitalTwinsEndpointEventgridTimeoutsOutputReference | DigitalTwinsEndpointEventgridTimeouts): any;
/**
 * @stability stable
 */
export declare class DigitalTwinsEndpointEventgridTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DigitalTwinsEndpointEventgridTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DigitalTwinsEndpointEventgridTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html azurerm_digital_twins_endpoint_eventgrid}.
 *
 * @stability stable
 */
export declare class DigitalTwinsEndpointEventgrid extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/digital_twins_endpoint_eventgrid.html azurerm_digital_twins_endpoint_eventgrid} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DigitalTwinsEndpointEventgridConfig);
    private _deadLetterStorageSecret?;
    /**
     * @stability stable
     */
    get deadLetterStorageSecret(): string;
    /**
     * @stability stable
     */
    set deadLetterStorageSecret(value: string);
    /**
     * @stability stable
     */
    resetDeadLetterStorageSecret(): void;
    /**
     * @stability stable
     */
    get deadLetterStorageSecretInput(): string | undefined;
    private _digitalTwinsId?;
    /**
     * @stability stable
     */
    get digitalTwinsId(): string;
    /**
     * @stability stable
     */
    set digitalTwinsId(value: string);
    /**
     * @stability stable
     */
    get digitalTwinsIdInput(): string | undefined;
    private _eventgridTopicEndpoint?;
    /**
     * @stability stable
     */
    get eventgridTopicEndpoint(): string;
    /**
     * @stability stable
     */
    set eventgridTopicEndpoint(value: string);
    /**
     * @stability stable
     */
    get eventgridTopicEndpointInput(): string | undefined;
    private _eventgridTopicPrimaryAccessKey?;
    /**
     * @stability stable
     */
    get eventgridTopicPrimaryAccessKey(): string;
    /**
     * @stability stable
     */
    set eventgridTopicPrimaryAccessKey(value: string);
    /**
     * @stability stable
     */
    get eventgridTopicPrimaryAccessKeyInput(): string | undefined;
    private _eventgridTopicSecondaryAccessKey?;
    /**
     * @stability stable
     */
    get eventgridTopicSecondaryAccessKey(): string;
    /**
     * @stability stable
     */
    set eventgridTopicSecondaryAccessKey(value: string);
    /**
     * @stability stable
     */
    get eventgridTopicSecondaryAccessKeyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DigitalTwinsEndpointEventgridTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DigitalTwinsEndpointEventgridTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DigitalTwinsEndpointEventgridTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
