import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DnsZoneConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#name DnsZone#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#resource_group_name DnsZone#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#tags DnsZone#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * soa_record block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#soa_record DnsZone#soa_record}
     *
     * @stability stable
     */
    readonly soaRecord?: DnsZoneSoaRecord;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#timeouts DnsZone#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DnsZoneTimeouts;
}
/**
 * @stability stable
 */
export interface DnsZoneSoaRecord {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#email DnsZone#email}.
     *
     * @stability stable
     */
    readonly email: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#expire_time DnsZone#expire_time}.
     *
     * @stability stable
     */
    readonly expireTime?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#host_name DnsZone#host_name}.
     *
     * @stability stable
     */
    readonly hostName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#minimum_ttl DnsZone#minimum_ttl}.
     *
     * @stability stable
     */
    readonly minimumTtl?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#refresh_time DnsZone#refresh_time}.
     *
     * @stability stable
     */
    readonly refreshTime?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#retry_time DnsZone#retry_time}.
     *
     * @stability stable
     */
    readonly retryTime?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#serial_number DnsZone#serial_number}.
     *
     * @stability stable
     */
    readonly serialNumber?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#tags DnsZone#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#ttl DnsZone#ttl}.
     *
     * @stability stable
     */
    readonly ttl?: number;
}
export declare function dnsZoneSoaRecordToTerraform(struct?: DnsZoneSoaRecordOutputReference | DnsZoneSoaRecord): any;
/**
 * @stability stable
 */
export declare class DnsZoneSoaRecordOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsZoneSoaRecord | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsZoneSoaRecord | undefined);
    private _email?;
    /**
     * @stability stable
     */
    get email(): string;
    /**
     * @stability stable
     */
    set email(value: string);
    /**
     * @stability stable
     */
    get emailInput(): string | undefined;
    private _expireTime?;
    /**
     * @stability stable
     */
    get expireTime(): number;
    /**
     * @stability stable
     */
    set expireTime(value: number);
    /**
     * @stability stable
     */
    resetExpireTime(): void;
    /**
     * @stability stable
     */
    get expireTimeInput(): number | undefined;
    private _hostName?;
    /**
     * @stability stable
     */
    get hostName(): string;
    /**
     * @stability stable
     */
    set hostName(value: string);
    /**
     * @stability stable
     */
    get hostNameInput(): string | undefined;
    private _minimumTtl?;
    /**
     * @stability stable
     */
    get minimumTtl(): number;
    /**
     * @stability stable
     */
    set minimumTtl(value: number);
    /**
     * @stability stable
     */
    resetMinimumTtl(): void;
    /**
     * @stability stable
     */
    get minimumTtlInput(): number | undefined;
    private _refreshTime?;
    /**
     * @stability stable
     */
    get refreshTime(): number;
    /**
     * @stability stable
     */
    set refreshTime(value: number);
    /**
     * @stability stable
     */
    resetRefreshTime(): void;
    /**
     * @stability stable
     */
    get refreshTimeInput(): number | undefined;
    private _retryTime?;
    /**
     * @stability stable
     */
    get retryTime(): number;
    /**
     * @stability stable
     */
    set retryTime(value: number);
    /**
     * @stability stable
     */
    resetRetryTime(): void;
    /**
     * @stability stable
     */
    get retryTimeInput(): number | undefined;
    private _serialNumber?;
    /**
     * @stability stable
     */
    get serialNumber(): number;
    /**
     * @stability stable
     */
    set serialNumber(value: number);
    /**
     * @stability stable
     */
    resetSerialNumber(): void;
    /**
     * @stability stable
     */
    get serialNumberInput(): number | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): number;
    /**
     * @stability stable
     */
    set ttl(value: number);
    /**
     * @stability stable
     */
    resetTtl(): void;
    /**
     * @stability stable
     */
    get ttlInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface DnsZoneTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#create DnsZone#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#delete DnsZone#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#read DnsZone#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html#update DnsZone#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dnsZoneTimeoutsToTerraform(struct?: DnsZoneTimeoutsOutputReference | DnsZoneTimeouts): any;
/**
 * @stability stable
 */
export declare class DnsZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsZoneTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsZoneTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html azurerm_dns_zone}.
 *
 * @stability stable
 */
export declare class DnsZone extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/dns_zone.html azurerm_dns_zone} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DnsZoneConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get maxNumberOfRecordSets(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get nameServers(): string[];
    /**
     * @stability stable
     */
    get numberOfRecordSets(): number;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _soaRecord;
    /**
     * @stability stable
     */
    get soaRecord(): DnsZoneSoaRecordOutputReference;
    /**
     * @stability stable
     */
    putSoaRecord(value: DnsZoneSoaRecord): void;
    /**
     * @stability stable
     */
    resetSoaRecord(): void;
    /**
     * @stability stable
     */
    get soaRecordInput(): DnsZoneSoaRecord | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DnsZoneTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DnsZoneTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DnsZoneTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
