import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FirewallConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#dns_servers Firewall#dns_servers}.
     *
     * @stability stable
     */
    readonly dnsServers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#firewall_policy_id Firewall#firewall_policy_id}.
     *
     * @stability stable
     */
    readonly firewallPolicyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#location Firewall#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#name Firewall#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#private_ip_ranges Firewall#private_ip_ranges}.
     *
     * @stability stable
     */
    readonly privateIpRanges?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#resource_group_name Firewall#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#sku_name Firewall#sku_name}.
     *
     * @stability stable
     */
    readonly skuName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#sku_tier Firewall#sku_tier}.
     *
     * @stability stable
     */
    readonly skuTier?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#tags Firewall#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#threat_intel_mode Firewall#threat_intel_mode}.
     *
     * @stability stable
     */
    readonly threatIntelMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#zones Firewall#zones}.
     *
     * @stability stable
     */
    readonly zones?: string[];
    /**
     * ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#ip_configuration Firewall#ip_configuration}
     *
     * @stability stable
     */
    readonly ipConfiguration?: FirewallIpConfiguration[];
    /**
     * management_ip_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#management_ip_configuration Firewall#management_ip_configuration}
     *
     * @stability stable
     */
    readonly managementIpConfiguration?: FirewallManagementIpConfiguration;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#timeouts Firewall#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FirewallTimeouts;
    /**
     * virtual_hub block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#virtual_hub Firewall#virtual_hub}
     *
     * @stability stable
     */
    readonly virtualHub?: FirewallVirtualHub;
}
/**
 * @stability stable
 */
export interface FirewallIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#name Firewall#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#public_ip_address_id Firewall#public_ip_address_id}.
     *
     * @stability stable
     */
    readonly publicIpAddressId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#subnet_id Firewall#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
}
export declare function firewallIpConfigurationToTerraform(struct?: FirewallIpConfiguration): any;
/**
 * @stability stable
 */
export interface FirewallManagementIpConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#name Firewall#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#public_ip_address_id Firewall#public_ip_address_id}.
     *
     * @stability stable
     */
    readonly publicIpAddressId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#subnet_id Firewall#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId: string;
}
export declare function firewallManagementIpConfigurationToTerraform(struct?: FirewallManagementIpConfigurationOutputReference | FirewallManagementIpConfiguration): any;
/**
 * @stability stable
 */
export declare class FirewallManagementIpConfigurationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FirewallManagementIpConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FirewallManagementIpConfiguration | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _publicIpAddressId?;
    /**
     * @stability stable
     */
    get publicIpAddressId(): string;
    /**
     * @stability stable
     */
    set publicIpAddressId(value: string);
    /**
     * @stability stable
     */
    get publicIpAddressIdInput(): string | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FirewallTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#create Firewall#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#delete Firewall#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#read Firewall#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#update Firewall#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function firewallTimeoutsToTerraform(struct?: FirewallTimeoutsOutputReference | FirewallTimeouts): any;
/**
 * @stability stable
 */
export declare class FirewallTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FirewallTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FirewallTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface FirewallVirtualHub {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#public_ip_count Firewall#public_ip_count}.
     *
     * @stability stable
     */
    readonly publicIpCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html#virtual_hub_id Firewall#virtual_hub_id}.
     *
     * @stability stable
     */
    readonly virtualHubId: string;
}
export declare function firewallVirtualHubToTerraform(struct?: FirewallVirtualHubOutputReference | FirewallVirtualHub): any;
/**
 * @stability stable
 */
export declare class FirewallVirtualHubOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FirewallVirtualHub | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FirewallVirtualHub | undefined);
    private _publicIpCount?;
    /**
     * @stability stable
     */
    get publicIpCount(): number;
    /**
     * @stability stable
     */
    set publicIpCount(value: number);
    /**
     * @stability stable
     */
    resetPublicIpCount(): void;
    /**
     * @stability stable
     */
    get publicIpCountInput(): number | undefined;
    private _virtualHubId?;
    /**
     * @stability stable
     */
    get virtualHubId(): string;
    /**
     * @stability stable
     */
    set virtualHubId(value: string);
    /**
     * @stability stable
     */
    get virtualHubIdInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html azurerm_firewall}.
 *
 * @stability stable
 */
export declare class Firewall extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/firewall.html azurerm_firewall} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FirewallConfig);
    private _dnsServers?;
    /**
     * @stability stable
     */
    get dnsServers(): string[];
    /**
     * @stability stable
     */
    set dnsServers(value: string[]);
    /**
     * @stability stable
     */
    resetDnsServers(): void;
    /**
     * @stability stable
     */
    get dnsServersInput(): string[] | undefined;
    private _firewallPolicyId?;
    /**
     * @stability stable
     */
    get firewallPolicyId(): string;
    /**
     * @stability stable
     */
    set firewallPolicyId(value: string);
    /**
     * @stability stable
     */
    resetFirewallPolicyId(): void;
    /**
     * @stability stable
     */
    get firewallPolicyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _privateIpRanges?;
    /**
     * @stability stable
     */
    get privateIpRanges(): string[];
    /**
     * @stability stable
     */
    set privateIpRanges(value: string[]);
    /**
     * @stability stable
     */
    resetPrivateIpRanges(): void;
    /**
     * @stability stable
     */
    get privateIpRangesInput(): string[] | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _skuName?;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    set skuName(value: string);
    /**
     * @stability stable
     */
    resetSkuName(): void;
    /**
     * @stability stable
     */
    get skuNameInput(): string | undefined;
    private _skuTier?;
    /**
     * @stability stable
     */
    get skuTier(): string;
    /**
     * @stability stable
     */
    set skuTier(value: string);
    /**
     * @stability stable
     */
    resetSkuTier(): void;
    /**
     * @stability stable
     */
    get skuTierInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _threatIntelMode?;
    /**
     * @stability stable
     */
    get threatIntelMode(): string;
    /**
     * @stability stable
     */
    set threatIntelMode(value: string);
    /**
     * @stability stable
     */
    resetThreatIntelMode(): void;
    /**
     * @stability stable
     */
    get threatIntelModeInput(): string | undefined;
    private _zones?;
    /**
     * @stability stable
     */
    get zones(): string[];
    /**
     * @stability stable
     */
    set zones(value: string[]);
    /**
     * @stability stable
     */
    resetZones(): void;
    /**
     * @stability stable
     */
    get zonesInput(): string[] | undefined;
    private _ipConfiguration?;
    /**
     * @stability stable
     */
    get ipConfiguration(): FirewallIpConfiguration[];
    /**
     * @stability stable
     */
    set ipConfiguration(value: FirewallIpConfiguration[]);
    /**
     * @stability stable
     */
    resetIpConfiguration(): void;
    /**
     * @stability stable
     */
    get ipConfigurationInput(): FirewallIpConfiguration[] | undefined;
    private _managementIpConfiguration;
    /**
     * @stability stable
     */
    get managementIpConfiguration(): FirewallManagementIpConfigurationOutputReference;
    /**
     * @stability stable
     */
    putManagementIpConfiguration(value: FirewallManagementIpConfiguration): void;
    /**
     * @stability stable
     */
    resetManagementIpConfiguration(): void;
    /**
     * @stability stable
     */
    get managementIpConfigurationInput(): FirewallManagementIpConfiguration | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FirewallTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FirewallTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FirewallTimeouts | undefined;
    private _virtualHub;
    /**
     * @stability stable
     */
    get virtualHub(): FirewallVirtualHubOutputReference;
    /**
     * @stability stable
     */
    putVirtualHub(value: FirewallVirtualHub): void;
    /**
     * @stability stable
     */
    resetVirtualHub(): void;
    /**
     * @stability stable
     */
    get virtualHubInput(): FirewallVirtualHub | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
